/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.engine.def.impl.handler;

import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.Dom4jUtil;
import com.hotent.bpm.api.model.process.def.BpmFormInit;
import com.hotent.bpm.api.model.process.def.FieldInitSetting;
import com.hotent.bpm.api.model.process.def.FormInitItem;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.engine.def.AbstractBpmDefXmlHandler;
import com.hotent.bpm.engine.def.DefXmlHandlerUtil;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.jamesmurty.utils.XMLBuilder;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.springframework.stereotype.Service;

@Service
public class BpmFormInitBpmDefXmlHandler
extends AbstractBpmDefXmlHandler<BpmFormInit> {
    private String getFormInit(FormInitItem formInitItem) {
        if (BeanUtils.isEmpty(formInitItem.getShowFieldsSetting()) && BeanUtils.isEmpty(formInitItem.getSaveFieldsSetting()) && BeanUtils.isEmpty(formInitItem.getAddSignFieldsSetting()) && BeanUtils.isEmpty(formInitItem.getRejectFieldsSetting()) && BeanUtils.isEmpty(formInitItem.getOpposeFieldsSetting()) && BeanUtils.isEmpty(formInitItem.getAddSignFieldsSetting()) && BeanUtils.isEmpty(formInitItem.getRoamFieldsSetting()) && BeanUtils.isEmpty(formInitItem.getConsultFieldsSetting())) {
            return "";
        }
        try {
            XMLBuilder xmlBuilder = XMLBuilder.create((String)"ext:initItem").a("xmlns:ext", "http://www.jee-soft.cn/bpm").a("parentDefKey", formInitItem.getParentDefKey());
            this.buildXml(formInitItem.getShowFieldsSetting(), xmlBuilder, "prevSetting");
            xmlBuilder.up();
            this.buildXml(formInitItem.getSaveFieldsSetting(), xmlBuilder, "saveSetting");
            xmlBuilder.up();
            this.buildXml(formInitItem.getAgreeFieldsSetting(), xmlBuilder, "agreeSetting");
            xmlBuilder.up();
            this.buildXml(formInitItem.getRejectFieldsSetting(), xmlBuilder, "rejectSetting");
            xmlBuilder.up();
            this.buildXml(formInitItem.getOpposeFieldsSetting(), xmlBuilder, "opposeSetting");
            xmlBuilder.up();
            this.buildXml(formInitItem.getAddSignFieldsSetting(), xmlBuilder, "addSignSetting");
            xmlBuilder.up();
            this.buildXml(formInitItem.getRoamFieldsSetting(), xmlBuilder, "roamSetting");
            xmlBuilder.up();
            this.buildXml(formInitItem.getConsultFieldsSetting(), xmlBuilder, "consultSetting");
            return xmlBuilder.asString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private void buildXml(List<FieldInitSetting> settings, XMLBuilder xmlBuilder, String setStr) {
        if (BeanUtils.isNotEmpty(settings)) {
            xmlBuilder = xmlBuilder.e("ext:" + setStr);
            for (FieldInitSetting setting : settings) {
                xmlBuilder.e("ext:fieldSetting").a("description", setting.getDescription()).e("ext:setting").d(setting.getSetting());
            }
        }
    }

    @Override
    protected String getXml(String defId, String node, BpmFormInit formInit) throws Exception {
        DefaultBpmDefinition def = this.bpmDefinitionManager.getById(defId);
        String defXml = def.getBpmnXml();
        Document doc = Dom4jUtil.loadXml((String)defXml);
        Element root = doc.getRootElement();
        List<BpmNodeDef> list = super.getNodeList(defId);
        Map<String, FormInitItem> map = formInit.getFormInitItemMap();
        for (BpmNodeDef nodeDef : list) {
            String nodeId = nodeDef.getNodeId();
            boolean isContain = map.containsKey(nodeId);
            String xml = "";
            if (isContain) {
                xml = this.getFormInit(map.get(nodeId));
            }
            String xPath = "//ext:*[@bpmnElement='" + nodeId + "']/ext:formInitSetting";
            String xParentPath = "//ext:*[@bpmnElement='" + nodeId + "']";
            Node el = root.selectSingleNode(xPath);
            Element elParent = (Element)root.selectSingleNode(xParentPath);
            if (el == null) {
                String propxml = "<ext:formInitSetting xmlns:ext=\"http://www.jee-soft.cn/bpm\" />";
                Document tempDoc = Dom4jUtil.loadXml((String)propxml);
                elParent.add(tempDoc.getRootElement());
            }
            String xPathItem = "//ext:*[@bpmnElement='" + nodeId + "']/ext:formInitSetting/ext:initItem[@parentDefKey='" + formInit.getParentDefKey() + "']";
            DefXmlHandlerUtil.handXmlDom(root, xml, xPath, xPathItem);
        }
        return root.asXML();
    }
}

