/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.engine.def.impl.handler;

import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.Dom4jUtil;
import com.hotent.bpm.api.model.process.nodedef.JumpRule;
import com.hotent.bpm.engine.def.AbstractBpmDefXmlHandler;
import com.hotent.bpm.engine.def.DefXmlHandlerUtil;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.jamesmurty.utils.XMLBuilder;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.stereotype.Service;

@Service
public class TransRulesBpmDefXmlHandler
extends AbstractBpmDefXmlHandler<List<JumpRule>> {
    private String getXml(List<JumpRule> jumpRuleList) {
        String xml = "";
        if (BeanUtils.isEmpty(jumpRuleList)) {
            return xml;
        }
        try {
            xml = xml + "<ext:transformRules xmlns:ext=\"http://www.jee-soft.cn/bpm\">";
            for (JumpRule jumpRule : jumpRuleList) {
                XMLBuilder ruleBuilder = XMLBuilder.create((String)"ext:rule").a("name", jumpRule.getRuleName()).a("targetnode", jumpRule.getTargetNode()).e("ext:condition").d(jumpRule.getCondition()).up();
                xml = xml + ruleBuilder.asString();
            }
            xml = xml + "</ext:transformRules>";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xml;
    }

    @Override
    protected String getXml(String defId, String nodeId, List<JumpRule> jumpRuleList) {
        String xml = this.getXml(jumpRuleList);
        DefaultBpmDefinition bpmDef = this.bpmDefinitionManager.getById(defId);
        String defXml = bpmDef.getBpmnXml();
        String xPath = "//ext:*[@bpmnElement='" + nodeId + "']/ext:transformRules";
        String xParentPath = "//ext:*[@bpmnElement='" + nodeId + "']";
        String rtnXml = DefXmlHandlerUtil.getXml(defXml, xml, xParentPath, xPath);
        return rtnXml;
    }

    public String copyNodeTransRule(String sourceNodeId, String targetNodeId, String bpmnXml) {
        Document doc = Dom4jUtil.loadXml((String)bpmnXml);
        Element root = doc.getRootElement();
        String subElName = "transformRules";
        String xParentPath = "//ext:extProcess//ext:*[@bpmnElement='%s']";
        Element parentEl = (Element)root.selectSingleNode(String.format(xParentPath, sourceNodeId));
        Element element = (Element)parentEl.selectSingleNode(subElName);
        DefXmlHandlerUtil.handleXmlDom(root, element != null ? element.asXML() : "", String.format(xParentPath, targetNodeId), subElName);
        return root.asXML();
    }
}

