/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.engine.form;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.feign.FormFeignService;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FluentUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.model.form.FormType;
import com.hotent.bpm.api.model.process.def.BpmDefinition;
import com.hotent.bpm.api.model.process.def.BpmProcessDef;
import com.hotent.bpm.api.model.process.def.BpmProcessDefExt;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeForm;
import com.hotent.bpm.api.model.process.nodedef.ext.CallActivityNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.UserTaskNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.FormExt;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.api.service.BpmDefinitionService;
import com.hotent.bpm.api.service.BpmFormService;
import com.hotent.bpm.model.form.BpmForm;
import com.hotent.bpm.model.form.BpmUrlForm;
import com.hotent.bpm.model.form.Form;
import com.hotent.bpm.model.form.FormCategory;
import com.hotent.bpm.model.form.FormModel;
import com.hotent.bpm.natapi.inst.NatProInstanceService;
import com.hotent.bpm.persistence.manager.BpmBusLinkManager;
import com.hotent.bpm.persistence.manager.BpmInstFormManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.manager.BpmWatermarkManager;
import com.hotent.bpm.persistence.model.BpmBusLink;
import com.hotent.bpm.persistence.model.BpmInstForm;
import com.hotent.bpm.persistence.model.BpmWatermark;
import com.hotent.bpm.persistence.model.DefaultBpmProcessDefExt;
import com.hotent.bpm.util.BpmUtil;
import com.hotent.bpm.util.PortalDataUtil;
import com.hotent.i18n.util.I18nUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.http.client.ClientProtocolException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.Assert;

public abstract class AbstractFormService
implements BpmFormService {
    private static Pattern regex = Pattern.compile("\\{(\\w+)\\}", 66);
    @Resource
    protected BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    protected BpmDefinitionService bpmDefinitionService;
    @Resource
    protected BpmBusLinkManager bpmBusLinkManager;
    @Resource
    protected NatProInstanceService natProcessInstanceService;
    @Resource
    protected FormFeignService formService;
    @Resource
    protected PortalFeignService portalService;
    @Resource
    protected BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    protected BpmInstFormManager bpmInstFormManager;

    protected abstract Form getFormByNodeDef(BpmNodeDef var1);

    protected abstract Form getGlobalFormByDefExt(DefaultBpmProcessDefExt var1);

    protected abstract Form getInstFormByDefExt(DefaultBpmProcessDefExt var1);

    protected abstract Form getSubForm(BpmNodeDef var1, String var2);

    @Override
    public BpmNodeForm getByDefId(String defId) throws Exception {
        BpmNodeForm nodeForm = this.getFormDefByDefId(defId);
        if (nodeForm == null) {
            return null;
        }
        FormModel formModel = this.getByForm(nodeForm.getForm(), null, false);
        String formHtml = I18nUtil.replaceTemp((String)formModel.getFormHtml(), (String)"\\#\\{([\\w]+[\\.\\w]*)\\}", (Locale)LocaleContextHolder.getLocale());
        formModel.setFormHtml(formHtml);
        nodeForm.setForm(formModel);
        return nodeForm;
    }

    @Override
    public BpmNodeForm getByInstance(BpmProcessInstance instance) throws Exception {
        if (instance == null) {
            return null;
        }
        BpmNodeForm nodeForm = this.getFormDefByDefId(instance.getProcDefId());
        if (nodeForm == null) {
            return null;
        }
        FormModel formModel = this.getByForm(nodeForm.getForm(), instance, false);
        String formHtml = I18nUtil.replaceTemp((String)formModel.getFormHtml(), (String)"\\#\\{([\\w]+[\\.\\w]*)\\}", (Locale)LocaleContextHolder.getLocale());
        formModel.setFormHtml(formHtml);
        nodeForm.setForm(formModel);
        return nodeForm;
    }

    @Override
    public BpmUrlForm getDefUrlForm(String defId) throws Exception {
        BpmNodeForm nodeForm = this.getFormDefByDefId(defId);
        if (nodeForm == null) {
            return null;
        }
        return this.getByUrlForm(nodeForm.getForm(), null, false);
    }

    protected boolean isNotEmptyForm(Form form) {
        if (form == null) {
            return false;
        }
        return !form.isFormEmpty();
    }

    protected BpmNodeForm getFormDefByDefId(String defId) throws Exception {
        DefaultBpmProcessDefExt defExt;
        Form gloableForm;
        Form task1Form;
        BpmNodeDef nodeDef;
        List<BpmNodeDef> bpmNodeDefs;
        BpmNodeForm nodeForm = new BpmNodeForm();
        BpmProcessDef<BpmProcessDefExt> bpmProcessDef = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        BpmNodeDef bpmNodeDef = bpmProcessDef.getStartEvent();
        Form form = this.getFormByNodeDef(bpmNodeDef);
        String helpFile = "";
        if (BeanUtils.isNotEmpty((Object)form)) {
            if (StringUtil.isNotEmpty((String)form.getHelpFile()) && StringUtil.isNotEmpty((String)form.getFormValue())) {
                nodeForm.setBpmNodeDef(bpmNodeDef);
                nodeForm.setForm(form);
                return nodeForm;
            }
            helpFile = form.getHelpFile();
        }
        if (BeanUtils.isNotEmpty(bpmNodeDefs = bpmProcessDef.getStartNodes()) && bpmNodeDefs.size() == 1 && (nodeDef = bpmNodeDefs.get(0)) instanceof UserTaskNodeDef && BeanUtils.isNotEmpty((Object)(task1Form = this.getFormByNodeDef(nodeDef)))) {
            String string = helpFile = StringUtil.isNotEmpty((String)helpFile) ? helpFile : task1Form.getHelpFile();
            if (!this.isNotEmptyForm(form) && StringUtil.isNotEmpty((String)task1Form.getFormValue())) {
                form = task1Form;
            }
        }
        if ((!this.isNotEmptyForm(form) || StringUtil.isEmpty((String)helpFile)) && BeanUtils.isNotEmpty((Object)(gloableForm = this.getGlobalFormByDefExt(defExt = (DefaultBpmProcessDefExt)bpmProcessDef.getProcessDefExt())))) {
            String string = helpFile = StringUtil.isNotEmpty((String)helpFile) ? helpFile : gloableForm.getHelpFile();
            if (!this.isNotEmptyForm(form) && StringUtil.isNotEmpty((String)gloableForm.getFormValue())) {
                form = gloableForm;
            }
        }
        if (this.isNotEmptyForm(form)) {
            form.setHelpFile(helpFile);
            nodeForm.setBpmNodeDef(bpmNodeDef);
            nodeForm.setForm(form);
            return nodeForm;
        }
        return null;
    }

    @Override
    public BpmNodeForm getByDraft(BpmProcessInstance instance) throws Exception {
        String defId = instance.getProcDefId();
        BpmNodeForm nodeForm = this.getFormDefByDefId(defId);
        if (nodeForm == null) {
            return null;
        }
        FormModel formModel = this.getByForm(nodeForm.getForm(), instance, false);
        String formHtml = I18nUtil.replaceTemp((String)formModel.getFormHtml(), (String)"\\#\\{([\\w]+[\\.\\w]*)\\}", (Locale)LocaleContextHolder.getLocale());
        formModel.setFormHtml(formHtml);
        nodeForm.setForm(formModel);
        return nodeForm;
    }

    private BpmForm getFormByKey(String formKey) throws JsonParseException, JsonMappingException, IOException {
        AbstractFormService bean = (AbstractFormService)AppUtil.getBean(this.getClass());
        return bean.getFormByKeyFromCache(formKey);
    }

    protected BpmForm getFormByKeyFromCache(String formKey) throws JsonParseException, JsonMappingException, IOException {
        BpmWatermarkManager bpmWatermarkManager;
        BpmWatermark bpmWatermark;
        String waterId;
        ObjectNode byFormKey = this.formService.getByFormKey(formKey);
        BpmForm bpmFrom = (BpmForm)JsonUtil.toBean((JsonNode)byFormKey, BpmForm.class);
        if (byFormKey != null && byFormKey.has("watermarkId") && StringUtil.isNotEmpty((String)(waterId = JsonUtil.getString((JsonNode)byFormKey, (String)"watermarkId"))) && (bpmWatermark = (BpmWatermark)(bpmWatermarkManager = (BpmWatermarkManager)AppUtil.getBean(BpmWatermarkManager.class)).get((Serializable)((Object)waterId))) != null && "0".equals(bpmWatermark.getStatus())) {
            bpmFrom.setWater(bpmWatermark);
        }
        if (BeanUtils.isEmpty((Object)bpmFrom)) {
            throw new RuntimeException("\u6839\u636e\u672c\u8868\u5355key:" + formKey + "\u672a\u627e\u5230\u76f8\u5e94\u7684\u8868\u5355");
        }
        return bpmFrom;
    }

    private BpmUrlForm getUrlFormKey(String formKey) throws JsonParseException, JsonMappingException, IOException {
        AbstractFormService bean = (AbstractFormService)AppUtil.getBean(this.getClass());
        return bean.getUrlFormByKeyCache(formKey);
    }

    @Cacheable(value={"eip:form:urlForm"}, key="#formKey")
    protected BpmUrlForm getUrlFormByKeyCache(String formKey) throws JsonParseException, JsonMappingException, IOException {
        ObjectNode byFormKey = this.formService.getUrlFormByKey(formKey);
        if (BeanUtils.isEmpty((Object)byFormKey)) {
            throw new RuntimeException("\u6839\u636e\u672c\u8868\u5355key:" + formKey + "\u672a\u627e\u5230\u76f8\u5e94\u7684\u8868\u5355");
        }
        BpmUrlForm bpmFrom = (BpmUrlForm)JsonUtil.toBean((JsonNode)byFormKey, BpmUrlForm.class);
        String sysCode = bpmFrom.getSysCode();
        if (StringUtil.isNotEmpty((String)sysCode)) {
            CommonResult commonResult = this.portalService.getBizSystemByCode(sysCode);
            if (!commonResult.getState().booleanValue()) {
                throw new RuntimeException("\u6839\u636e\u7cfb\u7edfID:" + sysCode + "\u672a\u627e\u5230\u5bf9\u5e94\u5916\u90e8\u7cfb\u7edf");
            }
            JsonNode jsonNode = JsonUtil.toJsonNode((Object)commonResult.getValue());
            if (BeanUtils.isNotEmpty((Object)jsonNode.get("rootAddress"))) {
                String baseUrl = jsonNode.get("rootAddress").asText();
                bpmFrom.setBaseUrl(baseUrl);
            }
        }
        return bpmFrom;
    }

    protected FormModel getByForm(Form frm, BpmProcessInstance instance) throws ClientProtocolException, IOException {
        BpmForm formModel = new BpmForm(frm);
        FormCategory formType = formModel.getType();
        if (FormCategory.INNER.equals((Object)formType)) {
            String formKey = formModel.getFormValue();
            BpmForm bpmFrom = this.getFormByKey(formKey);
            BpmForm formModelDB = bpmFrom;
            if (BeanUtils.isNotEmpty((Object)formModelDB)) {
                String html = formModelDB.getFormHtml();
                if (html.indexOf("</form>") == -1) {
                    // empty if block
                }
                formModel.setFormHtml(html);
                formModel.setFormKey(formModelDB.getFormKey());
                formModel.setFormId(formModelDB.getFormId());
            }
        } else if (FormCategory.FRAME.equals((Object)formType)) {
            String url;
            if (instance != null) {
                url = frm.getFormValue();
                url = this.getUrl(instance, url);
                formModel.setFormValue(url);
            } else {
                url = frm.getFormValue();
                url = AbstractFormService.replaceStr(url);
                formModel.setFormValue(url);
            }
        }
        String formHtml = I18nUtil.replaceTemp((String)formModel.getFormHtml(), (String)"\\#\\{([\\w]+[\\.\\w]*)\\}", (Locale)LocaleContextHolder.getLocale());
        formModel.setFormHtml(formHtml);
        return formModel;
    }

    protected FormModel getByForm(Form frm, BpmProcessInstance instance, boolean isTaskOrDone) throws ClientProtocolException, IOException {
        BpmUrlForm bpmUrlForm;
        String formKey;
        BpmForm formModel = new BpmForm(frm);
        FormCategory formType = formModel.getType();
        if (FormCategory.INNER.equals((Object)formType)) {
            formKey = formModel.getFormValue();
            BpmForm bpmFrom = this.getFormByKey(formKey);
            BpmForm formModelDB = bpmFrom;
            if (BeanUtils.isNotEmpty((Object)formModelDB)) {
                String html = formModelDB.getFormHtml();
                if (html.indexOf("</form>") == -1) {
                    // empty if block
                }
                formModel.setFormHtml(html);
                formModel.setFormKey(formModelDB.getFormKey());
                formModel.setFormId(formModelDB.getFormId());
                formModel.setDiyJs(formModelDB.getDiyJs());
                formModel.setFormCss(formModelDB.getFormCss());
                formModel.setWater(formModelDB.getWater());
            }
        } else if (FormCategory.FRAME.equals((Object)formType) && BeanUtils.isNotEmpty((Object)(bpmUrlForm = this.getUrlFormKey(formKey = formModel.getFormValue()))) && BpmUrlForm.YES.equals(bpmUrlForm.getIsEmbed())) {
            formModel.setTokenAuth(bpmUrlForm.getTokenAuth());
            String baseUrl = bpmUrlForm.getBaseUrl();
            if (instance != null) {
                String url = baseUrl + bpmUrlForm.getTaskUrl();
                if (StringUtil.isNotEmpty((String)bpmUrlForm.getTaskUrl()) && FluentUtil.isHttpUrl((String)bpmUrlForm.getTaskUrl())) {
                    url = bpmUrlForm.getStartUrl();
                }
                if (!isTaskOrDone && StringUtil.isNotEmpty((String)bpmUrlForm.getInstUrl())) {
                    url = baseUrl + bpmUrlForm.getInstUrl();
                }
                url = this.getUrl(instance, url);
                formModel.setFormValue(url);
            } else {
                String url = baseUrl + bpmUrlForm.getStartUrl();
                if (StringUtil.isNotEmpty((String)bpmUrlForm.getStartUrl()) && FluentUtil.isHttpUrl((String)bpmUrlForm.getStartUrl())) {
                    url = bpmUrlForm.getStartUrl();
                }
                if (StringUtil.isEmpty((String)url)) {
                    url = baseUrl + bpmUrlForm.getTaskUrl();
                }
                url = AbstractFormService.replaceStr(url);
                formModel.setFormValue(url);
            }
        }
        String formHtml = I18nUtil.replaceTemp((String)formModel.getFormHtml(), (String)"\\#\\{([\\w]+[\\.\\w]*)\\}", (Locale)LocaleContextHolder.getLocale());
        formModel.setFormHtml(formHtml);
        return formModel;
    }

    protected BpmUrlForm getByUrlForm(Form frm, BpmProcessInstance instance, boolean isTaskOrDone) throws ClientProtocolException, IOException {
        BpmForm formModel = new BpmForm(frm);
        FormCategory formType = formModel.getType();
        if (FormCategory.FRAME.equals((Object)formType)) {
            String formKey = formModel.getFormValue();
            BpmUrlForm bpmUrlForm = this.getUrlFormKey(formKey);
            return bpmUrlForm;
        }
        return null;
    }

    protected FormModel handForm(FormModel formModel, BpmProcessInstance instance) {
        FormCategory formType = formModel.getType();
        if (FormCategory.INNER.equals((Object)formType)) {
            String html = formModel.getFormHtml();
            if (html.indexOf("</form>") == -1) {
                // empty if block
            }
            formModel.setFormValue(formModel.getFormKey());
            formModel.setFormHtml(html);
        } else if (FormCategory.FRAME.equals((Object)formType)) {
            if (instance != null) {
                String url = formModel.getFormValue();
                url = this.getUrl(instance, url);
                formModel.setFormValue(url);
            } else {
                String url = formModel.getFormValue();
                url = AbstractFormService.replaceStr(url);
                formModel.setFormValue(url);
            }
        }
        return formModel;
    }

    protected FormModel handForm(FormModel formModel, BpmUrlForm bpmUrlForm, BpmProcessInstance instance, boolean isTaskOrDone) {
        FormCategory formType = formModel.getType();
        if (FormCategory.INNER.equals((Object)formType)) {
            String html = formModel.getFormHtml();
            if (html.indexOf("</form>") == -1) {
                // empty if block
            }
            formModel.setFormValue(formModel.getFormKey());
            formModel.setFormHtml(html);
        } else if (FormCategory.FRAME.equals((Object)formType) && BpmUrlForm.YES.equals(bpmUrlForm.getIsEmbed())) {
            formModel.setTokenAuth(bpmUrlForm.getTokenAuth());
            String baseUrl = bpmUrlForm.getBaseUrl();
            if (instance != null) {
                String url = baseUrl + bpmUrlForm.getTaskUrl();
                if (!isTaskOrDone && StringUtil.isNotEmpty((String)bpmUrlForm.getInstUrl())) {
                    url = baseUrl + bpmUrlForm.getInstUrl();
                }
                url = this.getUrl(instance, url);
                formModel.setFormValue(url);
            } else {
                String url = baseUrl + bpmUrlForm.getStartUrl();
                if (StringUtil.isEmpty((String)url)) {
                    url = baseUrl + bpmUrlForm.getTaskUrl();
                }
                url = AbstractFormService.replaceStr(url);
                formModel.setFormValue(url);
            }
        }
        return formModel;
    }

    @Override
    public Form getFormDefByDefNode(String defId, String nodeId, BpmProcessInstance bpmProcessInstance) throws Exception {
        BpmNodeDef bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        Form form = null;
        String parentInstId = bpmProcessInstance.getParentInstId();
        if (StringUtil.isZeroEmpty((String)parentInstId) && bpmNodeDef != null) {
            form = this.getFormByNodeDef(bpmNodeDef);
        }
        return form;
    }

    @Override
    public FormModel getInstFormByDefId(BpmProcessInstance instance) throws Exception {
        BpmProcessInstance topInstance = this.bpmProcessInstanceManager.getTopBpmProcessInstance(instance);
        String defId = topInstance.getProcDefId();
        FormModel formModel = this.getInstanceNodeForm(instance, defId, instance.getId(), false);
        if (BeanUtils.isNotEmpty((Object)formModel)) {
            return formModel;
        }
        FormModel frmModel = this.getInstanceNodeForm(instance, defId, null, false);
        return frmModel;
    }

    @Override
    public FormModel getByDefId(String defId, String nodeId, BpmProcessInstance instance, boolean isTaskOrDone) throws Exception {
        return this.getByDefId(defId, nodeId, instance, isTaskOrDone, false);
    }

    @Override
    public FormModel getByDefId(String defId, String nodeId, BpmProcessInstance instance, boolean isTaskOrDone, boolean isMobile) throws Exception {
        FormModel formModel;
        BpmNodeDef bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        String useMainForm = "";
        if (BeanUtils.isNotEmpty((Object)bpmNodeDef)) {
            BpmProcessInstance parentInstance;
            useMainForm = BpmUtil.getUseMainForm(bpmNodeDef);
            if (StringUtil.isNotZeroEmpty((String)instance.getParentInstId()) && bpmNodeDef.getParentBpmNodeDef() == null && BeanUtils.isNotEmpty((Object)(parentInstance = (BpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instance.getParentInstId()))))) {
                BpmNodeDef parentBpmNodeDef = this.bpmDefinitionAccessor.getStartEvent(parentInstance.getProcDefId());
                useMainForm = BpmUtil.getUseMainForm(parentBpmNodeDef);
            }
        }
        if (StringUtil.isEmpty((String)useMainForm) || "instUseMainForm".equals(useMainForm)) {
            useMainForm = "mainVersion";
            String isUsedMainForm = PortalDataUtil.getPropertyByAlias("inst.useMainForm");
            if (BeanUtils.isEmpty((Object)isUsedMainForm)) {
                isUsedMainForm = "true";
            }
            if (!Boolean.parseBoolean(isUsedMainForm)) {
                useMainForm = "startVersion";
            }
        }
        if (useMainForm.equals("startVersion") && BeanUtils.isNotEmpty((Object)(formModel = this.getInstanceNodeForm(instance, defId, nodeId, isTaskOrDone)))) {
            return formModel;
        }
        Form frm = null;
        String formHelpFile = "";
        if (StringUtil.isZeroEmpty((String)instance.getParentInstId())) {
            frm = this.getFormDefByDefNode(defId, nodeId, instance);
            if (frm != null) {
                formHelpFile = frm.getHelpFile();
                if (StringUtil.isNotEmpty((String)frm.getFormValue()) && StringUtil.isNotEmpty((String)formHelpFile)) {
                    FormModel formModel2 = this.getByForm(frm, instance, isTaskOrDone);
                    return formModel2;
                }
            }
            if (frm == null || StringUtil.isEmpty((String)frm.getFormValue()) || StringUtil.isEmpty((String)formHelpFile)) {
                DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)this.bpmDefinitionAccessor.getBpmProcessDef(defId).getProcessDefExt();
                if (isTaskOrDone) {
                    Form globalForm = this.getGlobalFormByDefExt(defExt);
                    if (BeanUtils.isEmpty((Object)frm) || BeanUtils.isEmpty((Object)frm.getFormValue())) {
                        frm = globalForm;
                    }
                    if (StringUtil.isEmpty((String)formHelpFile) && BeanUtils.isNotEmpty((Object)globalForm)) {
                        formHelpFile = globalForm.getHelpFile();
                    }
                } else if ((BeanUtils.isEmpty((Object)frm) || StringUtil.isEmpty((String)frm.getFormValue())) && BeanUtils.isEmpty((Object)(frm = this.getInstFormByDefExt(defExt)))) {
                    frm = this.getGlobalFormByDefExt(defExt);
                }
            }
            if (frm != null) {
                if (StringUtil.isNotEmpty((String)formHelpFile)) {
                    frm.setHelpFile(formHelpFile);
                }
                FormModel formModel3 = this.getByForm(frm, instance, isTaskOrDone);
                return formModel3;
            }
        } else {
            BpmNodeForm nodeFrm;
            BpmProcessDef<BpmProcessDefExt> bpmProcessDef;
            DefaultBpmProcessDefExt defExt;
            FormExt subGlobalForm;
            BpmProcessInstance topInstance = this.bpmProcessInstanceManager.getTopBpmProcessInstance(instance);
            String parentDefKey = topInstance.getProcDefKey();
            if (BeanUtils.isNotEmpty((Object)bpmNodeDef) && BeanUtils.isNotEmpty((Object)(frm = this.getSubForm(bpmNodeDef, parentDefKey))) && StringUtil.isEmpty((String)formHelpFile)) {
                formHelpFile = frm.getHelpFile();
            }
            if ((!this.isNotEmptyForm(frm) || StringUtil.isEmpty((String)formHelpFile)) && BeanUtils.isNotEmpty((Object)(subGlobalForm = (defExt = (DefaultBpmProcessDefExt)(bpmProcessDef = this.bpmDefinitionAccessor.getBpmProcessDef(defId)).getProcessDefExt()).getGlobalFormByDefKey(parentDefKey, isMobile)))) {
                if (!this.isNotEmptyForm(frm)) {
                    frm = subGlobalForm;
                }
                if (StringUtil.isEmpty((String)formHelpFile)) {
                    formHelpFile = frm.getHelpFile();
                }
            }
            if ((!this.isNotEmptyForm(frm) || StringUtil.isEmpty((String)formHelpFile)) && BeanUtils.isNotEmpty((Object)(nodeFrm = this.getFormDefByParentFlowKey(topInstance.getProcDefId(), "local_", isMobile)))) {
                if (!this.isNotEmptyForm(frm)) {
                    frm = nodeFrm.getForm();
                }
                if (StringUtil.isEmpty((String)formHelpFile)) {
                    formHelpFile = frm.getHelpFile();
                }
            }
            if (BeanUtils.isEmpty((Object)frm)) {
                return null;
            }
            FormModel formModel4 = this.getByForm(frm, topInstance, isTaskOrDone);
            formModel4.setHelpFile(formHelpFile);
            return formModel4;
        }
        return null;
    }

    @Override
    public FormModel myApplication(String defId, String startNodeId, String nodeId, BpmProcessInstance instance, boolean isTaskOrDone, boolean myApplication) throws Exception {
        FormModel formModel;
        BpmNodeDef bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        String useMainForm = "";
        if (BeanUtils.isNotEmpty((Object)bpmNodeDef)) {
            BpmProcessInstance parentInstance;
            useMainForm = BpmUtil.getUseMainForm(bpmNodeDef);
            if (StringUtil.isNotZeroEmpty((String)instance.getParentInstId()) && bpmNodeDef.getParentBpmNodeDef() == null && BeanUtils.isNotEmpty((Object)(parentInstance = (BpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instance.getParentInstId()))))) {
                BpmNodeDef parentBpmNodeDef = this.bpmDefinitionAccessor.getStartEvent(parentInstance.getProcDefId());
                useMainForm = BpmUtil.getUseMainForm(parentBpmNodeDef);
            }
        }
        if (StringUtil.isEmpty((String)useMainForm) || "instUseMainForm".equals(useMainForm)) {
            useMainForm = "mainVersion";
            String isUsedMainForm = PortalDataUtil.getPropertyByAlias("inst.useMainForm");
            if (BeanUtils.isEmpty((Object)isUsedMainForm)) {
                isUsedMainForm = "true";
            }
            if (!Boolean.parseBoolean(isUsedMainForm)) {
                useMainForm = "startVersion";
            }
        }
        if (useMainForm.equals("startVersion") && BeanUtils.isNotEmpty((Object)(formModel = this.getInstanceNodeForm(instance, defId, nodeId, isTaskOrDone)))) {
            return formModel;
        }
        Form formNode = this.getFormByNodeDef(bpmNodeDef);
        if (myApplication && BeanUtils.isNotEmpty((Object)formNode)) {
            return this.getByForm(formNode, instance, isTaskOrDone);
        }
        Form frm = null;
        String formHelpFile = "";
        if (StringUtil.isZeroEmpty((String)instance.getParentInstId())) {
            frm = this.getFormDefByDefNode(defId, nodeId, instance);
            if (frm != null) {
                formHelpFile = frm.getHelpFile();
                if (StringUtil.isNotEmpty((String)frm.getFormValue()) && StringUtil.isNotEmpty((String)formHelpFile)) {
                    FormModel formModel2 = this.getByForm(frm, instance, isTaskOrDone);
                    return formModel2;
                }
            }
            if (frm == null || StringUtil.isEmpty((String)frm.getFormValue()) || StringUtil.isEmpty((String)formHelpFile)) {
                DefaultBpmProcessDefExt defExt;
                List<BpmNodeDef> startNodes;
                frm = this.getFormDefByDefNode(defId, startNodeId, instance);
                if (frm != null) {
                    formHelpFile = frm.getHelpFile();
                    if (StringUtil.isNotEmpty((String)frm.getFormValue()) && StringUtil.isNotEmpty((String)formHelpFile)) {
                        FormModel formModel3 = this.getByForm(frm, instance, isTaskOrDone);
                        return formModel3;
                    }
                }
                if ((startNodes = this.bpmDefinitionAccessor.getStartNodes(defId)) != null) {
                    for (int i = 0; i < startNodes.size() && (frm = this.getFormByNodeDef(startNodes.get(i))) == null; ++i) {
                    }
                }
                if (frm == null && BeanUtils.isEmpty((Object)(frm = this.getInstFormByDefExt(defExt = (DefaultBpmProcessDefExt)this.bpmDefinitionAccessor.getBpmProcessDef(defId).getProcessDefExt())))) {
                    frm = this.getGlobalFormByDefExt(defExt);
                }
            }
            if (frm != null) {
                if (StringUtil.isNotEmpty((String)formHelpFile)) {
                    frm.setHelpFile(formHelpFile);
                }
                FormModel formModel4 = this.getByForm(frm, instance, isTaskOrDone);
                return formModel4;
            }
        } else {
            BpmNodeForm nodeFrm;
            BpmProcessDef<BpmProcessDefExt> bpmProcessDef;
            DefaultBpmProcessDefExt defExt;
            FormExt subGlobalForm;
            BpmProcessInstance topInstance = this.bpmProcessInstanceManager.getTopBpmProcessInstance(instance);
            String parentDefKey = topInstance.getProcDefKey();
            if (BeanUtils.isNotEmpty((Object)bpmNodeDef) && BeanUtils.isNotEmpty((Object)(frm = this.getSubForm(bpmNodeDef, parentDefKey))) && StringUtil.isEmpty((String)formHelpFile)) {
                formHelpFile = frm.getHelpFile();
            }
            if ((!this.isNotEmptyForm(frm) || StringUtil.isEmpty((String)formHelpFile)) && BeanUtils.isNotEmpty((Object)(subGlobalForm = (defExt = (DefaultBpmProcessDefExt)(bpmProcessDef = this.bpmDefinitionAccessor.getBpmProcessDef(defId)).getProcessDefExt()).getGlobalFormByDefKey(parentDefKey, false)))) {
                if (!this.isNotEmptyForm(frm)) {
                    frm = subGlobalForm;
                }
                if (StringUtil.isEmpty((String)formHelpFile)) {
                    formHelpFile = frm.getHelpFile();
                }
            }
            if ((!this.isNotEmptyForm(frm) || StringUtil.isEmpty((String)formHelpFile)) && BeanUtils.isNotEmpty((Object)(nodeFrm = this.getFormDefByParentFlowKey(topInstance.getProcDefId(), "local_", false)))) {
                if (!this.isNotEmptyForm(frm)) {
                    frm = nodeFrm.getForm();
                }
                if (StringUtil.isEmpty((String)formHelpFile)) {
                    formHelpFile = frm.getHelpFile();
                }
            }
            FormModel formModel5 = this.getByForm(frm, topInstance, isTaskOrDone);
            formModel5.setHelpFile(formHelpFile);
            return formModel5;
        }
        return null;
    }

    @Override
    public BpmUrlForm getBpmUrlForm(String defId, String nodeId, BpmProcessInstance instance, boolean isTaskOrDone) throws Exception {
        BpmUrlForm bpmUrlForm;
        BpmNodeDef bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        String useMainForm = "";
        if (BeanUtils.isNotEmpty((Object)bpmNodeDef)) {
            BpmProcessInstance parentInstance;
            useMainForm = BpmUtil.getUseMainForm(bpmNodeDef);
            if (StringUtil.isNotZeroEmpty((String)instance.getParentInstId()) && bpmNodeDef.getParentBpmNodeDef() == null && BeanUtils.isNotEmpty((Object)(parentInstance = (BpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instance.getParentInstId()))))) {
                BpmNodeDef parentBpmNodeDef = this.bpmDefinitionAccessor.getStartEvent(parentInstance.getProcDefId());
                useMainForm = BpmUtil.getUseMainForm(parentBpmNodeDef);
            }
        }
        if (StringUtil.isEmpty((String)useMainForm) || "instUseMainForm".equals(useMainForm)) {
            useMainForm = "mainVersion";
            String isUsedMainForm = PortalDataUtil.getPropertyByAlias("inst.useMainForm");
            if (BeanUtils.isEmpty((Object)isUsedMainForm)) {
                isUsedMainForm = "true";
            }
            if (!Boolean.parseBoolean(isUsedMainForm)) {
                useMainForm = "startVersion";
            }
        }
        if (useMainForm.equals("startVersion") && BeanUtils.isNotEmpty((Object)(bpmUrlForm = this.getInstanceUrlForm(instance, defId, nodeId, isTaskOrDone)))) {
            return bpmUrlForm;
        }
        Form frm = null;
        String formHelpFile = "";
        if (StringUtil.isZeroEmpty((String)instance.getParentInstId())) {
            frm = this.getFormDefByDefNode(defId, nodeId, instance);
            if (frm != null) {
                formHelpFile = frm.getHelpFile();
                if (StringUtil.isNotEmpty((String)frm.getFormValue()) && StringUtil.isNotEmpty((String)formHelpFile)) {
                    BpmUrlForm bpmUrlForm2 = this.getByUrlForm(frm, instance, isTaskOrDone);
                    return bpmUrlForm2;
                }
            }
            if (frm == null || StringUtil.isEmpty((String)frm.getFormValue()) || StringUtil.isEmpty((String)formHelpFile)) {
                DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)this.bpmDefinitionAccessor.getBpmProcessDef(defId).getProcessDefExt();
                if (isTaskOrDone) {
                    Form globalForm = this.getGlobalFormByDefExt(defExt);
                    if (BeanUtils.isEmpty((Object)frm) || BeanUtils.isEmpty((Object)frm.getFormValue())) {
                        frm = globalForm;
                    }
                    if (StringUtil.isEmpty((String)formHelpFile) && BeanUtils.isNotEmpty((Object)globalForm)) {
                        formHelpFile = globalForm.getHelpFile();
                    }
                } else if ((BeanUtils.isEmpty((Object)frm) || StringUtil.isEmpty((String)frm.getFormValue())) && BeanUtils.isEmpty((Object)(frm = this.getInstFormByDefExt(defExt)))) {
                    frm = this.getGlobalFormByDefExt(defExt);
                }
            }
            if (frm != null) {
                if (StringUtil.isNotEmpty((String)formHelpFile)) {
                    frm.setHelpFile(formHelpFile);
                }
                BpmUrlForm bpmUrlForm3 = this.getByUrlForm(frm, instance, isTaskOrDone);
                return bpmUrlForm3;
            }
        } else {
            BpmNodeForm nodeFrm;
            BpmProcessDef<BpmProcessDefExt> bpmProcessDef;
            DefaultBpmProcessDefExt defExt;
            FormExt subGlobalForm;
            BpmProcessInstance topInstance = this.bpmProcessInstanceManager.getTopBpmProcessInstance(instance);
            String parentDefKey = topInstance.getProcDefKey();
            if (BeanUtils.isNotEmpty((Object)bpmNodeDef) && BeanUtils.isNotEmpty((Object)(frm = this.getSubForm(bpmNodeDef, parentDefKey))) && StringUtil.isEmpty((String)formHelpFile)) {
                formHelpFile = frm.getHelpFile();
            }
            if ((!this.isNotEmptyForm(frm) || StringUtil.isEmpty((String)formHelpFile)) && BeanUtils.isNotEmpty((Object)(subGlobalForm = (defExt = (DefaultBpmProcessDefExt)(bpmProcessDef = this.bpmDefinitionAccessor.getBpmProcessDef(defId)).getProcessDefExt()).getGlobalFormByDefKey(parentDefKey, false)))) {
                if (!this.isNotEmptyForm(frm)) {
                    frm = subGlobalForm;
                }
                if (StringUtil.isEmpty((String)formHelpFile)) {
                    formHelpFile = frm.getHelpFile();
                }
            }
            if ((!this.isNotEmptyForm(frm) || StringUtil.isEmpty((String)formHelpFile)) && BeanUtils.isNotEmpty((Object)(nodeFrm = this.getFormDefByParentFlowKey(topInstance.getProcDefId(), "local_", false)))) {
                if (!this.isNotEmptyForm(frm)) {
                    frm = nodeFrm.getForm();
                }
                if (StringUtil.isEmpty((String)formHelpFile)) {
                    formHelpFile = frm.getHelpFile();
                }
            }
            BpmUrlForm bpmUrlForm4 = this.getByUrlForm(frm, instance, isTaskOrDone);
            return bpmUrlForm4;
        }
        return null;
    }

    @Override
    public void handleInstForm(String instId, String defId, Boolean isSubFlow) throws Exception {
        List<BpmNodeDef> allBpmNodeDefs = this.bpmDefinitionAccessor.getAllNodeDef(defId);
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        if (!isSubFlow.booleanValue()) {
            BpmProcessDef<BpmProcessDefExt> bpmProcessDef = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
            DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDef.getProcessDefExt();
            FormExt frm = defExt.getGlobalForm();
            this.saveBpmInstForm(frm, instId, defId, null);
            frm = defExt.getGlobalMobileForm();
            this.saveBpmInstForm(frm, instId, defId, null);
            frm = defExt.getInstForm();
            this.saveBpmInstForm(frm, instId, defId, instId);
            frm = defExt.getInstMobileForm();
            this.saveBpmInstForm(frm, instId, defId, instId);
        }
        for (BpmNodeDef bpmNodeDef : allBpmNodeDefs) {
            if (bpmNodeDef instanceof CallActivityNodeDef) {
                BpmDefinition bpmDef = this.bpmDefinitionService.getBpmDefinitionByDefKey(((CallActivityNodeDef)bpmNodeDef).getFlowKey(), false);
                Assert.notNull((Object)bpmDef, (String)String.format("\u627e\u4e0d\u5230\u5b50\u6d41\u7a0b %s[%s]", bpmNodeDef.getName(), ((CallActivityNodeDef)bpmNodeDef).getFlowKey()));
                this.handleInstForm(instId, bpmDef.getDefId(), true);
                continue;
            }
            if (!isSubFlow.booleanValue()) {
                this.saveBpmInstForm(bpmNodeDef.getForm(), instId, defId, bpmNodeDef.getNodeId());
                this.saveBpmInstForm(bpmNodeDef.getMobileForm(), instId, defId, bpmNodeDef.getNodeId());
            }
            if (!isSubFlow.booleanValue()) continue;
            this.saveBpmInstForm(bpmNodeDef.getSubForm(String.valueOf(cmd.getVariables().get("flowKey_")), FormType.MOBILE), instId, defId, bpmNodeDef.getNodeId());
            this.saveBpmInstForm(bpmNodeDef.getSubForm(String.valueOf(cmd.getVariables().get("flowKey_")), FormType.PC), instId, defId, bpmNodeDef.getNodeId());
        }
    }

    private void saveBpmInstForm(Form form, String instId, String defId, String nodeId) throws ClientProtocolException, IOException {
        if (BeanUtils.isEmpty((Object)form) || StringUtil.isEmpty((String)form.getFormValue())) {
            return;
        }
        BpmInstForm bpmInstForm = new BpmInstForm();
        bpmInstForm.setInstId(instId);
        bpmInstForm.setDefId(defId);
        bpmInstForm.setNodeId(nodeId);
        bpmInstForm.setFormCategory(form.getType().value());
        bpmInstForm.setFormType(form.getFormType());
        if (FormCategory.INNER.equals((Object)form.getType())) {
            String formKey = form.getFormValue();
            BpmForm formModel = this.getFormByKey(formKey);
            if (BeanUtils.isNotEmpty((Object)formModel)) {
                bpmInstForm.setFormValue(formModel.getFormId());
            }
        } else {
            String formKey = form.getFormValue();
            BpmUrlForm formModel = this.getUrlFormKey(formKey);
            if (BeanUtils.isNotEmpty((Object)formModel)) {
                bpmInstForm.setFormValue(formModel.getId());
            }
        }
        if (StringUtil.isNotEmpty((String)bpmInstForm.getFormValue())) {
            this.bpmInstFormManager.create((Model)bpmInstForm);
        }
    }

    private String getUrl(BpmProcessInstance instance, String url) {
        HashMap<String, String> map = new HashMap<String, String>();
        if ("pk".equals(instance.getDataMode())) {
            map.put("pk", instance.getBizKey());
            map.put("instId", instance.getId());
        } else {
            List<BpmBusLink> list = this.bpmBusLinkManager.getByInstId(instance.getId());
            for (BpmBusLink link : list) {
                map.put(link.getFormIdentify(), link.getBusinesskeyStr());
            }
        }
        url = AbstractFormService.replaceStr(url, map);
        url = url + (url.contains("?") ? "&" : "?") + "language=" + LocaleContextHolder.getLocale().toLanguageTag();
        return url;
    }

    private static String replaceStr(String str, Map<String, String> map) {
        if (StringUtil.isEmpty((String)str)) {
            return "";
        }
        Matcher regexMatcher = regex.matcher(str);
        while (regexMatcher.find()) {
            String key = regexMatcher.group(1);
            String toReplace = regexMatcher.group(0);
            String val = map.get(key);
            if (!StringUtil.isNotEmpty((String)val)) continue;
            str = str.replace(toReplace, val);
        }
        return str;
    }

    private static String replaceStr(String str) {
        if (StringUtil.isEmpty((String)str)) {
            return "";
        }
        Matcher regexMatcher = regex.matcher(str);
        while (regexMatcher.find()) {
            String toReplace = regexMatcher.group(0);
            str = str.replace(toReplace, "");
        }
        str = str + (str.contains("?") ? "&" : "?") + "language=" + LocaleContextHolder.getLocale().toLanguageTag();
        return str;
    }

    private BpmNodeForm getFormDefByParentFlowKey(String defId, String parentFlowKey, boolean isMobile) throws Exception {
        BpmNodeForm nodeForm = new BpmNodeForm();
        BpmProcessDef<BpmProcessDefExt> bpmProcessDef = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        BpmNodeDef bpmNodeDef = bpmProcessDef.getStartEvent();
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDef.getProcessDefExt();
        FormExt flowForm = null;
        if (BeanUtils.isNotEmpty((Object)defExt) && BeanUtils.isNotEmpty(defExt.getAllGlobalForm())) {
            FormType formType = isMobile ? FormType.MOBILE : FormType.PC;
            for (FormExt form : defExt.getAllGlobalForm()) {
                if (!form.getParentFlowKey().equals(parentFlowKey) || !form.getFormType().equalsIgnoreCase(formType.toString())) continue;
                flowForm = form;
                break;
            }
        }
        if (this.isNotEmptyForm(flowForm)) {
            nodeForm.setForm(flowForm);
            nodeForm.setBpmNodeDef(bpmNodeDef);
            return nodeForm;
        }
        return null;
    }

    private FormModel getSubForm(BpmProcessInstance instance, String defId) {
        FormModel formModel = new BpmForm();
        BpmUrlForm bpmUrlForm = new BpmUrlForm();
        String instId = instance.getId();
        BpmProcessInstance topInstance = this.bpmProcessInstanceManager.getTopBpmProcessInstance(instance);
        String topInstId = topInstance.getId();
        try {
            BpmInstForm bpmInstForm = this.bpmInstFormManager.getSubInstanFrom(instId, FormType.PC.value());
            BpmNodeForm nodeFrm = this.getFormDefByParentFlowKey(defId, topInstance.getProcDefKey(), false);
            if (nodeFrm == null) {
                bpmInstForm = this.bpmInstFormManager.getSubInstanFrom(topInstId, FormType.PC.value());
            }
            String formCategory = bpmInstForm.getFormCategory();
            FormFeignService formService = (FormFeignService)AppUtil.getBean(FormFeignService.class);
            if (FormCategory.INNER.equals((Object)FormCategory.fromValue(formCategory))) {
                ObjectNode objectNode = formService.getByFormId(bpmInstForm.getFormValue());
                formModel = (FormModel)JsonUtil.toBean((JsonNode)objectNode, BpmForm.class);
                formModel.setType(FormCategory.INNER);
            } else {
                ObjectNode objectNode = formService.getByUrlFormId(bpmInstForm.getFormValue());
                if (!BeanUtils.isNotEmpty((Object)objectNode)) {
                    return null;
                }
                bpmUrlForm = (BpmUrlForm)JsonUtil.toBean((JsonNode)objectNode, BpmUrlForm.class);
                formModel.setType(FormCategory.FRAME);
            }
            formModel = this.handForm(formModel, bpmUrlForm, instance, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return formModel;
    }
}

