/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.engine.form;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.feign.FormFeignService;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.constant.NodeType;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.model.process.def.BpmProcessDef;
import com.hotent.bpm.api.model.process.def.BpmProcessDefExt;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.ProcBoDef;
import com.hotent.bpm.api.service.BoDataService;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.engine.def.BpmDefUtil;
import com.hotent.bpm.natapi.inst.NatProInstanceService;
import com.hotent.bpm.natapi.task.NatTaskService;
import com.hotent.bpm.persistence.manager.BpmBusLinkManager;
import com.hotent.bpm.persistence.manager.BpmCheckOpinionManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.model.BpmBusLink;
import com.hotent.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.hotent.bpm.persistence.model.DefaultBpmProcessDefExt;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.http.client.ClientProtocolException;
import org.springframework.stereotype.Service;

@Service
public class BoDataServiceImpl
implements BoDataService {
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BpmBusLinkManager bpmBusLinkManager;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    FormFeignService formRestfulService;
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    NatTaskService natTaskService;
    @Resource
    NatProInstanceService natProInstanceService;

    @Override
    public List<ObjectNode> getDataByInst(BpmProcessInstance instance) throws Exception {
        DefaultBpmProcessDefExt defExt;
        List<ProcBoDef> boList;
        ObjectNode formRestParams = JsonUtil.getMapper().createObjectNode();
        formRestParams.put("flowDefId", instance.getProcDefId());
        formRestParams.put("flowKey", instance.getProcDefKey());
        if (BeanUtils.isNotEmpty((Object)instance) && StringUtil.isNotZeroEmpty((String)instance.getParentInstId())) {
            DefaultBpmProcessInstance pInstance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instance.getParentInstId()));
            if (BeanUtils.isNotEmpty((Object)instance)) {
                formRestParams.put("parentFlowKey", pInstance.getProcDefKey());
            }
        }
        if (BeanUtils.isEmpty(boList = (defExt = BpmDefUtil.getProcessExt(instance = this.bpmProcessInstanceManager.getTopBpmProcessInstance(instance))).getBoDefList())) {
            return Collections.emptyList();
        }
        Map<String, BpmBusLink> keyValueMap = this.bpmBusLinkManager.getMapByInstIdOrDefId(instance.getId(), instance.getProcDefId());
        String saveType = defExt.isBoSaveToDb() ? "database" : "boObject";
        ArrayList<ObjectNode> dataObjects = new ArrayList<ObjectNode>();
        for (String key : keyValueMap.keySet()) {
            Map variable;
            DefaultBpmTask task;
            String execId;
            Object formType;
            JsonNode node;
            BpmBusLink link = keyValueMap.get(key);
            String id = StringUtil.isNotEmpty((String)link.getBusinesskeyStr()) ? link.getBusinesskeyStr() : link.getBusinesskey().toString();
            formRestParams.put("saveType", saveType);
            formRestParams.put("boid", id);
            formRestParams.put("code", link.getBoDefCode());
            formRestParams.put("nodeId", ContextThreadUtil.getCommuVar("nodeId", "").toString());
            Object formPermission = ContextThreadUtil.getCommuVar("formPermission", "");
            if (BeanUtils.isNotEmpty((Object)formPermission) && (node = JsonUtil.toJsonNode((String)formPermission.toString())) instanceof ObjectNode) {
                ObjectNode formPermissionObj = (ObjectNode)JsonUtil.toJsonNode((String)formPermission.toString());
                if (BeanUtils.isNotEmpty((Object)formPermissionObj.get("subRowAuth"))) {
                    formRestParams.put("subRowAuthJosn", JsonUtil.toJson((Object)formPermissionObj.get("subRowAuth")));
                }
                if (formPermissionObj.has("desensitization")) {
                    formRestParams.put("desensitization", formPermissionObj.get("desensitization").toString());
                }
            }
            formRestParams.put("formType", BeanUtils.isNotEmpty((Object)(formType = ContextThreadUtil.getCommuVar("formType", "pc"))) ? String.valueOf(formType) : "pc");
            formRestParams.put("flowCreaterID", instance.getCreateBy());
            formRestParams.put("flowCreaterAccount", instance.getCreateAccount());
            formRestParams.put("flowCreaterName", instance.getCreator());
            String taskId = (String)ContextThreadUtil.getCommuVar("taskId", "");
            if (StringUtil.isNotEmpty((String)taskId) && StringUtil.isNotEmpty((String)(execId = (task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId))).getExecId())) && BeanUtils.isNotEmpty((Object)(variable = (Map)this.natProInstanceService.getVariable(execId, execId)))) {
                formRestParams.put("subCreaterID", (String)variable.get("subCreaterID"));
                formRestParams.put("subCreaterAccount", (String)variable.get("subCreaterAccount"));
                formRestParams.put("subCreaterName", (String)variable.get("subCreaterName"));
            }
            ObjectNode boData = this.formRestfulService.getBodataById(formRestParams);
            dataObjects.add(boData);
        }
        return dataObjects;
    }

    @Override
    public List<ObjectNode> getDataByBizKey(String businessKey) throws Exception {
        BpmProcessInstance instance = this.bpmProcessInstanceManager.getTopBpmProcessInstance(this.bpmProcessInstanceManager.getByBusinessKey(businessKey));
        DefaultBpmProcessDefExt defExt = BpmDefUtil.getProcessExt(instance);
        List<ProcBoDef> boList = defExt.getBoDefList();
        if (BeanUtils.isEmpty(boList)) {
            return Collections.emptyList();
        }
        Map<String, BpmBusLink> keyValueMap = this.bpmBusLinkManager.getMapByInstId(instance.getId());
        String saveType = defExt.isBoSaveToDb() ? "database" : "boObject";
        ArrayList<ObjectNode> dataObjects = new ArrayList<ObjectNode>();
        for (String key : keyValueMap.keySet()) {
            BpmBusLink link = keyValueMap.get(key);
            String id = StringUtil.isNotEmpty((String)link.getBusinesskeyStr()) ? link.getBusinesskeyStr() : link.getBusinesskey().toString();
            ObjectNode formRestParams = JsonUtil.getMapper().createObjectNode();
            formRestParams.put("saveType", saveType);
            formRestParams.put("boid", id);
            formRestParams.put("code", link.getBoDefCode());
            formRestParams.put("flowDefId", instance.getProcDefId());
            ObjectNode boData = this.formRestfulService.getBodataById(formRestParams);
            dataObjects.add(boData);
        }
        return dataObjects;
    }

    @Override
    public List<ObjectNode> getDataByDefId(String defId) throws Exception {
        BpmProcessDef<BpmProcessDefExt> bpmProcessDef = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDef.getProcessDefExt();
        List<ProcBoDef> boList = defExt.getBoDefList();
        if (BeanUtils.isEmpty(boList)) {
            return null;
        }
        String saveType = defExt.isBoSaveToDb() ? "database" : "boObject";
        ArrayList<ObjectNode> dataObjects = new ArrayList<ObjectNode>();
        for (ProcBoDef procBoDef : boList) {
            String boKey = procBoDef.getKey();
            ObjectNode boData = this.formRestfulService.getBodataByDefCode(saveType, boKey);
            dataObjects.add(boData);
        }
        return dataObjects;
    }

    @Override
    public List<ObjectNode> getDataByBoKeys(List<String> boKeyList) throws ClientProtocolException, IOException {
        ArrayList<ObjectNode> dataObjects = new ArrayList<ObjectNode>();
        for (String key : boKeyList) {
            ObjectNode boData = this.formRestfulService.getBodataByDefCode("database", key);
            dataObjects.add(boData);
        }
        return dataObjects;
    }

    @Override
    public ObjectNode getFormOpinionJson(String proInstId) throws Exception {
        ObjectNode json = JsonUtil.getMapper().createObjectNode();
        List<DefaultBpmCheckOpinion> opinionList = this.bpmCheckOpinionManager.getFormOpinionByInstId(proInstId);
        Map<String, Boolean> nodeTypeMap = this.convertNodeDef(proInstId);
        HashMap<String, String> identityMap = new HashMap<String, String>();
        for (DefaultBpmCheckOpinion opinion : opinionList) {
            ArrayNode ary;
            String formIdentity = opinion.getFormName();
            ObjectNode opinionJson = this.getJsonByOpinion(opinion);
            identityMap.put(formIdentity, opinion.getTaskKey());
            if (JsonUtil.isContainsKey((JsonNode)json, (String)formIdentity)) {
                ary = (ArrayNode)JsonUtil.toJsonNode((String)json.get(formIdentity).asText());
                ary.add((JsonNode)opinionJson);
                continue;
            }
            ary = JsonUtil.getMapper().createArrayNode();
            ary.add((JsonNode)opinionJson);
            json.set(formIdentity, (JsonNode)ary);
        }
        ObjectNode rtnJson = JsonUtil.getMapper().createObjectNode();
        Iterator it = json.fieldNames();
        while (it.hasNext()) {
            String key = (String)it.next();
            ArrayNode ary = (ArrayNode)JsonUtil.toJsonNode((String)json.get(key).asText());
            String nodeId = (String)identityMap.get(key);
            boolean isSignTask = false;
            if (nodeTypeMap.containsKey(nodeId)) {
                isSignTask = nodeTypeMap.get(nodeId);
            }
            if (isSignTask) {
                rtnJson.set(key, (JsonNode)ary);
                continue;
            }
            ArrayNode tmpAry = JsonUtil.getMapper().createArrayNode();
            tmpAry.add(ary.get(ary.size() - 1));
            rtnJson.set(key, (JsonNode)tmpAry);
        }
        return rtnJson;
    }

    private Map<String, Boolean> convertNodeDef(String proInstId) throws Exception {
        BpmProcessInstance instance = (BpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)proInstId));
        List<BpmNodeDef> nodeList = this.bpmDefinitionAccessor.getAllNodeDef(instance.getProcDefId());
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (BpmNodeDef def : nodeList) {
            map.put(def.getNodeId(), NodeType.SIGNTASK.equals((Object)def.getType()));
        }
        return map;
    }

    private ObjectNode getJsonByOpinion(DefaultBpmCheckOpinion opinion) {
        ObjectNode json = JsonUtil.getMapper().createObjectNode();
        json.put("nodeId", opinion.getTaskKey());
        json.put("opinion", opinion.getOpinion());
        json.put("createTime", opinion.getCompleteTime().toString());
        json.put("status", opinion.getStatus());
        json.put("auditorName", opinion.getAuditorName());
        json.put("auditor", opinion.getAuditor());
        return json;
    }
}

