/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.engine.form;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.groovy.GroovyScriptEngine;
import com.hotent.base.util.EncryptUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.model.process.def.BpmSubTableRight;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.UserTaskNodeDef;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.persistence.manager.BpmBusLinkManager;
import com.hotent.table.datasource.DataSourceUtil;
import com.hotent.uc.api.impl.util.ContextUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class BoSubDataHandlerImpl {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    JdbcTemplate jdbcTemplate;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    GroovyScriptEngine groovyScriptEngine;
    @Resource
    BpmBusLinkManager bpmBusLinkManager;

    public List<Map<String, Object>> getSubDataByFk(ObjectNode boEnt, Object fkValue) throws Exception {
        String defId = (String)ContextThreadUtil.getCommuVar("defId", "");
        String nodeId = (String)ContextThreadUtil.getCommuVar("nodeId", "");
        String parentDefKey = (String)ContextThreadUtil.getCommuVar("parentDefKey", "local_");
        BpmSubTableRight bpmSubTableRight = this.getSubTableRight(defId, nodeId, parentDefKey, boEnt);
        String sql = "";
        if (boEnt.get("type").asText().equals("manytomany")) {
            sql = "select A.* from " + boEnt.get("tableName").asText() + " A , form_bo_data_relation B where  B.SUB_BO_NAME = '" + boEnt.get("name").asText() + "' AND A." + boEnt.get("pkKey").asText() + "=B.FK_  AND B.PK_=?";
        } else {
            String fk = boEnt.get("fk").asText();
            if (StringUtil.isEmpty((String)fk)) {
                throw new RuntimeException("\u901a\u8fc7\u6dfb\u52a0\u5916\u90e8\u8868\u6784\u5efa\u4e1a\u52a1\u5bf9\u8c61\u65f6\u5fc5\u987b\u6307\u5b9a\u5916\u952e");
            }
            sql = "select * from " + boEnt.get("tableName").asText() + " A  where A." + fk + "=?";
        }
        sql = this.handleRight(bpmSubTableRight, fkValue, sql);
        ArrayList<Map<String, Object>> list = new ArrayList();
        if (boEnt.get("isExternal").asInt() == 1) {
            try {
                list = DataSourceUtil.getJdbcTempByDsAlias((String)boEnt.get("dsName").asText()).queryForList(sql, new Object[]{fkValue});
            }
            catch (Exception e) {
                throw new RuntimeException("\u64cd\u4f5c\u5916\u90e8\u8868\uff1a" + boEnt.get("dsName").asText() + " \u4e2d\u7684 " + boEnt.get("desc").asText() + " \u51fa\u9519\uff1a" + e.getMessage(), e);
            }
        } else {
            list = this.jdbcTemplate.queryForList(sql, new Object[]{fkValue});
        }
        this.decryptResult(boEnt, list);
        return list;
    }

    private void decryptResult(ObjectNode boEnt, List<Map<String, Object>> list) {
        for (Map<String, Object> data : list) {
            for (String key : data.keySet()) {
                JsonNode attributeList = boEnt.get("attributeList");
                for (JsonNode boAttribute : attributeList) {
                    String fieldName = boAttribute.get("fieldName").asText();
                    if (!fieldName.equalsIgnoreCase(key) || !boAttribute.hasNonNull("isEncode") || boAttribute.get("isEncode").asInt() != 1) continue;
                    try {
                        Object val = data.get(key);
                        data.put(key, EncryptUtil.decrypt((String)((String)val), (String)"@$ATPW*%"));
                    }
                    catch (Exception e) {
                        this.logger.error("\u5efa\u6a21\u5b57\u6bb5\u89e3\u5bc6\u5931\u8d25", (Throwable)e);
                    }
                }
            }
        }
    }

    private BpmSubTableRight getSubTableRight(String defId, String nodeId, String parentDefKey, ObjectNode boEnt) throws Exception {
        if (StringUtil.isEmpty((String)nodeId)) {
            return null;
        }
        BpmNodeDef nodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        UserTaskNodeDef utnd = (UserTaskNodeDef)nodeDef;
        BpmSubTableRight bpmSubTableRight = null;
        List<BpmSubTableRight> list = utnd.getBpmSubTableRightByParentDefKey(parentDefKey);
        for (BpmSubTableRight bsr : list) {
            if (!bsr.getTableName().equals(boEnt.get("name").asText())) continue;
            bpmSubTableRight = bsr;
            break;
        }
        return bpmSubTableRight;
    }

    private String handleRight(BpmSubTableRight right, Object fkValue, String sql) throws Exception {
        if (right == null) {
            return sql;
        }
        if (right.getRightType().equals("script")) {
            String str = this.groovyScriptEngine.executeString(right.getScript(), new HashMap());
            sql = sql + " and " + str;
        } else if (right.getRightType().equals("curUser")) {
            sql = "select a.* from (" + sql + ") a , bpm_bus_link b where a.ID_ = B.businesskey_str_ and  B.start_id_=" + ContextUtil.getCurrentUserId();
        } else if (right.getRightType().equals("curOrg")) {
            sql = "select a.* from (" + sql + ") a , bpm_bus_link b where a.ID_ = B.businesskey_str_ and  B.start_group_id_=" + ContextUtil.getCurrentGroupId();
        }
        return sql;
    }
}

