/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.engine.form;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.feign.FormFeignService;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.constant.NodeType;
import com.hotent.bpm.api.model.form.FormType;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.engine.form.AbstractFormService;
import com.hotent.bpm.model.form.BpmForm;
import com.hotent.bpm.model.form.BpmUrlForm;
import com.hotent.bpm.model.form.Form;
import com.hotent.bpm.model.form.FormCategory;
import com.hotent.bpm.model.form.FormModel;
import com.hotent.bpm.persistence.model.BpmInstForm;
import com.hotent.bpm.persistence.model.DefaultBpmProcessDefExt;
import com.hotent.i18n.util.I18nUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service(value="mobileFormService")
public class MobileFormService
extends AbstractFormService {
    @Override
    protected Form getFormByNodeDef(BpmNodeDef bpmNodeDef) {
        return bpmNodeDef.getMobileForm();
    }

    @Override
    protected Form getGlobalFormByDefExt(DefaultBpmProcessDefExt ext) {
        return ext.getGlobalMobileForm();
    }

    @Override
    protected Form getSubForm(BpmNodeDef bpmNodeDef, String parentDefKey) {
        return bpmNodeDef.getSubForm(parentDefKey, FormType.MOBILE);
    }

    @Override
    protected Form getInstFormByDefExt(DefaultBpmProcessDefExt defExt) {
        return defExt.getInstMobileForm();
    }

    @Override
    public FormModel getInstanceNodeForm(BpmProcessInstance instance, String defId, String nodeId, boolean isTaskOrDone) throws Exception {
        boolean isSub = false;
        boolean isInstForm = false;
        if (instance.getId().equals(nodeId)) {
            isInstForm = true;
        }
        if (StringUtil.isNotZeroEmpty((String)instance.getParentInstId())) {
            instance = (BpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instance.getParentInstId()));
            isSub = true;
        }
        BpmInstForm bpmInstForm = this.bpmInstFormManager.getNodeForm(instance.getId(), defId, nodeId, FormType.MOBILE.value());
        if (isSub) {
            if (isInstForm) {
                bpmInstForm = this.bpmInstFormManager.getNodeForm(instance.getId(), defId, instance.getId(), FormType.MOBILE.value());
            } else {
                BpmNodeDef bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
                Form form = bpmNodeDef.getSubForm(instance.getProcDefKey(), FormType.MOBILE);
                if (BeanUtils.isEmpty((Object)form)) {
                    List<BpmNodeDef> startNodes;
                    bpmInstForm = null;
                    List<BpmNodeDef> nodeDefs = this.bpmDefinitionAccessor.getAllNodeDef(instance.getProcDefId());
                    for (BpmNodeDef nodeDef : nodeDefs) {
                        if (!nodeDef.getType().equals((Object)NodeType.START) || !BeanUtils.isNotEmpty(nodeDef.getSubFormList())) continue;
                        bpmInstForm = this.bpmInstFormManager.getNodeForm(instance.getId(), instance.getProcDefId(), nodeDef.getNodeId(), FormType.MOBILE.value());
                        break;
                    }
                    if (BeanUtils.isEmpty((Object)((Object)bpmInstForm)) && BeanUtils.isNotEmpty(startNodes = this.bpmDefinitionAccessor.getStartNodes(instance.getProcDefId()))) {
                        bpmInstForm = this.bpmInstFormManager.getNodeForm(instance.getId(), instance.getProcDefId(), startNodes.get(0).getNodeId(), FormType.MOBILE.value());
                    }
                }
            }
        }
        if (BeanUtils.isEmpty((Object)((Object)bpmInstForm))) {
            bpmInstForm = this.bpmInstFormManager.getGlobalForm(instance.getId(), FormType.MOBILE.value());
        }
        if (BeanUtils.isEmpty((Object)((Object)bpmInstForm))) {
            return null;
        }
        String formCategory = bpmInstForm.getFormCategory();
        FormModel formModel = new BpmForm();
        BpmUrlForm bpmUrlForm = new BpmUrlForm();
        if (FormCategory.INNER.equals((Object)FormCategory.fromValue(formCategory))) {
            FormFeignService formService = (FormFeignService)AppUtil.getBean(FormFeignService.class);
            ObjectNode objectNode = formService.getByFormId(bpmInstForm.getFormValue());
            formModel = (FormModel)JsonUtil.toBean((JsonNode)objectNode, BpmForm.class);
            if (BeanUtils.isEmpty((Object)formModel)) {
                return null;
            }
            formModel.setType(FormCategory.INNER);
        } else {
            ObjectNode objectNode = this.formService.getByUrlFormId(bpmInstForm.getFormValue());
            if (BeanUtils.isNotEmpty((Object)objectNode)) {
                CommonResult commonResult;
                JsonNode sysNode;
                bpmUrlForm = (BpmUrlForm)JsonUtil.toBean((JsonNode)objectNode, BpmUrlForm.class);
                PortalFeignService portalService = (PortalFeignService)AppUtil.getBean(PortalFeignService.class);
                String sysCode = bpmUrlForm.getSysCode();
                if (StringUtil.isNotEmpty((String)sysCode) && BeanUtils.isNotEmpty((Object)(sysNode = JsonUtil.toJsonNode((Object)(commonResult = portalService.getBizSystemByCode(sysCode)).getValue()))) && BeanUtils.isNotEmpty((Object)sysNode.get("rootAddress"))) {
                    String baseUrl = sysNode.get("rootAddress").asText();
                    bpmUrlForm.setBaseUrl(baseUrl);
                }
            } else {
                return null;
            }
            formModel.setType(FormCategory.FRAME);
        }
        formModel = this.handForm(formModel, bpmUrlForm, instance, isTaskOrDone);
        String formHtml = I18nUtil.replaceTemp((String)formModel.getFormHtml(), (String)"\\#\\{([\\w]+[\\.\\w]*)\\}", (Locale)LocaleContextHolder.getLocale());
        formModel.setFormHtml(formHtml);
        return formModel;
    }

    @Override
    public BpmUrlForm getInstanceUrlForm(BpmProcessInstance instance, String defId, String nodeId, boolean isTaskOrDone) throws Exception {
        boolean isSub = false;
        boolean isInstForm = false;
        if (instance.getId().equals(nodeId)) {
            isInstForm = true;
        }
        if (StringUtil.isNotZeroEmpty((String)instance.getParentInstId())) {
            instance = (BpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instance.getParentInstId()));
            isSub = true;
        }
        BpmInstForm bpmInstForm = this.bpmInstFormManager.getNodeForm(instance.getId(), defId, nodeId, FormType.MOBILE.value());
        if (isSub) {
            if (isInstForm) {
                bpmInstForm = this.bpmInstFormManager.getNodeForm(instance.getId(), defId, instance.getId(), FormType.MOBILE.value());
            } else {
                BpmNodeDef bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
                Form form = bpmNodeDef.getSubForm(instance.getProcDefKey(), FormType.MOBILE);
                if (BeanUtils.isEmpty((Object)form)) {
                    List<BpmNodeDef> startNodes;
                    bpmInstForm = null;
                    List<BpmNodeDef> nodeDefs = this.bpmDefinitionAccessor.getAllNodeDef(instance.getProcDefId());
                    for (BpmNodeDef nodeDef : nodeDefs) {
                        if (!nodeDef.getType().equals((Object)NodeType.START) || !BeanUtils.isNotEmpty(nodeDef.getSubFormList())) continue;
                        bpmInstForm = this.bpmInstFormManager.getNodeForm(instance.getId(), instance.getProcDefId(), nodeDef.getNodeId(), FormType.MOBILE.value());
                        break;
                    }
                    if (BeanUtils.isEmpty((Object)((Object)bpmInstForm)) && BeanUtils.isNotEmpty(startNodes = this.bpmDefinitionAccessor.getStartNodes(instance.getProcDefId()))) {
                        bpmInstForm = this.bpmInstFormManager.getNodeForm(instance.getId(), instance.getProcDefId(), startNodes.get(0).getNodeId(), FormType.MOBILE.value());
                    }
                }
            }
        }
        if (BeanUtils.isEmpty((Object)((Object)bpmInstForm))) {
            bpmInstForm = this.bpmInstFormManager.getGlobalForm(instance.getId(), FormType.MOBILE.value());
        }
        if (BeanUtils.isEmpty((Object)((Object)bpmInstForm))) {
            return null;
        }
        String formCategory = bpmInstForm.getFormCategory();
        BpmUrlForm bpmUrlForm = null;
        if (FormCategory.FRAME.equals((Object)FormCategory.fromValue(formCategory))) {
            ObjectNode objectNode = this.formService.getByUrlFormId(bpmInstForm.getFormValue());
            if (BeanUtils.isNotEmpty((Object)objectNode)) {
                CommonResult commonResult;
                JsonNode sysNode;
                bpmUrlForm = (BpmUrlForm)JsonUtil.toBean((JsonNode)objectNode, BpmUrlForm.class);
                PortalFeignService portalService = (PortalFeignService)AppUtil.getBean(PortalFeignService.class);
                String sysCode = bpmUrlForm.getSysCode();
                if (StringUtil.isNotEmpty((String)sysCode) && BeanUtils.isNotEmpty((Object)(sysNode = JsonUtil.toJsonNode((Object)(commonResult = portalService.getBizSystemByCode(sysCode)).getValue()))) && BeanUtils.isNotEmpty((Object)sysNode.get("rootAddress"))) {
                    String baseUrl = sysNode.get("rootAddress").asText();
                    bpmUrlForm.setBaseUrl(baseUrl);
                }
            } else {
                return null;
            }
        }
        return bpmUrlForm;
    }

    @Override
    public FormModel getByDefId(String defId, String nodeId, BpmProcessInstance instance, boolean isTaskOrDone) throws Exception {
        return this.getByDefId(defId, nodeId, instance, isTaskOrDone, true);
    }
}

