/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.engine.task.handler;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.BaseException;
import com.hotent.base.model.HtJsonNodeFactory;
import com.hotent.base.model.HtObjectNode;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.bpm.api.constant.ActionType;
import com.hotent.bpm.api.constant.NodeType;
import com.hotent.bpm.api.context.BpmContextUtil;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.SignNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.UserTaskNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.DefaultJumpRule;
import com.hotent.bpm.api.model.process.task.BpmTask;
import com.hotent.bpm.api.plugin.core.def.TaskActionHandlerDef;
import com.hotent.bpm.api.plugin.core.session.TaskActionPluginSession;
import com.hotent.bpm.api.service.BoDataService;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.api.service.BpmDefinitionService;
import com.hotent.bpm.api.service.BpmInstService;
import com.hotent.bpm.api.service.BpmTaskActionService;
import com.hotent.bpm.api.service.JumpRuleCalc;
import com.hotent.bpm.engine.task.cmd.DefaultTaskFinishCmd;
import com.hotent.bpm.engine.task.handler.AbstractTaskActionHandler;
import com.hotent.bpm.natapi.inst.NatProInstanceService;
import com.hotent.bpm.natapi.task.NatTaskService;
import com.hotent.bpm.persistence.manager.ActExecutionManager;
import com.hotent.bpm.persistence.manager.ActTaskManager;
import com.hotent.bpm.persistence.manager.BpmCheckOpinionManager;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.manager.BpmExeStackExecutorManager;
import com.hotent.bpm.persistence.manager.BpmExeStackManager;
import com.hotent.bpm.persistence.manager.BpmSignDataManager;
import com.hotent.bpm.util.BpmUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang.exception.ExceptionUtils;

public class TaskActionApproveHandler
extends AbstractTaskActionHandler {
    @Resource
    NatTaskService natTaskService;
    @Resource
    JumpRuleCalc jumpRuleCalc;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmTaskActionService bpmTaskActionService;
    @Resource
    BpmDefinitionService bpmDefinitionService;
    @Resource
    BpmExeStackManager bpmExeStackManager;
    @Resource
    NatProInstanceService natProInstanceService;
    @Resource
    BpmSignDataManager bpmSignDataManager;
    @Resource
    BpmExeStackExecutorManager bpmExeStackExecutorManager;
    @Resource
    ActExecutionManager actExecutionManager;
    @Resource
    BoDataService boDataService;
    @Resource
    BpmInstService bpmInstService;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    ActTaskManager actTaskManager;

    @Override
    public boolean isNeedCompleteTask() {
        return true;
    }

    @Override
    public void preActionHandler(TaskActionPluginSession pluginSession, TaskActionHandlerDef def) throws Exception {
        this.setDestination(pluginSession);
        this.signVote(pluginSession);
    }

    private void signVote(TaskActionPluginSession pluginSession) throws Exception {
        DefaultTaskFinishCmd cmd = (DefaultTaskFinishCmd)pluginSession.getTaskFinishCmd();
        BpmTask bpmTask = (BpmTask)cmd.getTransitVars("bpmTask_");
        String defId = bpmTask.getProcDefId();
        BpmNodeDef bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, bpmTask.getNodeId());
        if (bpmNodeDef instanceof SignNodeDef) {
            String taskId = bpmTask.getTaskId();
            Short index = ((Integer)this.natTaskService.getVariable(taskId, "loopCounter")).shortValue();
            SignNodeDef signNodeDef = (SignNodeDef)bpmNodeDef;
            String executionId = bpmTask.getExecId();
            Object executionIdObj = this.natTaskService.getVariable(taskId, "bpm_task_id_execution_id_" + bpmTask.getId());
            executionId = BeanUtils.isNotEmpty((Object)executionIdObj) ? executionIdObj.toString() : this.actTaskManager.getExecutionIdByTaskId(taskId);
            int level = signNodeDef.isParallel() ? 2 : 1;
            String parentExecuteId = this.actExecutionManager.getParentExecuteId(executionId, level);
            this.bpmSignDataManager.vote(parentExecuteId, bpmTask.getNodeId(), index, cmd.getActionName());
        }
    }

    private void setDestination(TaskActionPluginSession pluginSession) throws Exception {
        DefaultTaskFinishCmd cmd = (DefaultTaskFinishCmd)pluginSession.getTaskFinishCmd();
        if (StringUtil.isNotEmpty((String)cmd.getDestination())) {
            return;
        }
        String instId = cmd.getInstId();
        BpmTask bpmTask = (BpmTask)cmd.getTransitVars("bpmTask_");
        String targetNode = bpmTask.getTargetNode();
        if (StringUtil.isNotEmpty((String)targetNode)) {
            cmd.setDestination(targetNode);
            BpmNodeDef bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(bpmTask.getProcDefId(), targetNode);
            if (bpmNodeDef instanceof SignNodeDef) {
                List<BpmIdentity> signBpmIdentity = this.bpmSignDataManager.getByInstanIdAndNodeIdAndNo(instId, targetNode);
                cmd.addBpmIdentity(targetNode, signBpmIdentity);
            } else {
                List<BpmIdentity> identitys = this.bpmCheckOpinionManager.getRejectHistoryBpmIdentityByInstNodeId(instId, targetNode);
                cmd.addBpmIdentity(targetNode, identitys);
            }
        }
        this.calcJumpRules(bpmTask, cmd);
    }

    private void calcJumpRules(BpmTask bpmTask, DefaultTaskFinishCmd cmd) throws Exception {
        String nodeId = bpmTask.getNodeId();
        String defId = bpmTask.getProcDefId();
        UserTaskNodeDef bpmNodeDef = (UserTaskNodeDef)this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        List<DefaultJumpRule> ruleList = bpmNodeDef.getJumpRuleList();
        if (BeanUtils.isEmpty(ruleList)) {
            return;
        }
        Map<String, Object> vars = this.natTaskService.getVariables(bpmTask.getTaskId());
        Map<String, ObjectNode> boMap = BpmContextUtil.getBoFromContext();
        if (BeanUtils.isEmpty(boMap)) {
            BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(bpmTask.getProcInstId());
            List<ObjectNode> boDatas = this.boDataService.getDataByInst(bpmProcessInstance);
            BpmContextUtil.setBoToContext(boDatas);
            boMap = BpmContextUtil.getBoFromContext();
        }
        if (BeanUtils.isNotEmpty(boMap)) {
            HashMap<String, HtObjectNode> newMap = new HashMap<String, HtObjectNode>();
            for (Map.Entry<String, ObjectNode> next : boMap.entrySet()) {
                ObjectNode obj = next.getValue();
                if (obj.hasNonNull("data") && obj.get("data") instanceof ObjectNode) {
                    obj = (ObjectNode)obj.get("data");
                }
                HtObjectNode htObjectNode = HtJsonNodeFactory.build().htObjectNode(obj);
                newMap.put(next.getKey(), htObjectNode);
                vars.put(next.getKey(), htObjectNode);
            }
            vars.putAll(newMap);
        }
        vars.putAll(cmd.getVariables());
        String targetNode = this.jumpRuleCalc.eval(ruleList, vars);
        if (StringUtil.isNotEmpty((String)targetNode)) {
            cmd.setDestination(targetNode);
        }
    }

    @Override
    public void afterActionHandler(TaskActionPluginSession pluginSession, TaskActionHandlerDef def) throws Exception {
        DefaultTaskFinishCmd finishCmd = (DefaultTaskFinishCmd)pluginSession.getTaskFinishCmd();
        String instId = finishCmd.getInstId();
        BpmTask bpmTask = (BpmTask)finishCmd.getTransitVars("bpmTask_");
        String nodeId = (String)finishCmd.getTransitVars("cur_node_path_id");
        BpmNodeDef nodeDef = BeanUtils.isEmpty((Object)bpmTask) ? null : this.bpmDefinitionAccessor.getBpmNodeDef(bpmTask.getProcDefId(), nodeId);
        this.handSkipTask(instId, nodeId, nodeDef);
    }

    private void handSkipTask(String instId, String curentNodeId, BpmNodeDef nodeDef) throws Exception {
        Set<BpmTask> set = ContextThreadUtil.getByInstId(instId);
        if (BeanUtils.isEmpty(set)) {
            instId = (String)ContextThreadUtil.getCommuVar("instanceId_", instId);
            set = ContextThreadUtil.getByInstId(instId);
        }
        ContextThreadUtil.clearTaskByInstId(instId);
        if (BeanUtils.isEmpty(set)) {
            return;
        }
        set.stream().forEach(task -> {
            try {
                if (task.isGateWay()) {
                    return;
                }
                BpmUtil.setTaskSkip(task);
                if (task.getSkipResult().isSkipTask() && !task.getNodeId().equals(curentNodeId)) {
                    ThreadMsgUtil.addMapMsg((String)"ignore_form_data_rev", (String)"true");
                    BpmUtil.finishTask(task);
                } else if (task.getSkipResult().isSkipTask() && BeanUtils.isNotEmpty((Object)nodeDef) && nodeDef.getType() == NodeType.SIGNTASK) {
                    ThreadMsgUtil.addMapMsg((String)"ignore_form_data_rev", (String)"true");
                    BpmUtil.finishTask(task);
                }
            }
            catch (Exception e) {
                String rootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
                throw new BaseException(rootCauseMessage, (Throwable)e);
            }
        });
    }

    @Override
    public ActionType getActionType() {
        return ActionType.APPROVE;
    }
}

