/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.engine.task.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.cmd.TaskFinishCmd;
import com.hotent.bpm.api.constant.ActionType;
import com.hotent.bpm.api.constant.MultiInstanceType;
import com.hotent.bpm.api.constant.NodeStatus;
import com.hotent.bpm.api.constant.OpinionStatus;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.event.StartNewFlowEvent;
import com.hotent.bpm.api.model.delegate.BpmDelegateExecution;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.plugin.core.execution.sign.SignActionHandler;
import com.hotent.bpm.api.plugin.core.execution.sign.SignResult;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.api.service.SignComplete;
import com.hotent.bpm.engine.execution.sign.handler.SignActionHandlerContainer;
import com.hotent.bpm.persistence.manager.BpmCheckOpinionManager;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.manager.BpmProStatusManager;
import com.hotent.bpm.persistence.manager.BpmSignDataManager;
import com.hotent.bpm.persistence.manager.BpmTaskCandidateManager;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import com.hotent.bpm.service.PortalMsgPushService;
import com.hotent.bpm.todo.vo.PortalTaskVo;
import com.hotent.bpm.util.BpmUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.ApplicationEvent;
import org.springframework.transaction.annotation.Transactional;

public class SignCompleteImpl
implements SignComplete {
    @Resource
    SignActionHandlerContainer actionHandlerContainer;
    @Resource
    BpmProStatusManager bpmProStatusManager;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BpmSignDataManager bpmSignDataManager;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    BpmTaskCandidateManager bpmTaskCandidateManager;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;

    @Override
    @Transactional
    public boolean isComplete(BpmDelegateExecution bpmDelegateExecution) throws Exception {
        String instId = (String)bpmDelegateExecution.getVariable("instanceId_");
        TaskFinishCmd taskFinishCmd = (TaskFinishCmd)ContextThreadUtil.getActionCmd();
        if (BeanUtils.isEmpty((Object)this.actionHandlerContainer)) {
            this.actionHandlerContainer = (SignActionHandlerContainer)AppUtil.getBean((String)"signActionHandlerContainer");
        }
        SignActionHandler handler = this.actionHandlerContainer.getSignActionHandler(taskFinishCmd.getActionType().getKey());
        SignResult result = handler.handByActionType(taskFinishCmd, bpmDelegateExecution);
        this.handComplete(result, instId, bpmDelegateExecution, taskFinishCmd.getActionType());
        return result.isComplete();
    }

    private void handComplete(SignResult result, String instId, BpmDelegateExecution bpmDelegateExecution, ActionType actionType) {
        String executeParentId;
        TaskFinishCmd taskFinishCmd = (TaskFinishCmd)ContextThreadUtil.getActionCmd();
        if (!result.isComplete()) {
            Object transitVars = taskFinishCmd.getTransitVars("bpmTask_");
            if (BeanUtils.isNotEmpty((Object)transitVars) && transitVars instanceof DefaultBpmTask && StringUtil.isNotEmpty((String)((DefaultBpmTask)transitVars).getTargetNode())) {
                taskFinishCmd.addTransitVars("target_node", ((DefaultBpmTask)transitVars).getTargetNode());
            }
            return;
        }
        String nodeId = bpmDelegateExecution.getNodeId();
        String nodeName = bpmDelegateExecution.getNodeName();
        DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)taskFinishCmd.getTransitVars("processInstance");
        String defId = instance.getProcDefId();
        try {
            BpmDefinitionAccessor bpmDefinitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean(BpmDefinitionAccessor.class);
            BpmNodeDef bpmNodeDef = bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
            StartNewFlowEvent event = new StartNewFlowEvent(bpmNodeDef);
            AppUtil.publishEvent((ApplicationEvent)event);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        NodeStatus signNodeStatus = null;
        signNodeStatus = result.getNodeStatus().getKey().equals(NodeStatus.AGREE.getKey()) ? NodeStatus.SIGN_PASS : (result.getNodeStatus().getKey().equals(NodeStatus.OPPOSE.getKey()) ? NodeStatus.SIGN_NO_PASS : this.getNodeStatus(taskFinishCmd));
        if (BeanUtils.isEmpty((Object)this.bpmProStatusManager)) {
            this.bpmProStatusManager = (BpmProStatusManager)AppUtil.getBean(BpmProStatusManager.class);
        }
        this.bpmProStatusManager.createOrUpd(instId, defId, nodeId, nodeName, signNodeStatus);
        boolean isParallel = !MultiInstanceType.SEQUENTIAL.equals((Object)bpmDelegateExecution.multiInstanceType());
        String string = executeParentId = isParallel ? bpmDelegateExecution.getParentExecution().getParentExecution().getId() : bpmDelegateExecution.getParentId();
        if (BeanUtils.isEmpty((Object)this.bpmSignDataManager)) {
            this.bpmSignDataManager = (BpmSignDataManager)AppUtil.getBean(BpmSignDataManager.class);
        }
        QueryWrapper fromAssignWrapper = new QueryWrapper();
        fromAssignWrapper.eq((Object)"execute_id_", (Object)executeParentId);
        fromAssignWrapper.eq((Object)"node_id_", (Object)nodeId);
        fromAssignWrapper.eq((Object)"from_", (Object)"assign");
        fromAssignWrapper.eq((Object)"is_active_", (Object)1);
        List assignlist = this.bpmSignDataManager.list((Wrapper)fromAssignWrapper);
        if (BeanUtils.isEmpty((Object)assignlist)) {
            this.bpmSignDataManager.removeByNotActive(executeParentId, nodeId);
            this.bpmSignDataManager.updByNotActive(executeParentId, nodeId);
        } else {
            this.bpmSignDataManager.remove((Wrapper)fromAssignWrapper);
        }
        if (ActionType.BACK_TO_START.equals((Object)actionType) && StringUtil.isNotEmpty((String)instId)) {
            this.bpmSignDataManager.disableByInstId(instId);
        }
        this.updOpinion(bpmDelegateExecution, isParallel, nodeId, result.getOpinionStatus().getKey());
        if (ActionType.APPROVE.equals((Object)actionType)) {
            String resultVarName = "signResult_" + nodeId;
            bpmDelegateExecution.setVariable(resultVarName, result.getNodeStatus().getKey());
        }
        String varName = "signUsers_" + nodeId;
        if (MultiInstanceType.SEQUENTIAL.equals((Object)bpmDelegateExecution.multiInstanceType())) {
            bpmDelegateExecution.removeVariable(varName);
        }
    }

    private void updOpinion(BpmDelegateExecution bpmDelegateExecution, boolean isParallel, String nodeId, String status) {
        HashSet<String> todoExecIdSet = new HashSet<String>();
        todoExecIdSet.add(bpmDelegateExecution.getId());
        if (isParallel) {
            bpmDelegateExecution.getParentExecution().getExecutions().forEach(e -> todoExecIdSet.add(e.getId()));
        }
        this.bpmTaskManager = (BpmTaskManager)AppUtil.getBean(BpmTaskManager.class);
        this.bpmCheckOpinionManager = (BpmCheckOpinionManager)AppUtil.getBean(BpmCheckOpinionManager.class);
        this.bpmTaskCandidateManager = (BpmTaskCandidateManager)AppUtil.getBean(BpmTaskCandidateManager.class);
        ActionCmd actionCmd = ContextThreadUtil.getActionCmd();
        List bpmTasks = ((LambdaQueryChainWrapper)this.bpmTaskManager.lambdaQuery().in(DefaultBpmTask::getExecId, todoExecIdSet)).list();
        if (BeanUtils.isEmpty((Object)bpmTasks)) {
            return;
        }
        ArrayList<String> taskIdList = new ArrayList<String>();
        ArrayList<String> ownerList = new ArrayList<String>();
        for (Object task : bpmTasks) {
            String taskId = ((DefaultBpmTask)task).getId();
            taskIdList.add(taskId);
            ownerList.add(((DefaultBpmTask)task).getOwnerId());
            this.bpmTaskCandidateManager.removeByTaskId(taskId);
            this.bpmTaskManager.remove((Serializable)((Object)taskId));
        }
        List<DefaultBpmCheckOpinion> byInstNodeId = this.bpmCheckOpinionManager.getByInstNodeId(actionCmd.getInstId(), nodeId);
        for (DefaultBpmCheckOpinion opinion : byInstNodeId) {
            if (!OpinionStatus.AWAITING_CHECK.getKey().equals(opinion.getStatus()) || !taskIdList.contains(opinion.getTaskId())) continue;
            opinion.setStatus(status);
            if (OpinionStatus.RETRACTED.getKey().equals(status) && StringUtil.isEmpty((String)opinion.getOpinion())) {
                opinion.setOpinion(OpinionStatus.RETRACTED.getValue());
            }
            opinion.setCompleteTime(LocalDateTime.now());
            this.bpmCheckOpinionManager.update((Model)opinion);
        }
        PortalTaskVo portalTaskVo = new PortalTaskVo();
        portalTaskVo.setInstId(((DefaultBpmTask)bpmTasks.get(0)).getProcInstId());
        portalTaskVo.setFlowType(((DefaultBpmTask)bpmTasks.get(0)).getProcDefKey());
        portalTaskVo.setFlowTypeName(((DefaultBpmTask)bpmTasks.get(0)).getProcDefName());
        PortalMsgPushService portalMsgPushService = (PortalMsgPushService)AppUtil.getBean(PortalMsgPushService.class);
        portalMsgPushService.delTodo(((DefaultBpmTask)bpmTasks.get(0)).getProcInstId(), taskIdList, 3, ownerList, null, portalTaskVo);
    }

    private NodeStatus getNodeStatus(TaskFinishCmd cmd) {
        NodeStatus nodeStatus = NodeStatus.AGREE;
        String action = cmd.getActionName();
        Object isDoneUnused = cmd.getTransitVars("IsDoneUnused");
        if (isDoneUnused != null) {
            nodeStatus = NodeStatus.RECOVER;
            return nodeStatus;
        }
        NodeStatus backNodeStatus = BpmUtil.getBackNodeStatus(cmd);
        if (backNodeStatus != null) {
            return backNodeStatus;
        }
        switch (cmd.getActionType()) {
            case APPROVE: {
                nodeStatus = NodeStatus.fromKey(cmd.getActionName());
                break;
            }
            case BACK_TO_START: {
                nodeStatus = NodeStatus.BACK_TO_START;
                break;
            }
            case BACK: {
                if ("toStart".equals(action) || "backToStart".equals(action)) {
                    nodeStatus = NodeStatus.BACK_TO_START;
                    break;
                }
                nodeStatus = NodeStatus.BACK;
                break;
            }
            case RECOVER: {
                nodeStatus = "toStart".equals(action) ? NodeStatus.RECOVER_TO_START : NodeStatus.RECOVER;
            }
        }
        return nodeStatus;
    }
}

