/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.engine.task.skip;

import com.hotent.base.util.BeanUtils;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.inst.ISkipCondition;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.model.process.task.BpmTask;
import com.hotent.bpm.engine.task.skip.SkipConditionUtil;
import com.hotent.bpm.persistence.manager.BpmCheckOpinionManager;
import com.hotent.bpm.persistence.model.DefaultBpmCheckOpinion;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ApproverSkipCondition
implements ISkipCondition {
    @Resource
    private BpmCheckOpinionManager bpmCheckOpinionManager;

    @Override
    public boolean canSkip(BpmTask task) {
        String instId = task.getProcInstId();
        List<DefaultBpmCheckOpinion> list = this.bpmCheckOpinionManager.getByInstId(instId);
        boolean hasReroute = list.stream().anyMatch(defaultBpmCheckOpinion -> defaultBpmCheckOpinion.getInterpose() == 1);
        if (hasReroute) {
            int num = 0;
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i).getInterpose() != 1) continue;
                num = i + 1;
            }
            list = list.stream().skip(num).collect(Collectors.toList());
        }
        for (DefaultBpmCheckOpinion opinion : list) {
            if (task.getNodeId().equals(opinion.getTaskKey())) continue;
            List<BpmIdentity> identityList = SkipConditionUtil.convertIdentityAgent(task.getIdentityList(), task.getId());
            if (!this.isChecked(opinion.getAuditor(), identityList)) continue;
            ContextThreadUtil.putCommonVars("Auditor", opinion.getAuditor());
            ContextThreadUtil.putCommonVars("auditorName", opinion.getAuditorName());
            return true;
        }
        return false;
    }

    private boolean isChecked(String auditor, List<BpmIdentity> identitys) {
        if (BeanUtils.isEmpty(identitys)) {
            return false;
        }
        for (BpmIdentity bpmIdentity : identitys) {
            if (!bpmIdentity.getId().equals(auditor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getTitle() {
        return "\u66fe\u7ecf\u5ba1\u6279\u540e\u8df3\u8fc7";
    }

    @Override
    public String getType() {
        return "approver";
    }
}

