/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.helper.identity;

import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.helper.identity.BpmIdentityBuilder;
import com.hotent.bpm.api.helper.identity.BpmIdentityConverter;
import com.hotent.bpm.api.helper.identity.BpmIdentityExtractService;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.model.identity.DefaultBpmIdentity;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class BpmIdentityExtractServiceImpl
implements BpmIdentityExtractService {
    @Resource
    BpmIdentityConverter bpmIdentityConverter;
    @Resource
    BpmIdentityBuilder bpmIdentityBuilder;
    @Resource
    IUserService userServiceImpl;

    @Override
    public List<BpmIdentity> extractUserGroup(List<BpmIdentity> bpmIdentities) {
        ArrayList<BpmIdentity> results = new ArrayList<BpmIdentity>();
        StringBuffer sb = new StringBuffer();
        StringBuffer sbName = new StringBuffer();
        for (BpmIdentity bpmIdentity : bpmIdentities) {
            if (!bpmIdentity.getType().equals("user")) continue;
            sb.append(bpmIdentity.getId()).append(",");
            sbName.append(bpmIdentity.getName()).append(",");
        }
        List collect = bpmIdentities.stream().filter(predicate -> predicate.getType().equals("groupUser")).collect(Collectors.toList());
        if (collect.size() == bpmIdentities.size()) {
            return bpmIdentities;
        }
        if (StringUtil.isEmpty((String)sb.toString())) {
            return results;
        }
        String userGroup = sb.toString().substring(0, sb.length() - 1);
        String userGroupName = sbName.toString().substring(0, sbName.length() - 1);
        DefaultBpmIdentity bpmIdentity = new DefaultBpmIdentity();
        bpmIdentity.setId(userGroup);
        bpmIdentity.setType("groupUser");
        bpmIdentity.setName(userGroupName);
        results.add(bpmIdentity);
        return results;
    }

    @Override
    public List<BpmIdentity> extractBpmIdentity(List<BpmIdentity> bpmIdentities) {
        ArrayList<BpmIdentity> results = new ArrayList<BpmIdentity>();
        for (BpmIdentity bpmIdentity : bpmIdentities) {
            if (bpmIdentity.getType().equals("group")) {
                String id = StringUtil.isNotEmpty((String)bpmIdentity.getId()) ? bpmIdentity.getId() : bpmIdentity.getCode();
                List users = this.userServiceImpl.getUserListByGroup(bpmIdentity.getGroupType(), id, bpmIdentity.getCode());
                List<BpmIdentity> tempBpmIdentities = this.bpmIdentityConverter.convertUserList(users);
                results.addAll(tempBpmIdentities);
                continue;
            }
            if (!"user".equals(bpmIdentity.getType())) continue;
            results.add(bpmIdentity);
        }
        return results;
    }

    @Override
    public List<IUser> extractUser(List<BpmIdentity> bpmIdentities) {
        ArrayList<IUser> results = new ArrayList<IUser>();
        if (BeanUtils.isEmpty(bpmIdentities)) {
            return results;
        }
        for (BpmIdentity bpmIdentity : bpmIdentities) {
            if (bpmIdentity == null) continue;
            if (bpmIdentity.getType().equals("group")) {
                List users = this.userServiceImpl.getUserListByGroup(bpmIdentity.getGroupType(), bpmIdentity.getId(), bpmIdentity.getCode());
                results.addAll(users);
                continue;
            }
            if ("user".equals(bpmIdentity.getType())) {
                IUser user = this.userServiceImpl.getUserById(bpmIdentity.getId());
                results.add(user);
                continue;
            }
            if (!bpmIdentity.getType().equals("groupUser")) continue;
            results.addAll(this.userServiceImpl.getUserByIds(bpmIdentity.getId()));
        }
        return results;
    }
}

