/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.listener;

import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.util.AppUtil;
import com.hotent.bpm.api.event.BpmDefinitionDelEvent;
import com.hotent.bpm.api.model.process.def.BpmDefinition;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.natapi.def.NatProDefinitionService;
import javax.annotation.Resource;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Service;

@Service
public class BpmDefinitionListener
implements ApplicationListener<BpmDefinitionDelEvent> {
    @Resource
    NatProDefinitionService natProDefinitionService;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;

    public void onApplicationEvent(BpmDefinitionDelEvent endEvent) {
        BpmDefinition bpmDef = (BpmDefinition)endEvent.getSource();
        this.delFromCache(bpmDef);
    }

    private void delFromCache(BpmDefinition def) {
        String bpmnDefId = def.getBpmnDefId();
        String defId = def.getDefId();
        BpmDefinitionListener bean = (BpmDefinitionListener)AppUtil.getBean(this.getClass());
        bean.delByDefId(defId);
        bean.delByBpmnDefId(bpmnDefId);
        bean.delByFlowKey(def.getDefKey());
        this.natProDefinitionService.clearCacheByBpmnDefId(bpmnDefId);
        this.bpmDefinitionAccessor.clean(defId);
    }

    @CacheEvict(value={"eip:bpm:definition"}, key="#defId", ignoreException=false)
    protected void delByDefId(String defId) {
    }

    @CacheEvict(value={"eip:bpm:definitionBpmnId"}, key="#bpmnDefId", ignoreException=false)
    protected void delByBpmnDefId(String bpmnDefId) {
    }

    @CacheEvict(value={"eip:bpm:definitionFlowKey"}, key="#flowKey", ignoreException=false)
    protected void delByFlowKey(String flowKey) {
    }
}

