/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.listener;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.exception.BaseException;
import com.hotent.base.exception.WorkFlowException;
import com.hotent.base.util.BeanUtils;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.constant.MultiInstanceType;
import com.hotent.bpm.api.constant.NodeStatus;
import com.hotent.bpm.api.constant.ProcessInstanceStatus;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.event.CallSubProcessEndEvent;
import com.hotent.bpm.api.model.delegate.BpmDelegateExecution;
import com.hotent.bpm.api.model.process.task.BpmTask;
import com.hotent.bpm.natapi.inst.NatProInstanceService;
import com.hotent.bpm.natapi.task.NatTaskService;
import com.hotent.bpm.persistence.manager.BpmExeStackExecutorManager;
import com.hotent.bpm.persistence.manager.BpmExeStackManager;
import com.hotent.bpm.persistence.manager.BpmProStatusManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.model.BpmExeStack;
import com.hotent.bpm.persistence.model.BpmExeStackExecutor;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import com.hotent.uc.api.impl.util.ContextUtil;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Service;

@Service(value="callSubProcessEndEventListener")
public class CallSubProcessEndEventListener
implements ApplicationListener<CallSubProcessEndEvent>,
Ordered {
    @Resource
    BpmProStatusManager bpmProStatusManager;
    @Resource
    BpmExeStackManager bpmExeStackManager;
    @Resource
    BpmExeStackExecutorManager bpmExeStackExecutorManager;
    @Resource
    NatTaskService natTaskService;
    @Resource
    NatProInstanceService natProInstanceService;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;

    public int getOrder() {
        return 1;
    }

    public void onApplicationEvent(CallSubProcessEndEvent endEvent) {
        BpmDelegateExecution execution = (BpmDelegateExecution)endEvent.getSource();
        Integer instCount = (Integer)execution.getVariable("nrOfInstances");
        Integer completeInstCount = (Integer)execution.getVariable("nrOfCompletedInstances");
        if (instCount == null) {
            this.setVars(execution);
            this.updNodeStatus(execution);
        } else if (instCount.equals(completeInstCount)) {
            MultiInstanceType mulType = execution.multiInstanceType();
            if (MultiInstanceType.SEQUENTIAL.equals((Object)mulType)) {
                String varName = "signUsers_" + execution.getNodeId();
                execution.removeVariable(varName);
            }
            this.setVars(execution);
            this.updNodeStatus(execution);
        }
        String nodeId = execution.getNodeId();
        String nodeName = execution.getNodeName();
        String instId = (String)execution.getVariable("instanceId_");
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        DefaultBpmTask bpmTask = new DefaultBpmTask();
        DefaultBpmTask _bpmTask = (DefaultBpmTask)cmd.getTransitVars("bpmTask_");
        bpmTask.setId(execution.getId());
        bpmTask.setTaskId(execution.getId());
        bpmTask.setNodeId(nodeId);
        bpmTask.setProcDefId(_bpmTask.getProcDefId());
        bpmTask.setProcInstId(instId);
        bpmTask.setName(nodeName);
        bpmTask.setIsGateWay(true);
        ContextThreadUtil.addTask(bpmTask);
        try {
            this.bpmExeStackManager.pushStack(execution);
            this.updStack(bpmTask, cmd);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WorkFlowException(ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    private void setVars(BpmDelegateExecution execution) {
        Map<String, Object> vars = ContextThreadUtil.getCommuVars();
        String varName = "callActivityVars_" + execution.getNodeId();
        try {
            execution.setVariable(varName, BeanUtils.cloneBean(vars));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException("\u6d41\u7a0b\u53d8\u91cf\u6ca1\u6709\u5e8f\u5217\u5316" + e.getMessage(), (Throwable)e);
        }
    }

    private void updNodeStatus(BpmDelegateExecution execution) {
        String instId = (String)execution.getVariable("instanceId_");
        String bpmnDefId = execution.getBpmnDefId();
        String nodeId = execution.getNodeId();
        String nodeName = execution.getNodeName();
        this.bpmProStatusManager.createOrUpd(instId, bpmnDefId, nodeId, nodeName, NodeStatus.COMPLETE);
        this.bpmProcessInstanceManager.updateStatusByInstanceId(instId, ProcessInstanceStatus.STATUS_RUNNING.getKey());
    }

    private void updStack(BpmTask bpmTask, ActionCmd cmd) {
        String token = null;
        BpmExeStack bpmExeStack = this.bpmExeStackManager.getStack(bpmTask.getProcInstId(), bpmTask.getNodeId(), token);
        if (bpmExeStack == null) {
            bpmExeStack = this.bpmExeStackManager.getStack(bpmTask.getProcInstId(), bpmTask.getNodeId(), null);
        }
        if (bpmExeStack == null) {
            return;
        }
        bpmExeStack.setEndTime(LocalDateTime.now());
        this.bpmExeStackManager.update((Model)bpmExeStack);
        BpmExeStackExecutor executor = this.bpmExeStackExecutorManager.getByTaskId(bpmTask.getId());
        cmd.addTransitVars("parentStack", (Object)bpmExeStack);
        ContextThreadUtil.putCommonVars("parentStack", (Object)bpmExeStack);
        if (executor == null) {
            List<BpmExeStackExecutor> executorList = this.bpmExeStackExecutorManager.getByStackId(bpmExeStack.getId());
            if (executorList.size() == 1) {
                executor = executorList.get(0);
            } else {
                return;
            }
        }
        executor.setAssigneeId(ContextUtil.getCurrentUserId());
        executor.setEndTime(LocalDateTime.now());
        executor.setStatus(1);
        this.bpmExeStackExecutorManager.update((Model)executor);
    }
}

