/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.listener;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.constant.NodeStatus;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.event.CallSubProcessStartEvent;
import com.hotent.bpm.api.model.delegate.BpmDelegateExecution;
import com.hotent.bpm.api.model.process.task.BpmTask;
import com.hotent.bpm.natapi.inst.NatProInstanceService;
import com.hotent.bpm.natapi.task.NatTaskService;
import com.hotent.bpm.persistence.manager.BpmExeStackExecutorManager;
import com.hotent.bpm.persistence.manager.BpmExeStackManager;
import com.hotent.bpm.persistence.manager.BpmProStatusManager;
import com.hotent.bpm.persistence.model.BpmExeStack;
import com.hotent.bpm.persistence.model.BpmExeStackExecutor;
import com.hotent.uc.api.impl.util.ContextUtil;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Service;

@Service(value="callSubProcessStartEventListener")
public class CallSubProcessStartEventListener
implements ApplicationListener<CallSubProcessStartEvent>,
Ordered {
    @Resource
    BpmProStatusManager bpmProStatusManager;
    @Resource
    BpmExeStackManager bpmExeStackManager;
    @Resource
    BpmExeStackExecutorManager bpmExeStackExecutorManager;
    @Resource
    NatTaskService natTaskService;
    @Resource
    NatProInstanceService natProInstanceService;

    public void onApplicationEvent(CallSubProcessStartEvent ev) {
        BpmDelegateExecution execution = (BpmDelegateExecution)ev.getSource();
        String nodeId = execution.getNodeId();
        String bpmnDefId = execution.getBpmnDefId();
        String nodeName = execution.getNodeName();
        String parentNodeId = execution.getActivityParentId();
        execution.setVariable("callActivitiParentsNode_", parentNodeId);
        Map<String, Object> variables = execution.getVariables();
        Integer completeInstance = (Integer)variables.get("nrOfCompletedInstances");
        this.removeVars(variables);
        ContextThreadUtil.cleanCommuVars();
        ContextThreadUtil.setCommuVars(variables);
        String instId = (String)execution.getVariable("instanceId_");
        if (completeInstance == null) {
            this.bpmProStatusManager.createOrUpd(instId, bpmnDefId, nodeId, nodeName, NodeStatus.PENDING);
        }
    }

    private void removeVars(Map<String, Object> variables) {
        variables.remove("loopCounter");
        variables.remove("nrOfActiveInstances");
        variables.remove("nrOfCompletedInstances");
        variables.remove("nrOfInstances");
        variables.remove("parentStack");
    }

    public int getOrder() {
        return 1;
    }

    private void updStack(BpmTask bpmTask, ActionCmd cmd) {
        Object tokenObj = this.natProInstanceService.getVariable(bpmTask.getExecId(), "token_");
        String token = tokenObj == null ? null : tokenObj.toString();
        BpmExeStack bpmExeStack = this.bpmExeStackManager.getStack(bpmTask.getProcInstId(), bpmTask.getNodeId(), token);
        if (bpmExeStack == null) {
            bpmExeStack = this.bpmExeStackManager.getStack(bpmTask.getProcInstId(), bpmTask.getNodeId(), null);
        }
        if (bpmExeStack == null) {
            return;
        }
        bpmExeStack.setEndTime(LocalDateTime.now());
        this.bpmExeStackManager.update((Model)bpmExeStack);
        BpmExeStackExecutor executor = this.bpmExeStackExecutorManager.getByTaskId(bpmTask.getId());
        cmd.addTransitVars("parentStack", (Object)bpmExeStack);
        if (executor == null) {
            List<BpmExeStackExecutor> executorList = this.bpmExeStackExecutorManager.getByStackId(bpmExeStack.getId());
            if (executorList.size() == 1) {
                executor = executorList.get(0);
            } else {
                return;
            }
        }
        executor.setAssigneeId(ContextUtil.getCurrentUserId());
        executor.setEndTime(LocalDateTime.now());
        this.bpmExeStackExecutorManager.update((Model)executor);
    }
}

