/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.listener;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.hotent.base.feign.FormFeignService;
import com.hotent.base.groovy.GroovyScriptEngine;
import com.hotent.base.jms.JmsActor;
import com.hotent.base.jms.JmsProducer;
import com.hotent.base.jms.Notice;
import com.hotent.base.jms.NoticeMessageType;
import com.hotent.base.model.HtJsonNodeFactory;
import com.hotent.base.template.impl.FreeMarkerEngine;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.cmd.BaseActionCmd;
import com.hotent.bpm.api.constant.EventType;
import com.hotent.bpm.api.event.NodeNotifyEvent;
import com.hotent.bpm.api.event.NodeNotifyModel;
import com.hotent.bpm.api.event.TaskNotifyEvent;
import com.hotent.bpm.api.helper.identity.BpmIdentityExtractService;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.model.process.def.BpmDefExtProperties;
import com.hotent.bpm.api.model.process.def.BpmDefinition;
import com.hotent.bpm.api.model.process.def.BpmProcessDef;
import com.hotent.bpm.api.model.process.def.NodeProperties;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.Button;
import com.hotent.bpm.api.plugin.core.context.BpmPluginContext;
import com.hotent.bpm.api.plugin.core.factory.BpmPluginSessionFactory;
import com.hotent.bpm.api.plugin.core.session.BpmUserCalcPluginSession;
import com.hotent.bpm.api.service.BoDataService;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.api.service.BpmOpinionService;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.plugin.task.userassign.def.UserAssignPluginDef;
import com.hotent.bpm.plugin.task.userassign.plugin.UserQueryPlugin;
import com.hotent.bpm.plugin.usercalc.cuserrel.def.ExecutorVar;
import com.hotent.bpm.plugin.usercalc.cusers.def.CusersPluginDef;
import com.hotent.bpm.plugin.usercalc.cusers.runtime.CusersPlugin;
import com.hotent.bpm.util.BoDataUtil;
import com.hotent.bpm.util.BpmUtil;
import com.hotent.bpm.util.MessageUtil;
import com.hotent.bpm.util.PortalDataUtil;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserService;
import java.io.IOException;
import java.io.Serializable;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Service;

@Service
public class NodeNotifyEventListener
implements ApplicationListener<NodeNotifyEvent>,
Ordered {
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    FreeMarkerEngine freeMarkerEngine;
    @Resource
    BpmProcessInstanceManager instanceManager;
    @Resource
    BoDataService boDataService;
    @Resource
    BpmOpinionService bpmOpinionService;
    @Resource
    IUserService userService;
    @Resource
    FormFeignService formFeignService;
    private static final Logger logger = LoggerFactory.getLogger(NodeNotifyEventListener.class);
    private static final Pattern REGEX = Pattern.compile("\\{(.*?)}", 98);

    public void onApplicationEvent(NodeNotifyEvent nodeNotifyEvent) {
        NodeNotifyModel model = (NodeNotifyModel)nodeNotifyEvent.getSource();
        try {
            String html;
            ActionCmd cmd = Optional.ofNullable(model.getActionCmd()).orElse(new BaseActionCmd());
            model.setActionCmd(cmd);
            DefaultBpmProcessInstance instance = BeanUtils.isEmpty((Object)cmd.getTransitVars("processInstance")) ? (DefaultBpmProcessInstance)this.instanceManager.get((Serializable)((Object)(BeanUtils.isNotEmpty((Object)cmd.getTransitVars("instanceId_")) ? (String)cmd.getTransitVars("instanceId_") : model.getProcInstId()))) : (DefaultBpmProcessInstance)cmd.getTransitVars("processInstance");
            Object[] aryObj = BpmUtil.getDefProperties(instance, model.getNodeId());
            NodeProperties properties = (NodeProperties)aryObj[0];
            BpmProcessDef procDef = (BpmProcessDef)aryObj[1];
            BpmDefinition bpmDefinition = (BpmDefinition)aryObj[2];
            BpmNodeDef bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(instance.getProcDefId(), model.getNodeId());
            if (bpmNodeDef == null) {
                logger.warn("\u5904\u7406\u6d41\u7a0b\uff1a{}({})\u5728\u8282\u70b9{}\u4e0a\u7684\u901a\u77e5\u4e8b\u4ef6\u65f6\u56e0\u4e3a\u83b7\u53d6\u4e0d\u5230\u6d41\u7a0b\u5b9a\u4e49\u6570\u636e\u4e2d\u6b62\u4e86\u901a\u77e5\u4e8b\u4ef6\u7684\u5904\u7406\u3002", new Object[]{procDef.getName(), procDef.getDefKey(), model.getNodeId()});
                return;
            }
            model.setNodeName(bpmNodeDef.getName());
            model.setProcInstId(instance.getId());
            Object ext = procDef.getProcessDefExt();
            BpmDefExtProperties prop = ext.getExtProperties();
            String notifyType = BpmUtil.getNotifyType(instance, model.getNodeId());
            if (StringUtil.isEmpty((String)notifyType)) {
                return;
            }
            String msgConfig = "";
            EventType moment = model.getMoment();
            if (StringUtil.isNotEmpty((String)model.getBtnName())) {
                List<Button> buttons = bpmNodeDef.getButtons();
                for (Button button : buttons) {
                    if (!button.getAlias().equals(model.getBtnName())) continue;
                    msgConfig = button.getMsgConfig();
                    break;
                }
                if (StringUtil.isEmpty((String)msgConfig)) {
                    return;
                }
            }
            if (StringUtil.isEmpty((String)msgConfig)) {
                msgConfig = properties.getMsgConfig();
            }
            if (StringUtil.isEmpty((String)msgConfig)) {
                msgConfig = prop.getMsgConfig();
            }
            if (BeanUtils.isNotEmpty((Object)((Object)moment)) && moment.getKey().equals(EventType.TASK_CREATE_EVENT.getKey())) {
                TaskNotifyEvent ev = new TaskNotifyEvent(model);
                AppUtil.publishEvent((ApplicationEvent)ev);
            }
            if (StringUtil.isEmpty((String)msgConfig)) {
                return;
            }
            ObjectNode configObj = (ObjectNode)JsonUtil.toJsonNode((String)Base64.getFromBase64((String)msgConfig));
            if (BeanUtils.isNotEmpty((Object)((Object)moment)) && !JsonUtil.getString((JsonNode)configObj, (String)"moment").contains(moment.getKey()) || BeanUtils.isEmpty((Object)configObj.get("receivers"))) {
                return;
            }
            String subject = JsonUtil.getString((JsonNode)configObj, (String)"subject", (String)"");
            if (StringUtil.isEmpty((String)subject)) {
                return;
            }
            ObjectNode data = null;
            String busData = cmd.getBusData();
            if (StringUtil.isNotEmpty((String)busData)) {
                data = (ObjectNode)JsonUtil.toJsonNode((String)busData);
                cmd.addTransitVars("bo_inst_", BoDataUtil.getMap((ObjectNode)JsonUtil.toJsonNode((String)busData)));
            } else {
                List<ObjectNode> boDatas = this.boDataService.getDataByInst(instance);
                if (BeanUtils.isNotEmpty(boDatas)) {
                    data = BoDataUtil.hanlerData(instance, "", boDatas);
                }
            }
            this.setVars(model, instance, data);
            model.setSubject(this.parseHtmlContent(subject, model.getVars()));
            String plain = JsonUtil.getString((JsonNode)configObj, (String)"plain", (String)"");
            String string = html = StringUtil.isNotEmpty((String)JsonUtil.getString((JsonNode)configObj, (String)"html")) ? JsonUtil.getString((JsonNode)configObj, (String)"html") : plain;
            if (StringUtil.isEmpty((String)html)) {
                return;
            }
            model.setContent(this.parseHtmlContent(html, model.getVars()));
            ObjectNode receivers = (ObjectNode)configObj.get("receivers");
            List<JmsActor> recievers = this.getReceiver(model, receivers, bpmNodeDef);
            if (BeanUtils.isNotEmpty(recievers)) {
                model.setJmsActors(recievers);
                this.sendMsg(model, notifyType);
            }
            if (notifyType.indexOf(NoticeMessageType.SMS.key()) < 0 && notifyType.indexOf(NoticeMessageType.MAIL.key()) < 0 || BeanUtils.isEmpty((Object)receivers.get("externalUser"))) {
                return;
            }
            ArrayList<JmsActor> smsRecievers = new ArrayList<JmsActor>();
            ArrayList<JmsActor> mailRecievers = new ArrayList<JmsActor>();
            ArrayNode outArray = (ArrayNode)receivers.get("externalUser");
            Map<String, Object> varMap = null;
            for (JsonNode json : outArray) {
                String email;
                String name = JsonUtil.getString((JsonNode)json, (String)"name");
                String mobile = JsonUtil.getString((JsonNode)json, (String)"mobile");
                if (null != mobile && mobile.matches("\\w*\\$\\{[\\w.]+\\}\\w*")) {
                    if (null == varMap) {
                        varMap = this.handleVarMap(cmd);
                    }
                    mobile = this.freeMarkerEngine.parseByTemplate(mobile, varMap);
                }
                if (null != (email = JsonUtil.getString((JsonNode)json, (String)"email")) && email.matches("\\w*\\$\\{[\\w.]+\\}\\w*")) {
                    if (null == varMap) {
                        varMap = this.handleVarMap(cmd);
                    }
                    email = this.freeMarkerEngine.parseByTemplate(email, varMap);
                }
                if (notifyType.contains(NoticeMessageType.SMS.key()) && StringUtil.isNotEmpty((String)mobile)) {
                    smsRecievers.add(new JmsActor("", "", name, "", mobile, "", "", ""));
                }
                if (!notifyType.contains(NoticeMessageType.MAIL.key()) || !StringUtil.isNotEmpty((String)email)) continue;
                mailRecievers.add(new JmsActor("", "", name, email, "", "", "", ""));
            }
            if (!smsRecievers.isEmpty()) {
                model.setJmsActors(smsRecievers);
                this.sendMsg(model, NoticeMessageType.SMS.key());
            }
            if (!mailRecievers.isEmpty()) {
                model.setJmsActors(mailRecievers);
                this.sendMsg(model, NoticeMessageType.MAIL.key());
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u6d88\u606f\u5931\u8d25", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private Map<String, Object> handleVarMap(ActionCmd cmd) {
        String boJson = cmd.getBusData();
        HashMap<String, Object> varMap = new HashMap<String, Object>();
        if (StringUtil.isNotEmpty((String)boJson)) {
            try {
                Map map = JsonUtil.toMap((String)boJson);
                for (String s : map.keySet()) {
                    varMap.put(s, map.get(s));
                }
            }
            catch (IOException map) {
                // empty catch block
            }
        }
        Map<String, Object> variables = cmd.getVariables();
        for (String key : variables.keySet()) {
            varMap.put(key, variables.get(key));
        }
        return varMap;
    }

    private List<JmsActor> getReceiver(NodeNotifyModel model, ObjectNode conf, BpmNodeDef bpmNodeDef) throws Exception {
        List users;
        Map<String, Set<String>> auditorSet;
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.putAll(model.getVars());
        variables.putAll(model.getActionCmd().getVariables());
        variables.putAll(model.getActionCmd().getTransitVars());
        BpmPluginSessionFactory bpmPluginSessionFactory = (BpmPluginSessionFactory)AppUtil.getBean(BpmPluginSessionFactory.class);
        BpmIdentityExtractService bpmIdentityExtractService = (BpmIdentityExtractService)AppUtil.getBean(BpmIdentityExtractService.class);
        BpmUserCalcPluginSession userCalcPluginSession = bpmPluginSessionFactory.buildBpmUserCalcPluginSession(variables);
        UserQueryPlugin userQueryPlugin = (UserQueryPlugin)AppUtil.getBean(UserQueryPlugin.class);
        ArrayList<IUser> iUsers = new ArrayList<IUser>();
        for (BpmPluginContext bpmPluginContext : bpmNodeDef.getBpmPluginContexts()) {
            if ((!"\u4f20\u9605\u7528\u6237\u5206\u914d\u63d2\u4ef6".equals(bpmPluginContext.getTitle()) || !JsonUtil.getBoolean((ObjectNode)conf, (String)"curCopyTo", (boolean)false)) && (!"\u7528\u6237\u5206\u914d\u63d2\u4ef6".equals(bpmPluginContext.getTitle()) || !JsonUtil.getBoolean((ObjectNode)conf, (String)"curAuditor", (boolean)false))) continue;
            UserAssignPluginDef userAssignPluginDef = (UserAssignPluginDef)bpmPluginContext.getBpmPluginDef();
            List<BpmIdentity> bpmIdentities = userQueryPlugin.execute(userCalcPluginSession, userAssignPluginDef);
            iUsers.addAll(bpmIdentityExtractService.extractUser(bpmIdentities));
        }
        HashSet<String> userIds = new HashSet<String>();
        if (StringUtil.isNotEmpty((String)JsonUtil.getString((JsonNode)conf, (String)"hisNode", (String)"")) && BeanUtils.isNotEmpty(auditorSet = this.bpmOpinionService.getHisAuditorByInstId(model.getProcInstId(), false)) && auditorSet.containsKey(conf.get("hisNode").asText())) {
            userIds.addAll((Collection)auditorSet.get(conf.get("hisNode").asText()));
        }
        if (JsonUtil.getBoolean((ObjectNode)conf, (String)"startor", (boolean)false)) {
            userIds.add((String)model.getVars().get("creatorId"));
        }
        if (conf.hasNonNull("sysUser") && BeanUtils.isNotEmpty((Object)conf.get("sysUser").get("userId"))) {
            userIds.addAll(Arrays.asList(conf.get("sysUser").get("userId").asText().split(",")));
        }
        userIds.removeIf(String::isEmpty);
        if (BeanUtils.isNotEmpty(userIds) && BeanUtils.isNotEmpty((Object)(users = this.userService.getUserByIds(StringUtil.join(userIds))))) {
            iUsers.addAll(users);
        }
        if (conf.hasNonNull("var") && BeanUtils.isNotEmpty((Object)conf.get("var").get("name"))) {
            CusersPluginDef pluginDef = new CusersPluginDef();
            pluginDef.setSource("var");
            ExecutorVar var = (ExecutorVar)JsonUtil.toBean((JsonNode)conf.get("var"), ExecutorVar.class);
            pluginDef.setExecutorVar(var);
            CusersPlugin cusersPlugin = (CusersPlugin)AppUtil.getBean(CusersPlugin.class);
            List<BpmIdentity> bpmIdentities = cusersPlugin.execute(userCalcPluginSession, pluginDef);
            iUsers.addAll(bpmIdentityExtractService.extractUser(bpmIdentities));
        }
        List unique = iUsers.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<IUser>(Comparator.comparing(IUser::getUserId))), ArrayList::new));
        return MessageUtil.parseJmsActor(unique);
    }

    private void sendMsg(NodeNotifyModel model, String notifyType) throws Exception {
        NoticeMessageType[] messageTypes = MessageUtil.parseNotifyType(notifyType);
        List<JmsActor> recieverAccounts = model.getJmsActors();
        IUser sender = ContextUtil.getCurrentUser();
        Map<String, Object> vars = model.getVars();
        vars.put("sender", BeanUtils.isNotEmpty((Object)sender) ? sender.getFullname() : "\u7cfb\u7edf\u6267\u884c\u4eba");
        vars.put("senderId", BeanUtils.isNotEmpty((Object)sender) ? sender.getUserId() : "-1");
        if (recieverAccounts.size() == 1) {
            vars.put("receiver", recieverAccounts.get(0).getAccount());
        }
        Notice notice = new Notice();
        notice.setSubject(model.getSubject());
        notice.setContent(model.getContent());
        notice.setUseTemplate(false);
        notice.setBatchSend(false);
        notice.setMessageTypes(messageTypes);
        notice.setSender(sender.getAccount());
        notice.setVars(vars);
        notice.setReceiver(recieverAccounts);
        JmsProducer jmsProducer = (JmsProducer)AppUtil.getBean(JmsProducer.class);
        jmsProducer.sendToQueue((Object)notice);
    }

    private void setVars(NodeNotifyModel model, DefaultBpmProcessInstance defaultBpmProcessInstance, ObjectNode data) {
        String baseUrl = PortalDataUtil.getPropertyByAlias("baseUrl");
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        model.addVars("baseUrl", baseUrl).addVars("taskSubject", model.getSubject()).addVars("taskId", model.getTaskId()).addVars("cause", model.getOpinion()).addVars("nodeName", model.getNodeName()).addVars("agent", BeanUtils.isEmpty((Object)model.getAgent()) ? "" : model.getAgent().getFullname()).addVars("instSubject", defaultBpmProcessInstance.getSubject()).addVars("instId", defaultBpmProcessInstance.getId()).addVars("bpmName", defaultBpmProcessInstance.getProcDefName()).addVars("date", defaultBpmProcessInstance.getCreateTime().format(dateTimeFormatter)).addVars("creator", defaultBpmProcessInstance.getCreator()).addVars("creatorId", defaultBpmProcessInstance.getCreateBy());
        if (data != null) {
            Iterator iterator = data.fields();
            while (iterator.hasNext()) {
                Map.Entry next = (Map.Entry)iterator.next();
                if (next.getValue() instanceof TextNode) {
                    model.addVars((String)next.getKey(), ((JsonNode)next.getValue()).asText());
                    continue;
                }
                model.addVars((String)next.getKey(), HtJsonNodeFactory.build().htObjectNode((ObjectNode)next.getValue()));
            }
        }
    }

    private String parseHtmlContent(String titleRule, Map<String, Object> map) {
        if (StringUtils.isEmpty((String)titleRule)) {
            return "";
        }
        GroovyScriptEngine scriptEngine = (GroovyScriptEngine)AppUtil.getBean(GroovyScriptEngine.class);
        Matcher matcher = REGEX.matcher(titleRule);
        while (matcher.find()) {
            String rule = matcher.group(1);
            String[] aryRule = rule.split(":");
            if (aryRule.length == 1) continue;
            String name = aryRule[1];
            if (map.containsKey(name)) {
                titleRule = titleRule.replace(matcher.group(0), BeanUtils.ObjectToString((Object)map.get(name)));
                continue;
            }
            String defaultValue = "";
            try {
                String script = rule.replace(aryRule[0] + ":", "");
                defaultValue = scriptEngine.executeString(script, map);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            titleRule = titleRule.replace(matcher.group(0), defaultValue);
        }
        return titleRule;
    }

    public int getOrder() {
        return 1;
    }
}

