/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.listener;

import com.hotent.base.context.BaseContext;
import com.hotent.base.exception.BaseException;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.constant.ActionType;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.event.NotifyTaskModel;
import com.hotent.bpm.api.event.TaskNotifyEvent;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.engine.task.cmd.DefaultTaskFinishCmd;
import com.hotent.bpm.model.identity.DefaultBpmIdentity;
import com.hotent.bpm.persistence.manager.DefaultBpmDefinitionAccessor;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.util.BpmUtil;
import com.hotent.bpm.util.MessageUtil;
import com.hotent.bpm.util.PortalDataUtil;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserService;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TaskNotifyEventListener
implements ApplicationListener<TaskNotifyEvent>,
Ordered {
    private static final Log logger = LogFactory.getLog(TaskNotifyEventListener.class);
    @Resource
    IUserService userServiceImpl;
    @Autowired
    DefaultBpmDefinitionAccessor defaultBpmDefinitionAccessor;
    @Resource
    BaseContext baseContext;

    public int getOrder() {
        return 1;
    }

    public void onApplicationEvent(TaskNotifyEvent ev) {
        NotifyTaskModel model = (NotifyTaskModel)ev.getSource();
        ActionType actionType = model.getActionType();
        ActionCmd taskCmd = ContextThreadUtil.getActionCmd();
        String notifyType = null;
        try {
            notifyType = BpmUtil.getNotifyType((BpmProcessInstance)taskCmd.getTransitVars("processInstance"), model.getNodeId());
            if (StringUtil.isEmpty((String)notifyType)) {
                return;
            }
            String currentTenantId = this.baseContext.getCurrentTenantId();
            String baseUrl = this.getPropertyByTempTenant("baseUrl");
            String front = PortalDataUtil.getPropertyByAlias("frontBaseUrl");
            String manage = PortalDataUtil.getPropertyByAlias("manageBaseUrl");
            String mobile = PortalDataUtil.getPropertyByAlias("mobileBaseUrl");
            model.addVars("baseUrl", baseUrl).addVars("taskSubject", model.getSubject()).addVars("taskId", model.getTaskId()).addVars("cause", model.getOpinion()).addVars("nodeName", model.getNodeName()).addVars("agent", BeanUtils.isEmpty((Object)model.getAgent()) ? "" : model.getAgent().getFullname()).addVars("instSubject", model.getSubject()).addVars("instId", taskCmd.getInstId()).addVars("frontBaseUrl", front).addVars("manageBaseUrl", manage).addVars("mobileBaseUrl", mobile);
            DefaultBpmProcessInstance defaultBpmProcessInstance = (DefaultBpmProcessInstance)taskCmd.getTransitVars().get("processInstance");
            if (BeanUtils.isNotEmpty((Object)defaultBpmProcessInstance)) {
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                model.addVars("bpmName", defaultBpmProcessInstance.getProcDefName()).addVars("date", defaultBpmProcessInstance.getCreateTime().format(dateTimeFormatter)).addVars("creator", defaultBpmProcessInstance.getCreator());
                if (StringUtil.isNotEmpty((String)defaultBpmProcessInstance.getSysCode())) {
                    model.addVars("sysCode", defaultBpmProcessInstance.getSysCode());
                    model.addVars("TRIG_NODE_ID_", model.getNodeId());
                    model.addVars("ACTION_TYPE_", model.getActionType().getKey());
                }
            }
            this.handleModeVars(model);
            if (ActionType.APPROVE.equals((Object)model.getActionType())) {
                if (model.isAgent()) {
                    this.handAgent(model, notifyType);
                } else {
                    MessageUtil.send(model, notifyType, "bpmnApproval");
                }
            } else if (ActionType.BACK.equals((Object)actionType) || ActionType.BACK_TO_START.equals((Object)actionType)) {
                MessageUtil.send(model, notifyType, "bpmnBack");
            } else if (ActionType.RECOVER.equals((Object)actionType)) {
                DefaultTaskFinishCmd taskFinishCmd;
                if (taskCmd instanceof DefaultTaskFinishCmd && !CollectionUtils.isEmpty((taskFinishCmd = (DefaultTaskFinishCmd)taskCmd).getUserListNotice())) {
                    model.setIdentitys(taskFinishCmd.getUserListNotice());
                }
                MessageUtil.send(model, notifyType, "bpmnRecover");
            } else {
                MessageUtil.send(model, notifyType, "bpmnRecover");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e);
        }
    }

    private String getPropertyByTempTenant(String key) {
        String currentTenantId = this.baseContext.getCurrentTenantId();
        try {
            String baseUrl;
            this.baseContext.setTempTenantId("-1");
            String string = baseUrl = PortalDataUtil.getPropertyByAlias(key);
            return string;
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
        finally {
            this.baseContext.setTempTenantId(currentTenantId);
        }
    }

    private void handleModeVars(NotifyTaskModel model) {
        Map<String, Object> vars = model.getVars();
        if (vars.containsKey("assignee") && BeanUtils.isNotEmpty(vars.getOrDefault("assignee", null))) {
            try {
                vars.put("assignee", JsonUtil.toJsonNode((Object)vars.get("assignee")));
            }
            catch (Exception e) {
                logger.info((Object)("assignee\u8f6c\u6362\u5931\u8d25\uff1a" + e));
            }
        }
        for (Map.Entry<String, Object> entry : vars.entrySet()) {
            if (!BeanUtils.isNotEmpty((Object)entry.getValue()) || !(entry.getValue() instanceof Collection) && !(entry.getValue() instanceof DefaultBpmIdentity)) continue;
            try {
                entry.setValue(JsonUtil.toJsonNode((Object)entry.getValue()));
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
    }

    private void handAgent(NotifyTaskModel model, String notifyType) {
        IUser agent = model.getAgent();
        IUser delegateUser = model.getDelegator();
        model.addVars("delegate", delegateUser.getFullname());
        model.addVars("agent", agent.getFullname());
        ArrayList<IUser> agentReceivers = new ArrayList<IUser>();
        agentReceivers.add(agent);
        model.setIdentitys(agentReceivers);
        try {
            MessageUtil.send(model, notifyType, "bpmnAgent");
            ArrayList<IUser> delegateReceivers = new ArrayList<IUser>();
            delegateReceivers.add(delegateUser);
            model.setIdentitys(delegateReceivers);
            MessageUtil.send(model, notifyType, "bpmnDelegate");
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }
}

