/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.persistence.manager;

import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.exception.WorkFlowException;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.constant.NodeType;
import com.hotent.bpm.api.model.process.def.BpmProcessDef;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.SubProcessNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.UserTaskNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.DefaultJumpRule;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.defxml.DefXmlUtil;
import com.hotent.bpm.defxml.entity.Process;
import com.hotent.bpm.defxml.entity.RootElement;
import com.hotent.bpm.defxml.entity.ext.ExtDefinitions;
import com.hotent.bpm.model.BpmFreeProcessDef;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.manager.BpmFreeProcessDefManager;
import com.hotent.bpm.persistence.model.BpmDefData;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.hotent.bpm.persistence.model.DefaultBpmProcessDef;
import com.hotent.bpm.persistence.util.BpmProcessDefExtParse;
import com.hotent.bpm.util.BpmUtil;
import io.jsonwebtoken.lang.Assert;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DefaultBpmDefinitionAccessor
implements BpmDefinitionAccessor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultBpmDefinitionAccessor.class);
    @Resource
    private BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BpmFreeProcessDefManager bpmFreeProcessDefManager;

    @Override
    public List<BpmNodeDef> getNodeDefs(String processDefinitionId) throws Exception {
        List<BpmNodeDef> list = new ArrayList<BpmNodeDef>();
        DefaultBpmProcessDef processDef = this.getProcessDefByDefId(processDefinitionId);
        if (processDef != null) {
            list = processDef.getBpmnNodeDefs();
        }
        return list;
    }

    @Override
    public BpmNodeDef getBpmNodeDef(String processDefinitionId, String nodeId) throws Exception {
        List<BpmNodeDef> list = this.getNodeDefs(processDefinitionId);
        ArrayList<SubProcessNodeDef> listSub = new ArrayList<SubProcessNodeDef>();
        List collect = list.stream().filter(nodeDef -> {
            if (nodeDef.getNodeId().equals(nodeId)) {
                UserTaskNodeDef utn;
                if (nodeDef instanceof UserTaskNodeDef && (utn = (UserTaskNodeDef)nodeDef).getJumpRuleList() == null) {
                    utn.setJumpRuleList(new ArrayList<DefaultJumpRule>());
                }
                return true;
            }
            if (nodeDef instanceof SubProcessNodeDef) {
                listSub.add((SubProcessNodeDef)nodeDef);
            }
            return false;
        }).collect(Collectors.toList());
        if (BeanUtils.isNotEmpty(collect) && collect.size() > 0) {
            return (BpmNodeDef)collect.get(0);
        }
        if (listSub.size() > 0) {
            return this.findSubProcessNodeDefByNodeId(listSub, nodeId);
        }
        return null;
    }

    private BpmNodeDef findSubProcessNodeDefByNodeId(List<SubProcessNodeDef> subList, String nodeId) {
        for (SubProcessNodeDef nodeDef : subList) {
            List<BpmNodeDef> nodeList = nodeDef.getChildBpmProcessDef().getBpmnNodeDefs();
            ArrayList<SubProcessNodeDef> nestSub = new ArrayList<SubProcessNodeDef>();
            for (BpmNodeDef tmpDef : nodeList) {
                if (tmpDef.getNodeId().equals(nodeId)) {
                    return tmpDef;
                }
                if (!(tmpDef instanceof SubProcessNodeDef)) continue;
                nestSub.add((SubProcessNodeDef)tmpDef);
            }
            if (nestSub.size() <= 0) continue;
            return this.findSubProcessNodeDefByNodeId(nestSub, nodeId);
        }
        return null;
    }

    public BpmProcessDef getBpmProcessDef(String processDefId) throws Exception {
        return this.getProcessDefByDefId(processDefId);
    }

    @Override
    public BpmNodeDef getStartEvent(String processDefId) throws Exception {
        DefaultBpmProcessDef processDef = this.getProcessDefByDefId(processDefId);
        if (processDef != null) {
            List<BpmNodeDef> list = processDef.getBpmnNodeDefs();
            for (BpmNodeDef nodeDef : list) {
                if (!nodeDef.getType().equals((Object)NodeType.START)) continue;
                return nodeDef;
            }
        }
        return null;
    }

    @Override
    public List<BpmNodeDef> getEndEvents(String processDefId) throws Exception {
        ArrayList<BpmNodeDef> nodeList = new ArrayList<BpmNodeDef>();
        DefaultBpmProcessDef processDef = this.getProcessDefByDefId(processDefId);
        if (processDef != null) {
            List<BpmNodeDef> list = processDef.getBpmnNodeDefs();
            for (BpmNodeDef nodeDef : list) {
                if (!nodeDef.getType().equals((Object)NodeType.END)) continue;
                nodeList.add(nodeDef);
            }
        }
        return nodeList;
    }

    @Override
    @CacheEvict(value={"eip:bpm:processDef"}, key="#processDefId", ignoreException=false)
    public void clean(String processDefId) {
    }

    @Override
    @CacheEvict(value={"eip:bpm:processDef"}, allEntries=true, ignoreException=false)
    public void clearAll() {
    }

    @Override
    public List<BpmNodeDef> getStartNodes(String processDefId) throws Exception {
        BpmNodeDef nodeDef = this.getStartEvent(processDefId);
        return nodeDef.getOutcomeNodes();
    }

    @Override
    public boolean isStartNode(String defId, String nodeId) throws Exception {
        List<BpmNodeDef> nodes = this.getStartNodes(defId);
        for (BpmNodeDef node : nodes) {
            if (!node.getNodeId().equals(nodeId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean validNodeDefType(String defId, String nodeId, NodeType nodeDefType) throws Exception {
        BpmNodeDef nodeDef = this.getBpmNodeDef(defId, nodeId);
        return nodeDef.getType().equals((Object)nodeDefType);
    }

    @Override
    public boolean isContainCallActivity(String defId) throws Exception {
        DefaultBpmProcessDef processDef = this.getProcessDefByDefId(defId);
        if (processDef != null) {
            List<BpmNodeDef> list = processDef.getBpmnNodeDefs();
            for (BpmNodeDef nodeDef : list) {
                if (!nodeDef.getType().equals((Object)NodeType.CALLACTIVITY)) continue;
                return true;
            }
        }
        return false;
    }

    private DefaultBpmProcessDef getProcessDefByDefId(String processDefinitionId) throws Exception {
        if (StringUtil.isEmpty((String)processDefinitionId)) {
            StackTraceElement[] stackTrace;
            logger.error("\u4f20\u5165\u6d41\u7a0b\u5b9a\u4e49ID\u4e3a\u7a7a\uff0c\u76f4\u63a5\u8fd4\u56denull\u3002\u4e34\u65f6\u6253\u5370\u5806\u6808\u4fe1\u606f\u5982\u4e0b\uff1a");
            for (StackTraceElement element : stackTrace = Thread.currentThread().getStackTrace()) {
                logger.error(element.toString());
            }
            return null;
        }
        DefaultBpmDefinitionAccessor bean = (DefaultBpmDefinitionAccessor)AppUtil.getBean(this.getClass());
        DefaultBpmProcessDef defaultBpmProcessDef = bean.getProcessDefByDefIdFromCache(processDefinitionId);
        return defaultBpmProcessDef;
    }

    @Cacheable(value={"eip:bpm:processDef"}, key="#processDefinitionId", ignoreException=false)
    protected DefaultBpmProcessDef getProcessDefByDefIdFromCache(String processDefinitionId) throws Exception {
        DefaultBpmProcessDef bpmProcessDef = null;
        DefaultBpmDefinition bpmDef = this.bpmDefinitionManager.getById(processDefinitionId);
        if (BeanUtils.isEmpty((Object)bpmDef)) {
            BpmFreeProcessDef bpmFreeProcessDef = (BpmFreeProcessDef)this.bpmFreeProcessDefManager.get((Serializable)((Object)processDefinitionId));
            Assert.notNull((Object)((Object)bpmFreeProcessDef), (String)String.format("DefinitionId\u4e3a%s\u7684\u6d41\u7a0b\u4e0d\u5b58\u5728", processDefinitionId));
            bpmDef = this.bpmDefinitionManager.getById(bpmFreeProcessDef.getSourceDefId());
            bpmDef.setDefId(bpmFreeProcessDef.getId());
            if (BeanUtils.isNotEmpty((Object)bpmDef)) {
                bpmDef.setBpmnXml(bpmFreeProcessDef.getBpmnXml());
            }
        }
        Assert.isTrue((boolean)BeanUtils.isNotEmpty((Object)bpmDef), (String)String.format("\u672a\u83b7\u53d6\u5230processDefinitionId\u4e3a\uff1a%s\u7684\u6d41\u7a0b\u5b9a\u4e49", processDefinitionId));
        BpmDefData data = bpmDef.getBpmDefData();
        try {
            bpmProcessDef = this.getByBpmnXml(processDefinitionId, data.getBpmnXml());
            bpmProcessDef.getProcessDefExt().getExtProperties().setTestStatus(bpmDef.getTestStatus());
        }
        catch (Exception e) {
            throw new WorkFlowException(String.format("\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49\u65f6\u5019\u51fa\u73b0\u5f02\u5e38\uff1a%s", ExceptionUtils.getFullStackTrace((Throwable)e)), (Throwable)e);
        }
        return bpmProcessDef;
    }

    public DefaultBpmProcessDef getByBpmnXml(String processDefinitionId, String bpmnXml) throws Exception {
        ExtDefinitions definition = DefXmlUtil.getDefinitionsByXml(bpmnXml);
        if (definition == null) {
            return null;
        }
        List<Process> list = this.getProcess(definition);
        if (list.size() != 1) {
            return null;
        }
        Process process = list.get(0);
        DefaultBpmProcessDef bpmProcessDef = new DefaultBpmProcessDef();
        bpmProcessDef.setProcessDefinitionId(processDefinitionId);
        bpmProcessDef.setName(process.getName());
        bpmProcessDef.setDefKey(process.getId());
        BpmProcessDefExtParse processDefExtParse = BpmProcessDefExtParse.getInstance();
        processDefExtParse.handProcessDef(bpmProcessDef, definition, process);
        return bpmProcessDef;
    }

    private List<Process> getProcess(ExtDefinitions definitions) throws JAXBException, IOException {
        ArrayList<Process> processes = new ArrayList<Process>();
        List<JAXBElement<? extends RootElement>> bPMNElements = definitions.getRootElement();
        for (JAXBElement<? extends RootElement> jAXBe : bPMNElements) {
            RootElement element = (RootElement)jAXBe.getValue();
            if (!(element instanceof Process)) continue;
            processes.add((Process)element);
        }
        return processes;
    }

    @Override
    public List<BpmNodeDef> getNodesByType(String processDefinitionId, NodeType nodeType) throws Exception {
        ArrayList<BpmNodeDef> rtnList = new ArrayList<BpmNodeDef>();
        DefaultBpmProcessDef processDef = this.getProcessDefByDefId(processDefinitionId);
        if (processDef != null) {
            List<BpmNodeDef> list = processDef.getBpmnNodeDefs();
            list.stream().forEach(nodeDef -> {
                if (nodeDef.getType().equals((Object)nodeType)) {
                    rtnList.add((BpmNodeDef)nodeDef);
                }
            });
        }
        return rtnList;
    }

    @Override
    public List<BpmNodeDef> getAllNodeDef(String processDefinitionId) throws Exception {
        return BpmUtil.getSubProcessNodes(this.getNodeDefs(processDefinitionId));
    }

    @Override
    public List<BpmNodeDef> getSignUserNode(String processDefinitionId) throws Exception {
        List<BpmNodeDef> bpmNodeDefs = this.getAllNodeDef(processDefinitionId);
        ArrayList<BpmNodeDef> rtnList = new ArrayList<BpmNodeDef>();
        for (BpmNodeDef bnd : bpmNodeDefs) {
            if (!bnd.getType().equals((Object)NodeType.START) && !bnd.getType().equals((Object)NodeType.SIGNTASK) && !bnd.getType().equals((Object)NodeType.USERTASK)) continue;
            rtnList.add(bnd);
        }
        return rtnList;
    }
}

