/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.persistence.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.FormFeignService;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.persistence.dao.BpmBusLinkDao;
import com.hotent.bpm.persistence.manager.BpmBusLinkManager;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.model.BpmBusLink;
import com.hotent.uc.api.impl.util.ContextUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bpmBusLinkManager")
public class BpmBusLinkManagerImpl
extends BaseManagerImpl<BpmBusLinkDao, BpmBusLink>
implements BpmBusLinkManager {
    @Resource
    BpmBusLinkDao bpmBusLinkDao;
    @Resource
    JdbcTemplate jdbcTemplate;
    @Resource
    BpmTaskManager bpmTaskManager;

    @Override
    public List<BpmBusLink> getByBusinesKey(String businessKey, String formIdentity, boolean isNumber) {
        return this.bpmBusLinkDao.getByBusinesKey(this.getParams(businessKey, formIdentity, isNumber));
    }

    @Override
    @Transactional
    public void removeDataByInstId(String instId) throws Exception {
        List<BpmBusLink> links = ((BpmBusLinkDao)this.baseMapper).getAllByInstId(instId);
        if (BeanUtils.isNotEmpty(links)) {
            FormFeignService boDefService = (FormFeignService)AppUtil.getBean(FormFeignService.class);
            boDefService.removeDataByBusLink(JsonUtil.toJsonNode(links));
        }
        for (BpmBusLink link : links) {
            this.remove((Serializable)((Object)link.getId()));
        }
    }

    @Override
    @Transactional
    public void delByBusinesKey(String businessKey, String formIdentity, boolean isNumber) {
        this.bpmBusLinkDao.delByBusinesKey(this.getParams(businessKey, formIdentity, isNumber));
    }

    @Override
    public List<BpmBusLink> getByInstId(String instId) {
        return this.bpmBusLinkDao.getByInstId(instId);
    }

    @Override
    public List<BpmBusLink> getByBusinesKey(String businessKey, String boDefCode, List<String> defIds, String formIdentity, boolean isNumber) {
        return this.bpmBusLinkDao.getByBusinesKey(this.getParams(businessKey, boDefCode, defIds, null, isNumber));
    }

    @Transactional
    public void create(BpmBusLink entity) {
        super.create((Model)entity);
    }

    @Override
    @Transactional
    public void removeDataByDefId(String defId) throws Exception {
        List<BpmBusLink> links = this.getByDefId(defId);
        if (BeanUtils.isNotEmpty(links)) {
            FormFeignService boDefService = (FormFeignService)AppUtil.getBean(FormFeignService.class);
            boDefService.removeDataByBusLink(JsonUtil.toJsonNode(links));
        }
        for (BpmBusLink link : links) {
            this.remove((Serializable)((Object)link.getId()));
        }
    }

    @Override
    public List<BpmBusLink> getByDefId(String defId) {
        return this.bpmBusLinkDao.getByDefId(defId);
    }

    @Override
    public Map<String, BpmBusLink> getMapByInstId(String instId) {
        HashMap<String, BpmBusLink> map = new HashMap<String, BpmBusLink>();
        List<BpmBusLink> list = this.getByInstId(instId);
        for (BpmBusLink busLink : list) {
            map.put(busLink.getBoDefCode(), busLink);
        }
        return map;
    }

    @Override
    public Map<String, BpmBusLink> getMapByInstIdOrDefId(String instId, String defId) {
        Map<String, BpmBusLink> mapByInstId;
        if (StringUtil.isNotEmpty((String)instId) && (mapByInstId = this.getMapByInstId(instId)) != null && mapByInstId.size() > 0) {
            return mapByInstId;
        }
        List<BpmBusLink> list = this.getByDefId(defId);
        HashMap<String, BpmBusLink> map = new HashMap<String, BpmBusLink>(16);
        for (BpmBusLink busLink : list) {
            map.put(busLink.getBoDefCode(), busLink);
        }
        return map;
    }

    private Map<String, Object> getParams(String businessKey, String formIdentity, boolean isNumber) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (isNumber) {
            params.put("businessKey", Long.parseLong(businessKey));
        } else {
            params.put("businessKey", businessKey);
        }
        if (StringUtil.isNotEmpty((String)formIdentity)) {
            params.put("formIdentity", formIdentity);
        }
        params.put("isNumber", isNumber);
        return params;
    }

    private Map<String, Object> getParams(String businessKey, String boDefCode, List<String> defIds, String formIdentity, boolean isNumber) {
        Map<String, Object> params = this.getParams(businessKey, formIdentity, isNumber);
        if (StringUtil.isNotEmpty((String)boDefCode)) {
            params.put("boDefCode", boDefCode);
        }
        if (BeanUtils.isNotEmpty(defIds)) {
            params.put("defIds", defIds);
        }
        return params;
    }

    @Override
    public boolean deleteBatch(List<String> list) {
        return this.bpmBusLinkDao.deleteBatch(list);
    }

    @Override
    public boolean delBatchByBusinesKey(List<Map<String, Object>> list) {
        return this.bpmBusLinkDao.delBatchByBusinesKey(list);
    }

    @Override
    public List<BpmBusLink> getAllByInstId(String instId) {
        return this.bpmBusLinkDao.getAllByInstId(instId);
    }

    @Override
    public Set<String> getFlowFilterBusinessKeys(List<String> filterTypes, String entName, boolean isNumberPk, String defKey) {
        HashSet<String> set = new HashSet<String>();
        String userId = ContextUtil.getCurrentUserId();
        Iterator<String> iterator = filterTypes.iterator();
        block12: while (iterator.hasNext()) {
            String filterType;
            switch (filterType = iterator.next()) {
                case "todo": {
                    set.addAll(this.bpmTaskManager.filterPksByTodo(userId, entName, isNumberPk, defKey));
                    continue block12;
                }
                case "done": {
                    set.addAll(((BpmBusLinkDao)this.baseMapper).filterByDone(userId, entName, isNumberPk, defKey));
                    continue block12;
                }
                case "request": {
                    set.addAll(((BpmBusLinkDao)this.baseMapper).filterByRequest(userId, entName, isNumberPk, defKey));
                    continue block12;
                }
                case "read": {
                    set.addAll(((BpmBusLinkDao)this.baseMapper).filterByRead(userId, entName, isNumberPk, defKey));
                    continue block12;
                }
            }
            throw new BaseException("unKnow filter type");
        }
        return set;
    }
}

