/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.persistence.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.MapUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.bpm.api.constant.InterPoseType;
import com.hotent.bpm.api.constant.OpinionStatus;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.defxml.entity.ext.ExtProperties;
import com.hotent.bpm.persistence.dao.BpmCheckOpinionDao;
import com.hotent.bpm.persistence.manager.BpmCheckOpinionManager;
import com.hotent.bpm.persistence.manager.BpmDefDataManager;
import com.hotent.bpm.persistence.manager.BpmInterposeRecoredManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.model.BpmInterposeRecored;
import com.hotent.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.util.BpmUtil;
import com.hotent.uc.api.impl.util.ContextUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="bpmCheckOpinionManager")
public class BpmCheckOpinionManagerImpl
extends BaseManagerImpl<BpmCheckOpinionDao, DefaultBpmCheckOpinion>
implements BpmCheckOpinionManager {
    @Resource
    BpmCheckOpinionDao bpmCheckOpinionDao;
    @Resource
    BpmDefDataManager bpmDefDataManager;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;

    @Override
    public DefaultBpmCheckOpinion getByTaskId(String taskId) {
        return this.bpmCheckOpinionDao.getByTaskId(taskId);
    }

    @Override
    public DefaultBpmCheckOpinion getTaskKeyByTaskId(String taskId) {
        return this.bpmCheckOpinionDao.getTaskKeyByTaskId(taskId).get(0);
    }

    @Override
    public DefaultBpmCheckOpinion getTaskKeyByNodeId(String nodeId, String instId) {
        return this.bpmCheckOpinionDao.getTaskKeyByNodeId(nodeId, instId).get(0);
    }

    @Override
    @Transactional
    public void archiveHistory(String instId) {
    }

    @Override
    public List<DefaultBpmCheckOpinion> getByInstId(String instId) {
        String supInstId = this.getTopInstId(instId);
        List<String> instList = this.getListByInstId(supInstId);
        return this.bpmCheckOpinionDao.getByInstIds(instList);
    }

    @Transactional
    public void create(DefaultBpmCheckOpinion checkOpinion) {
        if ("true".equals(ThreadMsgUtil.getMapMsg((String)"inst_end_revoke"))) {
            return;
        }
        if (StringUtil.isNotEmpty((String)checkOpinion.getAuditor()) && StringUtil.isEmpty((String)checkOpinion.getOrgId())) {
            BpmUtil.setOpinionOrgInfo(checkOpinion.getAuditor(), checkOpinion);
        }
        if (StringUtil.isNotEmpty((String)ThreadMsgUtil.getMapMsg((String)"leaderId")) && !ThreadMsgUtil.getMapMsg((String)"leaderId").equals("undefined") && StringUtil.isEmpty((String)checkOpinion.getAgentLeaderId()) && !OpinionStatus.AWAITING_CHECK.getKey().equals(checkOpinion.getStatus())) {
            checkOpinion.setAgentLeaderId(ThreadMsgUtil.getMapMsg((String)"leaderId"));
        }
        super.create((Model)checkOpinion);
    }

    @Transactional
    public void update(DefaultBpmCheckOpinion checkOpinion) {
        UCFeignService ucFeignService;
        CommonResult user;
        String fullname;
        if (StringUtil.isNotEmpty((String)checkOpinion.getAuditor()) && StringUtil.isNotEmpty((String)(fullname = JsonUtil.getString((JsonNode)((JsonNode)(user = (ucFeignService = (UCFeignService)AppUtil.getBean(UCFeignService.class)).getUserById(checkOpinion.getAuditor())).getValue()), (String)"fullname")))) {
            checkOpinion.setAuditorName(fullname);
        }
        if (StringUtil.isNotEmpty((String)checkOpinion.getAuditor()) && StringUtil.isEmpty((String)checkOpinion.getOrgId())) {
            BpmUtil.setOpinionOrgInfo(checkOpinion.getAuditor(), checkOpinion);
        }
        if (StringUtil.isNotEmpty((String)ThreadMsgUtil.getMapMsg((String)"leaderId")) && !ThreadMsgUtil.getMapMsg((String)"leaderId").equals("undefined") && StringUtil.isEmpty((String)checkOpinion.getAgentLeaderId())) {
            checkOpinion.setAgentLeaderId(ThreadMsgUtil.getMapMsg((String)"leaderId"));
        }
        super.update((Model)checkOpinion);
    }

    @Override
    public String getTopInstId(String instId) {
        String rtn = instId;
        String supInstId = this.bpmCheckOpinionDao.getSupInstByInstId(instId);
        while (StringUtil.isNotZeroEmpty((String)supInstId)) {
            rtn = supInstId;
            supInstId = this.bpmCheckOpinionDao.getSupInstByInstId(supInstId);
        }
        return rtn;
    }

    private void getChildInst(String supperId, List<String> instList) {
        List<String> list = this.bpmCheckOpinionDao.getBySupInstId(supperId);
        if (BeanUtils.isEmpty(list)) {
            return;
        }
        for (String instId : list) {
            instList.add(instId);
            this.getChildInst(instId, instList);
        }
    }

    @Override
    public List<String> getListByInstId(String supInstId) {
        ArrayList<String> instList = new ArrayList<String>();
        instList.add(supInstId);
        this.getChildInst(supInstId, instList);
        return instList;
    }

    @Override
    @Transactional
    public void delByInstList(List<String> instList) {
        this.bpmCheckOpinionDao.delByInstList(instList);
    }

    @Override
    public List<DefaultBpmCheckOpinion> getByInstNodeId(String instId, String nodeId) {
        return this.bpmCheckOpinionDao.getByInstNodeId(instId, nodeId);
    }

    @Override
    @Transactional
    public void updStatusByWait(String taskId, String status) {
        this.bpmCheckOpinionDao.updStatusByWait(taskId, status);
    }

    @Override
    public List<DefaultBpmCheckOpinion> getByInstIdsAndWait(List<String> list) {
        return this.bpmCheckOpinionDao.getByInstIdsAndWait(list);
    }

    @Override
    public List<DefaultBpmCheckOpinion> getFormOpinionByInstId(String instId) {
        ArrayList<DefaultBpmCheckOpinion> rtnList = new ArrayList<DefaultBpmCheckOpinion>();
        List<DefaultBpmCheckOpinion> list = this.getByInstId(instId);
        for (DefaultBpmCheckOpinion opinion : list) {
            if (!StringUtil.isNotEmpty((String)opinion.getFormName())) continue;
            rtnList.add(opinion);
        }
        return rtnList;
    }

    @Override
    public DefaultBpmCheckOpinion getByTaskIdStatus(String taskId, String taskAction) {
        return this.bpmCheckOpinionDao.getByTaskIdAction(taskId, taskAction);
    }

    @Override
    @Transactional
    public CommonResult<String> updateFlowOpinions(ObjectNode obj) {
        try {
            ObjectNode opinion = (ObjectNode)JsonUtil.toBean((String)obj.get("opinions").asText(), ObjectNode.class);
            this.bpmCheckOpinionDao.updateOpinion(new DefaultBpmCheckOpinion(opinion.get("id").asText(), opinion.get("opinion").asText(), opinion.get("files").asText()));
            BpmInterposeRecored bpmInterposeRecored = new BpmInterposeRecored(opinion.get("procInstId").asText(), obj.get("cause").asText(), InterPoseType.MODIFY_OPINION, "");
            bpmInterposeRecored.setFiles(opinion.get("files").asText());
            BpmInterposeRecoredManager manager = (BpmInterposeRecoredManager)AppUtil.getBean(BpmInterposeRecoredManager.class);
            manager.create((Model)bpmInterposeRecored);
            return new CommonResult(true, "\u4fee\u6539\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, e.getMessage());
        }
    }

    @Override
    @Transactional
    public CommonResult<String> delFlowOpinions(String id, String opinion) {
        try {
            super.remove((Serializable)((Object)id));
            BpmInterposeRecoredManager manager = (BpmInterposeRecoredManager)AppUtil.getBean(BpmInterposeRecoredManager.class);
            manager.remove((Serializable)((Object)id));
            return new CommonResult(true, "\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, e.getMessage());
        }
    }

    @Override
    public DefaultBpmCheckOpinion getBpmOpinion(String instId, String nodeId, String dbType) {
        return this.bpmCheckOpinionDao.getBpmOpinion(instId, nodeId, dbType);
    }

    @Override
    public DefaultBpmCheckOpinion getByTeam(String instId, String noticeId, OpinionStatus opinionStatus, String commuUser) {
        return this.bpmCheckOpinionDao.getByTeam(instId, noticeId, opinionStatus.getKey(), commuUser);
    }

    @Override
    @Transactional
    public void checkOpinionIsRead(String id) {
        this.bpmCheckOpinionDao.checkOpinionIsRead(id);
    }

    @Override
    public List<DefaultBpmCheckOpinion> getByRevokeParentTaskId(String parentTaskId) {
        return this.bpmCheckOpinionDao.getByRevokeParentTaskId(parentTaskId);
    }

    @Override
    @Transactional
    public void retrieveBpmTask(Map<String, Object> params) {
        String assigneeId = MapUtil.getString(params, (String)"assigneeId");
        String assigneeName = MapUtil.getString(params, (String)"assigneeName");
        String qualfieds = "[{\"id\":\"" + assigneeId + "\",\"type\":\"user\",\"groupType\":null,\"name\":\"" + assigneeName + "\"}]";
        params.put("qualfieds", qualfieds);
        this.bpmCheckOpinionDao.retrieveBpmTask(params);
    }

    @Override
    @Transactional
    public void updateQualfieds(List<String> instIds, String transfer, String transfered, String transferName, String transferedName) {
        List<DefaultBpmCheckOpinion> list = this.bpmCheckOpinionDao.getByInstIds(instIds);
        if (BeanUtils.isEmpty(list)) {
            return;
        }
        for (DefaultBpmCheckOpinion opinion : list) {
            if (!StringUtil.isNotEmpty((String)opinion.getQualfiedNames()) || opinion.getQualfiedNames().indexOf(transferName) == -1) continue;
            String qualfieds = opinion.getQualfieds();
            String qualfiedsName = opinion.getQualfiedNames();
            if (StringUtil.isNotEmpty((String)qualfieds)) {
                qualfieds = qualfieds.replace(transfer, transfered).replace(transferName, transferedName);
            }
            qualfiedsName = qualfiedsName.replace(transferName, transferedName);
            opinion.setQualfieds(qualfieds);
            opinion.setQualfiedNames(qualfiedsName);
            this.bpmCheckOpinionDao.updateQualfieds(opinion);
        }
    }

    @Override
    public List<DefaultBpmCheckOpinion> getByParentId(String parentId) {
        return this.bpmCheckOpinionDao.getByParentTaskIdAndStatus(parentId, null);
    }

    @Override
    @Transactional
    public void updateExtraProps(DefaultBpmCheckOpinion bpmCheckOpinion) {
    }

    @Override
    public List<DefaultBpmCheckOpinion> getByInstNodeIdAgree(String instId, String fromNodeId) {
        return ((BpmCheckOpinionDao)this.baseMapper).getByInstNodeIdAgree(instId, fromNodeId);
    }

    @Override
    public List<DefaultBpmCheckOpinion> getByInstNodeIdStatus(String instId, String revokeNodeId, Object object) {
        return ((BpmCheckOpinionDao)this.baseMapper).getByInstNodeIdStatus(instId, revokeNodeId, BeanUtils.isNotEmpty((Object)object) ? object.toString() : null);
    }

    @Override
    public DefaultBpmCheckOpinion getLastOpinionByProcId(String procInstId) {
        return this.bpmCheckOpinionDao.getLastOpinionByProcId(procInstId);
    }

    @Override
    public List<DefaultBpmCheckOpinion> getByInstIdAuditor(String procInstId, String auditor) {
        return this.bpmCheckOpinionDao.getByInstIdAuditor(procInstId, auditor);
    }

    @Override
    public List<String> getAuditorByInstNodeId(String procInstId, String fromNodeId) {
        return ((BpmCheckOpinionDao)this.baseMapper).getAuditorByInstNodeId(procInstId, fromNodeId);
    }

    @Override
    public List<DefaultBpmCheckOpinion> getBeforeEnd(String instId, String userId) {
        return ((BpmCheckOpinionDao)this.baseMapper).getBeforeEnd(instId, userId);
    }

    @Override
    public List<DefaultBpmCheckOpinion> getBpmCheckOpinionByInstId(String instId) {
        return ((BpmCheckOpinionDao)this.baseMapper).getBpmCheckOpinionByInstId(instId);
    }

    @Override
    public DefaultBpmCheckOpinion getLatestOrHistoryBpmCheckOpinionByInstId(String instId) {
        try {
            String curUserId = ContextUtil.getCurrentUserId();
            DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId));
            ExtProperties extProperties = this.bpmDefDataManager.getExtPropertiesByProcDefId(instance.getProcDefId());
            String dataVersion = extProperties.getDoneDataVersion();
            Optional<DefaultBpmCheckOpinion> first = null;
            List<DefaultBpmCheckOpinion> byInstId = this.getBpmCheckOpinionByInstId(instId);
            if (!CollectionUtils.isEmpty(byInstId) && (first = "latest".equals(dataVersion) ? byInstId.stream().filter(r -> StringUtil.isNotEmpty((String)r.getTaskKey())).findFirst() : byInstId.stream().filter(r -> StringUtil.isNotEmpty((String)r.getTaskKey()) && curUserId.equals(r.getAuditor())).findFirst()).isPresent()) {
                return first.get();
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
            return null;
        }
        return null;
    }

    @Override
    public List<BpmIdentity> getHistoryBpmIdentityByInstNodeId(String instId, String destinationNode) {
        return ((BpmCheckOpinionDao)this.baseMapper).getHistoryBpmIdentityByInstNodeId(instId, destinationNode);
    }

    @Override
    public List<BpmIdentity> getRejectHistoryBpmIdentityByInstNodeId(String instId, String targetNode) {
        return ((BpmCheckOpinionDao)this.baseMapper).getRejectHistoryBpmIdentityByInstNodeId(instId, targetNode);
    }
}

