/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.persistence.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.WorkFlowException;
import com.hotent.base.jms.FlowMessage;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.bpm.persistence.dao.BpmFlowMqLogDao;
import com.hotent.bpm.persistence.manager.BpmFlowMqLogManager;
import com.hotent.bpm.persistence.model.BpmFlowMqLog;
import com.hotent.bpm.service.FlowMessageService;
import com.hotent.bpm.todo.util.TodoPushUtil;
import com.hotent.bpm.todo.vo.PortalTaskVo;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="bpmFlowMqLogManager")
public class BpmFlowMqLogManagerImpl
extends BaseManagerImpl<BpmFlowMqLogDao, BpmFlowMqLog>
implements BpmFlowMqLogManager {
    @Resource
    FlowMessageService flowMessageService;

    @Override
    public void reinvoke(String id) throws Exception {
        BpmFlowMqLog bpmFlowMqLog = (BpmFlowMqLog)this.get((Serializable)((Object)id));
        bpmFlowMqLog.setTryTime(bpmFlowMqLog.getTryTime() + 1);
        try {
            FlowMessage msg = (FlowMessage)JsonUtil.toBean((String)bpmFlowMqLog.getContent(), FlowMessage.class);
            this.flowMessageService.handlerFlowJmsMessage(msg);
        }
        catch (WorkFlowException e) {
            bpmFlowMqLog.setException(e.getMessage());
            throw new WorkFlowException(e.getMessage());
        }
        finally {
            bpmFlowMqLog.setStatus(1);
            this.update((Model)bpmFlowMqLog);
        }
    }

    @Override
    public void signSuccess(String id) {
        ((BpmFlowMqLogDao)this.baseMapper).signSuccess(id);
    }

    @Override
    public void revoke(String id) throws Exception {
        BpmFlowMqLog bpmFlowMqLog = (BpmFlowMqLog)this.get((Serializable)((Object)id));
        String content = bpmFlowMqLog.getContent();
        ObjectNode node = (ObjectNode)JsonUtil.toJsonNode((String)content);
        ArrayList<String> taskIds = new ArrayList<String>();
        ArrayList<String> ownerList = new ArrayList<String>();
        taskIds.add(node.get("taskId").asText());
        PortalTaskVo portalTaskVo = new PortalTaskVo();
        portalTaskVo.setInstId(node.get("instId").asText());
        portalTaskVo.setFlowType(JsonUtil.getString((JsonNode)node, (String)"flowType"));
        portalTaskVo.setFlowTypeName(JsonUtil.getString((JsonNode)node, (String)"flowTypeName"));
        TodoPushUtil.delTodo(node.get("instId").asText(), taskIds, 3, ownerList, null, portalTaskVo);
    }

    @Override
    public void buildLog(String type, String subject, String content, int status, String exception, String proInstId, String taskId, String ownerId, String ownerName) {
        int time = 1;
        LocalDateTime now = LocalDateTime.now();
        BpmFlowMqLog log = new BpmFlowMqLog();
        log.setId(UniqueIdUtil.getSuid());
        log.setType(type);
        log.setLogTime(now);
        log.setContent(content);
        log.setTitle(subject);
        log.setTryTime(time);
        if (StringUtil.isNotEmpty((String)exception)) {
            log.setException(exception);
        }
        log.setStatus(status);
        log.setProcInstId(proInstId);
        log.setTaskId(taskId);
        log.setOwnerId(ownerId);
        log.setOwnerName(ownerName);
        log.setYearsPartition(now.getYear());
        super.create((Model)log);
    }
}

