/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.BaseException;
import com.hotent.base.exception.MessagePassingException;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.bpm.persistence.dao.BpmMobileCategoryDao;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.manager.BpmMobileCategoryManager;
import com.hotent.bpm.persistence.model.BpmMobileCategory;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.hotent.uc.api.impl.util.ContextUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BpmMobileCategoryManagerImpl
extends BaseManagerImpl<BpmMobileCategoryDao, BpmMobileCategory>
implements BpmMobileCategoryManager {
    private static final String TYPE_GROUP_MOBILE_FLOW = "14";
    @Resource
    BpmDefinitionManager bpmDefinitionManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveAll(String typeId, List<String> defKeys, boolean saveUser) throws Exception {
        this.validateAll(typeId, defKeys);
        PortalFeignService portalFeignService = (PortalFeignService)AppUtil.getBean(PortalFeignService.class);
        ObjectNode sysType = portalFeignService.getSysTypeById(typeId);
        if (BeanUtils.isEmpty((Object)sysType)) {
            throw new BaseException("\u672a\u627e\u5230\u5bf9\u5e94\u5206\u7c7b");
        }
        String userId = ContextUtil.getCurrentUserId();
        String typeKey = JsonUtil.getString((JsonNode)sysType, (String)"typeKey");
        ArrayList<BpmMobileCategory> list = new ArrayList<BpmMobileCategory>();
        for (String defKey : defKeys) {
            if (this.validateFlowExists(typeId, defKey)) continue;
            DefaultBpmDefinition mainByDefKey = this.bpmDefinitionManager.getMainByDefKey(defKey);
            BpmMobileCategory bpmMobileCategory = new BpmMobileCategory();
            if ("default".equals(typeKey)) {
                if (saveUser) {
                    bpmMobileCategory.setCreator(userId);
                } else {
                    bpmMobileCategory.setCreator("admin");
                }
            }
            bpmMobileCategory.setDefName(mainByDefKey.getName());
            bpmMobileCategory.setTypeId(typeId);
            bpmMobileCategory.setTypeKey(typeKey);
            bpmMobileCategory.setId(UniqueIdUtil.getSuid());
            bpmMobileCategory.setDefKey(defKey);
            list.add(bpmMobileCategory);
        }
        this.saveBatch(list);
    }

    private void validateAll(String typeId, List<String> defKeys) {
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.eq((Object)"TYPE_ID_", (Object)typeId)).in((Object)"DEF_KEY_", defKeys);
        List list = this.list((Wrapper)wrapper);
        if (!list.isEmpty()) {
            throw new MessagePassingException("\u8be5\u5206\u7c7b\u4e0b\u5df2\u5b58\u5728\u76f8\u540c\u7684\u6d41\u7a0b");
        }
    }

    private boolean validateFlowExists(String typeId, String defKey) {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("TYPE_ID_", (Object)typeId, QueryOP.EQUAL, FieldRelation.AND, "main");
        queryFilter.addFilter("DEF_KEY_", (Object)typeId, QueryOP.EQUAL, FieldRelation.AND, "main");
        if (TYPE_GROUP_MOBILE_FLOW.equals(typeId)) {
            String userId = ContextUtil.getCurrentUserId();
            queryFilter.addFilter("CREATOR_", (Object)userId, QueryOP.EQUAL, FieldRelation.OR, "creator");
            queryFilter.addFilter("CREATOR_", (Object)"admin", QueryOP.EQUAL, FieldRelation.OR, "creator");
        }
        return BeanUtils.isNotEmpty((Object)this.getOne(this.convert2Wrapper(queryFilter, BpmMobileCategory.class)));
    }
}

