/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.constant.TaskType;
import com.hotent.bpm.persistence.dao.BpmReadRecordDao;
import com.hotent.bpm.persistence.manager.BpmReadRecordManager;
import com.hotent.bpm.persistence.model.BpmReadRecord;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service(value="bpmReadRecordManager")
public class BpmReadRecordManagerImpl
extends BaseManagerImpl<BpmReadRecordDao, BpmReadRecord>
implements BpmReadRecordManager {
    @Override
    public List<BpmReadRecord> getByInstId(String instId) {
        String supInstId = this.getTopInstId(instId);
        List<String> instList = this.getListByInstId(supInstId);
        return ((BpmReadRecordDao)this.baseMapper).getByInstIds(instList);
    }

    @Override
    public String getTopInstId(String instId) {
        String rtn = instId;
        String supInstId = ((BpmReadRecordDao)this.baseMapper).getSupInstByInstId(instId);
        while (StringUtil.isNotZeroEmpty((String)supInstId)) {
            rtn = supInstId;
            supInstId = ((BpmReadRecordDao)this.baseMapper).getSupInstByInstId(supInstId);
        }
        return rtn;
    }

    private void getChildInst(String supperId, List<String> instList) {
        List<String> list = ((BpmReadRecordDao)this.baseMapper).getBySupInstId(supperId);
        if (BeanUtils.isEmpty(list)) {
            return;
        }
        for (String instId : list) {
            instList.add(instId);
            this.getChildInst(instId, instList);
        }
    }

    @Override
    public List<String> getListByInstId(String supInstId) {
        ArrayList<String> instList = new ArrayList<String>();
        instList.add(supInstId);
        this.getChildInst(supInstId, instList);
        return instList;
    }

    @Override
    public List<BpmReadRecord> getByInstNodeId(String instId, String nodeId) {
        return ((BpmReadRecordDao)this.baseMapper).getByInstNodeId(instId, nodeId);
    }

    @Override
    public List<BpmReadRecord> getFormOpinionByInstId(String instId) {
        ArrayList<BpmReadRecord> rtnList = new ArrayList<BpmReadRecord>();
        List<BpmReadRecord> list = this.getByInstId(instId);
        for (BpmReadRecord opinion : list) {
            rtnList.add(opinion);
        }
        return rtnList;
    }

    @Override
    public List<BpmReadRecord> getByTaskIdandrecord(String taskId, String ... reader) {
        return ((BpmReadRecordDao)this.baseMapper).getByTaskIdandrecord(taskId, reader);
    }

    @Override
    public List<BpmReadRecord> getByinstidandrecord(String instId, String reader) {
        return ((BpmReadRecordDao)this.baseMapper).getByinstidandrecord(instId, reader);
    }

    @Override
    public Boolean isTaskReadByOwner(String taskId) {
        return ((BpmReadRecordDao)this.baseMapper).getReadByOwnerCountWithTaskId(taskId) > 0;
    }

    @Override
    public List<BpmReadRecord> getByTaskIds(List<DefaultBpmTask> bpmTasks) {
        ArrayList<String> taskIds = new ArrayList<String>();
        bpmTasks.forEach(bpmTask -> {
            if (!TaskType.TRANSFORMING.getKey().equals(bpmTask.getStatus())) {
                taskIds.add(bpmTask.getId());
            }
        });
        return ((BpmReadRecordDao)this.baseMapper).getByTaskIds(taskIds);
    }

    @Override
    public PageList<BpmReadRecord> selectPageByGroup(QueryFilter<BpmReadRecord> queryFilter) {
        return new PageList(((BpmReadRecordDao)this.baseMapper).selectPageByGroup((IPage<BpmReadRecord>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BpmReadRecord>)this.convert2Wrapper(queryFilter, this.currentModelClass())));
    }
}

