/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.cache.annotation.CachePut;
import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.cache.annotation.FirstCache;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.JAXBUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.ZipUtil;
import com.hotent.bpm.persistence.dao.BpmReportActDao;
import com.hotent.bpm.persistence.dao.BpmReportListDao;
import com.hotent.bpm.persistence.manager.BpmReportActManager;
import com.hotent.bpm.persistence.manager.BpmReportListManager;
import com.hotent.bpm.persistence.model.BpmReportAct;
import com.hotent.bpm.persistence.model.BpmReportList;
import com.hotent.bpm.persistence.model.BpmReportXml;
import com.hotent.bpm.persistence.model.BpmReportXmlList;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="bpmReportListManager")
public class BpmReportListManagerImpl
extends BaseManagerImpl<BpmReportListDao, BpmReportList>
implements BpmReportListManager {
    @Resource
    BpmReportActManager bpmReportActManager;
    @Resource
    BpmReportActDao bpmReportActDao;
    @Resource
    PortalFeignService portalFeignService;
    @Resource
    UCFeignService ucFeignService;
    @Resource
    UCFeignService ucService;
    @Resource
    BpmReportListManager bpmReportListManager;

    @Transactional
    public void removeByIds(String ... ids) {
        for (String id : ids) {
            this.remove(id);
        }
    }

    @Transactional
    public void remove(String id) {
        BpmReportList reportList = (BpmReportList)super.get((Serializable)((Object)id));
        if (BeanUtils.isNotEmpty((Object)((Object)reportList))) {
            this.bpmReportActManager.removeByReportId(id);
        }
        super.remove((Serializable)((Object)id));
    }

    @Override
    public Map<String, String> exportData(List<String> ids) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        BpmReportXmlList bpmReportXmlList = new BpmReportXmlList();
        for (String id : ids) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"report_id_", (Object)id);
            List bpmReportActList = this.bpmReportActDao.selectList((Wrapper)wrapper);
            for (BpmReportAct bpmReportAct : bpmReportActList) {
                ArrayNode userArrayNode;
                String userIds;
                ArrayNode orgArrayNode;
                String orgIds;
                String flowTypeIds;
                ObjectNode prop = (ObjectNode)JsonUtil.toJsonNode((String)bpmReportAct.getPorp());
                String flowType = JsonUtil.getString((JsonNode)prop, (String)"flowType", (String)"1");
                ArrayList<String> flowTypeKeys = new ArrayList<String>();
                if ("2".equals(flowType) && StringUtil.isNotEmpty((String)(flowTypeIds = JsonUtil.getString((JsonNode)prop, (String)"id")))) {
                    QueryFilter queryFilter = QueryFilter.build();
                    queryFilter.addFilter("id_", (Object)flowTypeIds, QueryOP.IN);
                    ObjectNode sysTypeObjNode = this.portalFeignService.getAllSysType(queryFilter);
                    if (BeanUtils.isNotEmpty((Object)sysTypeObjNode) && BeanUtils.isNotEmpty((Object)sysTypeObjNode.get("rows"))) {
                        for (JsonNode sysTypeNode : sysTypeObjNode.get("rows")) {
                            String flowTypeKey = JsonUtil.getString((JsonNode)sysTypeNode, (String)"typeKey");
                            if (!StringUtil.isNotEmpty((String)flowTypeKey)) continue;
                            flowTypeKeys.add(flowTypeKey);
                        }
                        if (!flowTypeKeys.isEmpty()) {
                            bpmReportAct.setFlowTypeKeys(flowTypeKeys);
                        }
                    }
                }
                if (StringUtil.isNotEmpty((String)(orgIds = JsonUtil.getString((JsonNode)prop, (String)"orgIds"))) && BeanUtils.isNotEmpty((Object)(orgArrayNode = this.ucFeignService.getOrgsByIds(orgIds)))) {
                    ArrayList<String> orgCodes = new ArrayList<String>();
                    for (JsonNode orgNode : orgArrayNode) {
                        String code = JsonUtil.getString((JsonNode)orgNode, (String)"code");
                        if (!StringUtil.isNotEmpty((String)code)) continue;
                        orgCodes.add(code);
                    }
                    if (!orgCodes.isEmpty()) {
                        bpmReportAct.setOrgCodes(orgCodes);
                    }
                }
                if (!StringUtil.isNotEmpty((String)(userIds = JsonUtil.getString((JsonNode)prop, (String)"userIds"))) || !BeanUtils.isNotEmpty((Object)(userArrayNode = this.ucFeignService.getUserByIds(userIds)))) continue;
                ArrayList<String> userAccounts = new ArrayList<String>();
                for (JsonNode userNode : userArrayNode) {
                    String userAccount = JsonUtil.getString((JsonNode)userNode, (String)"account");
                    if (!StringUtil.isNotEmpty((String)userAccount)) continue;
                    userAccounts.add(userAccount);
                }
                if (userAccounts.isEmpty()) continue;
                bpmReportAct.setUserAccounts(userAccounts);
            }
            BpmReportXml bpmReportXml = new BpmReportXml();
            BpmReportList bpmReport = (BpmReportList)this.get((Serializable)((Object)id));
            bpmReportXml.setBpmReport(bpmReport);
            bpmReportXml.setBpmReportActList(bpmReportActList);
            bpmReportXmlList.addBpmReportXml(bpmReportXml);
        }
        try {
            String xml = JAXBUtil.marshall((Object)bpmReportXmlList, BpmReportXmlList.class);
            map.put("bpmReports.bpm.xml", xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5bfc\u51fa\u5931\u8d25\uff01" + e.getMessage(), e);
        }
        return map;
    }

    @Override
    @CachePut(value={"eip:bpm_report:importFile"}, key="#fileId", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.HOURS))
    public String putImportFileInCache(String fileId, String fileStr) {
        return fileStr;
    }

    @Override
    @Cacheable(value={"eip:bpm_report:importFile"}, key="#fileId", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.HOURS))
    public String getImportFileFromCache(String fileId) {
        return null;
    }

    @Override
    @CacheEvict(value={"eip:bpm_report:importFile"}, key="#fileId")
    public void delImportFileFromCache(String fileId) {
    }

    @Override
    @Transactional
    public CommonResult<String> importDataCheck(MultipartHttpServletRequest request, HttpServletResponse response) {
        String unZipFilePath = null;
        MultipartFile file = request.getFile("file");
        try {
            String rootRealPath = Paths.get(FileUtil.getIoTmpdir(), "/attachFiles/unZip").toString();
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            String name = file.getOriginalFilename();
            String fileDir = StringUtil.substringBeforeLast((String)name, (String)".");
            unZipFilePath = Paths.get(rootRealPath, fileDir).toString();
            String xml = FileUtil.readFile((String)Paths.get(unZipFilePath, "bpmReports.bpm.xml").toString());
            this.importDataCheck(xml);
            LinkedHashSet bpmReportsSkipped = ThreadMsgUtil.getMapMsg2((String)"bpmReportsSkipped");
            if (BeanUtils.isNotEmpty((Object)bpmReportsSkipped)) {
                StringBuilder sb = new StringBuilder();
                sb.append("<div style='font-weight:bold;'>\u4ee5\u4e0b\u6d41\u7a0b\u56fe\u8868\u91cd\u590d\uff0c\u662f\u5426\u8986\u76d6\u66f4\u65b0\uff1a</div>");
                String msg = String.format("%s", String.join((CharSequence)"", bpmReportsSkipped));
                sb.append(msg);
                String cacheFileId = UniqueIdUtil.getSuid();
                ((BpmReportListManagerImpl)AppUtil.getBean(this.getClass())).putImportFileInCache(cacheFileId, xml);
                return new CommonResult(false, sb.toString(), (Object)cacheFileId);
            }
            this.importData(xml);
            return new CommonResult(true, "\u5bfc\u5165\u6210\u529f!");
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
    }

    public void importDataCheck(String xml) throws Exception {
        if (StringUtil.isEmpty((String)xml)) {
            throw new BaseException("\u5bfc\u5165\u7684xml\u6587\u4ef6\u6ca1\u6709\u5185\u5bb9\uff01");
        }
        BpmReportXmlList list = (BpmReportXmlList)JAXBUtil.unmarshall((String)xml, BpmReportXmlList.class);
        List<BpmReportXml> bpmReportXmlList = list.getBpmReportXmlList();
        if (bpmReportXmlList.size() == 0) {
            throw new BaseException("\u5bfc\u5165\u6d41\u7a0b\u56fe\u8868\u5185\u5bb9\u65e0\u6548\uff01");
        }
        for (BpmReportXml bpmReportXml : bpmReportXmlList) {
            BpmReportList bpmReport = bpmReportXml.getBpmReport();
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"alias_", (Object)bpmReport.getAlias());
            List existBpmReportList = ((BpmReportListDao)this.baseMapper).selectList((Wrapper)wrapper);
            if (existBpmReportList == null || existBpmReportList.isEmpty()) continue;
            ThreadMsgUtil.addMapMsg2((String)"bpmReportsSkipped", (String)String.format("<div style='margin-left:12px; margin-top:6px;'>%s [%s]</div>", bpmReport.getName() + "", bpmReport.getAlias() + ""));
        }
    }

    @Transactional
    public void importData(String xml) throws Exception {
        if (StringUtil.isEmpty((String)xml)) {
            throw new BaseException("\u5bfc\u5165\u7684xml\u6587\u4ef6\u6ca1\u6709\u5185\u5bb9\uff01");
        }
        BpmReportXmlList list = (BpmReportXmlList)JAXBUtil.unmarshall((String)xml, BpmReportXmlList.class);
        List<BpmReportXml> bpmReportXmlList = list.getBpmReportXmlList();
        if (bpmReportXmlList.size() == 0) {
            throw new BaseException("\u5bfc\u5165\u6d41\u7a0b\u56fe\u8868\u5185\u5bb9\u65e0\u6548\uff01");
        }
        for (BpmReportXml bpmReportXml : bpmReportXmlList) {
            this.importData(bpmReportXml);
        }
    }

    @Override
    public CommonResult<String> importData(Optional<String> cacheFileId) throws Exception {
        CommonResult message = new CommonResult("\u5bfc\u5165\u6210\u529f");
        String cacheFile = cacheFileId.orElse("");
        String fileStr = ((BpmReportListManagerImpl)AppUtil.getBean(this.getClass())).getImportFileFromCache(cacheFile);
        if (StringUtil.isEmpty((String)fileStr)) {
            return new CommonResult("\u5bfc\u5165\u7684\u6587\u4ef6\u5df2\u7ecf\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165\u3002");
        }
        this.importData(fileStr);
        this.delImportFileFromCache(cacheFileId.orElse(""));
        return message;
    }

    @Override
    public CommonResult<String> saveList(BpmReportList bpmReportList) {
        String resultMsg = null;
        String id = bpmReportList.getId();
        try {
            if (StringUtil.isEmpty((String)id)) {
                IUser user = ContextUtil.getCurrentUser();
                bpmReportList.setCreateBy(user.getUserId());
                bpmReportList.setCreateName(user.getFullname());
                ObjectNode org = this.ucService.getMainGroup(user.getUserId());
                if (BeanUtils.isNotEmpty((Object)org)) {
                    String orgId = org.get("id").asText();
                    String orgName = org.get("name").asText();
                    bpmReportList.setCreateOrgId(orgId);
                    bpmReportList.setOrgName(orgName);
                }
                bpmReportList.setId(UniqueIdUtil.getSuid());
                this.bpmReportListManager.create((Model)bpmReportList);
                resultMsg = "\u6dfb\u52a0\u6d41\u7a0b\u7edf\u8ba1\u5206\u6790\u6210\u529f";
            } else {
                this.bpmReportListManager.update((Model)bpmReportList);
                resultMsg = "\u66f4\u65b0\u6d41\u7a0b\u7edf\u8ba1\u5206\u6790\u6210\u529f";
            }
            return new CommonResult(true, resultMsg, (Object)bpmReportList.getId());
        }
        catch (Exception e) {
            resultMsg = "\u5bf9\u6d41\u7a0b\u7edf\u8ba1\u5206\u6790\u64cd\u4f5c\u5931\u8d25";
            return new CommonResult(false, resultMsg);
        }
    }

    private void importData(BpmReportXml bpmReportxml) throws Exception {
        BpmReportList bpmReport = bpmReportxml.getBpmReport();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"alias_", (Object)bpmReport.getAlias());
        BpmReportList bpmReportList = (BpmReportList)((Object)((BpmReportListDao)this.baseMapper).selectOne((Wrapper)wrapper));
        Boolean existOldReport = false;
        if (bpmReportList != null) {
            existOldReport = true;
        }
        String reportId = UniqueIdUtil.getSuid();
        if (existOldReport.booleanValue()) {
            this.update((Object)bpmReport, (Wrapper)wrapper);
        } else {
            bpmReport.setId(reportId);
            this.create((Model)bpmReport);
        }
        List<BpmReportAct> bpmReportActList = bpmReportxml.getBpmReportActList();
        for (BpmReportAct bpmReportAct : bpmReportActList) {
            String userAccountsStr;
            ArrayNode userArrayNode;
            List<String> userAccounts;
            ArrayNode orgArrayNode;
            List<String> orgCodes;
            List<String> flowTypeKeys;
            ObjectNode prop = (ObjectNode)JsonUtil.toJsonNode((String)bpmReportAct.getPorp());
            String flowType = JsonUtil.getString((JsonNode)prop, (String)"flowType", (String)"1");
            if ("2".equals(flowType) && (flowTypeKeys = bpmReportAct.getFlowTypeKeys()) != null && !flowTypeKeys.isEmpty()) {
                String flowTypeKeysStr = String.join((CharSequence)",", flowTypeKeys);
                QueryFilter queryFilter = QueryFilter.build();
                queryFilter.addFilter("typeGroupKey", (Object)"FLOW_TYPE", QueryOP.EQUAL);
                queryFilter.addFilter("typeKey", (Object)flowTypeKeysStr, QueryOP.IN);
                ObjectNode sysTypeObjNode = this.portalFeignService.getAllSysType(queryFilter);
                if (BeanUtils.isNotEmpty((Object)sysTypeObjNode) && BeanUtils.isNotEmpty((Object)sysTypeObjNode.get("rows"))) {
                    ArrayList flowTypeIds = new ArrayList();
                    for (JsonNode sysTypeNode : sysTypeObjNode.get("rows")) {
                        String flowTypeId = JsonUtil.getString((JsonNode)sysTypeNode, (String)"id");
                        if (!StringUtil.isNotEmpty((String)flowTypeId)) continue;
                        flowTypeIds.add(flowTypeId);
                    }
                    if (!flowTypeIds.isEmpty()) {
                        String flowTypeIdsStr = String.join((CharSequence)",", flowTypeIds);
                        prop.put("id", flowTypeIdsStr);
                    }
                }
            }
            if ((orgCodes = bpmReportAct.getOrgCodes()) != null && !orgCodes.isEmpty() && BeanUtils.isNotEmpty((Object)(orgArrayNode = this.ucFeignService.getOrgsByCodes(String.join((CharSequence)",", orgCodes))))) {
                ArrayList<Object> orgIds = new ArrayList<Object>();
                ArrayList<String> orgNames = new ArrayList<String>();
                for (JsonNode orgNode : orgArrayNode) {
                    String orgName;
                    String orgId = JsonUtil.getString((JsonNode)orgNode, (String)"id");
                    if (StringUtil.isNotEmpty((String)orgId)) {
                        orgIds.add(orgId);
                    }
                    if (!StringUtil.isNotEmpty((String)(orgName = JsonUtil.getString((JsonNode)orgNode, (String)"name")))) continue;
                    orgNames.add(orgName);
                }
                if (!orgIds.isEmpty()) {
                    String orgIdsStr = String.join((CharSequence)",", orgIds);
                    prop.put("orgIds", orgIdsStr);
                }
                if (!orgNames.isEmpty()) {
                    String orgNamesStr = String.join((CharSequence)",", orgNames);
                    prop.put("orgNames", orgNamesStr);
                }
            }
            if ((userAccounts = bpmReportAct.getUserAccounts()) != null && !userAccounts.isEmpty() && BeanUtils.isNotEmpty((Object)(userArrayNode = this.ucFeignService.getUserByAccounts(userAccountsStr = String.join((CharSequence)",", userAccounts))))) {
                ArrayList<String> userIds = new ArrayList<String>();
                ArrayList<String> userNames = new ArrayList<String>();
                for (JsonNode userNode : userArrayNode) {
                    String userName;
                    String userId = JsonUtil.getString((JsonNode)userNode, (String)"id");
                    if (StringUtil.isNotEmpty((String)userId)) {
                        userIds.add(userId);
                    }
                    if (!StringUtil.isNotEmpty((String)(userName = JsonUtil.getString((JsonNode)userNode, (String)"fullname")))) continue;
                    userNames.add(userName);
                }
                if (!userIds.isEmpty()) {
                    String userIdsStr = String.join((CharSequence)",", userIds);
                    prop.put("orgIds", userIdsStr);
                }
                if (!userNames.isEmpty()) {
                    String userNamesStr = String.join((CharSequence)",", userNames);
                    prop.put("orgNames", userNamesStr);
                }
            }
            bpmReportAct.setPorp(JsonUtil.toJsonString((Object)prop));
            String actId = UniqueIdUtil.getSuid();
            bpmReportAct.setId(actId);
            if (existOldReport.booleanValue()) {
                wrapper = new QueryWrapper();
                wrapper.eq((Object)"report_id_", (Object)bpmReportList.getId());
                this.bpmReportActDao.delete((Wrapper)wrapper);
                bpmReportAct.setReportId(bpmReportList.getId());
                this.bpmReportActDao.insert((Object)bpmReportAct);
                continue;
            }
            bpmReportAct.setReportId(reportId);
            this.bpmReportActDao.insert((Object)bpmReportAct);
        }
    }
}

