/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.persistence.manager.impl;

import com.hotent.base.feign.UCFeignService;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.persistence.dao.BpmSecretaryManageDao;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.manager.BpmSecretaryManageManager;
import com.hotent.bpm.persistence.model.BpmSecretaryManage;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="bpmSecretaryManageManager")
public class BpmSecretaryManageManagerImpl
extends BaseManagerImpl<BpmSecretaryManageDao, BpmSecretaryManage>
implements BpmSecretaryManageManager {
    @Resource
    BpmDefinitionManager bpmDefinitionManager;

    @Override
    public Map<String, Set<String>> getShareDefsBySecretaryId(String secretaryId, String rightType) {
        List query;
        HashMap<String, Set<String>> resultMap = new HashMap<String, Set<String>>();
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("SECRETARY_ID_", (Object)secretaryId, QueryOP.LIKE);
        queryFilter.addFilter("ENABLED_", (Object)"1", QueryOP.EQUAL);
        if (StringUtil.isNotEmpty((String)rightType)) {
            queryFilter.addFilter("SHARE_RIGHT_", (Object)rightType, QueryOP.LIKE);
        }
        if (BeanUtils.isEmpty((Object)(query = super.queryNoPage(queryFilter))) || query.size() == 0) {
            return resultMap;
        }
        Map<String, Set<String>> defKeyMap = this.getDefTypeMap();
        for (BpmSecretaryManage secretary : query) {
            String secretaryIds = secretary.getSecretaryId();
            boolean match = false;
            for (String s : secretaryIds.split(",")) {
                if (!secretaryId.equals(s)) continue;
                match = true;
                break;
            }
            if (!match) continue;
            HashSet<String> keySet = resultMap.containsKey(secretary.getLeaderId()) ? (Set)resultMap.get(secretary.getLeaderId()) : new HashSet<String>();
            String[] keyArray = secretary.getShareKey().split(",");
            if ("1".equals(secretary.getShareType())) {
                keySet.addAll(Arrays.asList(keyArray));
            } else {
                for (String typeId : keyArray) {
                    if (!defKeyMap.containsKey(typeId)) continue;
                    keySet.addAll((Collection)defKeyMap.get(typeId));
                }
            }
            resultMap.put(secretary.getLeaderId(), keySet);
        }
        return resultMap;
    }

    private Map<String, Set<String>> getDefTypeMap() {
        QueryFilter deFilter = QueryFilter.build();
        deFilter.addParams("isAdmin", (Object)1);
        deFilter.addFilter("is_main_", (Object)"Y", QueryOP.EQUAL);
        List defQuery = this.bpmDefinitionManager.queryNoPage(deFilter);
        HashMap<String, Set<String>> defKeyMap = new HashMap<String, Set<String>>();
        if (BeanUtils.isNotEmpty((Object)defQuery)) {
            for (DefaultBpmDefinition definition : defQuery) {
                Set<String> keySet = new HashSet<String>();
                if (defKeyMap.containsKey(definition.getTypeId())) {
                    keySet = (Set)defKeyMap.get(definition.getTypeId());
                }
                keySet.add(definition.getDefKey());
                defKeyMap.put(definition.getTypeId(), keySet);
            }
        }
        return defKeyMap;
    }

    @Override
    public Map<String, Object> getLeadersRigthMapBySecretaryId(String secretaryId, String rightType, Boolean isUser) {
        Map<String, Set<String>> shareDefsBySecretaryId = this.getShareDefsBySecretaryId(secretaryId, rightType);
        if (isUser.booleanValue()) {
            shareDefsBySecretaryId.put(secretaryId, new HashSet());
        }
        UCFeignService ucFeignService = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        Set<String> keySet = shareDefsBySecretaryId.keySet();
        String ids = "";
        for (String string : keySet) {
            ids = ids + string + ",";
        }
        Map userRightMapByIds = ucFeignService.getUserRightMapByIds(ids);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (String userId : shareDefsBySecretaryId.keySet()) {
            Map groupMap = new HashMap();
            HashMap<String, Object> userRightMap = new HashMap<String, Object>();
            if (userId.equals(secretaryId)) {
                userRightMap.put("isSelf", true);
            } else {
                userRightMap.put("isSelf", false);
                userRightMap.put("defKeys", StringUtil.convertListToSingleQuotesString(shareDefsBySecretaryId.get(userId)));
            }
            if (userRightMapByIds.containsKey(userId)) {
                groupMap = (Map)userRightMapByIds.get(userId);
            }
            userRightMap.put("groupMap", groupMap);
            resultMap.put(userId, userRightMap);
        }
        return resultMap;
    }

    @Override
    public Map<String, Set<String>> getSecretaryByleaderIds(Set<String> leaderIds, String defKey) {
        HashMap<String, Set<String>> resultMap = new HashMap<String, Set<String>>();
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("LEADER_ID_", new ArrayList<String>(leaderIds), QueryOP.IN);
        queryFilter.addFilter("ENABLED_", (Object)"1", QueryOP.EQUAL);
        PageList query = super.query(queryFilter);
        if (BeanUtils.isEmpty((Object)query) || query.getRows().size() == 0) {
            return resultMap;
        }
        Map<String, Set<String>> defKeyMap = this.getDefTypeMap();
        for (BpmSecretaryManage secretary : query.getRows()) {
            HashSet<String> secretaryIds = resultMap.containsKey(secretary.getLeaderId()) ? (Set)resultMap.get(secretary.getLeaderId()) : new HashSet<String>();
            HashSet<Object> shareDefKeys = new HashSet();
            String[] keyArray = secretary.getShareKey().split(",");
            if ("1".equals(secretary.getShareType())) {
                shareDefKeys = new HashSet<String>(Arrays.asList(keyArray));
            } else {
                for (String typeId : keyArray) {
                    if (!defKeyMap.containsKey(typeId)) continue;
                    shareDefKeys.addAll((Collection<Object>)defKeyMap.get(typeId));
                }
            }
            if (shareDefKeys.contains(defKey)) {
                secretaryIds.addAll(Arrays.asList(secretary.getSecretaryId().split(",")));
            }
            resultMap.put(secretary.getLeaderId(), secretaryIds);
        }
        return resultMap;
    }

    @Override
    public List<BpmSecretaryManage> getSecretaryByUserId(String userId) {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addQueryField(new QueryField("SECRETARY_ID_", (Object)userId, QueryOP.EQUAL, FieldRelation.OR, "secretaryId"));
        queryFilter.addQueryField(new QueryField("SECRETARY_ID_", (Object)("," + userId + ","), QueryOP.LIKE, FieldRelation.OR, "secretaryId"));
        queryFilter.addQueryField(new QueryField("SECRETARY_ID_", (Object)(userId + ","), QueryOP.RIGHT_LIKE, FieldRelation.OR, "secretaryId"));
        queryFilter.addQueryField(new QueryField("SECRETARY_ID_", (Object)("," + userId), QueryOP.LEFT_LIKE, FieldRelation.OR, "secretaryId"));
        return super.queryNoPage(queryFilter);
    }

    @Override
    public int checkHasSecretaryByUserId(String userId) {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addQueryField(new QueryField("SECRETARY_ID_", (Object)userId, QueryOP.EQUAL, FieldRelation.OR, "secretaryId"));
        queryFilter.addQueryField(new QueryField("SECRETARY_ID_", (Object)("," + userId + ","), QueryOP.LIKE, FieldRelation.OR, "secretaryId"));
        queryFilter.addQueryField(new QueryField("SECRETARY_ID_", (Object)(userId + ","), QueryOP.RIGHT_LIKE, FieldRelation.OR, "secretaryId"));
        queryFilter.addQueryField(new QueryField("SECRETARY_ID_", (Object)("," + userId), QueryOP.LEFT_LIKE, FieldRelation.OR, "secretaryId"));
        queryFilter.addQueryField(new QueryField("ENABLED_", (Object)"1"));
        queryFilter.addQueryField(new QueryField("SHARE_RIGHT_", (Object)"2", QueryOP.LIKE));
        return super.count(queryFilter);
    }
}

