/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.persistence.manager.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.BeanUtils;
import com.hotent.bpm.api.constant.ExtractType;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.model.process.task.BpmTask;
import com.hotent.bpm.persistence.dao.BpmTaskCandidateDao;
import com.hotent.bpm.persistence.manager.BpmTaskCandidateManager;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.model.DefaultBpmTaskCandidate;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bpmTaskCandidateManager")
public class BpmTaskCandidateManagerImpl
extends BaseManagerImpl<BpmTaskCandidateDao, DefaultBpmTaskCandidate>
implements BpmTaskCandidateManager {
    @Resource
    BpmTaskCandidateDao bpmTaskCandidateDao;
    @Resource
    IUserService userServiceImpl;
    @Resource
    BpmTaskManager bpmTaskManager;

    @Override
    @Transactional
    public void addCandidate(BpmTask task, List<BpmIdentity> list) {
        String taskId = task.getId();
        String instId = task.getProcInstId();
        ArrayList<DefaultBpmTaskCandidate> identities = new ArrayList<DefaultBpmTaskCandidate>();
        for (BpmIdentity identity : list) {
            DefaultBpmTaskCandidate candidate;
            String type = identity.getType();
            if ("user".equals(type)) {
                candidate = new DefaultBpmTaskCandidate(taskId, "user", identity.getId(), instId);
                identities.add(candidate);
                continue;
            }
            if ("groupUser".equals(type)) {
                String[] aryId = identity.getId().split(",");
                for (String userId : aryId) {
                    DefaultBpmTaskCandidate candidate2 = new DefaultBpmTaskCandidate(taskId, "user", userId, instId);
                    identities.add(candidate2);
                }
                continue;
            }
            if (!"group".equals(type)) continue;
            if (ExtractType.EXACT_EXACT_USER.equals((Object)identity.getExtractType())) {
                List userList = this.userServiceImpl.getUserListByGroup(identity.getGroupType(), identity.getId(), identity.getCode());
                for (IUser user : userList) {
                    DefaultBpmTaskCandidate candidate3 = new DefaultBpmTaskCandidate(taskId, "user", user.getUserId(), instId);
                    identities.add(candidate3);
                }
                continue;
            }
            candidate = new DefaultBpmTaskCandidate(taskId, identity.getGroupType(), identity.getId(), instId);
            identities.add(candidate);
        }
        this.saveBatch(identities);
    }

    @Override
    @Transactional
    public void removeByTaskId(String taskId) {
        if (this.existByTaskId(taskId)) {
            this.bpmTaskCandidateDao.removeByTaskId(taskId);
        }
    }

    @Override
    public List<DefaultBpmTaskCandidate> queryByTaskId(String taskId) {
        return this.bpmTaskCandidateDao.queryByTaskId(taskId);
    }

    @Override
    public DefaultBpmTaskCandidate getByTaskIdExeIdType(String taskId, String executorId, String type) {
        return this.bpmTaskCandidateDao.getByTaskIdExeIdType(taskId, executorId, type);
    }

    @Override
    @Transactional
    public void delByInstList(List<String> instList) {
        this.bpmTaskCandidateDao.delByInstList(instList);
    }

    @Override
    public List<DefaultBpmTaskCandidate> getByInstList(List<String> instList) {
        return this.bpmTaskCandidateDao.getByInstList(instList);
    }

    @Override
    @Transactional
    public void updateExecutor(Map<String, Object> params) {
        this.bpmTaskCandidateDao.updateExecutor(params);
    }

    @Override
    @Transactional
    public void addCandidate(String taskId, List<BpmIdentity> list) {
        BpmTask bpmTask = (BpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        this.addCandidate(bpmTask, list);
    }

    @Override
    public boolean existByTaskId(String taskId) {
        Page page = new Page(1L, 1L);
        page.setSearchCount(false);
        Integer count = this.bpmTaskCandidateDao.existByTaskId(page, taskId);
        return BeanUtils.isNotEmpty((Object)count) && count > 0;
    }
}

