/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.BeanUtils;
import com.hotent.bpm.persistence.dao.BpmWatermarkProcessDao;
import com.hotent.bpm.persistence.manager.BpmWatermarkProcessManager;
import com.hotent.bpm.persistence.model.BpmWatermarkProcess;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service(value="bpmWatermarkProcessManager")
public class BpmWatermarkProcessManagerImpl
extends BaseManagerImpl<BpmWatermarkProcessDao, BpmWatermarkProcess>
implements BpmWatermarkProcessManager {
    @Override
    public void batchAdd(List<BpmWatermarkProcess> watermarkProcesses, int isAllSave) {
        if (isAllSave == 0) {
            List processes = watermarkProcesses.stream().filter(item -> {
                BpmWatermarkProcess process = this.isExist(item.getProcDefKey());
                return !BeanUtils.isNotEmpty((Object)((Object)process));
            }).collect(Collectors.toList());
            this.saveBatch(processes);
        } else {
            for (BpmWatermarkProcess item2 : watermarkProcesses) {
                BpmWatermarkProcess process = this.isExist(item2.getProcDefKey());
                if (BeanUtils.isNotEmpty((Object)((Object)process))) {
                    process.setWatermarkId(item2.getWatermarkId());
                    this.update((Model)process);
                    continue;
                }
                this.create((Model)item2);
            }
        }
    }

    @Override
    public CommonResult<String> isExist(List<BpmWatermarkProcess> watermarkProcesses) {
        ArrayList<String> existList = new ArrayList<String>();
        ArrayList<String> existHereList = new ArrayList<String>();
        for (BpmWatermarkProcess item : watermarkProcesses) {
            BpmWatermarkProcess process = this.isExist(item.getProcDefKey());
            if (!BeanUtils.isNotEmpty((Object)((Object)process))) continue;
            if (!item.getWatermarkId().equals(process.getWatermarkId())) {
                existList.add(item.getProcDefName());
                continue;
            }
            existHereList.add(item.getProcDefName());
        }
        if (existHereList.size() == watermarkProcesses.size()) {
            return new CommonResult(false, "\u6b64\u6d41\u7a0b\u5df2\u5206\u914d");
        }
        if (existList.size() > 0) {
            return new CommonResult(true, "[" + String.join((CharSequence)",", existList) + "]\u5df2\u8bbe\u7f6e");
        }
        return new CommonResult(true, "\u8bbe\u7f6e\u6210\u529f");
    }

    private BpmWatermarkProcess isExist(String defKey) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"proc_def_key_", (Object)defKey);
        BpmWatermarkProcess process = (BpmWatermarkProcess)((Object)((BpmWatermarkProcessDao)this.baseMapper).selectOne((Wrapper)wrapper));
        return process;
    }
}

