/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.persistence.model;

import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.model.form.FormType;
import com.hotent.bpm.api.model.process.def.BpmDefExtProperties;
import com.hotent.bpm.api.model.process.def.BpmProcessDefExt;
import com.hotent.bpm.api.model.process.def.BpmVariableDef;
import com.hotent.bpm.api.model.process.def.BpmWordPrintDef;
import com.hotent.bpm.api.model.process.def.Restful;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.FormExt;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.ProcBoDef;
import com.hotent.bpm.api.plugin.core.context.BpmPluginContext;
import com.hotent.bpm.api.plugin.core.context.ProcessInstAopPluginContext;
import com.hotent.bpm.defxml.entity.ext.ExtDefinitions;
import com.hotent.bpm.defxml.entity.ext.ExtProcess;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DefaultBpmProcessDefExt
implements BpmProcessDefExt {
    private static final long serialVersionUID = 6488971924132239577L;
    transient ExtProcess extProcess = null;
    private transient ExtDefinitions definitions;
    private List<BpmPluginContext> pluginContextList = new ArrayList<BpmPluginContext>();
    private List<ProcessInstAopPluginContext> processInstAopPluginContexts = null;
    private List<BpmVariableDef> varList = null;
    private List<BpmWordPrintDef> wordPrintList = null;
    private Map<String, List<BpmVariableDef>> nodeVariables = null;
    private boolean boSaveToDb = true;
    private List<ProcBoDef> boDefList = null;
    private FormExt instForm = null;
    private FormExt instMobileForm = null;
    private FormExt globalForm = null;
    private FormExt globalMobileForm = null;
    private List<Restful> globalRestfulList = new ArrayList<Restful>();
    private List<Restful> globalAllRestfulList = new ArrayList<Restful>();
    private List<FormExt> allGlobalForm = new ArrayList<FormExt>();
    private List<FormExt> allInstForm = new ArrayList<FormExt>();
    private BpmDefExtProperties extPropertys = null;

    public DefaultBpmProcessDefExt() {
    }

    public DefaultBpmProcessDefExt(ExtDefinitions definitions) {
        this.definitions = definitions;
        this.extProcess = definitions.getExtProcess();
    }

    public ExtDefinitions getDefinitions() {
        return this.definitions;
    }

    public void setDefinitions(ExtDefinitions definitions) {
        this.definitions = definitions;
    }

    @Override
    public BpmDefExtProperties getExtProperties() {
        return this.extPropertys;
    }

    public void setExtProperties(BpmDefExtProperties extPropertys) {
        this.extPropertys = extPropertys;
    }

    @Override
    public List<BpmPluginContext> getBpmPluginContexts() {
        return this.pluginContextList;
    }

    @Override
    public BpmPluginContext getBpmPluginContext(Class<?> clazz) {
        List<BpmPluginContext> Plugins = this.getBpmPluginContexts();
        if (BeanUtils.isEmpty(Plugins)) {
            return null;
        }
        for (BpmPluginContext pulgin : Plugins) {
            if (!pulgin.getClass().isAssignableFrom(clazz)) continue;
            return pulgin;
        }
        return null;
    }

    @Override
    public List<BpmVariableDef> getVariableList() {
        return this.varList;
    }

    @Override
    public List<BpmWordPrintDef> getWordPrintList() {
        return this.wordPrintList;
    }

    public List<BpmVariableDef> getVariableList(String nodeId) {
        if (!this.nodeVariables.containsKey(nodeId)) {
            return Collections.emptyList();
        }
        return this.nodeVariables.get(nodeId);
    }

    @Override
    public List<ProcBoDef> getBoDefList() {
        if (BeanUtils.isEmpty(this.boDefList)) {
            return new ArrayList<ProcBoDef>();
        }
        return this.boDefList;
    }

    @Override
    public List<ProcessInstAopPluginContext> getProcessInstAopPluginContexts() {
        return this.processInstAopPluginContexts;
    }

    public FormExt getInstForm() {
        return this.getInstFormList("local_", false);
    }

    public FormExt getInstMobileForm() {
        return this.getInstFormList("local_", true);
    }

    public FormExt getGlobalFormByDefKey(String parentFlowKey, boolean isMobile) {
        return this.getGlobalFormList(parentFlowKey, isMobile);
    }

    public FormExt getInstFormByDefKey(String parentFlowKey, boolean isMobile) {
        return this.getInstFormList(parentFlowKey, isMobile);
    }

    public List<Restful> getGlobalRestfulByDefKey(String parentFlowKey) {
        return this.getGlobalRestfulList(parentFlowKey);
    }

    public FormExt getGlobalForm() {
        return this.getGlobalFormList("local_", false);
    }

    public FormExt getGlobalMobileForm() {
        return this.getGlobalFormList("local_", true);
    }

    public List<Restful> getGlobalRestful() {
        return this.getGlobalRestfulList("local_");
    }

    private FormExt getGlobalFormList(String parentFlowKey, boolean isMobile) {
        if (StringUtil.isEmpty((String)parentFlowKey)) {
            parentFlowKey = "local_";
        }
        FormType formType = isMobile ? FormType.MOBILE : FormType.PC;
        for (FormExt form : this.allGlobalForm) {
            if (!form.getParentFlowKey().equals(parentFlowKey) || !form.getFormType().equalsIgnoreCase(formType.toString())) continue;
            return form;
        }
        return null;
    }

    private FormExt getInstFormList(String parentFlowKey, boolean isMobile) {
        if (StringUtil.isEmpty((String)parentFlowKey)) {
            parentFlowKey = "local_";
        }
        FormType formType = isMobile ? FormType.MOBILE : FormType.PC;
        for (FormExt form : this.allInstForm) {
            if (!form.getParentFlowKey().equals(parentFlowKey) || !form.getFormType().equalsIgnoreCase(formType.toString())) continue;
            return form;
        }
        return null;
    }

    private List<Restful> getGlobalRestfulList(String parentFlowKey) {
        if (StringUtil.isEmpty((String)parentFlowKey)) {
            parentFlowKey = "local_";
        }
        ArrayList<Restful> restfuls = new ArrayList<Restful>();
        for (Restful restful : this.globalAllRestfulList) {
            if (!parentFlowKey.equals(restful.getParentDefKey())) continue;
            restfuls.add(restful);
        }
        return restfuls;
    }

    public boolean isBoSaveToDb() {
        return this.boSaveToDb;
    }

    public void setBoSaveToDb(boolean boSaveToDb) {
        this.boSaveToDb = boSaveToDb;
    }

    public ExtProcess getExtProcess() {
        return this.extProcess;
    }

    public void setExtProcess(ExtProcess extProcess) {
        this.extProcess = extProcess;
    }

    public List<BpmPluginContext> getPluginContextList() {
        return this.pluginContextList;
    }

    public void setPluginContextList(List<BpmPluginContext> pluginContextList) {
        this.pluginContextList = pluginContextList;
    }

    public List<BpmVariableDef> getVarList() {
        return this.varList;
    }

    public void setVarList(List<BpmVariableDef> varList) {
        this.varList = varList;
    }

    public void setWordPrintList(List<BpmWordPrintDef> wordPrintList) {
        this.wordPrintList = wordPrintList;
    }

    public List<FormExt> getAllGlobalForm() {
        return this.allGlobalForm;
    }

    public void setAllGlobalForm(List<FormExt> allGlobalForm) {
        this.allGlobalForm = allGlobalForm;
    }

    public List<Restful> getGlobalAllRestfulList() {
        return this.globalAllRestfulList;
    }

    public void setGlobalAllRestfulList(List<Restful> globalAllRestfulList) {
        this.globalAllRestfulList = globalAllRestfulList;
    }

    public List<FormExt> getAllInstForm() {
        return this.allInstForm;
    }

    public void setAllInstForm(List<FormExt> allInstForm) {
        this.allInstForm = allInstForm;
    }

    public BpmDefExtProperties getExtPropertys() {
        return this.extPropertys;
    }

    public void setExtPropertys(BpmDefExtProperties extPropertys) {
        this.extPropertys = extPropertys;
    }

    public void setProcessInstAopPluginContexts(List<ProcessInstAopPluginContext> processInstAopPluginContexts) {
        this.processInstAopPluginContexts = processInstAopPluginContexts;
    }

    public void setBoDefList(List<ProcBoDef> boDefList) {
        this.boDefList = boDefList;
    }

    public Map<String, List<BpmVariableDef>> getNodeVariables() {
        return this.nodeVariables;
    }

    public void setNodeVariables(Map<String, List<BpmVariableDef>> nodeVariables) {
        this.nodeVariables = nodeVariables;
    }
}

