/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.plugin.core.runtime;

import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.ContextThread;
import com.hotent.bpm.api.constant.ExtractType;
import com.hotent.bpm.api.helper.identity.BpmIdentityBuilder;
import com.hotent.bpm.api.helper.identity.BpmIdentityConverter;
import com.hotent.bpm.api.helper.identity.BpmIdentityExtractService;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.plugin.core.def.BpmPluginDef;
import com.hotent.bpm.api.plugin.core.runtime.BpmUserCalcPlugin;
import com.hotent.bpm.api.plugin.core.session.BpmUserCalcPluginSession;
import com.hotent.bpm.plugin.core.plugindef.AbstractUserCalcPluginDef;
import com.hotent.bpm.plugin.usercalc.cusers.def.CusersPluginDef;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

public class AbstractUserCalcPlugin
implements BpmUserCalcPlugin,
ContextThread {
    private static ThreadLocal<Boolean> isPreVrewModel = new ThreadLocal();
    private BpmIdentityConverter bpmIdentityConverter;
    private BpmIdentityBuilder bpmIdentityBuilder;
    private BpmIdentityExtractService extractService = (BpmIdentityExtractService)AppUtil.getBean(BpmIdentityExtractService.class);

    public static boolean isPreviewMode() {
        Boolean preVrewModel = isPreVrewModel.get();
        return preVrewModel != null && preVrewModel != false;
    }

    public static void cleanPreviewMode() {
        isPreVrewModel.remove();
    }

    public static void setPreviewMode(Boolean isPreview) {
        isPreVrewModel.set(isPreview);
    }

    protected BpmIdentityConverter getBpmIdentityConverter() {
        if (this.bpmIdentityConverter == null) {
            this.bpmIdentityConverter = (BpmIdentityConverter)AppUtil.getBean(BpmIdentityConverter.class);
        }
        return this.bpmIdentityConverter;
    }

    protected BpmIdentityBuilder getBpmIdentityBuilder() {
        if (this.bpmIdentityBuilder == null) {
            this.bpmIdentityBuilder = (BpmIdentityBuilder)AppUtil.getBean(BpmIdentityBuilder.class);
        }
        return this.bpmIdentityBuilder;
    }

    protected List<BpmIdentity> queryByPluginDef(BpmUserCalcPluginSession pluginSession, BpmPluginDef pluginDef) throws Exception {
        return null;
    }

    @Override
    public List<BpmIdentity> execute(BpmUserCalcPluginSession pluginSession, BpmPluginDef pluginDef) throws Exception {
        if (AbstractUserCalcPlugin.isPreviewMode() && !this.supportPreView()) {
            return Collections.emptyList();
        }
        List<BpmIdentity> list = this.queryByPluginDef(pluginSession, pluginDef);
        if (BeanUtils.isEmpty(list)) {
            return list;
        }
        if (pluginDef instanceof CusersPluginDef && "startSuper".equals(((CusersPluginDef)pluginDef).getSource()) && BeanUtils.isEmpty((Object)list.get(0).getId())) {
            return new ArrayList<BpmIdentity>();
        }
        ExtractType extractType = ((AbstractUserCalcPluginDef)pluginDef).getExtract();
        LinkedHashSet<BpmIdentity> set = new LinkedHashSet<BpmIdentity>();
        ArrayList<BpmIdentity> rtnList = new ArrayList<BpmIdentity>();
        list = this.extract(list, extractType);
        set.addAll(list);
        rtnList.addAll(set);
        return rtnList;
    }

    protected List<BpmIdentity> extract(List<BpmIdentity> bpmIdentities, ExtractType extractType) {
        if (BeanUtils.isEmpty(bpmIdentities)) {
            return Collections.EMPTY_LIST;
        }
        List<BpmIdentity> results = new ArrayList<BpmIdentity>();
        switch (extractType) {
            case EXACT_NOEXACT: {
                results = bpmIdentities;
                break;
            }
            case EXACT_EXACT_USER: {
                results = this.extractService.extractBpmIdentity(bpmIdentities);
                break;
            }
            case EXACT_GROUP_USER: {
                results = this.extractService.extractUserGroup(bpmIdentities);
                break;
            }
            case EXACT_EXACT_DELAY: {
                for (BpmIdentity identity : bpmIdentities) {
                    if (!"group".equals(identity.getType())) continue;
                    identity.setExtractType(ExtractType.EXACT_EXACT_DELAY);
                    results.add(identity);
                }
                break;
            }
        }
        return results;
    }

    public boolean supportPreView() {
        return true;
    }

    public void cleanAll() {
        AbstractUserCalcPlugin.cleanPreviewMode();
    }
}

