/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.plugin.core.util;

import com.hotent.base.util.AppUtil;
import com.hotent.bpm.api.constant.ExtractType;
import com.hotent.bpm.api.constant.LogicType;
import com.hotent.bpm.api.helper.identity.IConditionCheck;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.UserAssignRule;
import com.hotent.bpm.api.plugin.core.context.UserCalcPluginContext;
import com.hotent.bpm.api.plugin.core.def.BpmUserCalcPluginDef;
import com.hotent.bpm.api.plugin.core.factory.BpmPluginSessionFactory;
import com.hotent.bpm.api.plugin.core.runtime.BpmUserCalcPlugin;
import com.hotent.bpm.api.plugin.core.session.BpmUserCalcPluginSession;
import com.hotent.bpm.plugin.core.util.UserAssignRuleComparator;
import com.hotent.bpm.plugin.core.util.UserConverter;
import com.hotent.uc.api.model.IUser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class UserAssignRuleQueryHelper {
    public static List<BpmIdentity> query(List<UserAssignRule> userAssignRules, BpmUserCalcPluginSession pluginSession) throws Exception {
        Collections.sort(userAssignRules, new UserAssignRuleComparator());
        List<BpmIdentity> bpmIdentities = UserAssignRuleQueryHelper.calcByRule(userAssignRules, pluginSession, false);
        return bpmIdentities;
    }

    public static List<BpmIdentity> queryExtract(List<UserAssignRule> userAssignRules, BpmUserCalcPluginSession pluginSession) throws Exception {
        Collections.sort(userAssignRules, new UserAssignRuleComparator());
        List<BpmIdentity> bpmIdentities = UserAssignRuleQueryHelper.calcByRule(userAssignRules, pluginSession, true);
        return bpmIdentities;
    }

    public static List<IUser> queryUsersWithExtract(List<UserAssignRule> userAssignRules, Map<String, Object> variables) throws Exception {
        BpmPluginSessionFactory sessionFactory = (BpmPluginSessionFactory)AppUtil.getBean(BpmPluginSessionFactory.class);
        BpmUserCalcPluginSession bpmUserCalcPluginSession = sessionFactory.buildBpmUserCalcPluginSession(variables);
        List<BpmIdentity> pluginBpmIdentities = UserAssignRuleQueryHelper.queryExtract(userAssignRules, bpmUserCalcPluginSession);
        List<IUser> users = UserConverter.queryAndConvert(pluginBpmIdentities);
        return users;
    }

    private static List<BpmIdentity> calcByRule(List<UserAssignRule> ruleList, BpmUserCalcPluginSession pluginSession, boolean forceExtract) throws Exception {
        UserAssignRule userRule;
        int tmpGroupNo;
        ArrayList<BpmIdentity> bpmIdentities = new ArrayList<BpmIdentity>();
        int groupNo = -1;
        Iterator<UserAssignRule> iterator = ruleList.iterator();
        while (iterator.hasNext() && (groupNo == (tmpGroupNo = (userRule = iterator.next()).getGroupNo()) || bpmIdentities.size() <= 0)) {
            boolean isValid = UserAssignRuleQueryHelper.isRuleValid(userRule, pluginSession);
            if (!isValid) continue;
            groupNo = tmpGroupNo;
            List<UserCalcPluginContext> calcList = userRule.getCalcPluginContextList();
            int calcIndex = 0;
            for (UserCalcPluginContext context : calcList) {
                List biList;
                BpmUserCalcPlugin plugin = (BpmUserCalcPlugin)AppUtil.getBean(context.getPluginClass());
                BpmUserCalcPluginDef pluginDef = (BpmUserCalcPluginDef)context.getBpmPluginDef();
                if (forceExtract) {
                    pluginDef.setExtract(ExtractType.EXACT_EXACT_USER);
                }
                if ((biList = (List)plugin.execute(pluginSession, context.getBpmPluginDef())) == null) continue;
                if (calcIndex == 0) {
                    bpmIdentities.addAll(biList);
                } else {
                    UserAssignRuleQueryHelper.calc(bpmIdentities, biList, pluginDef.getLogicCal());
                }
                ++calcIndex;
            }
        }
        return bpmIdentities;
    }

    private static boolean isRuleValid(UserAssignRule rule, BpmUserCalcPluginSession pluginSession) {
        IConditionCheck conditionCheck = (IConditionCheck)AppUtil.getBean((String)"userConditionCheck");
        return conditionCheck.check(rule.getCondition(), rule.getConditionMode(), pluginSession);
    }

    private static void calc(List<BpmIdentity> existBpmIdentities, List<BpmIdentity> newBpmIdentities, LogicType logic) {
        switch (logic) {
            case OR: {
                LinkedHashSet<BpmIdentity> set = new LinkedHashSet<BpmIdentity>();
                set.addAll(existBpmIdentities);
                set.addAll(newBpmIdentities);
                existBpmIdentities.clear();
                existBpmIdentities.addAll(set);
                break;
            }
            case AND: {
                ArrayList<BpmIdentity> rtnList = new ArrayList<BpmIdentity>();
                for (BpmIdentity identity : existBpmIdentities) {
                    for (BpmIdentity tmp : newBpmIdentities) {
                        if (!identity.equals(tmp)) continue;
                        rtnList.add(identity);
                    }
                }
                existBpmIdentities.clear();
                existBpmIdentities.addAll(rtnList);
                break;
            }
            default: {
                for (BpmIdentity tmp : newBpmIdentities) {
                    existBpmIdentities.remove(tmp);
                }
            }
        }
    }
}

