/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.plugin.execution.message.plugin;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.groovy.GroovyScriptEngine;
import com.hotent.base.jms.JmsActor;
import com.hotent.base.jms.Notice;
import com.hotent.base.jms.NoticeMessageType;
import com.hotent.base.template.impl.FreeMarkerEngine;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.context.BpmContextUtil;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.model.delegate.BpmDelegateExecution;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.api.plugin.core.def.BpmExecutionPluginDef;
import com.hotent.bpm.api.plugin.core.factory.BpmPluginSessionFactory;
import com.hotent.bpm.api.plugin.core.session.BpmExecutionPluginSession;
import com.hotent.bpm.api.plugin.core.session.BpmUserCalcPluginSession;
import com.hotent.bpm.api.service.BoDataService;
import com.hotent.bpm.api.service.BpmInstService;
import com.hotent.bpm.plugin.core.runtime.AbstractBpmExecutionPlugin;
import com.hotent.bpm.plugin.core.util.UserAssignRuleQueryHelper;
import com.hotent.bpm.plugin.execution.message.context.IExternalData;
import com.hotent.bpm.plugin.execution.message.def.HtmlSetting;
import com.hotent.bpm.plugin.execution.message.def.MessagePluginDef;
import com.hotent.bpm.plugin.execution.message.def.PlainTextSetting;
import com.hotent.bpm.util.MessageUtil;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessagePlugin
extends AbstractBpmExecutionPlugin {
    private Log logger = LogFactory.getLog(GroovyScriptEngine.class);
    @Resource
    BpmPluginSessionFactory sessionFactory;
    @Resource
    BoDataService boDataService;
    @Resource
    BpmInstService bpmInstService;
    @Resource
    private FreeMarkerEngine FreeMarkerEngine;

    @Override
    public Void execute(BpmExecutionPluginSession pluginSession, BpmExecutionPluginDef pluginDef) throws Exception {
        List<BpmIdentity> notifyIdentities;
        List<IUser> receivers;
        BpmDelegateExecution delegateExecution = pluginSession.getBpmDelegateExecution();
        String nodeName = delegateExecution.getNodeName();
        Map<String, Object> vars = delegateExecution.getVariables();
        vars.put("nodeName", nodeName);
        BpmUserCalcPluginSession bpmUserCalcPluginSession = this.sessionFactory.buildBpmUserCalcPluginSession(vars);
        MessagePluginDef messageDef = (MessagePluginDef)pluginDef;
        this.handFlowVars(vars, delegateExecution);
        this.handData(messageDef, vars, delegateExecution);
        PlainTextSetting plainSetting = messageDef.getPlainTextSetting();
        HtmlSetting htmlSetting = messageDef.getHtmlSetting();
        if (plainSetting != null && StringUtil.isNotEmpty((String)plainSetting.getContent()) && BeanUtils.isNotEmpty(receivers = this.queryAndConvert(notifyIdentities = UserAssignRuleQueryHelper.queryExtract(plainSetting.getRuleList(), bpmUserCalcPluginSession), pluginSession.getOrgEngine().getUserService()))) {
            String content = plainSetting.getContent();
            content = this.parse(content, vars);
            String notifyType = plainSetting.getMsgType();
            this.send("\u670d\u52a1\u4efb\u52a1", content, receivers, notifyType, vars);
        }
        if (htmlSetting != null && StringUtil.isNotEmpty((String)htmlSetting.getSubject()) && StringUtil.isNotEmpty((String)htmlSetting.getContent()) && BeanUtils.isNotEmpty(receivers = this.queryAndConvert(notifyIdentities = UserAssignRuleQueryHelper.queryExtract(htmlSetting.getRuleList(), bpmUserCalcPluginSession), pluginSession.getOrgEngine().getUserService()))) {
            String subject = htmlSetting.getSubject();
            String content = htmlSetting.getContent();
            subject = this.parse(subject, vars);
            content = this.parse(content, vars);
            String notifyType = htmlSetting.getMsgType();
            this.send(subject, content, receivers, notifyType, vars);
        }
        return null;
    }

    private void send(String subject, String content, List<IUser> receivers, String notifyType, Map<String, Object> vars) throws Exception {
        if (StringUtil.isEmpty((String)notifyType)) {
            return;
        }
        IUser currentUser = ContextUtil.getCurrentUser();
        NoticeMessageType[] messageTypes = MessageUtil.parseNotifyType(notifyType);
        String[] recieverAccounts = MessageUtil.parseAccountOfUser(receivers);
        Notice notice = new Notice();
        notice.setMessageTypes(messageTypes);
        notice.setSender(currentUser.getAccount());
        List<JmsActor> receiver = MessageUtil.parseJmsActor(receivers);
        notice.setReceiver(receiver);
        notice.setReceivers(recieverAccounts);
        notice.setSubject(subject);
        notice.setVars(vars);
        notice.setContent(content);
        PortalFeignService PortalFeignService2 = (PortalFeignService)AppUtil.getBean(PortalFeignService.class);
        PortalFeignService2.sendNoticeToQueue(notice);
    }

    private void handData(MessagePluginDef messageDef, Map<String, Object> vars, BpmDelegateExecution execution) {
        String externalClass = messageDef.getExternalClass();
        if (StringUtil.isEmpty((String)externalClass)) {
            return;
        }
        String instId = (String)vars.get("instanceId_");
        String bpmnDefId = execution.getBpmnDefId();
        String bpmnInstId = execution.getBpmnInstId();
        String nodeId = execution.getNodeId();
        String executionId = execution.getId();
        try {
            Class<?> cls = Class.forName(externalClass);
            IExternalData data = (IExternalData)cls.newInstance();
            Map<String, Object> varMap = data.getData(bpmnDefId, bpmnInstId, instId, nodeId, executionId);
            vars.putAll(varMap);
        }
        catch (ClassNotFoundException e) {
            this.logger.debug((Object)e.getMessage());
        }
        catch (InstantiationException e) {
            this.logger.debug((Object)e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.logger.debug((Object)e.getMessage());
        }
    }

    private String parse(String template, Object obj) throws Exception {
        return this.FreeMarkerEngine.parseByTemplate(template, obj);
    }

    private List<IUser> queryAndConvert(List<BpmIdentity> bpmIdentities, IUserService userService) {
        ArrayList<IUser> userList = new ArrayList<IUser>();
        for (BpmIdentity bpmIdentity : bpmIdentities) {
            IUser user = userService.getUserById(bpmIdentity.getId());
            userList.add(user);
        }
        return userList;
    }

    private void handFlowVars(Map<String, Object> vars, BpmDelegateExecution execution) {
        try {
            Map<String, ObjectNode> boMap;
            BpmProcessInstance instance;
            ActionCmd taskCmd = ContextThreadUtil.getActionCmd();
            if (BeanUtils.isNotEmpty((Object)taskCmd) && BeanUtils.isNotEmpty((Object)(instance = (BpmProcessInstance)taskCmd.getTransitVars("processInstance")))) {
                IUser user;
                IUserService userService;
                String userId = instance.getCreateBy();
                if (BeanUtils.isNotEmpty((Object)userId) && BeanUtils.isNotEmpty((Object)(userService = (IUserService)AppUtil.getBean(IUserService.class))) && BeanUtils.isNotEmpty((Object)(user = userService.getUserById(userId)))) {
                    vars.put("startorName", user.getFullname());
                }
                vars.put("startDate", DateFormatUtil.format((LocalDateTime)instance.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                vars.put("businessKey", taskCmd.getBusinessKey());
                vars.put("flowName", instance.getProcDefName());
            }
            if (BeanUtils.isEmpty(boMap = BpmContextUtil.getBoFromContext())) {
                BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(vars.get("instanceId_").toString());
                List<ObjectNode> boDatas = this.boDataService.getDataByInst(bpmProcessInstance);
                BpmContextUtil.setBoToContext(boDatas);
                boMap = BpmContextUtil.getBoFromContext();
            }
            if (BeanUtils.isNotEmpty(boMap)) {
                boMap.forEach((boName, dataMap) -> {
                    Iterator iterator = dataMap.fields();
                    while (iterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        vars.put(boName + "_" + (String)entry.getKey(), entry.getValue());
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

