/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.plugin.task.tasknotify.helper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.RequiredException;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.jms.JmsActor;
import com.hotent.base.jms.Notice;
import com.hotent.base.jms.NoticeMessageType;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.ArrayUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.plugin.core.util.UserAssignRuleQueryHelper;
import com.hotent.bpm.plugin.task.tasknotify.def.model.NotifyItem;
import com.hotent.bpm.util.MessageUtil;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class NotifyHelper {
    @Resource
    UCFeignService ucFeignService;

    public void notify(NotifyItem notifyItem, String typeKey, Map<String, Object> vars) throws Exception {
        List<IUser> pluginUsers = UserAssignRuleQueryHelper.queryUsersWithExtract(notifyItem.getUserAssignRules(), vars);
        this.notify(pluginUsers, notifyItem.getMsgTypes(), typeKey, vars);
    }

    public void notify(List<IUser> receiverUsers, List<String> msgTypeKeys, String typeKey, Map<String, Object> vars) throws Exception {
        String[] receiverAccounts;
        if (BeanUtils.isEmpty(receiverUsers)) {
            return;
        }
        IUser sender = ContextUtil.getCurrentUser();
        NoticeMessageType[] messageTypes = MessageUtil.parseNotifyType(msgTypeKeys);
        String[] receivers = MessageUtil.parseAccountOfUser(receiverUsers);
        Notice notice = new Notice();
        notice.setUseTemplate(true);
        notice.setMessageTypes(messageTypes);
        notice.setSender(sender.getAccount());
        notice.setTemplateType(typeKey);
        notice.setVars(vars);
        ArrayList<JsonNode> receiveUsers = new ArrayList<JsonNode>();
        for (String account : receiverAccounts = ArrayUtil.unique((String[])receivers)) {
            CommonResult userById;
            JsonNode receiver = this.ucFeignService.loadUserByUsername(account);
            if (BeanUtils.isEmpty((Object)receiver) && (userById = this.ucFeignService.getUserById(account)).getState().booleanValue()) {
                receiver = (JsonNode)userById.getValue();
            }
            if (!BeanUtils.isNotEmpty((Object)receiver)) continue;
            receiveUsers.add(receiver);
        }
        if (receiveUsers.size() == 0) {
            throw new RequiredException("The accounts of 'receivers' in 'Notice' can not find the match user, so we did not send the message.");
        }
        ArrayList<JmsActor> receives = new ArrayList<JmsActor>();
        for (JsonNode user : receiveUsers) {
            receives.add(this.convertUserObject2JmsActor(user));
        }
        notice.setReceiver(receives);
        PortalFeignService PortalFeignService2 = (PortalFeignService)AppUtil.getBean(PortalFeignService.class);
        PortalFeignService2.sendNoticeToQueue(notice);
    }

    public JmsActor convertUserObject2JmsActor(JsonNode jsonNode) {
        if (BeanUtils.isEmpty((Object)jsonNode) || !jsonNode.isObject()) {
            return null;
        }
        ObjectNode userNode = (ObjectNode)jsonNode;
        String userId = JsonUtil.getString((JsonNode)userNode, (String)"id");
        if (StringUtil.isEmpty((String)userId)) {
            userId = JsonUtil.getString((JsonNode)userNode, (String)"userId");
        }
        String account = JsonUtil.getString((JsonNode)userNode, (String)"account");
        String fullname = JsonUtil.getString((JsonNode)userNode, (String)"fullname");
        String email = JsonUtil.getString((JsonNode)userNode, (String)"email");
        String mobile = JsonUtil.getString((JsonNode)userNode, (String)"mobile");
        String weixin = JsonUtil.getString((JsonNode)userNode, (String)"weixin");
        String clientId = JsonUtil.getString((JsonNode)userNode, (String)"clientId");
        String clientToken = JsonUtil.getString((JsonNode)userNode, (String)"clientToken");
        return new JmsActor(userId, account, fullname, email, mobile, weixin, clientId, clientToken);
    }
}

