/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.plugin.usercalc.customQuery.runtime;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.feign.FormFeignService;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.groovy.GroovyScriptEngine;
import com.hotent.base.model.HtJsonNodeFactory;
import com.hotent.base.query.PageList;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.context.BpmContextUtil;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.api.plugin.core.def.BpmPluginDef;
import com.hotent.bpm.api.plugin.core.session.BpmUserCalcPluginSession;
import com.hotent.bpm.api.service.BoDataService;
import com.hotent.bpm.api.service.BpmInstService;
import com.hotent.bpm.model.identity.DefaultBpmIdentity;
import com.hotent.bpm.plugin.core.runtime.AbstractUserCalcPlugin;
import com.hotent.bpm.plugin.usercalc.customQuery.def.CustomQueryPluginDef;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomQueryPlugin
extends AbstractUserCalcPlugin {
    Logger logger = LoggerFactory.getLogger(CustomQueryPlugin.class);
    @Resource
    FormFeignService formFeignService;
    @Resource
    UCFeignService ucFeignService;
    @Resource
    BoDataService boDataService;
    @Resource
    BpmInstService bpmInstService;

    @Override
    public List<BpmIdentity> queryByPluginDef(BpmUserCalcPluginSession pluginSession, BpmPluginDef pluginDef) {
        ArrayList<BpmIdentity> identityList = new ArrayList<BpmIdentity>();
        CustomQueryPluginDef def = (CustomQueryPluginDef)pluginDef;
        String alias = def.getAlias();
        String valueField = def.getValueField();
        String params = def.getParams();
        if (StringUtil.isEmpty((String)alias) || StringUtil.isEmpty((String)valueField)) {
            return identityList;
        }
        try {
            Object obj;
            if (params.startsWith("\"")) {
                params = params.replace("\"[", "[");
                params = params.replace("]\"", "]");
                params = params.replace("\\\"", "\"");
            }
            if (params.contains("+\\")) {
                params = params.replace("\\\"", "\"");
            }
            String queryData = "";
            if (StringUtil.isNotEmpty((String)params)) {
                Object entry;
                Map<String, ObjectNode> boMap;
                GroovyScriptEngine groovyScriptEngine = new GroovyScriptEngine();
                HashMap<String, Object> varMap = new HashMap<String, Object>();
                ActionCmd cmd = ContextThreadUtil.getActionCmd();
                if (BeanUtils.isNotEmpty((Object)cmd)) {
                    varMap.putAll(cmd.getVariables());
                }
                if (BeanUtils.isEmpty(boMap = BpmContextUtil.getBoFromContext())) {
                    BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(varMap.get("instanceId_").toString());
                    List<ObjectNode> boDatas = this.boDataService.getDataByInst(bpmProcessInstance);
                    BpmContextUtil.setBoToContext(boDatas);
                    boMap = BpmContextUtil.getBoFromContext();
                }
                if (BeanUtils.isNotEmpty(boMap)) {
                    for (Map.Entry<String, ObjectNode> ent : boMap.entrySet()) {
                        varMap.put(ent.getKey(), HtJsonNodeFactory.build().htObjectNode(ent.getValue()));
                    }
                } else if (BeanUtils.isNotEmpty((Object)cmd) && BeanUtils.isNotEmpty((Object)cmd.getBusData())) {
                    try {
                        JsonNode dataNode = JsonUtil.toJsonNode((String)cmd.getBusData());
                        Iterator it = dataNode.fields();
                        while (it.hasNext()) {
                            entry = (Map.Entry)it.next();
                            varMap.put((String)entry.getKey(), HtJsonNodeFactory.build().htObjectNode((ObjectNode)entry.getValue()));
                        }
                    }
                    catch (Exception e) {
                        System.out.println("\u89e3\u6790\u6d41\u7a0b\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage());
                    }
                }
                ArrayNode array = JsonUtil.getMapper().createArrayNode();
                ArrayNode paramArray = (ArrayNode)JsonUtil.toJsonNode((String)params);
                entry = paramArray.iterator();
                while (entry.hasNext()) {
                    JsonNode jsonNode = (JsonNode)entry.next();
                    if (!BeanUtils.isNotEmpty((Object)jsonNode.get("value")) || !BeanUtils.isNotEmpty((Object)jsonNode.get("field")) || !StringUtil.isNotEmpty((String)jsonNode.get("value").asText())) continue;
                    ObjectNode node = JsonUtil.getMapper().createObjectNode();
                    node.put("key", jsonNode.get("field").asText());
                    String value = jsonNode.get("value").asText();
                    if ("0".equals(jsonNode.get("valueType").asText())) {
                        value = groovyScriptEngine.executeString(value, varMap);
                    }
                    node.put("value", value);
                    array.add((JsonNode)node);
                }
                if (BeanUtils.isNotEmpty((Object)array) && array.size() > 0) {
                    queryData = JsonUtil.toJson((Object)array);
                }
            }
            if ((obj = this.formFeignService.doCustomQuery(alias, Integer.valueOf(1), queryData)) != null) {
                ArrayNode users;
                String accounts = "";
                PageList pageList = this.getPageList(obj);
                if (pageList != null) {
                    PageList page = pageList;
                    if (BeanUtils.isNotEmpty((Object)page) && BeanUtils.isNotEmpty((Object)page.getRows())) {
                        List results = page.getRows();
                        for (Object object : results) {
                            JsonNode node = JsonUtil.toJsonNode(object);
                            accounts = this.appendAccountReturns(node.get(valueField), accounts);
                        }
                    }
                } else {
                    JsonNode nodeResult = JsonUtil.toJsonNode((Object)obj);
                    if (nodeResult != null) {
                        if (nodeResult instanceof ArrayNode) {
                            for (JsonNode node : nodeResult) {
                                accounts = this.appendAccountReturns(node.get(valueField), accounts);
                            }
                        } else {
                            accounts = this.appendAccountReturns(nodeResult.get(valueField), accounts);
                        }
                    }
                }
                if (StringUtil.isNotEmpty((String)accounts) && BeanUtils.isNotEmpty((Object)(users = this.ucFeignService.getUserByAccounts(accounts)))) {
                    for (JsonNode userNode : users) {
                        DefaultBpmIdentity identity = new DefaultBpmIdentity(userNode.get("id").asText(), userNode.get("fullname").asText(), "user");
                        identityList.add(identity);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u5173\u8054\u67e5\u8be2\u83b7\u53d6\u5ba1\u6279\u4eba\u5931\u8d25", (Throwable)e);
        }
        return identityList;
    }

    private PageList getPageList(Object object) {
        if (object instanceof PageList) {
            return (PageList)object;
        }
        if (object instanceof Map) {
            try {
                String json = JsonUtil.toJson((Object)object);
                return (PageList)JsonUtil.toBean((String)json, PageList.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private String appendAccountReturns(JsonNode nodeValueField, String accounts) {
        if (nodeValueField == null || StringUtil.isEmpty((String)nodeValueField.asText())) {
            return accounts;
        }
        if (StringUtil.isNotEmpty((String)accounts)) {
            accounts = accounts + ",";
        }
        accounts = accounts + nodeValueField.asText();
        return accounts;
    }
}

