/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.plugin.usercalc.hrScript.runtime;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.groovy.GroovyScriptEngine;
import com.hotent.base.model.HtJsonNodeFactory;
import com.hotent.base.model.HtObjectNode;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.context.BpmContextUtil;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.api.plugin.core.def.BpmPluginDef;
import com.hotent.bpm.api.plugin.core.session.BpmUserCalcPluginSession;
import com.hotent.bpm.api.service.BoDataService;
import com.hotent.bpm.api.service.BpmInstService;
import com.hotent.bpm.engine.task.cmd.DefaultTaskFinishCmd;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.plugin.core.runtime.AbstractUserCalcPlugin;
import com.hotent.bpm.plugin.usercalc.hrScript.def.HrScriptPluginDef;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HrScriptPlugin
extends AbstractUserCalcPlugin {
    private static final Logger logger = LoggerFactory.getLogger(HrScriptPlugin.class);
    @Resource
    GroovyScriptEngine groovyScriptEngine;
    @Resource
    BoDataService boDataService;
    @Resource
    BpmInstService bpmInstService;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;

    @Override
    public List<BpmIdentity> queryByPluginDef(BpmUserCalcPluginSession pluginSession, BpmPluginDef pluginDef) throws Exception {
        HrScriptPluginDef def = (HrScriptPluginDef)pluginDef;
        String script = def.getScript();
        if (StringUtil.isEmpty((String)script)) {
            return Collections.EMPTY_LIST;
        }
        Map<String, Object> variables = pluginSession.getVariables();
        Map<String, ObjectNode> boMap = BpmContextUtil.getBoFromContext();
        ActionCmd actionCmd = ContextThreadUtil.getActionCmd();
        if (BeanUtils.isEmpty((Object)actionCmd)) {
            DefaultTaskFinishCmd taskCmd = new DefaultTaskFinishCmd();
            taskCmd.setVariables(variables);
            ContextThreadUtil.setActionCmd(taskCmd);
        }
        if (boMap.isEmpty() && variables.containsKey("instanceId_")) {
            String instanceId = (String)variables.get("instanceId_");
            DefaultBpmProcessInstance bpmProcessInstance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instanceId));
            List<ObjectNode> boDatas = this.boDataService.getDataByInst(bpmProcessInstance);
            boMap = new HashMap<String, ObjectNode>();
            for (ObjectNode data : boDatas) {
                String code = "";
                code = data.hasNonNull("boDefAlias") ? data.get("boDefAlias").asText() : data.get("boDef").get("alias").asText();
                boMap.put(code, data.has("data") ? (ObjectNode)data.get("data") : data);
            }
        }
        if (BeanUtils.isEmpty(boMap)) {
            BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(variables.get("instanceId_").toString());
            List<ObjectNode> boDatas = this.boDataService.getDataByInst(bpmProcessInstance);
            BpmContextUtil.setBoToContext(boDatas);
            boMap = BpmContextUtil.getBoFromContext();
        }
        if (BeanUtils.isNotEmpty(boMap)) {
            HashMap<String, HtObjectNode> newMap = new HashMap<String, HtObjectNode>();
            for (Map.Entry<String, ObjectNode> next : boMap.entrySet()) {
                newMap.put(next.getKey(), HtJsonNodeFactory.build().htObjectNode(next.getValue()));
            }
            variables.putAll(newMap);
        }
        ArrayList<BpmIdentity> list = new ArrayList<BpmIdentity>();
        try {
            Set set = (Set)this.groovyScriptEngine.executeObject(script, variables);
            list.addAll(set);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return list;
    }

    @Override
    public boolean supportPreView() {
        return false;
    }
}

