/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.service.impl;

import com.hotent.base.util.AppUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.bpm.service.TodoMsgPushService;
import com.hotent.bpm.service.impl.FlowMessageServiceImpl;
import com.hotent.sdk.feign.properties.EipSdkProperty;
import com.hotent.sdk.feign.service.EipTodoSdkService;
import com.hotent.vo.CopyDoneVo;
import com.hotent.vo.CopyVo;
import com.hotent.vo.DeleteTaskVo;
import com.hotent.vo.FlowInstanceVo;
import com.hotent.vo.LockOrUnLockVo;
import com.hotent.vo.TaskDoneVo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;

@Service
public class TodoMsgPushServiceImpl
implements TodoMsgPushService {
    private static final Log logger = LogFactory.getLog(FlowMessageServiceImpl.class);

    @Override
    public void handlerFlowJmsMessage(String msgStr, String type, String tenantCode) {
        EipTodoSdkService eipTodoSdkService = this.getEipTodoSdkService(tenantCode);
        switch (type) {
            case "lockOrUnLock": {
                try {
                    eipTodoSdkService.lockOrUnLockTask((LockOrUnLockVo)JsonUtil.toBean((String)msgStr, LockOrUnLockVo.class));
                }
                catch (Exception e) {
                    logger.error((Object)"\u4efb\u52a1\u9501\u5b9a\u5931\u8d25{}", (Throwable)e);
                }
                break;
            }
            case "inst_new": {
                try {
                    eipTodoSdkService.startFlow((FlowInstanceVo)JsonUtil.toBean((String)msgStr, FlowInstanceVo.class));
                }
                catch (Exception e) {
                    logger.error((Object)"\u53d1\u8d77\u6d41\u7a0b\u5931\u8d25{}", (Throwable)e);
                }
                break;
            }
            case "inst_update": 
            case "task_create": {
                try {
                    eipTodoSdkService.updateFlow((FlowInstanceVo)JsonUtil.toBean((String)msgStr, FlowInstanceVo.class));
                }
                catch (Exception e) {
                    logger.error((Object)"\u6d41\u7a0b\u66f4\u65b0\u5931\u8d25{}", (Throwable)e);
                }
                break;
            }
            case "task_remove": {
                try {
                    eipTodoSdkService.deleteTask((DeleteTaskVo)JsonUtil.toBean((String)msgStr, DeleteTaskVo.class));
                }
                catch (Exception e) {
                    logger.error((Object)"\u4efb\u52a1\u5220\u9664\u5931\u8d25{}", (Throwable)e);
                }
                break;
            }
            case "task_2_done": {
                try {
                    eipTodoSdkService.taskToDone((TaskDoneVo)JsonUtil.toBean((String)msgStr, TaskDoneVo.class));
                }
                catch (Exception e) {
                    logger.error((Object)"\u5f85\u529e\u8f6c\u5df2\u529e\u5931\u8d25{}", (Throwable)e);
                }
                break;
            }
            case "copy_new": {
                try {
                    eipTodoSdkService.addCopy((CopyVo)JsonUtil.toBean((String)msgStr, CopyVo.class));
                }
                catch (Exception e) {
                    logger.error((Object)"\u65b0\u589e\u6284\u9001\u5931\u8d25{}", (Throwable)e);
                }
                break;
            }
            case "copy_handle": {
                try {
                    eipTodoSdkService.doneCopy((CopyDoneVo)JsonUtil.toBean((String)msgStr, CopyDoneVo.class));
                    break;
                }
                catch (Exception e) {
                    logger.error((Object)"\u5904\u7406\u6284\u9001\u5931\u8d25{}", (Throwable)e);
                }
            }
        }
    }

    private EipTodoSdkService getEipTodoSdkService(String tenantCode) {
        EipSdkProperty bean = (EipSdkProperty)AppUtil.getBean(EipSdkProperty.class);
        EipSdkProperty olde = null;
        try {
            olde = (EipSdkProperty)JsonUtil.toBean((String)JsonUtil.toJson((Object)bean), EipSdkProperty.class);
        }
        catch (Exception e) {
            olde = bean;
        }
        EipTodoSdkService eipTodoSdkService = new EipTodoSdkService(olde);
        return eipTodoSdkService;
    }
}

