/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.todo.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.hotent.base.conf.TodoConfig;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.constant.OpinionStatus;
import com.hotent.bpm.api.constant.ProcessInstanceStatus;
import com.hotent.bpm.api.constant.TaskType;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.helper.identity.BpmIdentityExtractService;
import com.hotent.bpm.api.model.delegate.BpmDelegateTask;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.model.process.task.BpmTask;
import com.hotent.bpm.helper.identity.DefaultBpmIdentityConverter;
import com.hotent.bpm.model.identity.DefaultBpmIdentity;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.manager.BpmTaskNoticeManager;
import com.hotent.bpm.persistence.model.BpmTaskNotice;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import com.hotent.bpm.service.ITaskTransService;
import com.hotent.bpm.service.PortalMsgPushService;
import com.hotent.bpm.todo.vo.HandledTask;
import com.hotent.bpm.todo.vo.PendingTask;
import com.hotent.bpm.todo.vo.PortalTaskVo;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TodoPushUtil {
    public static void startFlow(DefaultBpmProcessInstance instance) {
        TodoConfig todoConfig = (TodoConfig)AppUtil.getBean(TodoConfig.class);
        if (!todoConfig.getEnabled()) {
            return;
        }
        PortalMsgPushService portalMsgPushService = (PortalMsgPushService)AppUtil.getBean(PortalMsgPushService.class);
        portalMsgPushService.startFlow(instance);
    }

    public static void updateProcessStatus(DefaultBpmProcessInstance instance) {
        TodoConfig todoConfig = (TodoConfig)AppUtil.getBean(TodoConfig.class);
        if (!todoConfig.getEnabled()) {
            return;
        }
        PortalMsgPushService portalMsgPushService = (PortalMsgPushService)AppUtil.getBean(PortalMsgPushService.class);
        portalMsgPushService.updateProcessStatus(instance);
    }

    public static void copyTo(PendingTask task) {
        TodoConfig todoConfig = (TodoConfig)AppUtil.getBean(TodoConfig.class);
        if (!todoConfig.getEnabled()) {
            return;
        }
        PortalMsgPushService portalMsgPushService = (PortalMsgPushService)AppUtil.getBean(PortalMsgPushService.class);
        portalMsgPushService.copyTo(task);
    }

    public static void follow(PendingTask task) {
        TodoConfig todoConfig = (TodoConfig)AppUtil.getBean(TodoConfig.class);
        if (!todoConfig.getEnabled()) {
            return;
        }
        PortalMsgPushService portalMsgPushService = (PortalMsgPushService)AppUtil.getBean(PortalMsgPushService.class);
        portalMsgPushService.follow(task);
    }

    public static void delTodo(String instId, List<String> taskIdList, int type, List<String> ownerList, String fromSysKey, PortalTaskVo portalTaskVo) {
        TodoConfig todoConfig = (TodoConfig)AppUtil.getBean(TodoConfig.class);
        if (!todoConfig.getEnabled()) {
            return;
        }
        PortalMsgPushService portalMsgPushService = (PortalMsgPushService)AppUtil.getBean(PortalMsgPushService.class);
        portalMsgPushService.delTodo(instId, taskIdList, type, ownerList, fromSysKey, portalTaskVo);
    }

    public static void handTodoInstanceRemove(List<String> idList, String fromSysKey, PortalTaskVo portalTaskVo) {
        TodoConfig todoConfig = (TodoConfig)AppUtil.getBean(TodoConfig.class);
        if (!todoConfig.getEnabled()) {
            return;
        }
        if (BeanUtils.isNotEmpty(idList)) {
            for (String instId : idList) {
                TodoPushUtil.handTodoInstanceRemove(instId, fromSysKey, portalTaskVo);
            }
        }
    }

    public static void handTodoInstanceRemove(String instId, String fromSysKey, PortalTaskVo portalTaskVo) {
        TodoConfig todoConfig = (TodoConfig)AppUtil.getBean(TodoConfig.class);
        if (!todoConfig.getEnabled()) {
            return;
        }
        PortalMsgPushService portalMsgPushService = (PortalMsgPushService)AppUtil.getBean(PortalMsgPushService.class);
        BpmProcessInstanceManager bpmProcessInstanceManager = (BpmProcessInstanceManager)AppUtil.getBean(BpmProcessInstanceManager.class);
        DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)bpmProcessInstanceManager.get((Serializable)((Object)instId));
        instance.setStatus(ProcessInstanceStatus.STATUS_DELETE.getKey());
        portalMsgPushService.updateProcessStatus(instance);
        TodoPushUtil.handTodoInstanceRevoke(instId, fromSysKey, portalTaskVo);
    }

    public static void handTodoInstanceRevoke(String instId, String fromSysKey, PortalTaskVo portalTaskVo) {
        TodoConfig todoConfig = (TodoConfig)AppUtil.getBean(TodoConfig.class);
        if (!todoConfig.getEnabled()) {
            return;
        }
        TodoPushUtil.toDelPortalTasks(instId, fromSysKey, portalTaskVo);
        ITaskTransService taskTransService = (ITaskTransService)AppUtil.getBean(ITaskTransService.class);
        taskTransService.toPushDeleteByInstId(instId, fromSysKey, null);
        PortalMsgPushService portalMsgPushService = (PortalMsgPushService)AppUtil.getBean(PortalMsgPushService.class);
        BpmTaskNoticeManager bpmTaskNoticeManager = (BpmTaskNoticeManager)AppUtil.getBean(BpmTaskNoticeManager.class);
        List<BpmTaskNotice> notices = bpmTaskNoticeManager.getBpmTaskNoticeByInstId(instId);
        if (BeanUtils.isNotEmpty(notices)) {
            ArrayList<String> taskIdList = new ArrayList<String>();
            ArrayList<String> ownerList = new ArrayList<String>();
            for (BpmTaskNotice bpmTaskNotice : notices) {
                taskIdList.add(bpmTaskNotice.getId());
                ownerList.add(bpmTaskNotice.getOwnerId());
            }
            if (BeanUtils.isNotEmpty(taskIdList)) {
                portalMsgPushService.delTodo(instId, taskIdList, 3, ownerList, fromSysKey, portalTaskVo);
            }
        }
    }

    public static void handTodoInstanceRecover(String instId, String fromSysKey, PortalTaskVo portalTaskVo) {
        TodoConfig todoConfig = (TodoConfig)AppUtil.getBean(TodoConfig.class);
        if (!todoConfig.getEnabled()) {
            return;
        }
        TodoPushUtil.toRecoverPortalTasks(instId, fromSysKey, portalTaskVo);
        BpmTaskNoticeManager bpmTaskNoticeManager = (BpmTaskNoticeManager)AppUtil.getBean(BpmTaskNoticeManager.class);
        List<BpmTaskNotice> notices = bpmTaskNoticeManager.getBpmTaskNoticeByInstId(instId);
        if (BeanUtils.isNotEmpty(notices)) {
            for (BpmTaskNotice notice : notices) {
                TodoPushUtil.addCopyToToPortal(notice);
            }
        }
    }

    public static void handTodoInstanceRemove(List<String> idList, String fromSysKey) {
        TodoConfig todoConfig = (TodoConfig)AppUtil.getBean(TodoConfig.class);
        if (!todoConfig.getEnabled()) {
            return;
        }
        if (BeanUtils.isNotEmpty(idList)) {
            for (String instId : idList) {
                TodoPushUtil.handTodoInstanceRemove(instId, fromSysKey);
            }
        }
    }

    public static void handTodoInstanceRemove(String instId, String fromSysKey) {
        TodoConfig todoConfig = (TodoConfig)AppUtil.getBean(TodoConfig.class);
        if (!todoConfig.getEnabled()) {
            return;
        }
        PortalMsgPushService portalMsgPushService = (PortalMsgPushService)AppUtil.getBean(PortalMsgPushService.class);
        BpmProcessInstanceManager bpmProcessInstanceManager = (BpmProcessInstanceManager)AppUtil.getBean(BpmProcessInstanceManager.class);
        DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)bpmProcessInstanceManager.get((Serializable)((Object)instId));
        instance.setStatus(ProcessInstanceStatus.STATUS_DELETE.getKey());
        portalMsgPushService.updateProcessStatus(instance);
        PortalTaskVo portalTaskVo = new PortalTaskVo();
        portalTaskVo.setInstId(instance.getId());
        portalTaskVo.setFlowType(instance.getProcDefKey());
        portalTaskVo.setFlowTypeName(instance.getProcDefName());
        TodoPushUtil.handTodoInstanceRevoke(instId, fromSysKey, portalTaskVo);
    }

    private static List<DefaultBpmIdentity> getIdentityList(List<BpmIdentity> identitys) {
        ArrayList<DefaultBpmIdentity> nidentityList = new ArrayList<DefaultBpmIdentity>();
        if (identitys != null && identitys.size() > 0) {
            BpmIdentityExtractService bpmIdentityExtractService = (BpmIdentityExtractService)AppUtil.getBean(BpmIdentityExtractService.class);
            DefaultBpmIdentityConverter defaultBpmIdentityConverter = (DefaultBpmIdentityConverter)AppUtil.getBean(DefaultBpmIdentityConverter.class);
            List<IUser> userList = bpmIdentityExtractService.extractUser(identitys);
            List<BpmIdentity> identityList = defaultBpmIdentityConverter.convertUserList(userList);
            identityList.forEach(t -> nidentityList.add(new DefaultBpmIdentity(t.getId(), t.getName(), t.getType())));
        }
        return nidentityList;
    }

    public static void addTodoToPortal(BpmDelegateTask delegateTask, String instId, String subject) {
        TodoConfig todoConfig = (TodoConfig)AppUtil.getBean(TodoConfig.class);
        if (!todoConfig.getEnabled()) {
            return;
        }
        PortalMsgPushService portalMsgPushService = (PortalMsgPushService)AppUtil.getBean(PortalMsgPushService.class);
        BpmTaskManager bpmTaskManager = (BpmTaskManager)AppUtil.getBean(BpmTaskManager.class);
        DefaultBpmTask bpmTask = bpmTaskManager.getByRelateTaskId(delegateTask.getId());
        PortalTaskVo portalTaskVo = new PortalTaskVo();
        portalTaskVo.setInstId(instId);
        portalTaskVo.setNodeName(delegateTask.getName());
        portalTaskVo.setTaskApproveId(delegateTask.getAssignee());
        List<BpmIdentity> identitys = delegateTask.getExecutors();
        Object BPM_TASK = ContextThreadUtil.getActionCmd().getTransitVars("bpmTask_");
        if (BPM_TASK != null) {
            DefaultBpmTask defaultBpmTask = (DefaultBpmTask)BPM_TASK;
            identitys = defaultBpmTask.getIdentityList();
        }
        if (identitys != null && identitys.size() > 0) {
            List<DefaultBpmIdentity> identityList = TodoPushUtil.getIdentityList(identitys);
            portalTaskVo.setIdentityList(identityList);
        }
        portalTaskVo.setTaskArriveDate(delegateTask.getCreateTime());
        portalTaskVo.setTaskId(delegateTask.getId());
        portalTaskVo.setTodoType("task");
        portalTaskVo.setStatus(BeanUtils.isEmpty((Object)bpmTask) ? "NORMAL" : bpmTask.getStatus());
        String pre = TodoPushUtil.getSubjectPre("task", portalTaskVo.getStatus());
        portalTaskVo.setSubject(pre + subject);
        portalTaskVo.setDefName(BeanUtils.isEmpty((Object)bpmTask) ? "" : bpmTask.getProcDefName());
        portalMsgPushService.addTodo(portalTaskVo);
    }

    public static void addTodoToPortal(BpmTask task) {
        TodoConfig todoConfig = (TodoConfig)AppUtil.getBean(TodoConfig.class);
        if (!todoConfig.getEnabled()) {
            return;
        }
        TodoPushUtil.addTodoToPortal(task, null);
    }

    public static void addTodoToPortal(BpmTask task, String subjectPrefix) {
        TodoConfig todoConfig = (TodoConfig)AppUtil.getBean(TodoConfig.class);
        if (!todoConfig.getEnabled()) {
            return;
        }
        PortalMsgPushService portalMsgPushService = (PortalMsgPushService)AppUtil.getBean(PortalMsgPushService.class);
        PortalTaskVo portalTaskVo = new PortalTaskVo();
        portalTaskVo.setInstId(task.getProcInstId());
        portalTaskVo.setNodeName(task.getName());
        if (!StringUtil.isZeroEmpty((String)task.getAssigneeId()) && (TaskType.ADDSIGN.getKey().equals(task.getStatus()) || StringUtil.isEmpty((String)task.getOwnerId()) || "0".equals(task.getOwnerId()))) {
            portalTaskVo.setTaskApproveId(task.getAssigneeId());
        } else if (!StringUtil.isZeroEmpty((String)task.getAssigneeId()) && StringUtil.isNotEmpty((String)task.getOwnerId()) && StringUtil.isNotEmpty((String)task.getAssigneeId()) && !task.getOwnerId().equals(task.getAssigneeId())) {
            portalTaskVo.setTaskApproveId(task.getAssigneeId());
            portalTaskVo.setTaskApproveName(task.getAssigneeName());
            UCFeignService ucFeignService = (UCFeignService)AppUtil.getBean(UCFeignService.class);
            CommonResult userById = ucFeignService.getUserById(task.getAssigneeId());
            if (userById.getState().booleanValue() && BeanUtils.isNotEmpty((Object)userById.getValue())) {
                portalTaskVo.setTaskApproveAccount(JsonUtil.getString((JsonNode)((JsonNode)userById.getValue()), (String)"account", (String)""));
            }
        } else {
            portalTaskVo.setTaskApproveId(task.getOwnerId());
            portalTaskVo.setTaskApproveName(task.getOwnerName());
            portalTaskVo.setTaskApproveAccount(task.getOwnerAccount());
        }
        List<BpmIdentity> identitys = task.getIdentityList();
        if (identitys != null && identitys.size() > 0) {
            List<DefaultBpmIdentity> identityList = TodoPushUtil.getIdentityList(identitys);
            portalTaskVo.setIdentityList(identityList);
        }
        portalTaskVo.setTaskArriveDate(task.getCreateTime());
        portalTaskVo.setTaskId(task.getId());
        portalTaskVo.setStatus(task.getStatus());
        portalTaskVo.setTodoType("task");
        String pre = TodoPushUtil.getSubjectPre("task", task.getStatus());
        if (StringUtil.isNotEmpty((String)subjectPrefix)) {
            pre = subjectPrefix + pre;
        }
        portalTaskVo.setSubject(pre + task.getSubject());
        portalTaskVo.setDefName(task.getProcDefName());
        portalMsgPushService.addTodo(portalTaskVo);
    }

    public static void addCopyToToPortal(BpmTaskNotice notice) {
        TodoConfig todoConfig = (TodoConfig)AppUtil.getBean(TodoConfig.class);
        if (!todoConfig.getEnabled()) {
            return;
        }
        PortalMsgPushService portalMsgPushService = (PortalMsgPushService)AppUtil.getBean(PortalMsgPushService.class);
        PendingTask pendingTask = new PendingTask();
        pendingTask.setId(notice.getId());
        pendingTask.setProcInstId(notice.getProcInstId());
        pendingTask.setName(notice.getName());
        pendingTask.setOwnerId(notice.getAssigneeId());
        pendingTask.setOwnerName(notice.getAssigneeName());
        pendingTask.setCreateTime(notice.getCreateTime());
        pendingTask.setTaskId(notice.getId());
        pendingTask.setCopyType("COMMU".equals(notice.getStatus()) ? "commu" : "copyto");
        pendingTask.setDefId(notice.getProcDefId());
        pendingTask.setTaskStatus(notice.getStatus());
        pendingTask.setSupportMobile(notice.getSupportMobile());
        String pre = TodoPushUtil.getSubjectPre("COMMU".equals(notice.getStatus()) ? "commu" : "copyto", notice.getStatus());
        pendingTask.setSubject(pre + notice.getSubject());
        portalMsgPushService.copyTo(pendingTask);
    }

    public static void addTodoToPortal(PendingTask pendingTask) {
        TodoConfig todoConfig = (TodoConfig)AppUtil.getBean(TodoConfig.class);
        if (!todoConfig.getEnabled()) {
            return;
        }
        PortalMsgPushService portalMsgPushService = (PortalMsgPushService)AppUtil.getBean(PortalMsgPushService.class);
        if (OpinionStatus.COPYTO.getKey().equals(pendingTask.getCopyType())) {
            portalMsgPushService.copyTo(pendingTask);
        } else if (TaskType.FOLLOW.getKey().equalsIgnoreCase(pendingTask.getType())) {
            portalMsgPushService.follow(pendingTask);
        } else {
            PortalTaskVo portalTaskVo = new PortalTaskVo();
            portalTaskVo.setInstId(pendingTask.getProcInstId());
            portalTaskVo.setNodeName(pendingTask.getName());
            portalTaskVo.setTaskApproveId(pendingTask.getOwnerId());
            portalTaskVo.setTaskApproveName(pendingTask.getOwnerName());
            portalTaskVo.setTaskArriveDate(pendingTask.getCreateTime());
            portalTaskVo.setTaskId(pendingTask.getId());
            portalTaskVo.setTodoType(pendingTask.getType());
            portalTaskVo.setStatus(pendingTask.getTaskStatus());
            portalTaskVo.setCommuId(pendingTask.getCommuId());
            String pre = TodoPushUtil.getSubjectPre(pendingTask.getType(), pendingTask.getTaskStatus());
            portalTaskVo.setSubject(pre + pendingTask.getSubject());
            portalMsgPushService.addTodo(portalTaskVo);
        }
    }

    public static void delegateTodoToPortal(BpmTask task) {
        TodoConfig todoConfig = (TodoConfig)AppUtil.getBean(TodoConfig.class);
        if (!todoConfig.getEnabled()) {
            return;
        }
        PortalMsgPushService portalMsgPushService = (PortalMsgPushService)AppUtil.getBean(PortalMsgPushService.class);
        PortalTaskVo portalTaskVo = new PortalTaskVo();
        portalTaskVo.setInstId(task.getProcInstId());
        portalTaskVo.setNodeName(task.getName());
        if (Objects.equals(TaskType.DELIVERTO.name(), task.getStatus())) {
            portalTaskVo.setTaskApproveId(task.getAssigneeId());
            portalTaskVo.setTaskApproveName(task.getAssigneeName());
        } else {
            portalTaskVo.setTaskApproveId(task.getOwnerId());
            portalTaskVo.setTaskApproveName(task.getOwnerName());
        }
        portalTaskVo.setTaskArriveDate(task.getCreateTime());
        portalTaskVo.setTaskId(task.getId());
        portalTaskVo.setStatus(task.getStatus());
        portalTaskVo.setTodoType("task");
        String pre = TodoPushUtil.getSubjectPre("task", task.getStatus());
        portalTaskVo.setSubject(pre + task.getSubject());
        portalTaskVo.setDefName(task.getProcDefName());
        portalMsgPushService.addTodo(portalTaskVo);
    }

    public static String getSubjectPre(String type, String status) {
        if (StringUtil.isNotEmpty((String)status)) {
            status = status.toLowerCase();
        }
        String pre = "";
        ActionCmd finsActionCmd = ContextThreadUtil.getActionCmd();
        if (BeanUtils.isNotEmpty((Object)finsActionCmd) && BeanUtils.isNotEmpty((Object)finsActionCmd.getTransitVars("IsDoneUnused"))) {
            return pre;
        }
        switch (type) {
            case "task": {
                switch (status) {
                    case "back": {
                        pre = "\u3010\u9a73\u56de\u3011";
                        break;
                    }
                    case "backtostart": {
                        pre = "\u3010\u9a73\u56de\u3011";
                        break;
                    }
                    case "deliverto": {
                        pre = "\u3010\u8f6c\u529e\u3011";
                        break;
                    }
                    case "transforming": {
                        pre = "\u3010\u6d41\u8f6c\u3011";
                        break;
                    }
                    case "transformed": {
                        pre = "\u3010\u6d41\u8f6c\u3011";
                        break;
                    }
                    case "addsign": {
                        pre = "\u3010\u52a0\u7b7e\u3011";
                    }
                }
                break;
            }
            case "commu": {
                pre = "\u3010\u6c9f\u901a\u3011";
                break;
            }
            case "forward": {
                pre = "\u3010\u8f6c\u53d1\u3011";
                break;
            }
            case "copyto": {
                pre = "\u3010\u4f20\u9605\u3011";
                break;
            }
            case "follow": {
                pre = "\u3010\u8ddf\u8e2a\u3011";
            }
        }
        return pre;
    }

    public static void taskToHandled(BpmTask bpmTask) {
        TodoConfig todoConfig = (TodoConfig)AppUtil.getBean(TodoConfig.class);
        if (!todoConfig.getEnabled()) {
            return;
        }
        PortalMsgPushService portalMsgPushService = (PortalMsgPushService)AppUtil.getBean(PortalMsgPushService.class);
        HandledTask task = new HandledTask();
        if (StringUtil.isNotZeroEmpty((String)bpmTask.getAssigneeId())) {
            task.setAssigneeId(bpmTask.getAssigneeId());
        } else if (StringUtil.isNotZeroEmpty((String)bpmTask.getOwnerId())) {
            task.setAssigneeId(bpmTask.getOwnerId());
        }
        if (StringUtil.isEmpty((String)task.getAssigneeId()) && BeanUtils.isNotEmpty((Object)ContextUtil.getCurrentUser())) {
            IUser iuser = ContextUtil.getCurrentUser();
            task.setAssigneeId(iuser.getUserId());
            task.setAssigneeName(iuser.getFullname());
        }
        task.setCompleteTime(LocalDateTime.now());
        task.setId(bpmTask.getId());
        task.setTaskId(bpmTask.getId());
        task.setProcInstId(bpmTask.getProcInstId());
        task.setType("task");
        task.setTaskStatus("end");
        String pre = TodoPushUtil.getSubjectPre("task", bpmTask.getStatus());
        task.setSubject(pre + bpmTask.getSubject());
        portalMsgPushService.toCompleted(task);
    }

    public static void taskToHandled(BpmTask pendingTask, String type) {
        TodoConfig todoConfig = (TodoConfig)AppUtil.getBean(TodoConfig.class);
        if (!todoConfig.getEnabled()) {
            return;
        }
        PortalMsgPushService portalMsgPushService = (PortalMsgPushService)AppUtil.getBean(PortalMsgPushService.class);
        HandledTask task = new HandledTask();
        task.setAssigneeId(pendingTask.getOwnerId());
        task.setName(pendingTask.getName());
        task.setAssigneeName(pendingTask.getOwnerName());
        task.setCompleteTime(LocalDateTime.now());
        task.setId(pendingTask.getId());
        task.setTaskId(pendingTask.getId());
        task.setProcInstId(pendingTask.getProcInstId());
        task.setType(type);
        task.setTaskStatus("end");
        String pre = TodoPushUtil.getSubjectPre(type, pendingTask.getStatus());
        task.setSubject(pre + pendingTask.getSubject());
        if ("copyto".equals(type)) {
            portalMsgPushService.dealCopyTo(task);
        } else {
            portalMsgPushService.toCompleted(task);
        }
    }

    public static void taskToHandled(BpmTaskNotice bpmTaskNotice, String type) {
        TodoConfig todoConfig = (TodoConfig)AppUtil.getBean(TodoConfig.class);
        if (!todoConfig.getEnabled()) {
            return;
        }
        PortalMsgPushService portalMsgPushService = (PortalMsgPushService)AppUtil.getBean(PortalMsgPushService.class);
        HandledTask task = new HandledTask();
        task.setAssigneeId(bpmTaskNotice.getOwnerId());
        task.setName(bpmTaskNotice.getName());
        task.setAssigneeName(bpmTaskNotice.getOwnerName());
        task.setCompleteTime(LocalDateTime.now());
        task.setId(bpmTaskNotice.getId());
        task.setTaskId(bpmTaskNotice.getId());
        task.setProcInstId(bpmTaskNotice.getProcInstId());
        task.setType(type);
        task.setTaskStatus("end");
        String pre = TodoPushUtil.getSubjectPre(type, bpmTaskNotice.getStatus());
        task.setSubject(pre + bpmTaskNotice.getSubject());
        portalMsgPushService.dealCopyTo(task);
    }

    public static void toDelPortalTasks(String instId, String fromSysKey, PortalTaskVo portalTaskVo) {
        TodoConfig todoConfig = (TodoConfig)AppUtil.getBean(TodoConfig.class);
        if (!todoConfig.getEnabled()) {
            return;
        }
        BpmTaskManager bpmTaskManager = (BpmTaskManager)AppUtil.getBean(BpmTaskManager.class);
        List<DefaultBpmTask> tasks = bpmTaskManager.getByInstId(instId);
        if (BeanUtils.isNotEmpty(tasks)) {
            PortalMsgPushService portalMsgPushService = (PortalMsgPushService)AppUtil.getBean(PortalMsgPushService.class);
            ArrayList<String> taskIdList = new ArrayList<String>();
            ArrayList<String> ownerList = new ArrayList<String>();
            for (DefaultBpmTask task : tasks) {
                taskIdList.add(task.getId());
                ownerList.add(task.getOwnerId());
            }
            if (BeanUtils.isNotEmpty(taskIdList)) {
                portalMsgPushService.delTodo(instId, taskIdList, 3, ownerList, "", portalTaskVo);
            }
        }
    }

    public static void toRecoverPortalTasks(String instId, String fromSysKey, PortalTaskVo portalTaskVo) {
        TodoConfig todoConfig = (TodoConfig)AppUtil.getBean(TodoConfig.class);
        if (!todoConfig.getEnabled()) {
            return;
        }
        BpmTaskManager bpmTaskManager = (BpmTaskManager)AppUtil.getBean(BpmTaskManager.class);
        List<DefaultBpmTask> tasks = bpmTaskManager.getByInstId(instId);
        if (BeanUtils.isNotEmpty(tasks)) {
            for (DefaultBpmTask task : tasks) {
                TodoPushUtil.addTodoToPortal(task);
            }
        }
    }

    public static void lockOrUnLockTask(String instanceId, String taskId, String account, String type) {
        TodoConfig todoConfig = (TodoConfig)AppUtil.getBean(TodoConfig.class);
        if (!todoConfig.getEnabled()) {
            return;
        }
        PortalMsgPushService portalMsgPushService = (PortalMsgPushService)AppUtil.getBean(PortalMsgPushService.class);
        portalMsgPushService.lockOrUnLockTask(instanceId, taskId, account, type);
    }

    public static void addCommuToPortal(BpmTaskNotice notice) {
        TodoConfig todoConfig = (TodoConfig)AppUtil.getBean(TodoConfig.class);
        if (!todoConfig.getEnabled()) {
            return;
        }
        PortalMsgPushService portalMsgPushService = (PortalMsgPushService)AppUtil.getBean(PortalMsgPushService.class);
        PendingTask pendingTask = new PendingTask();
        pendingTask.setId(notice.getId());
        pendingTask.setProcInstId(notice.getProcInstId());
        pendingTask.setName(notice.getName());
        pendingTask.setOwnerId(notice.getAssigneeId());
        pendingTask.setOwnerName(notice.getAssigneeName());
        pendingTask.setCreateTime(notice.getCreateTime());
        pendingTask.setTaskId(notice.getId());
        pendingTask.setCopyType("commu");
        pendingTask.setDefId(notice.getProcDefId());
        pendingTask.setTaskStatus(notice.getStatus());
        pendingTask.setSupportMobile(notice.getSupportMobile());
        String pre = TodoPushUtil.getSubjectPre("commu", notice.getStatus());
        pendingTask.setSubject(pre + notice.getSubject());
        portalMsgPushService.commuTo(pendingTask);
    }
}

