/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.model.identity.DefaultBpmIdentity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BpmIdentityUtil {
    public static Map<String, List<BpmIdentity>> getBpmIdentity(String executors) throws IOException {
        HashMap<String, List<BpmIdentity>> map = new HashMap<String, List<BpmIdentity>>();
        if (StringUtil.isEmpty((String)executors)) {
            return map;
        }
        JsonNode jsonNode = JsonUtil.toJsonNode((String)executors);
        if (jsonNode.isArray()) {
            for (Object obj : jsonNode) {
                ObjectNode objectNode = (ObjectNode)JsonUtil.toJsonNode(obj);
                BpmIdentityUtil.getBpmIdentity(objectNode, map);
            }
        } else if (jsonNode.isObject()) {
            BpmIdentityUtil.getBpmIdentity((ObjectNode)jsonNode, map);
        }
        return map;
    }

    private static void getBpmIdentity(ObjectNode jsonNode, Map<String, List<BpmIdentity>> map) throws IOException {
        if (!jsonNode.hasNonNull("nodeId") || StringUtil.isEmpty((String)jsonNode.get("nodeId").asText())) {
            return;
        }
        String nodeId = jsonNode.get("nodeId").asText();
        ArrayNode users = (ArrayNode)JsonUtil.toJsonNode((Object)jsonNode.get("executors"));
        ArrayList<BpmIdentity> userList = new ArrayList<BpmIdentity>();
        for (Object userObj : users) {
            ObjectNode user = (ObjectNode)JsonUtil.toJsonNode(userObj);
            String id = user.has("id") ? user.get("id").asText() : "";
            String name = user.has("name") ? user.get("name").asText() : "";
            BpmIdentity bpmInentity = DefaultBpmIdentity.getIdentityByUserId(id, name);
            userList.add(bpmInentity);
        }
        map.put(nodeId, userList);
    }

    public static List<BpmIdentity> getNextNodeBpmIdentity(String executors) throws IOException {
        ArrayList<BpmIdentity> userList = new ArrayList<BpmIdentity>();
        if (StringUtil.isEmpty((String)executors)) {
            return userList;
        }
        ArrayNode ArrayNode2 = (ArrayNode)JsonUtil.toJsonNode((String)executors);
        for (Object obj : ArrayNode2) {
            ObjectNode jsonNode = (ObjectNode)JsonUtil.toJsonNode(obj);
            JsonNode executorsOjb = jsonNode.get("executors");
            if (BeanUtils.isEmpty((Object)executorsOjb)) continue;
            ArrayNode users = JsonUtil.getMapper().createArrayNode();
            if (executorsOjb instanceof ArrayNode) {
                users = (ArrayNode)executorsOjb;
            } else if (executorsOjb instanceof TextNode) {
                users = (ArrayNode)JsonUtil.toJsonNode((String)executorsOjb.asText());
            }
            for (Object userObj : users) {
                ObjectNode user = (ObjectNode)JsonUtil.toJsonNode(userObj);
                BpmIdentity bpmInentity = DefaultBpmIdentity.getIdentityByUserId(user.get("id").asText(), user.get("name").asText());
                userList.add(bpmInentity);
            }
        }
        return userList;
    }

    public static List<BpmIdentity> qualfields2BpmIdentity(String qualfieds) throws Exception {
        ArrayList<BpmIdentity> result = new ArrayList<BpmIdentity>();
        if (StringUtil.isEmpty((String)qualfieds)) {
            return result;
        }
        JsonNode parse = JsonUtil.toJsonNode((String)qualfieds);
        if (BeanUtils.isNotEmpty((Object)parse) && parse.isArray()) {
            ArrayNode ArrayNode2 = (ArrayNode)parse;
            for (JsonNode jsonNode : ArrayNode2) {
                ObjectNode jobject;
                if (BeanUtils.isEmpty((Object)jsonNode) || !jsonNode.isObject() || !BeanUtils.isNotEmpty((Object)(jobject = (ObjectNode)jsonNode).get("type")) || !jobject.get("type").isTextual()) continue;
                result.add(new DefaultBpmIdentity(jobject.get("id").asText(), jobject.get("name").asText(), jobject.get("type").asText()));
            }
        }
        return result;
    }
}

