/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.base.util.time.TimeUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.cmd.ProcessInstCmd;
import com.hotent.bpm.api.cmd.TaskFinishCmd;
import com.hotent.bpm.api.constant.ActionType;
import com.hotent.bpm.api.constant.BPMN20ExtConst;
import com.hotent.bpm.api.constant.EventType;
import com.hotent.bpm.api.constant.NodeStatus;
import com.hotent.bpm.api.constant.NodeType;
import com.hotent.bpm.api.constant.OpinionStatus;
import com.hotent.bpm.api.constant.PrivilegeMode;
import com.hotent.bpm.api.constant.TaskActionType;
import com.hotent.bpm.api.constant.TaskType;
import com.hotent.bpm.api.context.BpmContextUtil;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.event.BpmDefinitionDelEvent;
import com.hotent.bpm.api.event.NoExecutorEvent;
import com.hotent.bpm.api.event.NoExecutorModel;
import com.hotent.bpm.api.inst.ISkipCondition;
import com.hotent.bpm.api.model.delegate.BpmDelegateTask;
import com.hotent.bpm.api.model.form.FormType;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.model.process.def.BpmDefExtProperties;
import com.hotent.bpm.api.model.process.def.BpmDefinition;
import com.hotent.bpm.api.model.process.def.BpmProcessDef;
import com.hotent.bpm.api.model.process.def.BpmProcessDefExt;
import com.hotent.bpm.api.model.process.def.IGlobalRestfulPluginDef;
import com.hotent.bpm.api.model.process.def.NodeProperties;
import com.hotent.bpm.api.model.process.def.Restful;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.NodeInMulti;
import com.hotent.bpm.api.model.process.nodedef.ext.SignNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.SubProcessNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.Button;
import com.hotent.bpm.api.model.process.task.BpmTask;
import com.hotent.bpm.api.model.process.task.SkipResult;
import com.hotent.bpm.api.plugin.core.context.BpmPluginContext;
import com.hotent.bpm.api.plugin.core.def.BpmExecutionPluginDef;
import com.hotent.bpm.api.plugin.core.def.BpmPluginDef;
import com.hotent.bpm.api.plugin.core.def.BpmTaskPluginDef;
import com.hotent.bpm.api.plugin.core.def.TaskActionHandlerDef;
import com.hotent.bpm.api.plugin.core.factory.BpmPluginFactory;
import com.hotent.bpm.api.plugin.core.runtime.BpmExecutionPlugin;
import com.hotent.bpm.api.plugin.core.runtime.BpmTaskPlugin;
import com.hotent.bpm.api.plugin.core.task.TaskActionHandlerConfig;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.api.service.BpmDefinitionService;
import com.hotent.bpm.api.service.BpmFormService;
import com.hotent.bpm.api.service.BpmTaskActionService;
import com.hotent.bpm.api.service.RestfulService;
import com.hotent.bpm.api.service.SignService;
import com.hotent.bpm.defxml.entity.ExtensionElements;
import com.hotent.bpm.defxml.entity.FlowElement;
import com.hotent.bpm.engine.form.BpmFormFactory;
import com.hotent.bpm.engine.task.cmd.DefaultTaskFinishCmd;
import com.hotent.bpm.engine.task.skip.SkipConditionUtil;
import com.hotent.bpm.model.form.FormModel;
import com.hotent.bpm.natapi.task.NatTaskService;
import com.hotent.bpm.persistence.dao.BpmExeStackRelationDao;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.manager.BpmTaskDueTimeManager;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.model.BpmBusLink;
import com.hotent.bpm.persistence.model.BpmExeStackRelation;
import com.hotent.bpm.persistence.model.BpmTaskDueTime;
import com.hotent.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import com.hotent.bpm.persistence.util.BpmStackRelationUtil;
import com.hotent.i18n.util.I18nUtil;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserService;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;
import org.w3c.dom.Element;

public class BpmUtil {
    private static boolean showNodeHistoryData;
    public static List<String> REJECT_ACTION_NAMES;
    public static List<String> RECOVER_ACTION_NAMES;
    @Value(value="${system.bpm.showNodeHisData:false}")
    public boolean showNodeHisData;

    public static NodeStatus getBackNodeStatus(TaskFinishCmd cmd) {
        String actionName;
        Object transitVars;
        Object backOtherTaskCancle = cmd.getTransitVars("back_other_task_cancle");
        NodeStatus nodeStatus = null;
        if (BeanUtils.isNotEmpty((Object)backOtherTaskCancle)) {
            nodeStatus = NodeStatus.SIGN_BACK_CANCLE;
        }
        if (BeanUtils.isNotEmpty((Object)(transitVars = cmd.getTransitVars("IsDoneUnused")))) {
            nodeStatus = NodeStatus.RECOVER;
        }
        switch (actionName = (String)cmd.getTransitVars("first_action_name", cmd.getActionName())) {
            case "recover": {
                nodeStatus = NodeStatus.RECOVER;
                break;
            }
            case "recoverToStart": {
                nodeStatus = NodeStatus.RECOVER_TO_START;
                break;
            }
            case "back": {
                nodeStatus = NodeStatus.BACK;
                break;
            }
            case "backToStart": {
                nodeStatus = NodeStatus.BACK_TO_START;
            }
        }
        return nodeStatus;
    }

    public static OpinionStatus getBackOpinionStatus(TaskFinishCmd cmd) {
        Object transitVars;
        Object backOtherTaskCancle = cmd.getTransitVars("back_other_task_cancle");
        OpinionStatus opinionStatus = null;
        if (BeanUtils.isNotEmpty((Object)backOtherTaskCancle)) {
            opinionStatus = OpinionStatus.SIGN_BACK_CANCEL;
        }
        if (BeanUtils.isNotEmpty((Object)(transitVars = cmd.getTransitVars("IsDoneUnused")))) {
            opinionStatus = OpinionStatus.RETRACTED;
        }
        return opinionStatus;
    }

    public static void canRevoke(List<DefaultBpmTask> bpmTasks) {
        ArrayList<String> notAllowsStatus = new ArrayList<String>();
        notAllowsStatus.add(TaskType.TRANSFORMING.getKey());
        notAllowsStatus.add(TaskType.TRANSFORMEDINQU.getKey());
        notAllowsStatus.add(TaskType.COMMU.getKey());
        Optional<DefaultBpmTask> first = bpmTasks.stream().filter(bpmTask -> notAllowsStatus.contains(bpmTask.getStatus())).findFirst();
        if (first.isPresent()) {
            throw new BaseException("\u4e0d\u5141\u8bb8\u64a4\u56de");
        }
    }

    @PostConstruct
    public void setShowNodeHistoryData() {
        showNodeHistoryData = this.showNodeHisData;
    }

    public static boolean showNodeHistoryData() {
        return showNodeHistoryData;
    }

    public static String getTitleByRule(String titleRule, Map<String, Object> map) {
        if (StringUtils.isEmpty((String)titleRule)) {
            return "";
        }
        Pattern regex = Pattern.compile("\\{(.*?)\\}", 98);
        Matcher matcher = regex.matcher(titleRule);
        while (matcher.find()) {
            String tag = matcher.group(0);
            String rule = matcher.group(1);
            String[] aryRule = rule.split(":");
            String name = "";
            name = aryRule.length == 1 ? rule : aryRule[1];
            if (map.containsKey(name)) {
                Object obj = map.get(name);
                if (obj != null) {
                    try {
                        titleRule = titleRule.replace(tag, obj.toString());
                    }
                    catch (Exception e) {
                        titleRule = titleRule.replace(tag, "");
                    }
                    continue;
                }
                titleRule = titleRule.replace(tag, "");
                continue;
            }
            titleRule = titleRule.replace(tag, "");
        }
        return titleRule;
    }

    public static BpmTask convertTask(BpmDelegateTask delegateTask) throws Exception {
        return BpmUtil.convertTask(delegateTask, null);
    }

    public static DefaultBpmTask convertTask(DefaultBpmTask task, String parentTaskId, TaskType taskType, IUser user) {
        DefaultBpmTask cloneTask = (DefaultBpmTask)task.clone();
        cloneTask.setId(UniqueIdUtil.getSuid());
        cloneTask.setParentId(parentTaskId);
        cloneTask.setExecId("");
        cloneTask.setTaskId("");
        cloneTask.setStatus(taskType.name());
        cloneTask.setAssigneeId(user.getUserId());
        cloneTask.setOwnerId(user.getUserId());
        cloneTask.setCreateTime(LocalDateTime.now());
        return cloneTask;
    }

    public static BpmDefExtProperties getExtProperties(String bpmnDefId) throws Exception {
        BpmDefinitionService bpmDefinitionService = (BpmDefinitionService)AppUtil.getBean(BpmDefinitionService.class);
        BpmProcessDef<BpmProcessDefExt> procDef = bpmDefinitionService.getBpmProcessDef(bpmnDefId);
        BpmProcessDefExt procExt = procDef.getProcessDefExt();
        BpmDefExtProperties extProperties = procExt.getExtProperties();
        return extProperties;
    }

    public static Object[] getDefProperties(BpmProcessInstance instance, String nodeId) throws Exception {
        BpmProcessInstanceManager instanceManager;
        BpmProcessInstance parentInstance;
        Object[] aryObj = new Object[3];
        String defId = instance.getProcDefId();
        BpmDefinitionAccessor bpmDefinitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean((String)"bpmDefinitionAccessor");
        BpmDefinitionManager bpmDefinitionManager = (BpmDefinitionManager)AppUtil.getBean(BpmDefinitionManager.class);
        DefaultBpmDefinition bpmDefinition = bpmDefinitionManager.getById(defId);
        BpmNodeDef nodeDef = null;
        BpmProcessDef processDef = null;
        NodeProperties properties = null;
        String parentId = instance.getParentInstId();
        if (StringUtil.isNotZeroEmpty((String)parentId) && BeanUtils.isNotEmpty((Object)(nodeDef = bpmDefinitionAccessor.getBpmNodeDef((parentInstance = (BpmProcessInstance)(instanceManager = (BpmProcessInstanceManager)AppUtil.getBean(BpmProcessInstanceManager.class)).get((Serializable)((Object)parentId))).getProcDefId(), nodeId)))) {
            properties = nodeDef.getLocalProperties();
            processDef = nodeDef.getRootProcessDef();
        }
        if (BeanUtils.isEmpty(nodeDef)) {
            nodeDef = bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
            properties = nodeDef.getLocalProperties();
            processDef = nodeDef.getRootProcessDef();
        }
        aryObj[0] = properties;
        aryObj[1] = processDef;
        aryObj[2] = bpmDefinition;
        return aryObj;
    }

    public static boolean isAllowEmptyIdentity(BpmProcessInstance instance, String nodeId) throws Exception {
        boolean isAllowEmpty = false;
        Object[] aryObj = BpmUtil.getDefProperties(instance, nodeId);
        NodeProperties properties = (NodeProperties)aryObj[0];
        BpmProcessDef procDef = (BpmProcessDef)aryObj[1];
        if (properties != null) {
            isAllowEmpty = properties.isAllowExecutorEmpty();
        }
        if (!isAllowEmpty) {
            Object procExt = procDef.getProcessDefExt();
            BpmDefExtProperties extProperties = procExt.getExtProperties();
            isAllowEmpty = extProperties.isAllowExecutorEmpty();
        }
        return isAllowEmpty;
    }

    public static boolean getSkipFirstNode(String defId) throws Exception {
        BpmDefinitionAccessor bpmDefinitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean((String)"bpmDefinitionAccessor");
        BpmProcessDef<BpmProcessDefExt> procDef = bpmDefinitionAccessor.getBpmProcessDef(defId);
        BpmProcessDefExt procExt = procDef.getProcessDefExt();
        BpmDefExtProperties extProperties = procExt.getExtProperties();
        return extProperties.isSkipFirstNode();
    }

    public static BpmProcessDef<BpmProcessDefExt> getProcessDef(String bpmnDefId) throws Exception {
        BpmDefinitionService bpmDefinitionService = (BpmDefinitionService)AppUtil.getBean(BpmDefinitionService.class);
        BpmProcessDef<BpmProcessDefExt> procDef = bpmDefinitionService.getBpmProcessDef(bpmnDefId);
        return procDef;
    }

    public static BpmProcessDef<BpmProcessDefExt> getProcessDefByDefId(String defId) throws Exception {
        BpmDefinitionAccessor bpmDefinitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean((String)"bpmDefinitionAccessor");
        BpmProcessDef<BpmProcessDefExt> procDef = bpmDefinitionAccessor.getBpmProcessDef(defId);
        return procDef;
    }

    public static boolean IsAllowTransTo(BpmNodeDef bpmNodeDef) {
        boolean isAllowTransTo = true;
        if (bpmNodeDef.getBpmProcessDef().getProcessDefExt() == null) {
            bpmNodeDef = bpmNodeDef.getParentBpmNodeDef();
        }
        try {
            isAllowTransTo = bpmNodeDef.getBpmProcessDef().getProcessDefExt().getExtProperties().isAllowTransTo();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isAllowTransTo;
    }

    public static String getUseMainForm(BpmNodeDef bpmNodeDef) {
        String useMainForm = "";
        if (bpmNodeDef.getBpmProcessDef().getProcessDefExt() == null) {
            bpmNodeDef = bpmNodeDef.getParentBpmNodeDef();
        }
        try {
            useMainForm = bpmNodeDef.getBpmProcessDef().getProcessDefExt().getExtProperties().getUseMainForm();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return useMainForm;
    }

    public static void finishTask(BpmTask bpmTask) throws Exception {
        String taskId = bpmTask.getId();
        SkipResult result = bpmTask.getSkipResult();
        ActionCmd actionCmd = ContextThreadUtil.getActionCmd();
        String destination = actionCmd.getDestination();
        Map<String, List<BpmIdentity>> identityMap = actionCmd.getBpmIdentities();
        BpmTaskActionService bpmTaskActionService = (BpmTaskActionService)AppUtil.getBean(BpmTaskActionService.class);
        Map<String, ObjectNode> boMap = BpmContextUtil.getBoFromContext();
        DefaultTaskFinishCmd cmd = new DefaultTaskFinishCmd();
        cmd.addTransitVars("bo_inst_", boMap);
        if (BeanUtils.isNotEmpty((Object)actionCmd.getTransitVars("bpmTask_"))) {
            cmd.addTransitVars("bpmTask_", actionCmd.getTransitVars("bpmTask_"));
        }
        if (!result.isSkipTask()) {
            cmd.setDestination(destination);
        } else {
            cmd.setDestination("");
        }
        cmd.setTaskId(taskId);
        cmd.setBpmIdentities(identityMap);
        cmd.setBusData(actionCmd.getBusData());
        cmd.setDataMode(actionCmd.getDataMode());
        cmd.setActionName(TaskActionType.AGREE.getKey());
        String skipType = result.getSkipType();
        cmd.addTransitVars("skipType_", skipType);
        cmd.addTransitVars("bpmTask_", bpmTask);
        bpmTaskActionService.finishTask(cmd);
    }

    public static String getNotifyType(BpmProcessInstance instance, String nodeId) throws Exception {
        if (org.springframework.util.StringUtils.isEmpty((Object)nodeId)) {
            BpmDefExtProperties defExtProperties = BpmUtil.getExtProperties(instance.getBpmnDefId());
            return defExtProperties == null ? "" : defExtProperties.getNotifyType();
        }
        Object[] aryObj = BpmUtil.getDefProperties(instance, nodeId);
        NodeProperties properties = (NodeProperties)aryObj[0];
        BpmProcessDef procDef = (BpmProcessDef)aryObj[1];
        BpmDefinition bpmDefinition = (BpmDefinition)aryObj[2];
        Object ext = procDef.getProcessDefExt();
        BpmDefExtProperties prop = ext.getExtProperties();
        if (properties != null && StringUtil.isNotEmpty((String)properties.getNotifyType())) {
            return properties.getNotifyType();
        }
        if ("test".equals(bpmDefinition.getTestStatus())) {
            return prop.getTestNotifyType();
        }
        return prop.getNotifyType();
    }

    public static String getNotifyType(BpmTask task) throws Exception {
        if (BeanUtils.isEmpty((Object)task)) {
            return "";
        }
        BpmProcessInstanceManager instanceManager = (BpmProcessInstanceManager)AppUtil.getBean(BpmProcessInstanceManager.class);
        return BpmUtil.getNotifyType((BpmProcessInstance)instanceManager.get((Serializable)((Object)task.getProcInstId())), task.getNodeId());
    }

    public static void publishNoExecutorEvent(NoExecutorModel model) {
        NoExecutorEvent ev = new NoExecutorEvent(model);
        AppUtil.publishEvent((ApplicationEvent)ev);
    }

    public static void setTaskSkip(BpmTask bpmTask) throws Exception {
        block7: {
            String[] aryRules;
            BpmDefExtProperties extProperties;
            ActionCmd cmd;
            SkipResult skipResult;
            block6: {
                if (bpmTask.getSkipResult().isHasGetSkip()) {
                    return;
                }
                skipResult = new SkipResult();
                bpmTask.setSkipResult(skipResult);
                cmd = ContextThreadUtil.getActionCmd();
                BpmProcessDef<BpmProcessDefExt> procDef = BpmUtil.getProcessDefByDefId(bpmTask.getProcDefId());
                extProperties = procDef.getProcessDefExt().getExtProperties();
                if (!(cmd instanceof ProcessInstCmd)) break block6;
                boolean skipFirstNode = extProperties.isSkipFirstNode();
                BpmDefinitionAccessor bpmDefinitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean(BpmDefinitionAccessor.class);
                List<BpmNodeDef> startNodes = bpmDefinitionAccessor.getStartNodes(bpmTask.getProcDefId());
                if (!skipFirstNode || !bpmTask.getNodeId().equals(startNodes.get(0).getNodeId())) break block7;
                skipResult.setSkipTask(true);
                skipResult.setSkipType(SkipResult.SKIP_FIRST);
                break block7;
            }
            String skipRules = extProperties.getSkipRules();
            try {
                BpmProcessInstance instance = (BpmProcessInstance)cmd.getTransitVars("processInstance");
                Object[] aryObj = BpmUtil.getDefProperties(instance, bpmTask.getNodeId());
                NodeProperties properties = (NodeProperties)aryObj[0];
                if (properties.isSkipExecutorEmpty()) {
                    skipRules = StringUtil.isEmpty((String)skipRules) ? SkipResult.SKIP_EMPTY_USER : SkipResult.SKIP_EMPTY_USER + "," + skipRules;
                }
            }
            catch (Exception instance) {
                // empty catch block
            }
            if (StringUtil.isEmpty((String)skipRules)) {
                return;
            }
            for (String rule : aryRules = skipRules.split(",")) {
                ISkipCondition condition = SkipConditionUtil.getSkipConditionByType(rule);
                boolean rtn = condition.canSkip(bpmTask);
                if (!rtn) continue;
                skipResult.setSkipTask(true);
                skipResult.setSkipType(condition.getType());
                break;
            }
        }
    }

    public static IUser getUser(String userId, String userName) {
        IUser user = new IUser(){
            private static final long serialVersionUID = -3279144470311301256L;
            String userId = "";
            String fullName = "";

            public String getIdentityType() {
                return null;
            }

            public void setUserId(String userId) {
                this.userId = userId;
            }

            public void setFullname(String fullName) {
                this.fullName = fullName;
            }

            public void setAccount(String account) {
            }

            public String getUserId() {
                return this.userId;
            }

            public String getPassword() {
                return null;
            }

            public String getMobile() {
                return null;
            }

            public String getFullname() {
                return this.fullName;
            }

            public String getEmail() {
                return null;
            }

            public String getAccount() {
                return null;
            }

            public void setAttributes(Map<String, String> map) {
            }

            public Map<String, String> getAttributes() {
                return null;
            }

            public boolean isAdmin() {
                return false;
            }

            public String getAttrbuite(String key) {
                return "";
            }

            public String getPhoto() {
                return null;
            }

            public String getWeixin() {
                return null;
            }

            public Integer getHasSyncToWx() {
                return null;
            }

            public boolean isEnable() {
                return true;
            }

            public Collection<GrantedAuthority> getAuthorities() {
                return null;
            }

            public String getUsername() {
                return null;
            }

            public boolean isAccountNonExpired() {
                return false;
            }

            public boolean isAccountNonLocked() {
                return false;
            }

            public boolean isCredentialsNonExpired() {
                return false;
            }

            public boolean isEnabled() {
                return false;
            }

            public Integer getStatus() {
                return null;
            }

            public String getTenantId() {
                return null;
            }

            public LocalDateTime getPwdCreateTime() {
                return null;
            }

            public LocalDate getExpireDate() {
                return null;
            }

            public String getClientId() {
                return null;
            }

            public String getClientToken() {
                return null;
            }

            public LocalDate getEntryDate() {
                return null;
            }
        };
        user.setUserId(userId);
        user.setFullname(userName);
        return user;
    }

    public static IUser getUser(String userId) {
        IUserService userService = (IUserService)AppUtil.getBean(IUserService.class);
        IUser user = userService.getUserById(userId);
        return user;
    }

    public static BpmBusLink buildBusLink(BpmProcessInstance instance, ObjectNode result, String saveMode) {
        boolean isNumber;
        BpmProcessInstanceManager instanceManager = (BpmProcessInstanceManager)AppUtil.getBean(BpmProcessInstanceManager.class);
        instance = instanceManager.getTopBpmProcessInstance(instance);
        BpmBusLink busLink = BpmUtil.buildBusLink(instance);
        busLink.setSaveMode(saveMode);
        busLink.setIsMain("0".equals(result.get("parentId").asText()) ? 1 : 0);
        if (result.get("boAlias") != null) {
            busLink.setBoDefCode(result.get("boAlias").asText());
        }
        busLink.setFormIdentify(result.get("boEnt").get("name").asText());
        ObjectNode boEnt = (ObjectNode)result.get("boEnt");
        boolean bl = isNumber = BeanUtils.isNotEmpty((Object)boEnt.get("pkType")) && "number".equals(boEnt.get("pkType").asText());
        if (isNumber) {
            busLink.setBusinesskey(new Long(result.get("pk").asLong()));
        } else {
            busLink.setBusinesskeyStr(result.get("pk").asText());
        }
        if (StringUtil.isNotEmpty((String)instance.getSysCode())) {
            busLink.setSysCode(instance.getSysCode());
        }
        return busLink;
    }

    public static BpmBusLink buildBusLink(BpmProcessInstance instance) {
        BpmBusLink busLink = new BpmBusLink();
        busLink.setId(UniqueIdUtil.getSuid());
        busLink.setDefId(instance.getProcDefId());
        busLink.setProcInstId(instance.getId());
        IUser curUser = ContextUtil.getCurrentUser();
        busLink.setStartId(curUser.getUserId());
        busLink.setStartor(curUser.getFullname());
        busLink.setCreateDate(LocalDateTime.now());
        if (StringUtil.isNotEmpty((String)instance.getSysCode())) {
            busLink.setSysCode(instance.getSysCode());
        }
        return busLink;
    }

    public static List<Object> getFlowElementExtension(FlowElement flowElement, QName qname) {
        ArrayList<Object> extensions = new ArrayList<Object>();
        ExtensionElements extensionElements = flowElement.getExtensionElements();
        if (extensionElements == null) {
            return extensions;
        }
        List<Object> objects = extensionElements.getAny();
        for (Object obj : objects) {
            Element el;
            QName qn;
            if (!(obj instanceof Element) || !qname.equals(qn = new QName((el = (Element)obj).getNamespaceURI(), el.getLocalName()))) continue;
            extensions.add(el.getNodeValue());
        }
        return extensions;
    }

    public static Integer getFlowElementOrder(FlowElement flowElement) {
        String s;
        Integer nodeOrder = 0;
        List<Object> extensions = BpmUtil.getFlowElementExtension(flowElement, BPMN20ExtConst._ORDER_QNAME);
        if (BeanUtils.isNotEmpty(extensions) && StringUtil.isNotEmpty((String)(s = (String)extensions.get(0))) && !"null".equals(s)) {
            nodeOrder = Integer.parseInt(s);
        }
        return nodeOrder;
    }

    public static List<Button> getButtons(BpmNodeDef bpmNodeDef) throws Exception {
        return BpmUtil.getButtons(bpmNodeDef, null);
    }

    public static List<Button> getButtons(BpmNodeDef bpmNodeDef, DefaultBpmTask task) throws Exception {
        if (BeanUtils.isNotEmpty((Object)task) && "FOLLOW".equals(task.getStatus())) {
            return null;
        }
        boolean isStartNode = false;
        if (BeanUtils.isNotEmpty(bpmNodeDef.getIncomeNodes()) && NodeType.START.getKey().equals(bpmNodeDef.getIncomeNodes().get(0).getType().getKey())) {
            isStartNode = true;
        }
        List<Button> buttons = bpmNodeDef.getButtons();
        if (task == null) {
            return buttons;
        }
        ArrayList<Button> buttons2remove = new ArrayList<Button>();
        for (Button button : buttons) {
            if (!isStartNode && !StringUtil.isNotEmpty((String)task.getTargetNode()) || !"reject".equals(button.getAlias())) continue;
            buttons2remove.add(button);
        }
        Map<String, Button> buttonMap = BpmUtil.convertToMap(buttons);
        String status = task.getStatus();
        BpmProcessDef<?> bpmProcessDef = bpmNodeDef.getBpmProcessDef();
        BpmDefExtProperties prop = BpmUtil.getBpmDefExtPropertiesNest(bpmProcessDef);
        boolean isAllowTransTo = prop.isAllowTransTo();
        buttons = BpmUtil.getCommonButtons(buttons, status);
        BpmUtil.handDelegateButton(buttonMap, buttons2remove, isAllowTransTo);
        boolean isTransformAdd = task.getStatus().equals(TaskType.TRANSFORMED.getKey());
        BpmUtil.handTransformAddButton(buttonMap, buttons2remove, isTransformAdd);
        if (!"TRANSFORMEDINQU".equals(task.getStatus())) {
            BpmUtil.handSignButtons(task.getTaskId(), bpmNodeDef, buttons, buttons2remove);
        }
        BpmUtil.handLockButton(task, buttons, buttons2remove);
        BpmUtil.handTaskDelay(task.getTaskId(), bpmNodeDef, prop, buttonMap, buttons2remove);
        buttons.removeAll(buttons2remove);
        Locale locale = LocaleContextHolder.getLocale();
        if (!Locale.SIMPLIFIED_CHINESE.equals(locale)) {
            for (Button button : buttons) {
                String key = "flow.bnt." + task.getProcDefKey() + "." + bpmNodeDef.getNodeId() + "." + button.getAlias();
                String mes = I18nUtil.getMessage((String)key, (Locale)locale);
                if (!StringUtil.isNotEmpty((String)mes) || key.equals(mes)) continue;
                button.setName(mes);
            }
        }
        return buttons;
    }

    private static BpmDefExtProperties getBpmDefExtPropertiesNest(BpmProcessDef<?> processDef) {
        Assert.notNull(processDef, (String)"processDef\u4e0d\u80fd\u4e3a\u7a7a");
        if (processDef != null && processDef.getParentProcessDef() != null) {
            return BpmUtil.getBpmDefExtPropertiesNest(processDef.getParentProcessDef());
        }
        Object processDefExt = processDef.getProcessDefExt();
        Assert.notNull(processDefExt, (String)"processDefExt\u4e0d\u80fd\u4e3a\u7a7a");
        return processDefExt.getExtProperties();
    }

    public static BpmProcessDefExt getDefExt(BpmProcessDef def) {
        Object processDefExt = def.getProcessDefExt();
        for (int count = 0; count < 10 && BeanUtils.isEmpty(processDefExt); ++count) {
            if (BeanUtils.isNotEmpty(def = def.getParentProcessDef())) {
                processDefExt = def.getProcessDefExt();
                continue;
            }
            return null;
        }
        return processDefExt;
    }

    private static void handUserNodeTypeButton(List<Button> buttons, BpmNodeDef bpmNodeDef, DefaultBpmTask task) {
        NodeProperties nodeProperties = bpmNodeDef.getLocalProperties();
        if (BeanUtils.isNotEmpty((Object)nodeProperties) && StringUtil.isNotEmpty((String)nodeProperties.getUserNodeType())) {
            if (!(!"approveLine".equals(nodeProperties.getUserNodeType()) || TaskType.APPROVELINEING.getKey().equals(task.getStatus()) || TaskType.APPROVELINEED.getKey().equals(task.getStatus()) || TaskType.TRANSFORMED.getKey().equals(task.getStatus()) || TaskType.TRANSFORMING.getKey().equals(task.getStatus()) || TaskType.TRANSFORMEDINQU.getKey().equals(task.getStatus()))) {
                buttons.add(new Button("\u5e76\u884c\u5ba1\u6279", "approveLine", null, null, true));
            } else if (TaskType.APPROVELINEED.getKey().equals(task.getStatus()) || TaskType.SIGNSEQUENCEED.getKey().equals(task.getStatus())) {
                buttons.add(new Button("\u540c\u610f", "agreeTrans"));
            } else if (TaskType.SIGNLINEED.getKey().equals(task.getStatus())) {
                buttons.add(new Button("\u540c\u610f", "agree"));
            }
            switch (nodeProperties.getUserNodeType()) {
                case "signSequence": {
                    buttons.add(new Button("\u987a\u5e8f\u7b7e\u7f72", "signSequence", null, null, true));
                    break;
                }
                case "signLine": {
                    buttons.add(new Button("\u5e76\u884c\u7b7e\u7f72", "signLine", null, null, true));
                }
            }
        }
    }

    private static void handTaskDelay(String taskId, BpmNodeDef bpmNodeDef, BpmDefExtProperties prop, Map<String, Button> buttonMap, List<Button> buttons2remove) throws Exception {
        if (!buttonMap.containsKey("taskDelay")) {
            return;
        }
        BpmTaskDueTimeManager bpmTaskDueTimeManager = (BpmTaskDueTimeManager)AppUtil.getBean(BpmTaskDueTimeManager.class);
        PortalFeignService PortalFeignService2 = (PortalFeignService)AppUtil.getBean(PortalFeignService.class);
        BpmTaskDueTime bpmTaskDueTime = bpmTaskDueTimeManager.getByTaskId(taskId);
        if (BeanUtils.isEmpty((Object)((Object)bpmTaskDueTime)) && buttonMap.containsKey("taskDelay")) {
            buttons2remove.add(buttonMap.get("taskDelay"));
            return;
        }
        int remainingTime = 0;
        if ("caltime".equals(bpmTaskDueTime.getDateType())) {
            remainingTime = TimeUtil.getSecondDiff((LocalDateTime)LocalDateTime.now(), (LocalDateTime)bpmTaskDueTime.getStartTime()) / 60;
        } else {
            ObjectNode params = JsonUtil.getMapper().createObjectNode();
            params.put("userId", bpmTaskDueTime.getUserId());
            params.put("startTime", DateFormatUtil.formaDatetTime((LocalDateTime)bpmTaskDueTime.getStartTime()));
            params.put("endTime", DateFormatUtil.formaDatetTime((LocalDateTime)LocalDateTime.now()));
            remainingTime = (int)(PortalFeignService2.getWorkTimeByUser(params) / 60000L);
        }
        remainingTime = bpmTaskDueTime.getDueTime() - remainingTime;
        if (remainingTime <= 0 && buttonMap.containsKey("taskDelay")) {
            buttons2remove.add(buttonMap.get("taskDelay"));
        }
    }

    private static void handDelegateButton(Map<String, Button> buttonMap, List<Button> buttons2remove, boolean isAllowTransTo) {
        boolean rtn = buttonMap.containsKey("delegate");
        if (!isAllowTransTo && rtn) {
            buttons2remove.add(buttonMap.get("delegate"));
        }
    }

    private static void handTransformAddButton(Map<String, Button> buttonMap, List<Button> buttons2remove, boolean isTransformAdd) {
        boolean rtn = buttonMap.containsKey("transformAdd");
        if (!isTransformAdd && rtn) {
            buttons2remove.add(buttonMap.get("transformAdd"));
        }
    }

    private static List<Button> getCommonButtons(List<Button> buttonsDef, String status) {
        ArrayList<Button> buttons = new ArrayList<Button>();
        TaskActionHandlerConfig config = (TaskActionHandlerConfig)AppUtil.getBean(TaskActionHandlerConfig.class);
        List<? extends TaskActionHandlerDef> listDef = config.getAllActionHandlerDefList();
        ArrayList<String> allActions = new ArrayList<String>();
        for (TaskActionHandlerDef taskActionHandlerDef : listDef) {
            allActions.add(taskActionHandlerDef.getName());
        }
        Map defButtonsMap = (Map)AppUtil.getBean((String)"buttonsMap");
        String string = (String)defButtonsMap.get(status);
        String[] aryDefault = null;
        if (string != null) {
            aryDefault = string.split(",");
        }
        if (aryDefault != null) {
            for (Button btn : buttonsDef) {
                if (allActions.contains(btn.getAlias()) && !BpmUtil.isInDefault(btn.getAlias(), aryDefault)) continue;
                buttons.add(btn);
            }
        }
        return buttons;
    }

    private static boolean isInDefault(String alias, String[] aryDefault) {
        for (String tmp : aryDefault) {
            if (!tmp.equals(alias)) continue;
            return true;
        }
        return false;
    }

    private static Map<String, Button> convertToMap(List<Button> buttons) {
        HashMap<String, Button> btnMap = new HashMap<String, Button>();
        for (Button btn : buttons) {
            btnMap.put(btn.getAlias(), btn);
        }
        return btnMap;
    }

    private static void handSignButtons(String taskId, BpmNodeDef bpmNodeDef, List<Button> buttons, List<Button> buttons2remove) throws Exception {
        if (!bpmNodeDef.getType().equals((Object)NodeType.SIGNTASK) || StringUtil.isEmpty((String)taskId)) {
            return;
        }
        NatTaskService natTaskService = (NatTaskService)AppUtil.getBean(NatTaskService.class);
        SignService signService = (SignService)AppUtil.getBean(SignService.class);
        Map<String, Object> variables = natTaskService.getVariables(taskId);
        List<PrivilegeMode> privilege = signService.getPrivilege(ContextUtil.getCurrentUserId(), (SignNodeDef)bpmNodeDef, variables);
        if (!privilege.contains((Object)PrivilegeMode.ALL) && !privilege.contains((Object)PrivilegeMode.ALLOW_ADD_SIGN)) {
            for (Button bnt : buttons) {
                if (!"addSign".equals(bnt.getAlias())) continue;
                buttons2remove.add(bnt);
                break;
            }
        }
    }

    private static void handLockButton(DefaultBpmTask task, List<Button> buttons, List<Button> buttons2remove) {
        if (task == null) {
            return;
        }
        String taskId = task.getTaskId();
        BpmTaskManager taskManager = (BpmTaskManager)AppUtil.getBean(BpmTaskManager.class);
        int canLock = taskManager.canLockTask(task, "");
        Button button = null;
        for (Button btn : buttons) {
            if (!btn.getAlias().equals("lockUnlock")) continue;
            button = btn;
        }
        if (button == null) {
            return;
        }
        if (canLock == 0 || canLock == 4 || canLock == 5 || canLock == 2) {
            buttons2remove.add(button);
        }
    }

    public static NodeProperties getNodeProperties(BpmProcessInstance instance, String nodeId) throws Exception {
        Object[] defProperties = BpmUtil.getDefProperties(instance, nodeId);
        Object obj = defProperties[0];
        if (BeanUtils.isNotEmpty((Object)obj) && obj instanceof NodeProperties) {
            return (NodeProperties)obj;
        }
        return null;
    }

    public static void handOpinion(String data, DefaultTaskFinishCmd cmd) throws IOException {
        if (StringUtil.isEmpty((String)data)) {
            return;
        }
        ObjectNode dataJson = (ObjectNode)JsonUtil.toJsonNode((String)data);
        if (!JsonUtil.isContainsKey((JsonNode)dataJson, (String)"__form_opinion")) {
            return;
        }
        ObjectNode opinionJson = (ObjectNode)JsonUtil.toJsonNode((String)dataJson.get("__form_opinion").asText());
        if (BeanUtils.isNotEmpty((Object)opinionJson)) {
            Iterator keys = opinionJson.fieldNames();
            while (keys.hasNext()) {
                String opinionName = (String)keys.next();
                String opinion = opinionJson.get(opinionName).asText();
                if (!StringUtil.isNotEmpty((String)opinion)) continue;
                cmd.setOpinionIdentity(opinionName);
                cmd.setApprovalOpinion(opinion);
                break;
            }
        }
        dataJson.remove("__form_opinion");
        data = dataJson.toString();
        cmd.setBusData(data);
    }

    public static int isHandlerValidNoCmd(String handler, Class<?>[] parameterTypes) {
        if (handler.indexOf(".") == -1) {
            return -1;
        }
        String[] aryHandler = handler.split("[.]");
        String beanId = aryHandler[0];
        String method = aryHandler[1];
        Object serviceBean = null;
        try {
            serviceBean = AppUtil.getBean((String)beanId);
        }
        catch (Exception ex) {
            return -2;
        }
        if (serviceBean == null) {
            return -2;
        }
        try {
            Method invokeMethod = serviceBean.getClass().getMethod(method, parameterTypes);
            if (invokeMethod != null) {
                return 0;
            }
            return -3;
        }
        catch (NoSuchMethodException e) {
            return -3;
        }
        catch (Exception e) {
            return -4;
        }
    }

    public static void restfulPluginExecut(DefaultBpmTask task, EventType eventType) throws Exception {
        BpmDefinitionAccessor bpmDefinitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean((String)"bpmDefinitionAccessor");
        BpmPluginFactory bpmPluginFactory = (BpmPluginFactory)AppUtil.getBean(BpmPluginFactory.class);
        RestfulService restfulService = (RestfulService)AppUtil.getBean(RestfulService.class);
        BpmProcessDef<BpmProcessDefExt> bpmProcessDef = bpmDefinitionAccessor.getBpmProcessDef(task.getProcDefId());
        List<BpmPluginContext> pluginContextList = bpmProcessDef.getProcessDefExt().getBpmPluginContexts();
        if (BeanUtils.isNotEmpty(pluginContextList)) {
            for (BpmPluginContext bpmPluginContext : pluginContextList) {
                IGlobalRestfulPluginDef restfulPluginDef;
                List<Restful> restfuls;
                BpmPluginDef bpmPluginDef = bpmPluginContext.getBpmPluginDef();
                if (!(bpmPluginDef instanceof BpmExecutionPluginDef)) continue;
                BpmExecutionPluginDef bpmExecutionPluginDef = (BpmExecutionPluginDef)bpmPluginDef;
                BpmExecutionPlugin bpmExecutionPlugin = bpmPluginFactory.buildExecutionPlugin(bpmPluginContext, eventType);
                if (bpmExecutionPlugin == null || !bpmPluginContext.getEventTypes().contains((Object)eventType) || !(bpmExecutionPluginDef instanceof IGlobalRestfulPluginDef) || !BeanUtils.isNotEmpty(restfuls = (restfulPluginDef = (IGlobalRestfulPluginDef)((Object)bpmExecutionPluginDef)).getRestfulList())) continue;
                restfulService.outTaskPluginExecute(task, restfuls, eventType);
            }
        }
        BpmNodeDef bpmNodeDef = bpmDefinitionAccessor.getBpmNodeDef(task.getProcDefId(), task.getNodeId());
        for (BpmPluginContext bpmPluginContext : bpmNodeDef.getBpmPluginContexts()) {
            IGlobalRestfulPluginDef restfulPluginDef;
            List<Restful> restfuls;
            BpmPluginDef bpmPluginDef;
            if (BeanUtils.isEmpty(bpmPluginContext.getEventTypes()) || !((bpmPluginDef = bpmPluginContext.getBpmPluginDef()) instanceof BpmTaskPluginDef)) continue;
            BpmTaskPluginDef bpmTaskPluginDef = (BpmTaskPluginDef)bpmPluginDef;
            BpmTaskPlugin bpmTaskPlugin = bpmPluginFactory.buildTaskPlugin(bpmPluginContext, eventType);
            if (bpmTaskPlugin == null || !bpmPluginContext.getEventTypes().contains((Object)eventType) || !(bpmTaskPluginDef instanceof IGlobalRestfulPluginDef) || !BeanUtils.isNotEmpty(restfuls = (restfulPluginDef = (IGlobalRestfulPluginDef)((Object)bpmTaskPluginDef)).getRestfulList())) continue;
            restfulService.outTaskPluginExecute(task, restfuls, eventType);
        }
    }

    public static String getRejectPreDestination(String taskId) throws Exception {
        boolean canRejectPreAct = true;
        BpmTaskManager bpmTaskManager = (BpmTaskManager)AppUtil.getBean((String)"bpmTaskManager");
        DefaultBpmTask task = (DefaultBpmTask)bpmTaskManager.get((Serializable)((Object)taskId));
        String defId = task.getProcDefId();
        String nodeId = task.getNodeId();
        boolean canReject = false;
        BpmDefinitionAccessor bpmDefinitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean((String)"bpmDefinitionAccessor");
        BpmNodeDef taskNodeDef = bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        List<Button> buttons = BpmUtil.getButtons(taskNodeDef, task);
        for (Button button : buttons) {
            if (!"reject".equals(button.getAlias())) continue;
            canReject = true;
        }
        if (!canReject) {
            return "";
        }
        NodeProperties nodeProperties = taskNodeDef.getLocalProperties();
        String backMode = nodeProperties.getBackMode();
        if (StringUtil.isEmpty((String)backMode)) {
            backMode = "normal";
        }
        String procInstId = task.getProcInstId();
        List<BpmNodeDef> listBpmNodeDef = BpmStackRelationUtil.getHistoryListBpmNodeDef(procInstId, task.getNodeId(), "pre");
        ArrayList<BpmNodeDef> bpmExeStacksUserNode = new ArrayList<BpmNodeDef>();
        ArrayList<BpmNodeDef> bpmExeStacksGoMapUserNode = new ArrayList<BpmNodeDef>();
        BpmExeStackRelationDao relationDao = (BpmExeStackRelationDao)AppUtil.getBean((String)"bpmExeStackRelationDaoImpl");
        List<BpmExeStackRelation> relationList = relationDao.getListByProcInstId(procInstId);
        for (BpmNodeDef node : listBpmNodeDef) {
            if (!node.getType().equals((Object)NodeType.USERTASK) && !node.getType().equals((Object)NodeType.SIGNTASK) || node.getNodeId().equals(nodeId)) continue;
            bpmExeStacksUserNode.add(node);
            boolean isHavePre = BpmStackRelationUtil.isHaveAndOrGateway(procInstId, node.getNodeId(), "pre", relationList);
            boolean isHaveAfter = BpmStackRelationUtil.isHaveAndOrGateway(procInstId, node.getNodeId(), "after", relationList);
            if (!isHavePre || !isHaveAfter) {
                bpmExeStacksGoMapUserNode.add(node);
                continue;
            }
            List<BpmNodeDef> incomeNodes = node.getIncomeNodes();
            if (!BeanUtils.isNotEmpty(incomeNodes)) continue;
            BpmNodeDef nodeDef = incomeNodes.get(0);
            if (!node.getType().equals((Object)NodeType.USERTASK) || !nodeDef.getType().equals((Object)NodeType.START) && !nodeDef.getType().equals((Object)NodeType.USERTASK)) continue;
            bpmExeStacksGoMapUserNode.add(node);
        }
        boolean bl = canRejectPreAct = bpmExeStacksGoMapUserNode.size() > 0 || bpmExeStacksUserNode.size() > 0;
        if (!canRejectPreAct) {
            return "";
        }
        if ("direct".equals(backMode)) {
            return ((BpmNodeDef)bpmExeStacksUserNode.get(0)).getNodeId();
        }
        return ((BpmNodeDef)bpmExeStacksGoMapUserNode.get(0)).getNodeId();
    }

    public static void setOpinionOrgInfo(String userId, DefaultBpmCheckOpinion bpmCheckOpinion) {
        try {
            UCFeignService ucFeignService = (UCFeignService)AppUtil.getBean(UCFeignService.class);
            ObjectNode mainGroup = ucFeignService.getMainGroup(userId);
            if (BeanUtils.isNotEmpty((Object)mainGroup)) {
                bpmCheckOpinion.setOrgId(mainGroup.get("id").asText());
                bpmCheckOpinion.setOrgPath(mainGroup.get("pathName").asText());
            }
        }
        catch (Exception e) {
            System.out.println("\u83b7\u53d6\u4eba\u5458\u6240\u5c5e\u90e8\u95e8\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public static Map<String, BpmNodeDef> getInGatewayNodeMap(BpmProcessDef<BpmProcessDefExt> bpmProcessDefExt) {
        HashMap<String, BpmNodeDef> map = new HashMap<String, BpmNodeDef>();
        List<BpmNodeDef> bpmnNodeDefs = bpmProcessDefExt.getBpmnNodeDefs();
        for (BpmNodeDef bpmNodeDef : bpmnNodeDefs) {
            String nodeType = bpmNodeDef.getType().getKey();
            if (NodeType.START.getKey().equals(nodeType) || NodeType.END.getKey().equals(nodeType) || NodeType.EXCLUSIVEGATEWAY.getKey().equals(nodeType) || NodeType.PARALLELGATEWAY.getKey().equals(nodeType) || NodeType.INCLUSIVEGATEWAY.getKey().equals(nodeType)) continue;
            HashMap<String, Boolean> gatewayNodeCount = new HashMap<String, Boolean>();
            gatewayNodeCount.put("afterHasGateWay", false);
            gatewayNodeCount.put("afterHasEnd", false);
            gatewayNodeCount.put("beforeHasGateStart", false);
            gatewayNodeCount.put("beforeHasStart", false);
            HashSet<String> nodeIds = new HashSet<String>();
            BpmUtil.afterFindGateWayEnd(bpmNodeDef, gatewayNodeCount, nodeIds);
            if (((Boolean)gatewayNodeCount.get("afterHasGateWay")).booleanValue()) {
                map.put(bpmNodeDef.getNodeId(), bpmNodeDef);
                continue;
            }
            if (((Boolean)gatewayNodeCount.get("afterHasEnd")).booleanValue()) continue;
            nodeIds = new HashSet();
            BpmUtil.beforeFindGateWayStart(bpmNodeDef, gatewayNodeCount, nodeIds);
            if (((Boolean)gatewayNodeCount.get("beforeHasGateStart")).booleanValue()) {
                map.put(bpmNodeDef.getNodeId(), bpmNodeDef);
                continue;
            }
            if (!((Boolean)gatewayNodeCount.get("beforeHasStart")).booleanValue()) continue;
        }
        return map;
    }

    private static void beforeFindGateWayStart(BpmNodeDef startNode, Map<String, Boolean> count, Set<String> nodeIds) {
        List<BpmNodeDef> outcomeNodes = startNode.getIncomeNodes();
        for (BpmNodeDef bpmNodeDef : outcomeNodes) {
            String nodeType = bpmNodeDef.getType().getKey();
            if (NodeType.PARALLELGATEWAY.getKey().equals(nodeType) || NodeType.INCLUSIVEGATEWAY.getKey().equals(nodeType)) {
                if (bpmNodeDef.getIncomeNodes().size() == 1 && bpmNodeDef.getOutcomeNodes().size() > 1) {
                    count.put("beforeHasGateStart", true);
                    return;
                }
                return;
            }
            if (NodeType.START.getKey().equals(nodeType)) {
                count.put("beforeHasStart", true);
                return;
            }
            if (nodeIds.contains(bpmNodeDef.getNodeId())) continue;
            nodeIds.add(bpmNodeDef.getNodeId());
            BpmUtil.beforeFindGateWayStart(bpmNodeDef, count, nodeIds);
        }
    }

    private static void afterFindGateWayEnd(BpmNodeDef startNode, Map<String, Boolean> count, Set<String> nodeIds) {
        List<BpmNodeDef> outcomeNodes = startNode.getOutcomeNodes();
        for (BpmNodeDef bpmNodeDef : outcomeNodes) {
            String nodeType = bpmNodeDef.getType().getKey();
            if (NodeType.PARALLELGATEWAY.getKey().equals(nodeType) || NodeType.INCLUSIVEGATEWAY.getKey().equals(nodeType)) {
                if (bpmNodeDef.getIncomeNodes().size() > 1 && bpmNodeDef.getOutcomeNodes().size() == 1) {
                    count.put("afterHasGateWay", true);
                    return;
                }
                return;
            }
            if (NodeType.END.getKey().equals(nodeType)) {
                count.put("afterHasEnd", true);
                return;
            }
            if (nodeIds.contains(bpmNodeDef.getNodeId())) continue;
            nodeIds.add(bpmNodeDef.getNodeId());
            BpmUtil.afterFindGateWayEnd(bpmNodeDef, count, nodeIds);
        }
    }

    public static Map<String, BpmNodeDef> getNodesByDirection(BpmNodeDef startNode, String direction) {
        if (StringUtil.isEmpty((String)direction)) {
            direction = "pre";
        }
        HashMap<String, BpmNodeDef> map = new HashMap<String, BpmNodeDef>();
        BpmUtil.getNodesByDirection(map, startNode, direction);
        return map;
    }

    private static void getNodesByDirection(Map<String, BpmNodeDef> map, BpmNodeDef startNode, String direction) {
        List<BpmNodeDef> nodes = startNode.getOutcomeNodes();
        if ("pre".equals(direction)) {
            nodes = startNode.getIncomeNodes();
        }
        if (BeanUtils.isNotEmpty(nodes)) {
            for (BpmNodeDef bpmNodeDef : nodes) {
                if (map.containsKey(bpmNodeDef.getNodeId())) continue;
                map.put(bpmNodeDef.getNodeId(), bpmNodeDef);
                BpmUtil.getNodesByDirection(map, bpmNodeDef, direction);
            }
        }
    }

    public static Map<String, BpmNodeDef> getDeleteTaskNodesAndTargetNode(String procDefId, String procInstId, BpmNodeDef bpmNodeDef, String destination) {
        Map<String, BpmNodeDef> deleteTaskNodes = BpmUtil.getDeleteTaskNodes(bpmNodeDef, destination);
        List<BpmNodeDef> rejectTargetNode = BpmStackRelationUtil.getRejectTargetNode(procDefId, procInstId, new ArrayList<String>(deleteTaskNodes.keySet()));
        ((List)Optional.ofNullable(rejectTargetNode).orElse(new ArrayList())).stream().forEach(action -> deleteTaskNodes.put(action.getNodeId(), (BpmNodeDef)action));
        BpmTaskManager bpmTaskManager = (BpmTaskManager)AppUtil.getBean(BpmTaskManager.class);
        List<String> nodeIds = bpmTaskManager.getNodeIdByProcInstId(procInstId);
        Map<String, BpmNodeDef> resultDeleteTaskNodes = deleteTaskNodes.entrySet().stream().filter(predicate -> nodeIds.contains(predicate.getKey())).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (BpmNodeDef)e.getValue()));
        return resultDeleteTaskNodes;
    }

    @Deprecated
    public static Map<String, BpmNodeDef> getDeleteTaskNodes(BpmNodeDef afterNode, String beforNodeId) {
        HashMap<String, BpmNodeDef> nodeMap = new HashMap<String, BpmNodeDef>();
        if (BeanUtils.isEmpty((Object)afterNode)) {
            return nodeMap;
        }
        BpmNodeDef parentBpmNodeDef = afterNode.getParentBpmNodeDef();
        if (BeanUtils.isNotEmpty((Object)parentBpmNodeDef) && parentBpmNodeDef instanceof SubProcessNodeDef) {
            SubProcessNodeDef subProcessNodeDef = (SubProcessNodeDef)parentBpmNodeDef;
            List<BpmNodeDef> bpmnNodeDefs = subProcessNodeDef.getChildBpmProcessDef().getBpmnNodeDefs();
            for (BpmNodeDef bpmNodeDef : bpmnNodeDefs) {
                nodeMap.put(bpmNodeDef.getNodeId(), bpmNodeDef);
            }
            return nodeMap;
        }
        String processDefinitionId = afterNode.getBpmProcessDef().getProcessDefinitionId();
        BpmDefinitionAccessor bpmDefinitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean(BpmDefinitionAccessor.class);
        BpmNodeDef bpmNodeDef = null;
        Map<Object, Object> inGatewayNodeMap = new HashMap();
        try {
            bpmNodeDef = bpmDefinitionAccessor.getBpmNodeDef(processDefinitionId, beforNodeId);
            inGatewayNodeMap = BpmUtil.getInGatewayNodeMap(bpmDefinitionAccessor.getBpmProcessDef(processDefinitionId));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (inGatewayNodeMap.containsKey(afterNode.getNodeId()) && !inGatewayNodeMap.containsKey(beforNodeId)) {
            return BpmUtil.getNodesByDirection(bpmNodeDef, "after");
        }
        Map<String, BpmNodeDef> beforeNodes = BpmUtil.getNodesByDirection(afterNode, "");
        if (beforeNodes.containsKey(beforNodeId)) {
            BpmUtil.getBetweenNodes(afterNode, nodeMap, beforNodeId);
            nodeMap.put(afterNode.getNodeId(), afterNode);
        } else if (BeanUtils.isNotEmpty((Object)bpmNodeDef)) {
            BpmUtil.getBetweenNodes(bpmNodeDef, nodeMap, afterNode.getNodeId());
            nodeMap.put(bpmNodeDef.getNodeId(), bpmNodeDef);
        }
        return nodeMap;
    }

    public static void getBetweenNodes(BpmNodeDef startNode, Map<String, BpmNodeDef> nodeMap, String endNdeId) {
        List<BpmNodeDef> nodes = startNode.getIncomeNodes();
        if (BeanUtils.isNotEmpty(nodes)) {
            for (BpmNodeDef bpmNodeDef : nodes) {
                if (bpmNodeDef.getType().equals((Object)NodeType.START) && !nodeMap.containsKey(endNdeId)) {
                    nodeMap.clear();
                    return;
                }
                if (endNdeId.equals(bpmNodeDef.getNodeId()) || nodeMap.containsKey(endNdeId)) {
                    nodeMap.put(bpmNodeDef.getNodeId(), bpmNodeDef);
                    return;
                }
                if (nodeMap.containsKey(bpmNodeDef.getNodeId())) continue;
                nodeMap.put(bpmNodeDef.getNodeId(), bpmNodeDef);
                BpmUtil.getBetweenNodes(bpmNodeDef, nodeMap, endNdeId);
            }
        }
    }

    public static void clearCacheByDefId(String defId) {
        BpmDefinitionManager bpmDefinitionManager = (BpmDefinitionManager)AppUtil.getBean(BpmDefinitionManager.class);
        DefaultBpmDefinition defaultBpmDefinition = (DefaultBpmDefinition)bpmDefinitionManager.get((Serializable)((Object)defId));
        Assert.notNull((Object)defaultBpmDefinition, (String)String.format("\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49id\u3010%s\u3011\u672a\u627e\u5230\u6d41\u7a0b\u5b9a\u4e49", defId));
        AppUtil.publishEvent((ApplicationEvent)new BpmDefinitionDelEvent(defaultBpmDefinition));
    }

    public static void clearCacheByDefIds(List<String> defIds) {
        BpmDefinitionManager bpmDefinitionManager = (BpmDefinitionManager)AppUtil.getBean(BpmDefinitionManager.class);
        List defaultBpmDefinitions = bpmDefinitionManager.listByIds(defIds);
        for (DefaultBpmDefinition defaultBpmDefinition : defaultBpmDefinitions) {
            AppUtil.publishEvent((ApplicationEvent)new BpmDefinitionDelEvent(defaultBpmDefinition));
        }
    }

    public static List<BpmNodeDef> getSubProcessNodes(List<BpmNodeDef> bpmnNodes) {
        return BpmUtil.getSubProcessNodes(bpmnNodes, false);
    }

    public static List<BpmNodeDef> getSubProcessNodes(List<BpmNodeDef> bpmnNodes, boolean justUserNode) {
        ArrayList<BpmNodeDef> bpmnNodeDefs = new ArrayList<BpmNodeDef>();
        if (BeanUtils.isEmpty(bpmnNodes)) {
            return bpmnNodeDefs;
        }
        BpmUtil.getSubProcessNodes(bpmnNodes, bpmnNodeDefs, justUserNode);
        return bpmnNodeDefs;
    }

    private static void getSubProcessNodes(List<BpmNodeDef> bpmNodeDefs, List<BpmNodeDef> rtnList, boolean justUserNode) {
        for (BpmNodeDef def : bpmNodeDefs) {
            SubProcessNodeDef subProcessNodeDef;
            BpmProcessDef<? extends BpmProcessDefExt> processDef;
            NodeType nodeType = def.getType();
            if (!justUserNode) {
                rtnList.add(def);
            } else if (nodeType == NodeType.START || nodeType == NodeType.USERTASK || nodeType == NodeType.SIGNTASK) {
                rtnList.add(def);
            }
            if (!NodeType.SUBPROCESS.equals((Object)def.getType()) || (processDef = (subProcessNodeDef = (SubProcessNodeDef)def).getChildBpmProcessDef()) == null) continue;
            List<BpmNodeDef> subBpmNodeDefs = processDef.getBpmnNodeDefs();
            BpmUtil.getSubProcessNodes(subBpmNodeDefs, rtnList, justUserNode);
        }
    }

    public static String checkDefForbidStatus(String defId, String instanceId, String taskId) {
        BpmProcessInstanceManager bpmProcessInstanceManager = (BpmProcessInstanceManager)AppUtil.getBean(BpmProcessInstanceManager.class);
        String defStatus = bpmProcessInstanceManager.getDefForbidStatus(defId, instanceId, taskId);
        if (defStatus.indexOf("1") > -1) {
            throw new BaseException("\u6d41\u7a0b\u5b9e\u4f8b\u5df2\u88ab\u6302\u8d77\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (defStatus.indexOf("3") > -1) {
            throw new BaseException("\u6d41\u7a0b\u5b9a\u4e49\u5df2\u88ab\u7981\u6b62\u5b9e\u4f8b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return defStatus;
    }

    public static void commentsBackFill(String procDefId, String opinion, ObjectNode boData, String nodeId) throws Exception {
        BpmProcessDef<BpmProcessDefExt> procDef = BpmUtil.getProcessDefByDefId(procDefId);
        for (int i = 0; i < procDef.getBpmnNodeDefs().size(); ++i) {
            if (!procDef.getBpmnNodeDefs().get(i).getNodeId().equals(nodeId) || procDef.getBpmnNodeDefs().get(i).getNodeProperties().size() < 1) continue;
            for (int k = 0; k < procDef.getBpmnNodeDefs().get(i).getNodeProperties().size(); ++k) {
                NodeProperties nodeProperties = procDef.getBpmnNodeDefs().get(i).getNodeProperties().get(k);
                if (!BeanUtils.isNotEmpty((Object)nodeProperties.getOpinionField())) continue;
                try {
                    String opinionField = nodeProperties.getOpinionField();
                    ObjectNode boDataZhu = (ObjectNode)boData.get(opinionField.split("\\.")[0]);
                    if (nodeProperties.isAppendOpinion()) {
                        boDataZhu.put(opinionField.split("\\.")[1], opinion);
                        continue;
                    }
                    if (BeanUtils.isNotEmpty((Object)boDataZhu.get(opinionField.split("\\.")[1]))) {
                        opinion = JsonUtil.getString((JsonNode)boDataZhu, (String)opinionField.split("\\.")[1]) + "   \n" + opinion;
                        boDataZhu.put(opinionField.split("\\.")[1], opinion);
                        continue;
                    }
                    boDataZhu.put(opinionField.split("\\.")[1], opinion);
                    continue;
                }
                catch (Exception e) {
                    throw new Exception("\u610f\u89c1\u56de\u586b\u914d\u7f6e\u6709\u8bef\uff01\u8bf7\u68c0\u67e5\u610f\u89c1\u56de\u586b\u914d\u7f6e");
                }
            }
        }
    }

    public static BpmTask convertTask(BpmDelegateTask delegateTask, List<BpmIdentity> identityList) throws Exception {
        BpmIdentity identity;
        String taskId = delegateTask.getId();
        String subject = (String)delegateTask.getVariable("subject_");
        String instId = (String)delegateTask.getVariable("instanceId_");
        String bpmnDefId = delegateTask.getBpmnDefId();
        BpmDefinitionService bpmDefinitionService = (BpmDefinitionService)AppUtil.getBean(BpmDefinitionService.class);
        DefaultBpmDefinition def = (DefaultBpmDefinition)bpmDefinitionService.getByBpmnDefId(bpmnDefId);
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        BpmProcessInstance bpmProcessInstance = (BpmProcessInstance)cmd.getTransitVars("processInstance");
        if (!subject.equals(bpmProcessInstance.getSubject())) {
            subject = bpmProcessInstance.getSubject();
            delegateTask.setVariableLocal("subject_", subject);
        }
        BpmFormService bpmFormService = BpmFormFactory.getFormService(FormType.MOBILE);
        FormModel formModel = bpmFormService.getByDefId(def.getId(), delegateTask.getTaskDefinitionKey(), bpmProcessInstance, true);
        int supportMobile = 0;
        if (formModel != null && !formModel.isFormEmpty()) {
            supportMobile = 1;
        }
        DefaultBpmTask task = new DefaultBpmTask();
        task.setId(taskId);
        task.setSubject(subject);
        BpmDefinitionAccessor bpmDefinitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean(BpmDefinitionAccessor.class);
        BpmProcessInstanceManager bpmProcessInstanceManager = (BpmProcessInstanceManager)AppUtil.getBean(BpmProcessInstanceManager.class);
        BpmProcessDef<BpmProcessDefExt> processDef = bpmDefinitionAccessor.getBpmProcessDef(bpmProcessInstance.getProcDefId());
        if (ContextThreadUtil.getActionCmd() instanceof ProcessInstCmd) {
            String calSubject = bpmProcessInstanceManager.getSubject(processDef, (ProcessInstCmd)ContextThreadUtil.getActionCmd(), (DefaultBpmProcessInstance)bpmProcessInstance);
            task.setSubject(calSubject);
        }
        task.setTaskId(taskId);
        task.setDueTime(delegateTask.getDueDate());
        task.setSuspendState((short)delegateTask.getSuspensionState());
        task.setExecId(delegateTask.getExecutionId());
        task.setName(delegateTask.getName());
        task.setNodeId(delegateTask.getTaskDefinitionKey());
        task.setProcInstId(instId);
        task.setBpmnInstId(delegateTask.getProcessInstanceId());
        task.setOwnerId("0");
        task.setAssigneeId("0");
        task.setPriority(Long.valueOf(delegateTask.getPriority()));
        task.setProcDefId(def.getDefId());
        task.setProcDefKey(def.getDefKey());
        task.setProcDefName(def.getName());
        task.setStatus(TaskType.NORMAL.name());
        task.setBpmnDefId(bpmnDefId);
        task.setTypeId(def.getTypeId());
        task.setSupportMobile(supportMobile);
        task.setCreateTime(delegateTask.getCreateTime());
        if (BeanUtils.isNotEmpty((Object)cmd) && cmd.getTransitVars().containsKey("target_node")) {
            task.setTargetNode((String)cmd.getTransitVars().get("target_node"));
        }
        if (ActionType.BACK.getKey().equals(cmd.getActionName()) || ActionType.BACK_TO_START.getKey().equals(cmd.getActionName()) || ActionType.REJECT.getKey().equals(cmd.getActionName())) {
            task.setStatus(TaskType.BACK.name());
        } else if (ActionType.RECOVER.getKey().equals(cmd.getActionName()) || ActionType.RECOVER_TO_START.getKey().equals(cmd.getActionName())) {
            task.setStatus(TaskType.RECOVER.name());
        }
        if (identityList != null && identityList.size() == 1 && "user".equals((identity = identityList.get(0)).getType())) {
            task.setAssigneeId(identity.getId());
            task.setAssigneeName(identity.getName());
            delegateTask.setAssignee(identity.getId());
            delegateTask.setOwner(identity.getId());
            task.setOwnerId(identity.getId());
            task.setOwnerName(identity.getName());
        }
        return task;
    }

    public static boolean isCompletedByTaskStatus(String taskStatus) {
        return TaskType.TRANSFORMING.getKey().equals(taskStatus);
    }

    public static List<NodeInMulti> getNodeInMulti(List<BpmNodeDef> allNodeDef) throws Exception {
        ArrayList<NodeInMulti> nodeInMultis = new ArrayList<NodeInMulti>();
        NodeInMulti.conver2NodeInMulti(allNodeDef, NodeInMulti.findGatewayOrSubProcessNodes(allNodeDef), nodeInMultis);
        return BpmUtil.deleteDuplicateNodeInMulti(nodeInMultis);
    }

    private static List<NodeInMulti> deleteDuplicateNodeInMulti(List<NodeInMulti> nodeInMultis) {
        if (BeanUtils.isNotEmpty(nodeInMultis) || nodeInMultis.size() == 1) {
            return nodeInMultis;
        }
        HashSet<String> nodeIds = new HashSet<String>();
        BpmUtil.childrenNodeInMulti(nodeInMultis, nodeIds);
        List<NodeInMulti> resultNodeInMultis = nodeInMultis.stream().filter(predicate -> !nodeIds.contains(predicate.getStartNodeId() + predicate.getEndNodeId())).collect(Collectors.toList());
        return resultNodeInMultis;
    }

    private static void childrenNodeInMulti(List<NodeInMulti> nodeInMultis, Set<String> nodeIds) {
        if (BeanUtils.isEmpty(nodeInMultis)) {
            return;
        }
        nodeInMultis.stream().forEach(nodeInMulti -> nodeInMulti.getChildrens().stream().forEach(children -> {
            nodeIds.add(children.getStartNodeId() + "" + children.getEndNodeId());
            BpmUtil.childrenNodeInMulti(nodeInMultis, nodeIds);
        }));
    }

    public static DefaultTaskFinishCmd buildRevokeCmd(String taskId, String actionName, String opinion, String backHandMode, String toNodeId, BpmIdentity bpmIdentity) {
        DefaultTaskFinishCmd cmd = new DefaultTaskFinishCmd();
        cmd.setDestination(toNodeId);
        cmd.setTaskId(taskId);
        cmd.setActionName(actionName);
        cmd.addTransitVars("IsDoneUnused", true);
        cmd.setApprovalOpinion(opinion);
        cmd.setDataMode("bo");
        cmd.addTransitVars("backHandMode", backHandMode);
        if (BeanUtils.isNotEmpty((Object)bpmIdentity)) {
            ArrayList<BpmIdentity> list = new ArrayList<BpmIdentity>();
            list.add(bpmIdentity);
            HashMap<String, List<BpmIdentity>> nodeIdentityMap = new HashMap<String, List<BpmIdentity>>();
            nodeIdentityMap.put(toNodeId, list);
            cmd.setBpmIdentities(nodeIdentityMap);
        }
        ContextThreadUtil.setActionCmd(cmd);
        return cmd;
    }

    public static Boolean buildRejectCmd(String taskId, String actionName, String currentTaskActionName, Map<String, ObjectNode> finalFormBoData, Boolean direct) {
        try {
            DefaultTaskFinishCmd defaultTaskFinishCmd = new DefaultTaskFinishCmd();
            if (!defaultTaskFinishCmd.taskExists(taskId).booleanValue()) {
                return false;
            }
            defaultTaskFinishCmd.setTaskId(taskId);
            defaultTaskFinishCmd.setActionName(actionName);
            if (REJECT_ACTION_NAMES.contains(currentTaskActionName)) {
                defaultTaskFinishCmd.addTransitVars("back_other_task_cancle", true);
            }
            if (RECOVER_ACTION_NAMES.contains(currentTaskActionName)) {
                defaultTaskFinishCmd.addTransitVars("IsDoneUnused", true);
            }
            defaultTaskFinishCmd.addTransitVars("first_action_name", currentTaskActionName);
            if (direct.booleanValue()) {
                defaultTaskFinishCmd.addTransitVars("signDirect", "1");
            }
            defaultTaskFinishCmd.setDataMode("bo");
            defaultTaskFinishCmd.addTransitVars("bo_inst_", finalFormBoData);
            ContextThreadUtil.setActionCmd(defaultTaskFinishCmd);
            return true;
        }
        catch (Exception e) {
            throw new BaseException("\u9a73\u56de\u62a5\u9519" + e.getMessage(), (Throwable)e);
        }
    }

    static {
        REJECT_ACTION_NAMES = Arrays.asList("reject", "backToStart");
        RECOVER_ACTION_NAMES = Arrays.asList("recover", "recoverToStart");
    }
}

