/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.util;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class ParserUtil {
    private static final Pattern pattern = Pattern.compile("\\$\\{(.*?)\\}");
    private static Matcher matcher;

    public static String replaceWithMap(String sourceString, Map<String, Object> param) {
        if (Strings.isNullOrEmpty((String)sourceString) || CollectionUtils.isEmpty(param)) {
            return sourceString;
        }
        String targetString = sourceString;
        matcher = pattern.matcher(sourceString);
        while (matcher.find()) {
            try {
                String key = matcher.group();
                String keyclone = key.substring(2, key.length() - 1).trim();
                Object value = param.get(keyclone);
                if (value == null) continue;
                targetString = targetString.replace(key, value.toString());
            }
            catch (Exception e) {
                throw new RuntimeException("String formatter failed", e);
            }
        }
        return targetString;
    }

    public static String replaceWithObject(String sourceString, Object param) {
        if (Strings.isNullOrEmpty((String)sourceString) || ObjectUtils.isEmpty((Object)param)) {
            return sourceString;
        }
        String targetString = sourceString;
        matcher = pattern.matcher(sourceString);
        while (matcher.find()) {
            String key = matcher.group();
            String holderName = key.substring(2, key.length() - 1).trim();
            try {
                PropertyDescriptor pd = new PropertyDescriptor(holderName, param.getClass());
                Method getMethod = pd.getReadMethod();
                Object value = getMethod.invoke(param, new Object[0]);
                if (value == null) continue;
                targetString = targetString.replace(key, value.toString());
            }
            catch (Exception e) {
                throw new RuntimeException("String formatter failed", e);
            }
        }
        return targetString;
    }

    public static Set<String> findPlaceHolderKeys(String sourceString, Pattern pattern) {
        Set placeHolderSet = Sets.newConcurrentHashSet();
        if (Strings.isNullOrEmpty((String)sourceString) || ObjectUtils.isEmpty((Object)pattern)) {
            return placeHolderSet;
        }
        String targetString = sourceString;
        matcher = pattern.matcher(sourceString);
        while (matcher.find()) {
            String key = matcher.group();
            String placeHolder = key.substring(2, key.length() - 1).trim();
            placeHolderSet.add(placeHolder);
        }
        return placeHolderSet;
    }

    public static Map<String, Object> transStringToMap(String mapString, String separator, String pairSeparator) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] fSplit = mapString.split(separator);
        for (int i = 0; i < fSplit.length; ++i) {
            if (fSplit[i] == null || fSplit[i].length() == 0) continue;
            String[] sSplit = fSplit[i].split(pairSeparator);
            String value = fSplit[i].substring(fSplit[i].indexOf(61) + 1, fSplit[i].length());
            map.put(sSplit[0], value);
        }
        return map;
    }
}

