/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.api.model.process.nodedef;

import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.constant.NodeType;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.SubProcessNodeDef;
import com.hotent.bpm.util.BpmUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class NodeInMulti
implements Serializable {
    private String startNodeId;
    private String endNodeId;
    private BpmNodeDef bpmNodeDef;
    List<BpmNodeDef> bpmNodeDefList;
    List<NodeInMulti> childrens;
    private NodeInMulti parentNodeInMulti;

    public BpmNodeDef getBpmNodeDef() {
        return this.bpmNodeDef;
    }

    public void setBpmNodeDef(BpmNodeDef bpmNodeDef) {
        this.bpmNodeDef = bpmNodeDef;
    }

    public NodeInMulti getParentNodeInMulti() {
        return this.parentNodeInMulti;
    }

    public void setParentNodeInMulti(NodeInMulti parentNodeInMulti) {
        this.parentNodeInMulti = parentNodeInMulti;
    }

    public NodeInMulti() {
    }

    public NodeInMulti(BpmNodeDef bpmNodeDef, String startGatewayNodeId, String endGatewayNodeId, List<BpmNodeDef> bpmNodeDefList, List<BpmNodeDef> allNodeDef) {
        this.bpmNodeDef = bpmNodeDef;
        this.startNodeId = startGatewayNodeId;
        this.endNodeId = endGatewayNodeId;
        this.bpmNodeDefList = BpmUtil.getSubProcessNodes(bpmNodeDefList);
        ArrayList<NodeInMulti> nodeInMultis = new ArrayList<NodeInMulti>();
        NodeInMulti.conver2NodeInMulti(allNodeDef, NodeInMulti.findGatewayOrSubProcessNodes(bpmNodeDefList), nodeInMultis);
        this.childrens = nodeInMultis;
        this.childrens.stream().forEach(action -> action.setParentNodeInMulti(this));
    }

    public static List<BpmNodeDef> findGatewayOrSubProcessNodes(List<BpmNodeDef> nodeDefs) {
        ArrayList<String> gatewayList = new ArrayList<String>();
        gatewayList.add(NodeType.PARALLELGATEWAY.getKey());
        gatewayList.add(NodeType.INCLUSIVEGATEWAY.getKey());
        gatewayList.add(NodeType.SUBPROCESS.getKey());
        List<BpmNodeDef> gatewayBpmNodeDefs = nodeDefs.stream().filter(bpmNodeDef -> gatewayList.contains(bpmNodeDef.getType().getKey()) && bpmNodeDef.getIncomeNodes().size() == 1).collect(Collectors.toList());
        return gatewayBpmNodeDefs;
    }

    public static void conver2NodeInMulti(List<BpmNodeDef> allNodeDef, List<BpmNodeDef> gatewayBpmNodeDefs, List<NodeInMulti> nodeInMultis) {
        ArrayList<String> gatewayList = new ArrayList<String>();
        gatewayList.add(NodeType.PARALLELGATEWAY.getKey());
        gatewayList.add(NodeType.INCLUSIVEGATEWAY.getKey());
        if (BeanUtils.isNotEmpty(gatewayBpmNodeDefs)) {
            gatewayBpmNodeDefs.forEach(bpmNodeDef -> {
                NodeType type = bpmNodeDef.getType();
                NodeInMulti nodeInMulti = null;
                if (gatewayList.contains(type.getKey())) {
                    List<BpmNodeDef> outcomeNodes = bpmNodeDef.getOutcomeNodes();
                    ArrayList<String> findNodeIds = new ArrayList<String>();
                    LinkedHashMap<String, AtomicInteger> gateWayCount = new LinkedHashMap<String, AtomicInteger>();
                    NodeInMulti.collectGateWay(outcomeNodes, gateWayCount, type, findNodeIds);
                    String endGateWayNodeId = NodeInMulti.getFirstEndGateWayNodeId(gateWayCount, outcomeNodes.size(), allNodeDef);
                    if (StringUtil.isNotEmpty((String)endGateWayNodeId)) {
                        ArrayList<BpmNodeDef> nodeInGatewayList = new ArrayList<BpmNodeDef>();
                        findNodeIds = new ArrayList();
                        NodeInMulti.collectNodeInGateway(outcomeNodes, endGateWayNodeId, nodeInGatewayList, findNodeIds);
                        nodeInMulti = new NodeInMulti((BpmNodeDef)bpmNodeDef, bpmNodeDef.getNodeId(), endGateWayNodeId, (List<BpmNodeDef>)nodeInGatewayList, allNodeDef);
                    }
                } else {
                    SubProcessNodeDef subProcessNodeDef = (SubProcessNodeDef)bpmNodeDef;
                    String startNodeId = subProcessNodeDef.getChildBpmProcessDef().getStartEvent().getNodeId();
                    String endNodeId = subProcessNodeDef.getChildBpmProcessDef().getEndEvents().get(0).getNodeId();
                    List<BpmNodeDef> subProcessAllbpmnNodeDefs = subProcessNodeDef.getChildBpmProcessDef().getBpmnNodeDefs();
                    nodeInMulti = new NodeInMulti((BpmNodeDef)bpmNodeDef, startNodeId, endNodeId, subProcessAllbpmnNodeDefs, subProcessAllbpmnNodeDefs);
                }
                nodeInMultis.add(nodeInMulti);
            });
        }
    }

    private static void collectNodeInGateway(List<BpmNodeDef> outcomeNodes, String endGateWayNodeId, List<BpmNodeDef> nodeInGatewayList, List<String> findNodeIds) {
        if (BeanUtils.isEmpty(outcomeNodes)) {
            return;
        }
        outcomeNodes.stream().forEach(outcomeNode -> {
            if (!endGateWayNodeId.equals(outcomeNode.getNodeId()) && !findNodeIds.contains(outcomeNode.getNodeId())) {
                nodeInGatewayList.add((BpmNodeDef)outcomeNode);
                findNodeIds.add(outcomeNode.getNodeId());
                NodeInMulti.collectNodeInGateway(outcomeNode.getOutcomeNodes(), endGateWayNodeId, nodeInGatewayList, findNodeIds);
                return;
            }
        });
    }

    private static void collectGateWay(List<BpmNodeDef> outcomeNodes, Map<String, AtomicInteger> gateWayCount, NodeType nodeType, List<String> findNodeIds) {
        if (BeanUtils.isEmpty(outcomeNodes)) {
            return;
        }
        outcomeNodes.stream().forEach(outcomeNode -> {
            if (findNodeIds.contains(outcomeNode.getNodeId())) {
                return;
            }
            if (nodeType.getKey().equals(outcomeNode.getType().getKey())) {
                AtomicInteger atomicInteger = new AtomicInteger(1);
                if (gateWayCount.containsKey(outcomeNode.getNodeId())) {
                    atomicInteger = (AtomicInteger)gateWayCount.get(outcomeNode.getNodeId());
                    atomicInteger.addAndGet(1);
                }
                gateWayCount.put(outcomeNode.getNodeId(), atomicInteger);
            }
            if (!findNodeIds.contains(outcomeNode.getNodeId())) {
                findNodeIds.add(outcomeNode.getNodeId());
                NodeInMulti.collectGateWay(outcomeNode.getOutcomeNodes(), gateWayCount, nodeType, findNodeIds);
            }
        });
    }

    private static String getFirstEndGateWayNodeId(Map<String, AtomicInteger> gateWayCount, int size, List<BpmNodeDef> allNodeDef) {
        if (BeanUtils.isEmpty(gateWayCount)) {
            return null;
        }
        Collection<AtomicInteger> values = gateWayCount.values();
        List collect = values.stream().map(AtomicInteger::get).collect(Collectors.toList());
        Integer max = (Integer)Collections.max(collect);
        for (String nodeId : gateWayCount.keySet()) {
            Optional<BpmNodeDef> first;
            if (max.intValue() != gateWayCount.get(nodeId).get() || !(first = allNodeDef.stream().filter(predicate -> nodeId.equals(predicate.getNodeId())).findFirst()).isPresent() || first.get().getIncomeNodes().size() != size || first.get().getOutcomeNodes().size() != 1) continue;
            return nodeId;
        }
        return null;
    }

    public String getStartNodeId() {
        return this.startNodeId;
    }

    public void setStartNodeId(String startNodeId) {
        this.startNodeId = startNodeId;
    }

    public String getEndNodeId() {
        return this.endNodeId;
    }

    public void setEndNodeId(String endNodeId) {
        this.endNodeId = endNodeId;
    }

    public List<BpmNodeDef> getBpmNodeDefList() {
        return this.bpmNodeDefList;
    }

    public void setBpmNodeDefList(List<BpmNodeDef> bpmNodeDefList) {
        this.bpmNodeDefList = bpmNodeDefList;
    }

    public List<NodeInMulti> getChildrens() {
        return this.childrens;
    }

    public void setChildrens(List<NodeInMulti> childrens) {
        this.childrens = childrens;
    }

    public List<String> getAllNodeIdInMulti() {
        ArrayList<String> nodeIds = new ArrayList<String>();
        this.recursionGetAllNodeId(nodeIds, this.bpmNodeDefList);
        return nodeIds;
    }

    private void recursionGetAllNodeId(List<String> nodeIds, List<BpmNodeDef> bpmNodeDefList) {
        bpmNodeDefList.stream().forEach(bpmNodeDef -> {
            nodeIds.add(bpmNodeDef.getNodeId());
            if (NodeType.SUBPROCESS.equals((Object)bpmNodeDef.getType())) {
                SubProcessNodeDef subProcessNodeDef = (SubProcessNodeDef)bpmNodeDef;
                this.recursionGetAllNodeId(nodeIds, subProcessNodeDef.getChildBpmProcessDef().getBpmnNodeDefs());
            }
        });
    }

    public List<String> getAllNodeIdInCurrentMulti() {
        ArrayList<String> nodeIds = new ArrayList<String>();
        List<String> childrenGatewayNode = this.getChildrenAllNodeIdInMulti();
        this.bpmNodeDefList.stream().forEach(bpmNodeDef -> {
            if (!childrenGatewayNode.contains(bpmNodeDef.getNodeId())) {
                nodeIds.add(bpmNodeDef.getNodeId());
            }
        });
        return nodeIds;
    }

    public List<String> getChildrenAllNodeIdInMulti() {
        ArrayList nodeIds = new ArrayList();
        ArrayList<String> childrenMultiNode = new ArrayList<String>();
        if (BeanUtils.isNotEmpty(this.childrens)) {
            this.childrens.stream().forEach(nodeInGateway -> childrenMultiNode.addAll(nodeInGateway.getAllNodeIdInMulti()));
        }
        return childrenMultiNode;
    }
}

