/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.api.model.process.nodedef.ext;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.constant.NodeType;
import com.hotent.bpm.api.constant.ScriptType;
import com.hotent.bpm.api.model.form.FormType;
import com.hotent.bpm.api.model.process.def.BpmProcessDef;
import com.hotent.bpm.api.model.process.def.BpmProcessDefExt;
import com.hotent.bpm.api.model.process.def.FormInitItem;
import com.hotent.bpm.api.model.process.def.NodeProperties;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.SubProcessNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.Button;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.DefaultButton;
import com.hotent.bpm.api.plugin.core.context.BpmPluginContext;
import com.hotent.bpm.model.form.Form;
import com.hotent.bpm.persistence.manager.BpmDefaultButtonManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BaseBpmNodeDef
implements BpmNodeDef {
    private static final long serialVersionUID = -2044846605763777657L;
    private String nodeId;
    private String name;
    private NodeType type;
    private Integer order = 0;
    private BpmNodeDef parentBpmNodeDef;
    private List<BpmNodeDef> incomeNodes = new ArrayList<BpmNodeDef>();
    private List<BpmNodeDef> outcomeNodes = new ArrayList<BpmNodeDef>();
    private List<BpmPluginContext> bpmPluginContexts = new ArrayList<BpmPluginContext>();
    private Map<String, String> attrMap = new HashMap<String, String>();
    private BpmProcessDef<BpmProcessDefExt> bpmProcessDef;
    private List<Form> subFormList = new ArrayList<Form>();
    private List<Form> forms;
    private Map<String, String> conditionMap = new HashMap<String, String>();
    private Map<ScriptType, String> scriptMap = new HashMap<ScriptType, String>();
    private List<FormInitItem> formInitItems = new ArrayList<FormInitItem>();
    private List<NodeProperties> nodeProperties = new ArrayList<NodeProperties>();
    private List<Button> buttons = null;
    private List<DefaultButton> buttonsTop = null;
    private List<Button> buttonList = null;
    private String targetNode;
    private BpmNodeDef defaultOutcome;
    private String defaultSequenceFlowId;
    private String conditionJson;

    @Override
    public BpmNodeDef getDefaultOutcome() {
        return this.defaultOutcome;
    }

    @Override
    public void setDefaultOutcome(BpmNodeDef defaultOutcome) {
        this.defaultOutcome = defaultOutcome;
    }

    @Override
    public String getDefaultSequenceFlowId() {
        return this.defaultSequenceFlowId;
    }

    public void setDefaultSequenceFlowId(String defaultSequenceFlowId) {
        this.defaultSequenceFlowId = defaultSequenceFlowId;
    }

    @Override
    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public NodeType getType() {
        return this.type;
    }

    @Override
    public void setType(NodeType type) {
        this.type = type;
    }

    @Override
    public List<BpmNodeDef> getIncomeNodes() {
        return this.incomeNodes;
    }

    @JsonBackReference
    public void setIncomeNodes(List<BpmNodeDef> incomeNodes) {
        this.incomeNodes = incomeNodes;
    }

    @Override
    public List<BpmNodeDef> getOutcomeNodes() {
        return this.outcomeNodes;
    }

    @JsonBackReference
    public void setOutcomeNodes(List<BpmNodeDef> outcomeNodes) {
        this.outcomeNodes = outcomeNodes;
    }

    @Override
    public List<BpmPluginContext> getBpmPluginContexts() {
        return this.bpmPluginContexts;
    }

    public void setBpmPluginContexts(List<BpmPluginContext> bpmPluginContexts) {
        if (BeanUtils.isNotEmpty(bpmPluginContexts)) {
            Collections.sort(bpmPluginContexts, new Comparator<BpmPluginContext>(){

                @Override
                public int compare(BpmPluginContext o1, BpmPluginContext o2) {
                    int diff = o1.getOrder() - o2.getOrder();
                    if (diff > 0) {
                        return 1;
                    }
                    if (diff < 0) {
                        return -1;
                    }
                    return 0;
                }
            });
        }
        this.bpmPluginContexts = bpmPluginContexts;
    }

    public void setAttribute(String name, String value) {
        name = name.toLowerCase().trim();
        this.attrMap.put(name.toLowerCase(), value);
    }

    @Override
    public String getAttribute(String name) {
        name = name.toLowerCase().trim();
        return this.attrMap.get(name);
    }

    @Override
    public void addIncomeNode(BpmNodeDef bpmNodeDef) {
        this.incomeNodes.add(bpmNodeDef);
    }

    @Override
    public void addOutcomeNode(BpmNodeDef bpmNodeDef) {
        this.outcomeNodes.add(bpmNodeDef);
    }

    @Override
    @JsonIgnore
    public BpmNodeDef getParentBpmNodeDef() {
        return this.parentBpmNodeDef;
    }

    public void setParentBpmNodeDef(BpmNodeDef parentBpmNodeDef) {
        this.parentBpmNodeDef = parentBpmNodeDef;
    }

    @Override
    public String getRealPath() {
        String id = this.getNodeId();
        for (BpmNodeDef parent = this.getParentBpmNodeDef(); parent != null; parent = parent.getParentBpmNodeDef()) {
            id = parent.getNodeId() + "/" + id;
        }
        return id;
    }

    @JsonIgnore
    public BpmProcessDef<BpmProcessDefExt> getBpmProcessDef() {
        return this.bpmProcessDef;
    }

    public void setBpmProcessDef(BpmProcessDef<BpmProcessDefExt> bpmProcessDef) {
        this.bpmProcessDef = bpmProcessDef;
    }

    @Override
    @JsonIgnore
    public BpmProcessDef<BpmProcessDefExt> getRootProcessDef() {
        BpmProcessDef<BpmProcessDefExt> processDef = this.bpmProcessDef;
        for (BpmProcessDef<BpmProcessDefExt> parent = processDef.getParentProcessDef(); parent != null; parent = parent.getParentProcessDef()) {
            processDef = parent;
        }
        return processDef;
    }

    private Form getForm(String formType) {
        if (BeanUtils.isEmpty(this.forms)) {
            return null;
        }
        for (Form form : this.forms) {
            if (!form.getFormType().equals(formType)) continue;
            if (StringUtil.isEmpty((String)form.getNodeId())) {
                form.setNodeId(this.nodeId);
            }
            return form;
        }
        return null;
    }

    @Override
    public Form getForm() {
        return this.getForm(FormType.PC.value());
    }

    @Override
    public Form getMobileForm() {
        return this.getForm(FormType.MOBILE.value());
    }

    public void setForm(List<Form> forms) {
        this.forms = forms;
    }

    @Override
    @JsonIgnore
    public List<BpmNodeDef> getOutcomeTaskNodes() {
        return this.getNodeDefList(this.outcomeNodes);
    }

    private List<BpmNodeDef> getNodeDefList(List<BpmNodeDef> bpmNodeDefs) {
        ArrayList<BpmNodeDef> bpmNodeList = new ArrayList<BpmNodeDef>();
        for (BpmNodeDef def : bpmNodeDefs) {
            SubProcessNodeDef subProcessNodeDef;
            if (def.getType().equals((Object)NodeType.CALLACTIVITY)) continue;
            if (NodeType.USERTASK.equals((Object)def.getType()) || NodeType.SIGNTASK.equals((Object)def.getType())) {
                bpmNodeList.add(def);
                continue;
            }
            if (NodeType.SUBPROCESS.equals((Object)def.getType())) {
                subProcessNodeDef = (SubProcessNodeDef)def;
                BpmNodeDef startNodeDef = subProcessNodeDef.getChildBpmProcessDef().getStartEvent();
                bpmNodeList.addAll(this.getNodeDefList(startNodeDef.getOutcomeNodes()));
                continue;
            }
            if (NodeType.END.equals((Object)def.getType()) && def.getParentBpmNodeDef() != null && NodeType.SUBPROCESS.equals((Object)def.getParentBpmNodeDef().getType())) {
                subProcessNodeDef = (SubProcessNodeDef)def.getParentBpmNodeDef();
                bpmNodeList.addAll(this.getNodeDefList(subProcessNodeDef.getOutcomeNodes()));
                continue;
            }
            bpmNodeList.addAll(this.getNodeDefList(def.getOutcomeNodes()));
        }
        return bpmNodeList;
    }

    @Override
    @JsonIgnore
    public List<BpmNodeDef> getInnerOutcomeTaskNodes(boolean includeSignTask) {
        List<BpmNodeDef> bpmNodeList = this.getInnerOutcomeTaskNodes(this.outcomeNodes, includeSignTask);
        return bpmNodeList;
    }

    private List<BpmNodeDef> getInnerOutcomeTaskNodes(List<BpmNodeDef> bpmNodeDefs, boolean includeSignTask) {
        ArrayList<BpmNodeDef> bpmNodeList = new ArrayList<BpmNodeDef>();
        for (BpmNodeDef def : bpmNodeDefs) {
            if (NodeType.USERTASK.equals((Object)def.getType()) || includeSignTask && NodeType.SIGNTASK.equals((Object)def.getType())) {
                bpmNodeList.add(def);
                continue;
            }
            if (NodeType.SUBPROCESS.equals((Object)def.getType()) || NodeType.CALLACTIVITY.equals((Object)def.getType()) || NodeType.END.equals((Object)def.getType())) continue;
            bpmNodeList.addAll(this.getInnerOutcomeTaskNodes(def.getOutcomeNodes(), includeSignTask));
        }
        return bpmNodeList;
    }

    @Override
    @JsonIgnore
    public <T> T getPluginContext(Class<T> cls) {
        BpmPluginContext ctx = null;
        List<BpmPluginContext> list = this.bpmPluginContexts;
        for (BpmPluginContext context : list) {
            if (!context.getClass().isAssignableFrom(cls)) continue;
            ctx = context;
            break;
        }
        return (T)ctx;
    }

    @Override
    public List<Form> getSubFormList() {
        return this.subFormList;
    }

    @Override
    public Form getSubForm(String bpmDefKey, FormType formType) {
        if (BeanUtils.isEmpty(this.subFormList)) {
            return null;
        }
        for (Form frm : this.subFormList) {
            if (!bpmDefKey.equals(frm.getParentFlowKey()) || !frm.getFormType().equals(formType.value())) continue;
            return frm;
        }
        return null;
    }

    @Override
    public void setSubFormList(List<Form> list) {
        this.subFormList = list;
    }

    @Override
    public Map<String, String> getConditions() {
        return this.conditionMap;
    }

    @Override
    public void setConditions(Map<String, String> conditions) {
        this.conditionMap = conditions;
    }

    @Override
    public void addCondition(String targetNode, String condition) {
        this.conditionMap.put(targetNode, condition);
    }

    @Override
    public Map<ScriptType, String> getScripts() {
        return this.scriptMap;
    }

    @Override
    public void addScript(ScriptType scriptType, String script) {
        this.scriptMap.put(scriptType, script);
    }

    public List<FormInitItem> getFormInitItems() {
        return this.formInitItems;
    }

    public void setFormInitItems(List<FormInitItem> formInitItems) {
        this.formInitItems = formInitItems;
    }

    public void addFormInitItem(FormInitItem initItem) {
        this.formInitItems.add(initItem);
    }

    @Override
    public FormInitItem getFormInitItem() {
        if (BeanUtils.isEmpty(this.formInitItems)) {
            return null;
        }
        FormInitItem myItem = null;
        for (FormInitItem item : this.formInitItems) {
            if (!StringUtil.isNotEmpty((String)item.getParentDefKey())) continue;
            myItem = item;
            break;
        }
        return myItem;
    }

    @Override
    public FormInitItem getFormInitItemByParentKey(String parentDefKey) {
        if (BeanUtils.isEmpty(this.formInitItems)) {
            return null;
        }
        FormInitItem myItem = null;
        for (FormInitItem item : this.formInitItems) {
            if (StringUtil.isEmpty((String)item.getParentDefKey()) || !parentDefKey.equals(item.getParentDefKey())) continue;
            myItem = item;
            break;
        }
        return myItem;
    }

    @Override
    public List<NodeProperties> getNodeProperties() {
        return this.nodeProperties;
    }

    @Override
    public void setNodeProperties(List<NodeProperties> nodeProperties) {
        this.nodeProperties = nodeProperties;
    }

    @Override
    public void addNodeProperties(NodeProperties prop) {
        this.nodeProperties.add(prop);
    }

    @Override
    public NodeProperties getLocalProperties() {
        for (NodeProperties prop : this.nodeProperties) {
            if (!StringUtil.isNotEmpty((String)prop.getParentDefKey()) || !"local_".equals(prop.getParentDefKey())) continue;
            return prop;
        }
        NodeProperties prop = new NodeProperties();
        prop.setNodeId(this.nodeId);
        return prop;
    }

    @Override
    public NodeProperties getPropertiesByParentDefKey(String parentDefKey) {
        for (NodeProperties prop : this.nodeProperties) {
            if (!StringUtil.isNotEmpty((String)prop.getParentDefKey()) || !prop.getParentDefKey().equals(parentDefKey)) continue;
            return prop;
        }
        if (StringUtil.isNotEmpty((String)parentDefKey)) {
            NodeProperties prop = new NodeProperties();
            prop.setNodeId(this.nodeId);
            prop.setParentDefKey(parentDefKey);
            return prop;
        }
        return this.getLocalProperties();
    }

    @Override
    public Integer getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(Integer order) {
        this.order = order;
    }

    public void setButtons(List<Button> buttons) {
        this.buttons = buttons;
    }

    @Override
    public List<Button> getButtons() {
        if (this.buttons != null) {
            return this.buttons;
        }
        if (this.buttonList != null) {
            return this.buttonList;
        }
        this.buttonList = this.getButtonsByType(true);
        return this.buttonList;
    }

    @Override
    public List<DefaultButton> getTopButtons() {
        if (this.buttonsTop != null) {
            return this.buttonsTop;
        }
        if (NodeType.START.equals((Object)this.getType())) {
            return this.buttonsTop;
        }
        String topButtonType = "top";
        BpmDefaultButtonManager bpmDefaultButtonManager = (BpmDefaultButtonManager)AppUtil.getBean(BpmDefaultButtonManager.class);
        return bpmDefaultButtonManager.getByType(topButtonType, false);
    }

    public void setTopButtons(List<DefaultButton> buttonsTop) {
        this.buttonsTop = buttonsTop;
    }

    @Override
    public List<Button> getButtonsByType(boolean isInit) {
        ArrayList<Button> buttonList = new ArrayList<Button>();
        BpmDefaultButtonManager bpmDefaultButtonManager = (BpmDefaultButtonManager)AppUtil.getBean(BpmDefaultButtonManager.class);
        List<DefaultButton> defaultButtonList = bpmDefaultButtonManager.getByType(this.type.toString(), isInit);
        for (DefaultButton def : defaultButtonList) {
            Boolean supportScript = def.getSupportScript() == 1;
            Boolean isLock = def.getLock() == 1;
            Boolean disabled = def.getDisabled() == 1;
            Button button = new Button(def.getName(), def.getAlias(), def.getBeforeScript(), def.getAfterScript(), def.getGroovyScript(), def.getCompleteEventGroovyScript(), def.getRejectMode(), def.getRejectNode(), isLock, supportScript, def.getMsgConfig(), disabled, def.getDefaultOpinion());
            buttonList.add(button);
        }
        return buttonList;
    }

    @Override
    public boolean isDefaultBtn() {
        return this.buttons == null;
    }

    @Override
    public boolean isFirstNode() {
        boolean[] result = new boolean[]{false};
        if (BeanUtils.isEmpty(this.incomeNodes)) {
            return result[0];
        }
        this.incomeNodes.forEach(incomeNode -> {
            if (NodeType.START.equals((Object)incomeNode.getType())) {
                result[0] = true;
            }
        });
        return result[0];
    }

    @Override
    public void setTargetNode(String targetNode) {
        this.targetNode = targetNode;
    }

    @Override
    public String getTargetNode() {
        return this.targetNode;
    }

    @Override
    public String getConditionJson() {
        return this.conditionJson;
    }

    @Override
    public void setConditionJson(String conditionJson) {
        this.conditionJson = conditionJson;
    }
}

