/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.chart.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.chart.IChart;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component(value="start_throughput")
public class StartThroughputChart
implements IChart {
    @Override
    public String getQuerySql(String flowType, String dimension, String ids, String orgIds, String startTime, String endTime, String orgType, String dbType) {
        String[] idArray;
        String idCode;
        StringBuilder sql = new StringBuilder();
        String whereIds = "org".equals(dimension) ? ids : orgIds;
        StringBuilder whereSql = new StringBuilder();
        String string = idCode = "2".equals(orgType) ? "CREATE_BY_" : "CREATE_ORG_ID_";
        if ("oracle".equals(dbType)) {
            whereSql.append(" AND a.STATUS_ IS NOT NULL AND a.CREATE_TIME_ between to_date('" + startTime + "','YYYY-MM-DD HH24:MI:SS') and to_date('" + endTime + "','YYYY-MM-DD HH24:MI:SS')");
        } else {
            whereSql.append(" AND a.STATUS_ IS NOT NULL AND a.CREATE_TIME_>='" + startTime + "' AND a.CREATE_TIME_<='" + endTime + "' ");
        }
        if (StringUtil.isNotEmpty((String)whereIds)) {
            idArray = whereIds.split(",");
            if ("org".equals(dimension)) {
                if ("1".equals(flowType)) {
                    whereSql.append(" AND " + StringUtil.idsInSql((String[])idArray, (String)"a.PROC_DEF_ID_"));
                } else if ("2".equals(flowType)) {
                    whereSql.append(" AND " + StringUtil.idsInSql((String[])idArray, (String)"a.TYPE_ID_"));
                }
            } else {
                whereSql.append(" AND " + StringUtil.idsInSql((String[])idArray, (String)("a." + idCode)));
            }
        }
        if (StringUtil.isNotEmpty((String)orgIds) && "org".equals(dimension)) {
            String[] orgIdArray = orgIds.split(",");
            boolean isFirst = false;
            for (String id : orgIdArray) {
                if (!isFirst) {
                    isFirst = true;
                } else {
                    sql.append(" UNION ");
                }
                String baseSql = this.getBaseSql(id, flowType, dimension, whereSql.toString(), orgType, dbType);
                sql.append(baseSql);
            }
        } else if (StringUtil.isNotEmpty((String)ids) && "flow".equals(dimension)) {
            idArray = ids.split(",");
            boolean isFirst = false;
            for (String id : idArray) {
                if (!isFirst) {
                    isFirst = true;
                } else {
                    sql.append(" UNION ");
                }
                String baseSql = this.getBaseSql(id, flowType, dimension, whereSql.toString(), orgType, dbType);
                sql.append(baseSql);
            }
        } else {
            String baseSql = this.getBaseSql("", flowType, dimension, whereSql.toString(), orgType, dbType);
            sql.append(baseSql);
        }
        return sql.toString();
    }

    private String getBaseSql(String orgId, String flowType, String dimension, String whereSql, String orgType, String dbType) {
        StringBuilder baseSql = new StringBuilder();
        String idCode = "2".equals(orgType) ? "CREATE_BY_" : "CREATE_ORG_ID_";
        String orgSql = StringUtil.isNotEmpty((String)orgId) ? " AND a." + idCode + " ='" + orgId + "' " : " ";
        String havingSql = " having count(1) >0 ";
        String groupBySql = " GROUP BY a." + idCode;
        if ("flow".equals(dimension)) {
            if ("1".equals(flowType)) {
                orgSql = StringUtil.isNotEmpty((String)orgId) ? " AND a.PROC_DEF_ID_ ='" + orgId + "' " : " ";
                groupBySql = " GROUP BY a.PROC_DEF_ID_  ";
            } else {
                orgSql = StringUtil.isNotEmpty((String)orgId) ? " AND a.TYPE_ID_ ='" + orgId + "' " : " ";
                groupBySql = " GROUP BY a.TYPE_ID_ ";
            }
        }
        if ("oracle".equals(dbType) || "postgresql".equals(dbType) || "h2".equals(dbType) || "kingbasees".equals(dbType)) {
            havingSql = groupBySql + " having count(1) >0 ";
        }
        baseSql.append(this.getSelectSql(orgType, flowType, dimension, "running"));
        baseSql.append(" from bpm_pro_inst a WHERE a.STATUS_ in('running','back','backToStart','revoke','revokeToStart') ");
        baseSql.append(orgSql);
        baseSql.append(whereSql);
        baseSql.append(havingSql);
        baseSql.append(" UNION ");
        baseSql.append(this.getSelectSql(orgType, flowType, dimension, "backRevoke"));
        baseSql.append(" from bpm_pro_inst a WHERE a.STATUS_ in('back','backToStart','revoke','revokeToStart') ");
        baseSql.append(orgSql);
        baseSql.append(whereSql);
        baseSql.append(havingSql);
        baseSql.append(" UNION ");
        baseSql.append(this.getSelectSql(orgType, flowType, dimension, "manualend"));
        baseSql.append(" from bpm_pro_inst a WHERE a.STATUS_ in('manualend') ");
        baseSql.append(orgSql);
        baseSql.append(whereSql);
        baseSql.append(havingSql);
        baseSql.append(" UNION ");
        baseSql.append(this.getSelectSql(orgType, flowType, dimension, "end"));
        baseSql.append(" from bpm_pro_inst a WHERE a.STATUS_ ='end' ");
        baseSql.append(orgSql);
        baseSql.append(whereSql);
        baseSql.append(havingSql);
        baseSql.append(" UNION ");
        baseSql.append(this.getSelectSql(orgType, flowType, dimension, "instances"));
        baseSql.append(" from bpm_pro_inst a WHERE 1=1 ");
        baseSql.append(orgSql);
        baseSql.append(whereSql);
        baseSql.append(havingSql);
        baseSql.append(" UNION ");
        if ("oracle".equals(dbType) || "kingbasees".equals(dbType)) {
            baseSql.append(this.getHourLongSql_oracle(orgType, flowType, dimension, "hourLong", false));
        } else if ("postgresql".equals(dbType)) {
            baseSql.append(this.getHourLongSql_postgresql(orgType, flowType, dimension, "hourLong", false));
        } else if ("h2".equals(dbType)) {
            baseSql.append(this.getHourLongSql_h2(orgType, flowType, dimension, "hourLong", false));
        } else {
            baseSql.append(this.getHourLongSql_mysql(orgType, flowType, dimension, "hourLong", false));
        }
        baseSql.append(" from bpm_pro_inst a WHERE 1=1 ");
        baseSql.append(orgSql);
        baseSql.append(whereSql);
        baseSql.append(havingSql);
        baseSql.append(" UNION ");
        baseSql.append(this.getSelectSql(orgType, flowType, dimension, "incomplete"));
        baseSql.append(" from bpm_pro_inst a WHERE a.STATUS_ not in ('end','manualend') ");
        baseSql.append(orgSql);
        baseSql.append(whereSql);
        baseSql.append(havingSql);
        baseSql.append(" UNION ");
        if ("oracle".equals(dbType) || "kingbasees".equals(dbType)) {
            baseSql.append(this.getHourLongSql_oracle(orgType, flowType, dimension, "avgLong", true));
        } else if ("postgresql".equals(dbType)) {
            baseSql.append(this.getHourLongSql_postgresql(orgType, flowType, dimension, "avgLong", true));
        } else if ("h2".equals(dbType)) {
            baseSql.append(this.getHourLongSql_h2(orgType, flowType, dimension, "avgLong", true));
        } else {
            baseSql.append(this.getHourLongSql_mysql(orgType, flowType, dimension, "avgLong", true));
        }
        baseSql.append(" from bpm_pro_inst a WHERE 1=1 ");
        baseSql.append(orgSql);
        baseSql.append(whereSql);
        baseSql.append(havingSql);
        baseSql.append(" UNION ");
        baseSql.append(this.getSelectSql(orgType, flowType, dimension, "overtime"));
        if ("oracle".equals(dbType) || "kingbasees".equals(dbType)) {
            baseSql.append(" from bpm_pro_inst a WHERE ROUND(((TO_DATE(to_char((CASE a.END_TIME_ WHEN a.END_TIME_ THEN a.END_TIME_ ELSE (select sysdate from dual) END), 'YYYY-MM-DD HH24-MI-SS'), 'YYYY-MM-DD HH24-MI-SS') - TO_DATE(to_char(a.CREATE_TIME_ , 'YYYY-MM-DD HH24-MI-SS'), 'YYYY-MM-DD HH24-MI-SS')) * 24*60  ),1)>24 ");
        } else if ("postgresql".equals(dbType)) {
            baseSql.append(" from bpm_pro_inst a WHERE ROUND(((TO_DATE(to_char((CASE a.END_TIME_ WHEN a.END_TIME_ THEN a.END_TIME_ ELSE now() END), 'YYYY-MM-DD HH24-MI-SS'), 'YYYY-MM-DD HH24-MI-SS') - TO_DATE(to_char(a.CREATE_TIME_ , 'YYYY-MM-DD HH24-MI-SS'), 'YYYY-MM-DD HH24-MI-SS')) * 24*60  ),1)>24 ");
        } else if ("h2".equals(dbType)) {
            baseSql.append(" from bpm_pro_inst a WHERE TIMESTAMPDIFF(HOUR,a.CREATE_TIME_,(CASE WHEN a.END_TIME_ IS NOT NULL THEN a.END_TIME_ ELSE now() END))>24 ");
        } else {
            baseSql.append(" from bpm_pro_inst a WHERE TIMESTAMPDIFF(HOUR,a.CREATE_TIME_,IF(a.END_TIME_ IS NOT NULL,a.END_TIME_,now()))>24 ");
        }
        baseSql.append(orgSql);
        baseSql.append(whereSql);
        baseSql.append(havingSql);
        baseSql.append(" UNION ");
        StringBuilder countSql = new StringBuilder();
        countSql.append("select count(1) from bpm_pro_inst a where a.STATUS_ in ('end','manualend') ");
        countSql.append(orgSql);
        countSql.append(whereSql);
        countSql.append(havingSql);
        if ("oracle".equals(dbType)) {
            baseSql.append(this.getClosingRate_oracle(orgType, flowType, dimension, "closingRate", countSql.toString()));
        } else {
            baseSql.append(this.getClosingRate_mysql(orgType, flowType, dimension, "closingRate", countSql.toString()));
        }
        baseSql.append(" from bpm_pro_inst a WHERE 1=1 ");
        baseSql.append(orgSql);
        baseSql.append(whereSql);
        baseSql.append(havingSql);
        return baseSql.toString();
    }

    private String getSelectSql(String orgType, String flowType, String dimension, String status) {
        String idCode = "2".equals(orgType) ? "CREATE_BY_" : "CREATE_ORG_ID_";
        String selectSql = "select count(1) as count,a." + idCode + " as id,'" + status + "' as status ";
        if ("flow".equals(dimension)) {
            selectSql = "1".equals(flowType) ? "select count(1) as count,a.PROC_DEF_ID_ as id,'" + status + "' as status " : "select count(1) as count,a.TYPE_ID_ as id,'" + status + "' as status ";
        }
        return selectSql;
    }

    private String getHourLongSql_oracle(String orgType, String flowType, String dimension, String status, boolean isRate) {
        String idCode = "2".equals(orgType) ? "CREATE_BY_" : "CREATE_ORG_ID_";
        String rateSql = isRate ? "/count(a.ID_)) " : ")";
        String selectSql = "select round((SUM(TO_NUMBER((DECODE(END_TIME_,NULL,sysdate,END_TIME_)) -(CREATE_TIME_+0))*24))" + rateSql + " as count,a." + idCode + " as id,'" + status + "' as status ";
        if ("flow".equals(dimension)) {
            selectSql = "1".equals(flowType) ? "select round((SUM(TO_NUMBER((DECODE(END_TIME_,NULL,sysdate,END_TIME_)) -(CREATE_TIME_+0))*24))" + rateSql + " as count,a.PROC_DEF_ID_ as id,'" + status + "' as status " : "select round((SUM(TO_NUMBER((DECODE(END_TIME_,NULL,sysdate,END_TIME_)) -(CREATE_TIME_+0))*24))" + rateSql + " as count,a.TYPE_ID_ as id,'" + status + "' as status ";
        }
        return selectSql;
    }

    private String getHourLongSql_postgresql(String orgType, String flowType, String dimension, String status, boolean isRate) {
        String idCode = "2".equals(orgType) ? "CREATE_BY_" : "CREATE_ORG_ID_";
        String rateSql = isRate ? "/count(a.ID_),1)) " : ")";
        String roundSql = isRate ? "ROUND(" : "";
        String selectSql = "select (" + roundSql + "SUM(ROUND(cast(date_part('MINUTE',(CASE a.END_TIME_ WHEN a.END_TIME_ THEN a.END_TIME_ ELSE now() END)::timestamp- a.create_time_::timestamp)/60 as numeric), 1))" + rateSql + " as count,a." + idCode + " as id,'" + status + "' as status ";
        if ("flow".equals(dimension)) {
            selectSql = "1".equals(flowType) ? "select (" + roundSql + "SUM(ROUND(cast(date_part('MINUTE',(CASE a.END_TIME_ WHEN a.END_TIME_ THEN a.END_TIME_ ELSE now() END)::timestamp- a.create_time_::timestamp)/60 as numeric), 1))" + rateSql + " as count,a.PROC_DEF_ID_ as id,'" + status + "' as status " : "select (" + roundSql + "SUM(ROUND(cast(date_part('MINUTE',(CASE a.END_TIME_ WHEN a.END_TIME_ THEN a.END_TIME_ ELSE now() END)::timestamp- a.create_time_::timestamp)/60 as numeric), 1))" + rateSql + " as count,a.TYPE_ID_ as id,'" + status + "' as status ";
        }
        return selectSql;
    }

    private String getHourLongSql_mysql(String orgType, String flowType, String dimension, String status, boolean isRate) {
        String idCode = "2".equals(orgType) ? "CREATE_BY_" : "CREATE_ORG_ID_";
        String rateSql = isRate ? "/count(a.ID_),1)) " : ")";
        String roundSql = isRate ? "ROUND(" : "";
        String selectSql = "select (" + roundSql + "SUM(ROUND(TIMESTAMPDIFF(MINUTE,a.CREATE_TIME_,if(a.END_TIME_ IS not NULL,a.END_TIME_,now()))/60,1))" + rateSql + " as count,a." + idCode + " as id,'" + status + "' as status ";
        if ("flow".equals(dimension)) {
            selectSql = "1".equals(flowType) ? "select (" + roundSql + "SUM(ROUND(TIMESTAMPDIFF(MINUTE,a.CREATE_TIME_,if(a.END_TIME_ IS not NULL,a.END_TIME_,now()))/60,1))" + rateSql + " as count,a.PROC_DEF_ID_ as id,'" + status + "' as status " : "select (" + roundSql + "SUM(ROUND(TIMESTAMPDIFF(MINUTE,a.CREATE_TIME_,if(a.END_TIME_ IS not NULL,a.END_TIME_,now()))/60,1))" + rateSql + " as count,a.TYPE_ID_ as id,'" + status + "' as status ";
        }
        return selectSql;
    }

    private String getHourLongSql_h2(String orgType, String flowType, String dimension, String status, boolean isRate) {
        String idCode = "2".equals(orgType) ? "CREATE_BY_" : "CREATE_ORG_ID_";
        String rateSql = isRate ? "/count(a.ID_),1)) " : ")";
        String roundSql = isRate ? "ROUND(" : "";
        String selectSql = "select (" + roundSql + "SUM(ROUND(TIMESTAMPDIFF(MINUTE,a.CREATE_TIME_,(CASE WHEN a.END_TIME_ IS NOT NULL THEN a.END_TIME_ ELSE now() END))/60,1))" + rateSql + " as count,a." + idCode + " as id,'" + status + "' as status ";
        if ("flow".equals(dimension)) {
            selectSql = "1".equals(flowType) ? "select (" + roundSql + "SUM(ROUND(TIMESTAMPDIFF(MINUTE,a.CREATE_TIME_,(CASE WHEN a.END_TIME_ IS NOT NULL THEN a.END_TIME_ ELSE now() END))/60,1))" + rateSql + " as count,a.PROC_DEF_ID_ as id,'" + status + "' as status " : "select (" + roundSql + "SUM(ROUND(TIMESTAMPDIFF(MINUTE,a.CREATE_TIME_,(CASE WHEN a.END_TIME_ IS NOT NULL THEN a.END_TIME_ ELSE now() END))/60,1))" + rateSql + " as count,a.TYPE_ID_ as id,'" + status + "' as status ";
        }
        return selectSql;
    }

    private String getClosingRate_oracle(String orgType, String flowType, String dimension, String status, String countSql) {
        String idCode = "2".equals(orgType) ? "CREATE_BY_" : "CREATE_ORG_ID_";
        String selectSql = "select ROUND((select (" + countSql + ") from dual)/count(1)*100) as count,a." + idCode + " as id,'" + status + "' as status ";
        if ("flow".equals(dimension)) {
            selectSql = "1".equals(flowType) ? "select ROUND((select (" + countSql + ") from dual)/count(1)*100) as count,a.PROC_DEF_ID_ as id,'" + status + "' as status " : "select ROUND((select (" + countSql + ") from dual)/count(1)*100) as count,a.TYPE_ID_ as id,'" + status + "' as status ";
        }
        return selectSql;
    }

    private String getClosingRate_mysql(String orgType, String flowType, String dimension, String status, String countSql) {
        String idCode = "2".equals(orgType) ? "CREATE_BY_" : "CREATE_ORG_ID_";
        String selectSql = "select ROUND((" + countSql + ")/count(1)*100) as count,a." + idCode + " as id,'" + status + "' as status ";
        if ("flow".equals(dimension)) {
            selectSql = "1".equals(flowType) ? "select ROUND((" + countSql + ")/count(1)*100) as count,a.PROC_DEF_ID_ as id,'" + status + "' as status " : "select ROUND((" + countSql + ")/count(1)*100) as count,a.TYPE_ID_ as id,'" + status + "' as status ";
        }
        return selectSql;
    }

    @Override
    public String getDesc() {
        return "\u542f\u52a8\u541e\u5410\u91cf";
    }

    @Override
    public List<String> getLegend() {
        return Arrays.asList("\u5ba1\u6279\u4e2d", "\u9a73\u56de/\u9a73\u56de\u53d1\u8d77\u4eba/\u64a4\u56de", "\u5e9f\u5f03/\u7ec8\u6b62", "\u5ba1\u6279\u5b8c\u6210", "\u5de5\u5355\u6570\u91cf", "\u8fd0\u884c\u65f6\u957f\uff08\u5c0f\u65f6\uff09", "\u672a\u5b8c\u6210\u5de5\u5355", "\u5e73\u5747\u65f6\u957f\uff08\u5c0f\u65f6\uff09", "\u903e\u671f\u5de5\u5355", "\u95ed\u5355\u7387\uff08%\uff09");
    }

    @Override
    public ArrayNode getSeries(List<String> legend, List<Map<String, Object>> selectList, Map<String, String> map) throws Exception {
        ArrayNode array = JsonUtil.getMapper().createArrayNode();
        String defType = "bar";
        for (String le : legend) {
            ObjectNode node = JsonUtil.getMapper().createObjectNode();
            node.put("name", le);
            node.put("type", defType);
            List<Object> data = this.getSeriesData(le, selectList, map);
            node.set("data", JsonUtil.toJsonNode(data));
            array.add((JsonNode)node);
        }
        return array;
    }

    private List<Object> getSeriesData(String legend, List<Map<String, Object>> selectList, Map<String, String> map) throws Exception {
        ArrayList<Object> data = new ArrayList<Object>();
        String status = this.getLegendCode(legend);
        for (String key : map.keySet()) {
            double isValue = 0.0;
            for (Map<String, Object> obj : selectList) {
                if (!BeanUtils.isNotEmpty(obj)) continue;
                ObjectNode oNode = (ObjectNode)JsonUtil.toJsonNode(obj);
                if (BeanUtils.isNotEmpty((Object)oNode.get("id")) && key.equals(oNode.get("id").asText()) && status.equals(oNode.get("status").asText())) {
                    JsonNode countNode = Optional.ofNullable(oNode.get("count")).orElse(oNode.get("COUNT"));
                    double count = BeanUtils.isNotEmpty((Object)countNode) ? countNode.asDouble() : 0.0;
                    isValue += count;
                    continue;
                }
                if (!BeanUtils.isNotEmpty((Object)oNode.get("ID")) || !key.equals(oNode.get("ID").asText()) || !status.equals(oNode.get("STATUS").asText())) continue;
                double count = BeanUtils.isNotEmpty((Object)oNode.get("COUNT")) ? oNode.get("COUNT").asDouble() : 0.0;
                isValue += count;
            }
            data.add(isValue);
        }
        return data;
    }

    private String getLegendCode(String desc) {
        String status = "";
        switch (desc) {
            case "\u5ba1\u6279\u4e2d": {
                status = "running";
                break;
            }
            case "\u5ba1\u6279\u5b8c\u6210": {
                status = "end";
                break;
            }
            case "\u9a73\u56de/\u9a73\u56de\u53d1\u8d77\u4eba/\u64a4\u56de": {
                status = "backRevoke";
                break;
            }
            case "\u5e9f\u5f03/\u7ec8\u6b62": {
                status = "manualend";
                break;
            }
            case "\u5de5\u5355\u6570\u91cf": {
                status = "instances";
                break;
            }
            case "\u8fd0\u884c\u65f6\u957f\uff08\u5c0f\u65f6\uff09": {
                status = "hourLong";
                break;
            }
            case "\u672a\u5b8c\u6210\u5de5\u5355": {
                status = "incomplete";
                break;
            }
            case "\u5e73\u5747\u65f6\u957f\uff08\u5c0f\u65f6\uff09": {
                status = "avgLong";
                break;
            }
            case "\u903e\u671f\u5de5\u5355": {
                status = "overtime";
                break;
            }
            case "\u95ed\u5355\u7387\uff08%\uff09": {
                status = "closingRate";
            }
        }
        return status;
    }
}

