/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.chart.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.chart.IChart;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component(value="task_num")
public class TaskNumChart
implements IChart {
    @Override
    public String getQuerySql(String flowType, String dimension, String ids, String orgIds, String startTime, String endTime, String orgType, String dbType) {
        StringBuilder whereSql = new StringBuilder();
        String orgWhereId = "2".equals(orgType) ? "task.OWNER_ID_" : "inst.CREATE_ORG_ID_";
        String defWhereId = "1".equals(flowType) ? "def.DEF_ID_" : "task.TYPE_ID_";
        String xPropId = "org".equals(dimension) ? orgWhereId : defWhereId;
        whereSql.append(this.getBaseSql(xPropId));
        whereSql.append("where task.IS_DELE_ = 0 ");
        if ("oracle".equals(dbType)) {
            whereSql.append(" AND task.CREATE_TIME_ between to_date('" + startTime + "','YYYY-MM-DD HH24:MI:SS') and to_date('" + endTime + "','YYYY-MM-DD HH24:MI:SS')");
        } else {
            whereSql.append(" AND task.CREATE_TIME_>='" + startTime + "' AND task.CREATE_TIME_<='" + endTime + "' ");
        }
        if (StringUtil.isNotEmpty((String)ids)) {
            String[] idArray = ids.split(",");
            whereSql.append(" AND ").append(StringUtil.idsInSql((String[])idArray, (String)defWhereId));
        }
        if (StringUtil.isNotEmpty((String)orgIds)) {
            String[] orgIdArray = orgIds.split(",");
            whereSql.append(" AND ").append(StringUtil.idsInSql((String[])orgIdArray, (String)orgWhereId));
        }
        whereSql.append("group by " + xPropId);
        return whereSql.toString();
    }

    private String getBaseSql(String xPropId) {
        StringBuilder sql = new StringBuilder("select ");
        sql.append(xPropId + " \"id\",");
        sql.append("COUNT(1) \"count\" ");
        sql.append("FROM bpm_task task ");
        sql.append("left join bpm_definition def on def.DEF_KEY_ = task.PROC_DEF_KEY_ ");
        sql.append("left join bpm_pro_inst inst on inst.ID_ = task.PROC_INST_ID_ ");
        return sql.toString();
    }

    @Override
    public String getDesc() {
        return "\u4efb\u52a1\u91cf";
    }

    @Override
    public List<String> getLegend() {
        return Arrays.asList("\u4efb\u52a1\u91cf");
    }

    @Override
    public ArrayNode getSeries(List<String> legend, List<Map<String, Object>> selectList, Map<String, String> map) throws Exception {
        ArrayNode array = JsonUtil.getMapper().createArrayNode();
        String defType = "bar";
        for (String le : legend) {
            ObjectNode node = JsonUtil.getMapper().createObjectNode();
            node.put("name", le);
            node.put("type", defType);
            List<Object> data = this.getSeriesData(selectList, map);
            node.set("data", JsonUtil.toJsonNode(data));
            array.add((JsonNode)node);
        }
        return array;
    }

    private List<Object> getSeriesData(List<Map<String, Object>> selectList, Map<String, String> map) {
        String status = "count";
        ArrayList<Object> data = new ArrayList<Object>();
        for (String key : map.keySet()) {
            int length = data.size();
            for (Map<String, Object> select : selectList) {
                if (!key.equals(select.get("id").toString())) continue;
                data.add(Integer.valueOf(select.get(status).toString()));
            }
            if (data.size() != length) continue;
            data.add(0);
        }
        return data;
    }
}

