/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.chart.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.chart.IChart;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component(value="work_status")
public class WorkStatusChart
implements IChart {
    @Override
    public String getQuerySql(String flowType, String dimension, String ids, String orgIds, String startTime, String endTime, String orgType, String dbType) {
        StringBuilder whereSql = new StringBuilder();
        String orgWhereId = "2".equals(orgType) ? "a.create_by_" : "a.create_org_id_";
        String defWhereId = "1".equals(flowType) ? "a.proc_def_id_" : "a.type_id_";
        String xPropId = "org".equals(dimension) ? orgWhereId : defWhereId;
        whereSql.append(this.getBaseSql(xPropId, dbType));
        whereSql.append("where a.IS_DELE_ = 0 ");
        if ("oracle".equals(dbType)) {
            whereSql.append(" AND a.STATUS_ IS NOT NULL AND a.CREATE_TIME_ between to_date('" + startTime + "','YYYY-MM-DD HH24:MI:SS') and to_date('" + endTime + "','YYYY-MM-DD HH24:MI:SS')");
        } else {
            whereSql.append(" AND a.STATUS_ IS NOT NULL AND a.CREATE_TIME_>='" + startTime + "' AND a.CREATE_TIME_<='" + endTime + "' ");
        }
        if (StringUtil.isNotEmpty((String)ids)) {
            String[] idArray = ids.split(",");
            whereSql.append(" AND ").append(StringUtil.idsInSql((String[])idArray, (String)defWhereId));
        }
        if (StringUtil.isNotEmpty((String)orgIds)) {
            String[] orgIdArray = orgIds.split(",");
            whereSql.append(" AND ").append(StringUtil.idsInSql((String[])orgIdArray, (String)orgWhereId));
        }
        whereSql.append("group by " + xPropId);
        return whereSql.toString();
    }

    private String getBaseSql(String xPropId, String dbType) {
        String statusField = "";
        statusField = "oracle".equals(dbType) ? "TO_CHAR(a.STATUS_)" : "a.STATUS_";
        StringBuilder sql = new StringBuilder("select ");
        sql.append(xPropId + " \"id\",");
        sql.append("sum(CASE " + statusField + " WHEN 'running' THEN 1 ELSE 0 END) \"running\",");
        sql.append("sum(CASE " + statusField + " WHEN 'draft' THEN 1 ELSE 0 END) \"draft\",");
        sql.append("sum(CASE " + statusField + " WHEN 'end' THEN 1 ELSE 0 END) \"end\",");
        sql.append("sum(CASE " + statusField + " WHEN 'backToStart' THEN 1 ELSE 0 END)+sum(CASE " + statusField + " WHEN 'back' THEN 1 ELSE 0 END) \"back\",");
        sql.append("sum(CASE " + statusField + " WHEN 'revoke' THEN 1 ELSE 0 END)+sum(CASE " + statusField + " WHEN 'revokeToStart' THEN 1 ELSE 0 END) \"revokes\" ");
        sql.append("from bpm_pro_inst a ");
        sql.append("left join bpm_definition def on def.def_key_ = a.proc_def_key_ ");
        return sql.toString();
    }

    @Override
    public String getDesc() {
        return "\u5de5\u4f5c\u72b6\u6001";
    }

    @Override
    public List<String> getLegend() {
        return Arrays.asList("\u8349\u7a3f", "\u8fd0\u884c\u4e2d", "\u5b8c\u7ed3", "\u5df2\u9000\u56de", "\u5931\u6548");
    }

    @Override
    public ArrayNode getSeries(List<String> legend, List<Map<String, Object>> selectList, Map<String, String> map) throws Exception {
        ArrayNode array = JsonUtil.getMapper().createArrayNode();
        String defType = "bar";
        for (String le : legend) {
            ObjectNode node = JsonUtil.getMapper().createObjectNode();
            node.put("name", le);
            node.put("type", defType);
            List<Object> data = this.getSeriesData(selectList, le, map);
            node.set("data", JsonUtil.toJsonNode(data));
            array.add((JsonNode)node);
        }
        return array;
    }

    private List<Object> getSeriesData(List<Map<String, Object>> selectList, String legend, Map<String, String> map) {
        String status = this.getLegendCode(legend);
        ArrayList<Object> data = new ArrayList<Object>();
        for (String key : map.keySet()) {
            int length = data.size();
            for (Map<String, Object> select : selectList) {
                if (!key.equals(select.get("id").toString())) continue;
                data.add(Integer.valueOf(select.get(status).toString()));
            }
            if (data.size() != length) continue;
            data.add(0);
        }
        return data;
    }

    private String getLegendCode(String desc) {
        String status = "";
        switch (desc) {
            case "\u8349\u7a3f": {
                status = "draft";
                break;
            }
            case "\u8fd0\u884c\u4e2d": {
                status = "running";
                break;
            }
            case "\u5df2\u9000\u56de": {
                status = "back";
                break;
            }
            case "\u5931\u6548": {
                status = "revokes";
                break;
            }
            case "\u5b8c\u7ed3": {
                status = "end";
            }
        }
        return status;
    }
}

