/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.engine.def.impl.handler;

import com.hotent.base.util.Dom4jUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.model.process.def.EventScript;
import com.hotent.bpm.engine.def.AbstractBpmDefXmlHandler;
import com.hotent.bpm.engine.def.DefXmlHandlerUtil;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.stereotype.Service;

@Service
public class EventScriptBpmDefXmlHandler
extends AbstractBpmDefXmlHandler<EventScript> {
    @Override
    protected String getXml(String defId, String nodeId, EventScript eventScript) {
        String eventType = eventScript.getScriptType().getKey();
        DefaultBpmDefinition def = this.bpmDefinitionManager.getById(defId);
        String defXml = def.getBpmnXml();
        String xParentPath = "//ext:*[@bpmnElement='" + nodeId + "']";
        String xPath = "//ext:*[@bpmnElement='" + nodeId + "']/ext:scripts";
        String xScriptPath = "//ext:*[@bpmnElement='" + nodeId + "']/ext:scripts/ext:script[@scriptType='" + eventType + "']";
        Document doc = Dom4jUtil.loadXml((String)defXml);
        Element root = doc.getRootElement();
        String scriptsXml = "<ext:scripts xmlns:ext=\"http://www.jee-soft.cn/bpm\"></ext:scripts>";
        Element parentEl = (Element)root.selectSingleNode(xParentPath);
        Element scriptsEl = (Element)root.selectSingleNode(xPath);
        if (scriptsEl == null) {
            Document scriptDom = Dom4jUtil.loadXml((String)scriptsXml);
            parentEl.add(scriptDom.getRootElement());
        }
        String scriptXML = this.getScriptXml(eventScript);
        DefXmlHandlerUtil.handXmlDom(root, scriptXML, xPath, xScriptPath);
        return root.asXML();
    }

    private String getScriptXml(EventScript eventScript) {
        String script = eventScript.getContent();
        if (StringUtil.isEmpty((String)script)) {
            return "";
        }
        String scriptXml = "<ext:script xmlns:ext=\"http://www.jee-soft.cn/bpm\" scriptType=\"" + eventScript.getScriptType().getKey() + "\"><ext:content><![CDATA[" + script + "]]></ext:content></ext:script>";
        return scriptXml;
    }

    public String copyNodeEventScript(String sourceNodeId, String targetNodeId, String bpmnXml) {
        Document doc = Dom4jUtil.loadXml((String)bpmnXml);
        Element root = doc.getRootElement();
        String xParentPath = "//ext:*[@bpmnElement='%s']";
        String subElName = "scripts";
        Element parentEl = (Element)root.selectSingleNode(String.format(xParentPath, sourceNodeId));
        Element element = parentEl.element(subElName);
        DefXmlHandlerUtil.handleXmlDom(root, element != null ? element.asXML() : "", String.format(xParentPath, targetNodeId), subElName);
        return root.asXML();
    }
}

