/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.engine.def.impl.handler;

import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.model.process.def.BpmProcessDef;
import com.hotent.bpm.api.model.process.def.BpmProcessDefExt;
import com.hotent.bpm.api.model.process.def.BpmVariableDef;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.engine.def.AbstractBpmDefXmlHandler;
import com.hotent.bpm.engine.def.DefXmlHandlerUtil;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.jamesmurty.utils.XMLBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Service;

@Service
public class VarDefBpmDefXmlHandler
extends AbstractBpmDefXmlHandler<List<BpmVariableDef>> {
    @Override
    protected String getXml(String defId, String nodeId, List<BpmVariableDef> list) throws Exception {
        DefaultBpmDefinition def = this.bpmDefinitionManager.getById(defId);
        String defXml = def.getBpmnXml();
        String xParentPath = "//ext:extProcess";
        String xPath = "//ext:extProcess/ext:varDefs";
        Map<String, List<BpmVariableDef>> map = this.getByVar(list);
        Map<String, String> xmlMap = this.getXml(map);
        String globalXml = xmlMap.get("global");
        if (globalXml == null) {
            globalXml = "";
        }
        String rtnXml = DefXmlHandlerUtil.getXml(defXml, globalXml, xParentPath, xPath);
        map.remove("global");
        xmlMap.remove("global");
        Set<String> set = xmlMap.keySet();
        BpmProcessDef<BpmProcessDefExt> defExt = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        List<BpmNodeDef> nodeDefs = defExt.getBpmnNodeDefs();
        for (BpmNodeDef node : nodeDefs) {
            String thisNodeId = node.getNodeId();
            String xml = "";
            if (set.contains(thisNodeId)) {
                xml = xmlMap.get(thisNodeId);
            }
            String xNodePath = "//ext:*[@bpmnElement='" + thisNodeId + "']/ext:varDefs";
            String xNodeParentPath = "//ext:*[@bpmnElement='" + thisNodeId + "']";
            rtnXml = DefXmlHandlerUtil.getXml(rtnXml, xml, xNodeParentPath, xNodePath);
        }
        return rtnXml;
    }

    private Map<String, String> getXml(Map<String, List<BpmVariableDef>> map) {
        HashMap<String, String> xmlMap = new HashMap<String, String>();
        Set<String> set = map.keySet();
        for (String key : set) {
            List<BpmVariableDef> varList = map.get(key);
            String xml = this.getByVarDef(varList);
            xmlMap.put(key, xml);
        }
        return xmlMap;
    }

    private Map<String, List<BpmVariableDef>> getByVar(List<BpmVariableDef> varDefList) {
        HashMap<String, List<BpmVariableDef>> map = new HashMap<String, List<BpmVariableDef>>();
        for (BpmVariableDef def : varDefList) {
            if (StringUtil.isEmpty((String)def.getNodeId())) {
                ArrayList<BpmVariableDef> list = (ArrayList<BpmVariableDef>)map.get("global");
                if (BeanUtils.isEmpty((Object)list)) {
                    list = new ArrayList<BpmVariableDef>();
                    list.add(def);
                    map.put("global", list);
                    continue;
                }
                list.add(def);
                continue;
            }
            String nodeId = def.getNodeId();
            ArrayList<BpmVariableDef> list = (ArrayList<BpmVariableDef>)map.get(nodeId);
            if (BeanUtils.isEmpty((Object)list)) {
                list = new ArrayList<BpmVariableDef>();
                list.add(def);
                map.put(nodeId, list);
                continue;
            }
            list.add(def);
        }
        return map;
    }

    private String getByVarDef(List<BpmVariableDef> varDefList) {
        if (BeanUtils.isEmpty(varDefList)) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("<ext:varDefs xmlns:ext=\"http://www.jee-soft.cn/bpm\">");
            for (BpmVariableDef varDef : varDefList) {
                XMLBuilder xmlBuilder = XMLBuilder.create((String)"ext:variableDef").e("ext:name").t(varDef.getName()).up().e("ext:key").t(varDef.getVarKey()).up().e("ext:type").t(varDef.getDataType()).up().e("ext:description").t(varDef.getDescription()).up();
                xmlBuilder.e("ext:defaultVal").t(varDef.getDefaultVal().toString()).up();
                xmlBuilder.e("ext:isRequired").t(String.valueOf(varDef.isRequired())).up();
                sb.append(xmlBuilder.asString() + "\n");
            }
            sb.append("</ext:varDefs>");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }
}

