/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.engine.execution.sign.handler;

import com.hotent.base.annotation.InterfaceEventPostAsync;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.cmd.TaskFinishCmd;
import com.hotent.bpm.api.constant.DecideType;
import com.hotent.bpm.api.constant.FollowMode;
import com.hotent.bpm.api.constant.MultiInstanceType;
import com.hotent.bpm.api.constant.NodeStatus;
import com.hotent.bpm.api.constant.OpinionStatus;
import com.hotent.bpm.api.constant.PrivilegeMode;
import com.hotent.bpm.api.constant.VoteResult;
import com.hotent.bpm.api.constant.VoteType;
import com.hotent.bpm.api.model.delegate.BpmDelegateExecution;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.SignNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.SignRule;
import com.hotent.bpm.api.plugin.core.execution.sign.SignResult;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.api.service.SignService;
import com.hotent.bpm.engine.execution.sign.handler.AbstractSignActionHandler;
import com.hotent.bpm.persistence.manager.BpmSignDataManager;
import com.hotent.bpm.persistence.model.BpmSignData;
import com.hotent.bpm.persistence.util.BpmUtil;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;

public class ApproveSignActionHandler
extends AbstractSignActionHandler {
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    SignService signService;
    @Resource
    BpmSignDataManager bpmSignDataManager;

    @Override
    @InterfaceEventPostAsync
    public SignResult handByActionType(TaskFinishCmd cmd, BpmDelegateExecution bpmDelegateExecution) throws Exception {
        BpmProcessInstance instance = (BpmProcessInstance)cmd.getTransitVars("processInstance");
        String nodeId = bpmDelegateExecution.getNodeId();
        BpmNodeDef bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(instance.getProcDefId(), nodeId);
        SignNodeDef nodeDef = (SignNodeDef)bpmNodeDef;
        String actionName = cmd.getActionName();
        String direct = (String)cmd.getTransitVars("signDirect");
        if (StringUtil.isNotEmpty((String)direct) && "1".equals(direct)) {
            SignResult result = this.handDirect(actionName);
            SignResult backSignResult = ApproveSignActionHandler.getBackSignResult(cmd, result.getOpinionStatus(), result.getNodeStatus());
            backSignResult.setComplete(result.isComplete());
            return backSignResult;
        }
        SignResult result = this.handByRule(cmd, nodeDef, bpmDelegateExecution, instance);
        if (result.isComplete()) {
            cmd.addTransitVars("task_sign_result", result);
            BpmUtil.autoTrans(bpmNodeDef, instance.getId(), cmd.getTaskId());
        }
        SignResult backSignResult = ApproveSignActionHandler.getBackSignResult(cmd, result.getOpinionStatus(), result.getNodeStatus());
        backSignResult.setComplete(result.isComplete());
        return backSignResult;
    }

    private SignResult handDirect(String actionName) {
        SignResult result = new SignResult(true, NodeStatus.AGREE, OpinionStatus.SIGN_PASS_CANCEL);
        if (!actionName.equals(OpinionStatus.AGREE.getKey())) {
            result = new SignResult(true, NodeStatus.OPPOSE, OpinionStatus.SIGN_NOPASS_CANCEL);
        }
        return result;
    }

    private SignResult handByRule(TaskFinishCmd cmd, SignNodeDef nodeDef, BpmDelegateExecution bpmDelegteExecution, BpmProcessInstance processInstance) throws Exception {
        String nodeId = bpmDelegteExecution.getNodeId();
        boolean isParallel = !MultiInstanceType.SEQUENTIAL.equals((Object)bpmDelegteExecution.multiInstanceType());
        String executeId = isParallel ? bpmDelegteExecution.getParentExecution().getParentExecution().getId() : bpmDelegteExecution.getParentId();
        List<BpmSignData> list = this.bpmSignDataManager.getVoteByExecuteNode(executeId, nodeId, 1);
        int signSize = list.size();
        int aggreeCount = this.getAmount(list, VoteResult.AGREE);
        int opposeCount = this.getAmount(list, VoteResult.OPPOSE);
        int notVoteAmount = this.getAmount(list, VoteResult.NO);
        boolean isFinished = notVoteAmount == 0;
        SignRule rule = nodeDef.getSignRule();
        SignResult result = this.getByOneTicket(cmd, nodeDef, bpmDelegteExecution, processInstance);
        if (result != null) {
            return result;
        }
        result = this.getResult(rule, aggreeCount, opposeCount, signSize, isFinished);
        if (FollowMode.WAIT.equals((Object)rule.getFollowMode()) && !isFinished && result.isComplete()) {
            result.setComplete(false);
        }
        if (cmd.getTransitVars("b_tasks_revoke") != null) {
            result.setComplete(true);
            result.setNodeStatus(NodeStatus.BACK);
            result.setOpinionStatus(OpinionStatus.RETRACTED);
        }
        return result;
    }

    private SignResult getByOneTicket(TaskFinishCmd cmd, SignNodeDef nodeDef, BpmDelegateExecution bpmDelegteExecution, BpmProcessInstance bpmProcessInstance) throws Exception {
        String actionName = cmd.getActionName();
        if (!OpinionStatus.AGREE.getKey().equals(actionName) && !OpinionStatus.OPPOSE.getKey().equals(actionName)) {
            return null;
        }
        boolean hasOneTicket = this.getHasOneTicket(bpmDelegteExecution, nodeDef, bpmProcessInstance);
        if (!hasOneTicket) {
            return null;
        }
        String resultVarName = "signResult_" + bpmDelegteExecution.getNodeId();
        String resultVar = (String)bpmDelegteExecution.getVariable(resultVarName);
        if (hasOneTicket && StringUtil.isEmpty((String)resultVar)) {
            bpmDelegteExecution.setVariable(resultVarName, actionName);
        }
        if (StringUtil.isNotEmpty((String)(resultVar = (String)bpmDelegteExecution.getVariable(resultVarName)))) {
            SignResult result = new SignResult(true, NodeStatus.AGREE, OpinionStatus.SIGN_PASS_CANCEL);
            if (OpinionStatus.OPPOSE.getKey().equals(resultVar)) {
                result = new SignResult(true, NodeStatus.OPPOSE, OpinionStatus.SIGN_NOPASS_CANCEL);
                return result;
            }
            return result;
        }
        return null;
    }

    private SignResult getResult(SignRule rule, int agreeAmount, int opposeAmount, int totalAmount, boolean isFinished) {
        SignResult result = new SignResult();
        DecideType decideType = rule.getDecideType();
        int voteAmount = rule.getVoteAmount();
        if (DecideType.AGREE.getKey().equals(decideType.getKey())) {
            if (VoteType.PERCENT.getKey().equals(rule.getVoteType().getKey())) {
                agreeAmount = (int)((float)agreeAmount / (float)totalAmount * 100.0f);
            }
            if (agreeAmount >= voteAmount) {
                result.setComplete(true);
                result.setNodeStatus(NodeStatus.AGREE);
                result.setOpinionStatus(OpinionStatus.SIGN_PASS_CANCEL);
            } else if (isFinished) {
                result.setComplete(true);
                result.setNodeStatus(NodeStatus.OPPOSE);
                result.setOpinionStatus(OpinionStatus.SIGN_NOPASS_CANCEL);
            }
        } else {
            if (VoteType.PERCENT.getKey().equals(rule.getVoteType().getKey())) {
                opposeAmount = (int)((float)opposeAmount / (float)totalAmount * 100.0f);
            }
            if (opposeAmount >= voteAmount) {
                result.setComplete(true);
                result.setNodeStatus(NodeStatus.OPPOSE);
                result.setOpinionStatus(OpinionStatus.SIGN_NOPASS_CANCEL);
            } else if (isFinished) {
                result.setComplete(true);
                result.setNodeStatus(NodeStatus.AGREE);
                result.setOpinionStatus(OpinionStatus.SIGN_PASS_CANCEL);
            }
        }
        return result;
    }

    private int getAmount(List<BpmSignData> list, VoteResult voteResult) {
        int count = 0;
        for (BpmSignData signData : list) {
            if (!voteResult.getKey().equals(signData.getVoteResult())) continue;
            ++count;
        }
        return count;
    }

    private boolean getHasOneTicket(BpmDelegateExecution bpmDelegteExecution, SignNodeDef nodeDef, BpmProcessInstance bpmProcessInstance) throws Exception {
        Map<String, Object> vars;
        IUser user = ContextUtil.getCurrentUser();
        String userId = user.getUserId();
        List<PrivilegeMode> list = this.signService.getPrivilege(userId, nodeDef, vars = bpmDelegteExecution.getVariables());
        return list.contains((Object)PrivilegeMode.ALL) || list.contains((Object)PrivilegeMode.ONETICKET);
    }
}

