/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.engine.extra.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.constant.NodeType;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.engine.extra.IFlowExtVarHandler;
import com.hotent.bpm.persistence.manager.BpmCheckOpinionManager;
import com.hotent.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component(value="nodeExecutorVarImpl")
public class NodeExecutorVarImpl
implements IFlowExtVarHandler {
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;

    @Override
    public Object getVal() {
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        Object taskObj = cmd.getTransitVars("bpmTask_");
        if (null != taskObj) {
            List<BpmNodeDef> allNodeDef;
            DefaultBpmTask bpmTask = (DefaultBpmTask)taskObj;
            try {
                allNodeDef = this.bpmDefinitionAccessor.getAllNodeDef(bpmTask.getProcDefId());
            }
            catch (Exception e) {
                return "";
            }
            for (BpmNodeDef bpmNodeDef : allNodeDef) {
                if (!bpmNodeDef.getNodeId().equals(bpmTask.getNodeId())) continue;
                if (bpmNodeDef.getType().equals((Object)NodeType.SIGNTASK)) {
                    List<DefaultBpmCheckOpinion> opinions = this.bpmCheckOpinionManager.getByInstNodeId(bpmTask.getProcInstId(), bpmTask.getNodeId());
                    if (BeanUtils.isEmpty(opinions)) {
                        return "";
                    }
                    IUser currentUser = ContextUtil.getCurrentUser();
                    String curUserId = ContextUtil.getCurrentUserId();
                    HashSet<String> userIds = new HashSet<String>();
                    for (int i = 0; i < opinions.size(); ++i) {
                        if (null == opinions.get(i).getAuditor() || Objects.equals(curUserId, opinions.get(i).getAuditor())) continue;
                        userIds.add(opinions.get(i).getAuditor());
                    }
                    ArrayList<String> nameAccounts = new ArrayList<String>();
                    if (BeanUtils.isNotEmpty(userIds)) {
                        UCFeignService ucFeignService = (UCFeignService)AppUtil.getBean(UCFeignService.class);
                        ArrayNode userByIds = ucFeignService.getUserByIds(String.join((CharSequence)",", userIds));
                        for (JsonNode user : userByIds) {
                            String account = user.get("account").asText();
                            String fullname = user.get("fullname").asText();
                            nameAccounts.add(String.format("%s(%s)", fullname, account));
                        }
                    }
                    if (null != currentUser) {
                        nameAccounts.add(String.format("%s(%s)", currentUser.getFullname(), currentUser.getAccount()));
                    }
                    return String.join((CharSequence)",", nameAccounts);
                }
                IUser currentUser = ContextUtil.getCurrentUser();
                if (currentUser != null) {
                    return String.format("%s(%s)", currentUser.getFullname(), currentUser.getAccount());
                }
                return "";
            }
        }
        return "";
    }

    @Override
    public String getKey() {
        return "nodeExecutor";
    }
}

