/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.engine.form;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.FormFeignService;
import com.hotent.base.groovy.GroovyScriptEngine;
import com.hotent.base.model.HtJsonNodeFactory;
import com.hotent.base.model.HtObjectNode;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.constant.FlowExtraVars;
import com.hotent.bpm.api.constant.OpinionStatus;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.model.process.def.FieldInitSetting;
import com.hotent.bpm.api.model.process.def.FormInitItem;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.ProcBoDef;
import com.hotent.bpm.api.service.BoDataService;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.api.service.DataObjectHandler;
import com.hotent.bpm.engine.def.BpmDefUtil;
import com.hotent.bpm.engine.extra.IFlowExtVarHandler;
import com.hotent.bpm.persistence.manager.BpmCheckOpinionManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.model.DefaultBpmProcessDefExt;
import com.hotent.bpm.util.BoDataUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class DefaultDataObjectHandler
implements DataObjectHandler {
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BoDataService boDataService;
    @Resource
    FormFeignService formRestfulService;
    @Resource
    GroovyScriptEngine groovyScriptEngine;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;

    @Override
    public void handShowData(String defId, List<ObjectNode> boDatas) throws Exception {
        List<FieldInitSetting> fieldInitSettings;
        FormInitItem formInitItem = this.getFormInitItem(defId);
        String ActionName = "";
        if (BeanUtils.isNotEmpty((Object)ContextThreadUtil.getActionCmd())) {
            ActionName = ContextThreadUtil.getActionCmd().getActionName();
        }
        if ((fieldInitSettings = this.getFieldSetting(formInitItem, ActionName, true)) == null) {
            return;
        }
        this.setDataObject(fieldInitSettings, boDatas);
    }

    @Override
    public void handSaveData(BpmProcessInstance instance, List<ObjectNode> boDatas) throws Exception {
        FormInitItem formInitItem = this.getFormInitItem(instance.getProcDefId());
        if (BeanUtils.isEmpty((Object)ContextThreadUtil.getActionCmd())) {
            return;
        }
        List<FieldInitSetting> fieldInitSettings = this.getFieldSetting(formInitItem, ContextThreadUtil.getActionCmd().getActionName(), false);
        if (fieldInitSettings == null) {
            return;
        }
        this.addUnUseBoData(instance, boDatas);
        this.setDataObject(fieldInitSettings, boDatas);
    }

    @Override
    public void handSaveData(BpmProcessInstance instance, String nodeId, List<ObjectNode> boDatas) throws Exception {
        FormInitItem formInitItem = this.getFormInitItem(instance, nodeId);
        if (BeanUtils.isEmpty((Object)ContextThreadUtil.getActionCmd())) {
            return;
        }
        List<FieldInitSetting> fieldInitSettings = this.getFieldSetting(formInitItem, ContextThreadUtil.getActionCmd().getActionName(), false);
        if (fieldInitSettings == null) {
            return;
        }
        this.addUnUseBoData(instance, boDatas);
        this.setDataObject(fieldInitSettings, boDatas);
    }

    private void addUnUseBoData(BpmProcessInstance instance, List<ObjectNode> boDatas) throws Exception {
        DefaultBpmProcessDefExt defExt = BpmDefUtil.getProcessExt(instance);
        String saveMode = defExt.isBoSaveToDb() ? "database" : "boObject";
        List<ProcBoDef> boList = defExt.getBoDefList();
        ArrayList<String> boDefCodes = new ArrayList<String>();
        for (ProcBoDef procBoDef : boList) {
            boDefCodes.add(procBoDef.getKey());
        }
        ObjectNode jsonObject = (ObjectNode)BoDataUtil.hanlerData(boDatas);
        for (String boDefCode : boDefCodes) {
            if (jsonObject.findValue(boDefCode) != null) continue;
            ObjectNode boData = this.formRestfulService.getBodataByDefCode(saveMode, boDefCode);
            ObjectNode boDef = this.formRestfulService.getBodefByAlias(boDefCode);
            ObjectNode boEnt = (ObjectNode)boDef.get("boEnt");
            boData.set("boEnt", (JsonNode)boEnt);
            boDatas.add(boData);
        }
    }

    private void setDataObject(List<FieldInitSetting> fieldInitSettings, List<ObjectNode> boDatas) throws IOException {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        for (ObjectNode boData : boDatas) {
            String boDefCode = "";
            boDefCode = boData.has("boDef") ? boData.get("boDef").get("alias").asText() : boData.get("boDefAlias").asText();
            HtJsonNodeFactory factory = new HtJsonNodeFactory();
            HtObjectNode htBodata = factory.htObjectNode(boData);
            vars.put(boDefCode, htBodata);
        }
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        if (BeanUtils.isNotEmpty((Object)cmd)) {
            vars.putAll(cmd.getVariables());
        }
        this.handleVars(vars);
        this.handleDefaultValue(vars);
        for (FieldInitSetting setting : fieldInitSettings) {
            String script = setting.getSetting();
            if (StringUtil.isEmpty((String)script)) continue;
            this.groovyScriptEngine.execute(script, vars);
        }
        if (BeanUtils.isNotEmpty((Object)cmd)) {
            cmd.setBusData(BoDataUtil.hanlerData(boDatas).toString());
        }
    }

    private void handleDefaultValue(Map<String, Object> vars) {
        List<String> keys = Arrays.asList("instanceId_");
        keys.forEach(key -> {
            if (!vars.containsKey(key)) {
                vars.put((String)key, "");
            }
        });
    }

    private void handleVars(Map<String, Object> vars) {
        Map beanMap = AppUtil.getBeansOfType(IFlowExtVarHandler.class);
        for (FlowExtraVars.ExtraVar extraVar : FlowExtraVars.getDefaultVal()) {
            String beanName = extraVar.getBeanName();
            if (!beanMap.containsKey(beanName)) continue;
            IFlowExtVarHandler flowExtVarHandler = (IFlowExtVarHandler)beanMap.get(beanName);
            vars.put(beanName, flowExtVarHandler);
        }
    }

    @Override
    public void handShowData(BpmProcessInstance instance, String nodeId, List<ObjectNode> boDatas) throws Exception {
        List<FieldInitSetting> fieldInitSettings;
        FormInitItem formInitItem = this.getFormInitItem(instance, nodeId);
        String ActionName = "";
        if (StringUtil.isNotEmpty((String)ContextThreadUtil.getActionCmd().getActionName())) {
            ActionName = ContextThreadUtil.getActionCmd().getActionName();
        }
        if ((fieldInitSettings = this.getFieldSetting(formInitItem, ActionName, true)) == null) {
            return;
        }
        this.setDataObject(fieldInitSettings, boDatas);
    }

    private FormInitItem getFormInitItem(BpmProcessInstance instance, String nodeId) throws Exception {
        BpmProcessInstance topInstance;
        String defKey;
        FormInitItem formInitItem = null;
        BpmNodeDef bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(instance.getProcDefId(), nodeId);
        if (bpmNodeDef == null) {
            throw new BaseException("\u4efb\u52a1\u5f02\u5e38\uff0c\u6d41\u7a0b\u8282\u70b9\u53ef\u80fd\u5df2\u88ab\u5220\u9664\uff01");
        }
        if (StringUtil.isNotZeroEmpty((String)instance.getParentInstId()) && (formInitItem = bpmNodeDef.getFormInitItemByParentKey(defKey = (topInstance = this.bpmProcessInstanceManager.getTopBpmProcessInstance(instance)).getProcDefKey())) != null) {
            return formInitItem;
        }
        return bpmNodeDef.getFormInitItem();
    }

    private FormInitItem getFormInitItem(String defId) throws Exception {
        BpmNodeDef bpmNodeDef = this.bpmDefinitionAccessor.getStartEvent(defId);
        return bpmNodeDef.getFormInitItem();
    }

    private List<FieldInitSetting> getFieldSetting(FormInitItem formInitItem, String key, boolean isShow) {
        if (formInitItem == null) {
            return null;
        }
        if (isShow) {
            return formInitItem.getShowFieldsSetting();
        }
        List<FieldInitSetting> fieldInitSettings = null;
        if (OpinionStatus.AGREE.getKey().equals(key)) {
            fieldInitSettings = formInitItem.getAgreeFieldsSetting();
        } else if (OpinionStatus.ADDSIGN.getKey().equals(key)) {
            fieldInitSettings = formInitItem.getAddSignFieldsSetting();
        } else if (OpinionStatus.OPPOSE.getKey().equals(key)) {
            fieldInitSettings = formInitItem.getOpposeFieldsSetting();
        } else if (OpinionStatus.REJECT.getKey().equals(key) || OpinionStatus.BACK_TO_START.getKey().equals(key)) {
            fieldInitSettings = formInitItem.getRejectFieldsSetting();
        } else if (OpinionStatus.INQU.getKey().equals(key)) {
            fieldInitSettings = formInitItem.getConsultFieldsSetting();
        } else if (OpinionStatus.TRANS_FORMING.getKey().equals(key)) {
            fieldInitSettings = formInitItem.getRoamFieldsSetting();
        }
        if (BeanUtils.isNotEmpty(fieldInitSettings)) {
            fieldInitSettings = fieldInitSettings.stream().filter(item -> StringUtil.isNotEmpty((String)item.getSetting())).collect(Collectors.toList());
        }
        if (BeanUtils.isEmpty(fieldInitSettings)) {
            fieldInitSettings = formInitItem.getSaveFieldsSetting();
        }
        return fieldInitSettings;
    }

    @Override
    public String getUpdateBoData(BpmProcessInstance instance, String nodeId, List<ObjectNode> boDatas, String ActionName) throws Exception {
        FormInitItem formInitItem = this.getFormInitItem(instance, nodeId);
        List<FieldInitSetting> fieldInitSettings = this.getFieldSetting(formInitItem, ActionName, false);
        if (BeanUtils.isNotEmpty(fieldInitSettings)) {
            this.setDataObject(fieldInitSettings, boDatas);
            return BoDataUtil.hanlerData(boDatas).toString();
        }
        return BoDataUtil.hanlerData(boDatas).toString();
    }
}

