/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.engine.inst;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.time.TimeUtil;
import com.hotent.bpm.api.constant.CopyToType;
import com.hotent.bpm.api.constant.OpinionStatus;
import com.hotent.bpm.api.constant.TaskType;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.api.service.BpmCopyToService;
import com.hotent.bpm.persistence.manager.BpmCheckOpinionManager;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.manager.BpmTaskNoticeManager;
import com.hotent.bpm.persistence.manager.CopyToManager;
import com.hotent.bpm.persistence.model.BpmTaskNotice;
import com.hotent.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.persistence.util.BpmUtil;
import com.hotent.bpm.todo.util.TodoPushUtil;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DefaultBpmCopyToService
implements BpmCopyToService {
    @Resource
    CopyToManager copyToManager;
    @Resource
    BpmTaskManager bpmTaskManager;

    @Override
    public void copyTo(List<IUser> receiverUsers, BpmProcessInstance bpmProcessInstance, String nodeId) {
        this.copyTo(bpmProcessInstance, nodeId, CopyToType.COPYTO, receiverUsers);
    }

    private void copyTo(BpmProcessInstance instance, String nodeId, CopyToType copyToType, List<IUser> iUsers) {
        if (BeanUtils.isNotEmpty(iUsers)) {
            ArrayList<String> copyUsers = new ArrayList<String>();
            for (IUser entity : iUsers) {
                copyUsers.add(entity.getFullname());
                DefaultBpmCopyToService.transToMore(instance, entity.getUserId(), "inner", "");
            }
            DefaultBpmCheckOpinion defaultBpmCheckOpinion = new DefaultBpmCheckOpinion();
            defaultBpmCheckOpinion.setId(UniqueIdUtil.getSuid());
            defaultBpmCheckOpinion.setProcDefId(instance.getBpmnDefId());
            defaultBpmCheckOpinion.setProcInstId(instance.getId());
            defaultBpmCheckOpinion.setTaskId("");
            defaultBpmCheckOpinion.setTaskKey(null);
            defaultBpmCheckOpinion.setTaskName("\u4f20\u9605\u4efb\u52a1");
            defaultBpmCheckOpinion.setStatus(OpinionStatus.COPYTO.getKey());
            defaultBpmCheckOpinion.setCreateTime(LocalDateTime.now());
            defaultBpmCheckOpinion.setOpinion("\u6d41\u7a0b\u529e\u7ed3\u4f20\u9605");
            defaultBpmCheckOpinion.setQualfiedNames(ContextUtil.getCurrentUser().getFullname());
            defaultBpmCheckOpinion.setAuditorName(StringUtil.join(copyUsers, (String)","));
            defaultBpmCheckOpinion.setCompleteTime(LocalDateTime.now());
            defaultBpmCheckOpinion.setDurMs(TimeUtil.getCurrentTimeMillis() - TimeUtil.getTimeMillis((LocalDateTime)defaultBpmCheckOpinion.getCreateTime()));
            defaultBpmCheckOpinion.setAuditor(ContextUtil.getCurrentUser().getUserId());
            defaultBpmCheckOpinion.setFiles("");
            defaultBpmCheckOpinion.setIsRead(1);
            BpmCheckOpinionManager bpmCheckOpinionManager = (BpmCheckOpinionManager)AppUtil.getBean(BpmCheckOpinionManager.class);
            bpmCheckOpinionManager.create((Model)defaultBpmCheckOpinion);
        }
    }

    private static void transToMore(BpmProcessInstance instance, String userId, String messageType, String taskId) {
        IUserService userServiceImpl = (IUserService)AppUtil.getBean(IUserService.class);
        IUser user = userServiceImpl.getUserById(userId);
        IUser currentUser = userServiceImpl.getUserById(ContextUtil.getCurrentUserId());
        BpmTaskNoticeManager noticeManager = (BpmTaskNoticeManager)AppUtil.getBean(BpmTaskNoticeManager.class);
        BpmTaskNotice taskNotice = new BpmTaskNotice("\u4f20\u9605\u4efb\u52a1", instance.getSubject(), instance.getId(), instance.getProcDefId(), instance.getProcDefKey(), instance.getProcDefName(), userId, user.getFullname(), TaskType.COPYTO.getKey(), ((DefaultBpmProcessInstance)instance).getSupportMobile(), currentUser.getFullname(), currentUser.getUserId(), 0, BeanUtils.isEmpty((Object)taskId) ? null : taskId, null, null);
        BpmUtil.bpmTaskNoticeNodeSetHelper(taskNotice, taskId, null);
        noticeManager.create((Model)taskNotice);
        TodoPushUtil.addCopyToToPortal(taskNotice);
    }
}

