/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.engine.task.handler;

import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.model.process.task.BpmTask;
import com.hotent.bpm.api.plugin.core.def.TaskActionHandlerDef;
import com.hotent.bpm.api.plugin.core.runtime.TaskActionHandler;
import com.hotent.bpm.api.plugin.core.session.TaskActionPluginSession;
import com.hotent.bpm.engine.task.cmd.DefaultTaskFinishCmd;
import com.hotent.bpm.natapi.task.NatTaskService;
import com.hotent.bpm.persistence.manager.BpmTaskDueTimeManager;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Resource;

public abstract class AbstractTaskActionHandler
implements TaskActionHandler {
    @Resource
    NatTaskService natTaskService;
    @Resource
    BpmTaskDueTimeManager bpmTaskDueTimeManager;

    @Override
    public Boolean execute(TaskActionPluginSession pluginSession, TaskActionHandlerDef def) throws Exception {
        DefaultTaskFinishCmd finishCmd = (DefaultTaskFinishCmd)pluginSession.getTaskFinishCmd();
        BpmTask bpmTask = (BpmTask)finishCmd.getTransitVars("bpmTask_");
        String taskId = bpmTask.getTaskId();
        this.prepare(pluginSession, taskId);
        this.preActionHandler(pluginSession, def);
        if (this.isNeedCompleteTask()) {
            if (finishCmd.isOnlyFinishTask()) {
                this.natTaskService.completeTaskOnly(taskId);
            } else {
                String destinationNode = finishCmd.getDestination();
                if (StringUtil.isEmpty((String)destinationNode)) {
                    this.natTaskService.completeTask(taskId);
                } else {
                    String[] destNodes = destinationNode.contains(",") ? destinationNode.split(",") : new String[]{destinationNode};
                    this.natTaskService.completeTask(taskId, destNodes);
                }
            }
        }
        this.afterActionHandler(pluginSession, def);
        return true;
    }

    private void prepare(TaskActionPluginSession pluginSession, String taskId) {
        DefaultTaskFinishCmd finishCmd = (DefaultTaskFinishCmd)pluginSession.getTaskFinishCmd();
        Map<String, Object> vars = finishCmd.getVariables();
        if (vars.size() == 0) {
            vars = this.natTaskService.getVariables(taskId);
            finishCmd.setVariables(vars);
        } else {
            Map<String, Object> oldVars = this.natTaskService.getVariables(taskId);
            if (BeanUtils.isNotEmpty(oldVars)) {
                HashSet keyForRemove = new HashSet();
                vars.forEach((k, v) -> {
                    if (oldVars.containsKey(k) && k.startsWith("nodeAuditor_")) {
                        keyForRemove.add(k);
                    }
                });
                if (BeanUtils.isNotEmpty(keyForRemove)) {
                    for (String k2 : keyForRemove) {
                        vars.remove(k2);
                    }
                }
            }
            this.natTaskService.setVariables(taskId, vars);
        }
    }

    public abstract void preActionHandler(TaskActionPluginSession var1, TaskActionHandlerDef var2) throws Exception;

    public abstract void afterActionHandler(TaskActionPluginSession var1, TaskActionHandlerDef var2) throws Exception;
}

