/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.engine.task.handler;

import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.constant.ActionType;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.model.process.def.NodeProperties;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.SignNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.UserTaskNodeDef;
import com.hotent.bpm.api.model.process.task.BpmTask;
import com.hotent.bpm.api.plugin.core.def.TaskActionHandlerDef;
import com.hotent.bpm.api.plugin.core.session.TaskActionPluginSession;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.api.service.BpmInstService;
import com.hotent.bpm.engine.task.cmd.DefaultTaskFinishCmd;
import com.hotent.bpm.engine.task.handler.AbstractTaskActionHandler;
import com.hotent.bpm.persistence.manager.BpmCheckOpinionManager;
import com.hotent.bpm.persistence.manager.BpmExeStackExecutorManager;
import com.hotent.bpm.persistence.manager.BpmExeStackManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.manager.BpmSignDataManager;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.persistence.util.BpmUtil;
import com.hotent.uc.api.service.IUserService;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class TaskActionBackToStartHandler
extends AbstractTaskActionHandler {
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmInstService bpmInstService;
    @Resource
    IUserService userServiceImpl;
    @Resource
    BpmExeStackManager bpmExeStackManager;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BpmExeStackExecutorManager exeStrackExecutorManager;
    @Resource
    BpmSignDataManager bpmSignDataManager;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;

    @Override
    public boolean isNeedCompleteTask() {
        return true;
    }

    @Override
    public ActionType getActionType() {
        return ActionType.BACK_TO_START;
    }

    @Override
    public void preActionHandler(TaskActionPluginSession pluginSession, TaskActionHandlerDef def) throws Exception {
        DefaultTaskFinishCmd cmd = (DefaultTaskFinishCmd)pluginSession.getTaskFinishCmd();
        String instId = cmd.getInstId();
        String targeNode = cmd.getDestination();
        String handMode = (String)cmd.getTransitVars("backHandMode");
        BpmTask task = (BpmTask)cmd.getTransitVars("bpmTask_");
        if (StringUtil.isEmpty((String)targeNode)) {
            BpmNodeDef bpmNodeDef;
            UserTaskNodeDef backTargetNodeDef;
            NodeProperties nodeProperties;
            String backUserMode;
            DefaultBpmProcessInstance inst = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId));
            if (StringUtil.isNotZeroEmpty((String)inst.getParentInstId())) {
                throw new RuntimeException("\u591a\u5b9e\u4f8b\u7684\u5185\u5d4c\u5b50\u6d41\u7a0b\u4e0d\u5141\u8bb8\u9a73\u56de\u5230\u4e3b\u6d41\u7a0b!");
            }
            BpmNodeDef curNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(inst.getProcDefId(), task.getNodeId());
            String innerSubStartNodeId = BpmUtil.getInnerSubStartNodeId(curNodeDef);
            if (StringUtil.isNotEmpty((String)innerSubStartNodeId)) {
                cmd.setDestination(innerSubStartNodeId);
                List<BpmIdentity> identityList = BpmUtil.gethisOpinionQualfieds(task, innerSubStartNodeId);
                if (BeanUtils.isNotEmpty(identityList)) {
                    cmd.setBpmIdentity(innerSubStartNodeId, identityList);
                }
            } else {
                List<BpmNodeDef> startNodes = this.bpmDefinitionAccessor.getStartNodes(inst.getProcDefId());
                cmd.setDestination(startNodes.get(0).getNodeId());
            }
            String destinationNode = cmd.getDestination();
            if (!(cmd.getTransitVars("IsDoneUnused") != null && ((Boolean)cmd.getTransitVars("IsDoneUnused")).booleanValue() || !StringUtil.isEmpty((String)(backUserMode = (nodeProperties = (backTargetNodeDef = (UserTaskNodeDef)this.bpmDefinitionAccessor.getBpmNodeDef(inst.getProcDefId(), destinationNode)).getLocalProperties()).getBackUserMode())) && !backUserMode.equals("history"))) {
                List<BpmIdentity> identitys = this.bpmCheckOpinionManager.getHistoryBpmIdentityByInstNodeId(instId, destinationNode);
                cmd.addBpmIdentity(destinationNode, identitys);
            }
            if (cmd.getTransitVars("IsDoneUnused") != null && ((Boolean)cmd.getTransitVars("IsDoneUnused")).booleanValue() && (bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(inst.getProcDefId(), destinationNode)) instanceof SignNodeDef) {
                List<BpmIdentity> signBpmIdentity = this.bpmSignDataManager.getByInstanIdAndNodeIdAndNo(instId, destinationNode);
                cmd.addBpmIdentity(destinationNode, signBpmIdentity);
                return;
            }
        }
        if ("direct".equals(handMode)) {
            cmd.getTransitVars().put("target_node", task.getNodeId());
        } else {
            cmd.getTransitVars().put("target_node", null);
        }
    }

    @Override
    public void afterActionHandler(TaskActionPluginSession pluginSession, TaskActionHandlerDef def) {
    }
}

